local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, kraActor, brokActor, stoneProp, hintSeq, seq
local finishedVO = false
function OnScriptLoaded(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") <= 183 then
    SetupActors()
  end
  thisObj = obj
  thisLevel = level
  SetupProps()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart()
  GameObjects.Btr_FastTravelIntro_LockedIn.Child.LuaObjectScript.Disable()
end
function SetupActors()
  kraActor = actor.Actor.New("FAST TRAVEL INTRO: Kratos Actor", game.Player.FindPlayer)
  brokActor = actor.Actor.New("FAST TRAVEL INTRO: Brok Actor", ND.FindBrok)
end
function SetupProps()
  stoneProp = GameObjects.fastTravelStoneProp.Child
  HideProps()
end
function HideProps()
  stoneProp:Hide()
end
function ShowProps()
  stoneProp:Show()
end
function SetupHintSeq()
  hintSeq = LD.CreateCineSequence(thisLevel, thisObj, "FastTravelIntro_Hint")
  hintSeq:WaitForFunctionTrue(function()
    return not IsBrokTraveling()
  end)
  hintSeq:WaitSeconds(13)
  hintSeq:Do(function()
    game.Audio.PlayBanterNonCritical("033_FastTravelIntro_ComeHere")
  end)
  hintSeq:StartSequence()
end
function TrySetupSeq()
  if CanPlaySeq() then
    SetupSeq()
  end
end
function SetupSeq()
  seq = LD.CreateCineSequence(thisLevel, thisObj, "FastTravelIntro")
  local slaveTab = {
    {Actor = brokActor},
    {
      Obj = stoneProp,
      Anim = "poiCalFastTravelIntro"
    }
  }
  seq:CancelSequence(hintSeq)
  seq:Do(DisableHintBanterZones)
  seq:Do(function()
    brokActor:GetCreature():EndInteract()
  end)
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_FastTravelIntro",
    ReferenceJoint = "FastTravelIntro_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.InteractStopDistance,
    weapon_state = "bare"
  })
  seq:Do(ShowProps)
  seq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = "BRA_FastTravelIntro",
    ReferenceJoint = "FastTravelIntro_SynchJoint"
  })
  seq:Do(PlayVO)
  seq:Do(function()
    game.Player.FindPlayer().Pad:DisableGameButton(tweaks.ePad.kPadSquare)
  end)
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:Do(function()
    game.Player.FindPlayer().Pad:EnableGameButton(tweaks.ePad.kPadSquare)
  end)
  seq:Do(HideProps)
  seq:StopPuppetingActor(kraActor)
  seq:StopPuppetingActor(brokActor)
  seq:Do(BranchBrokToTableIdle)
  seq:WaitForFunctionTrue(FinishedFastTravelVO)
  seq:WaitForFunctionTrue(PlayerIsNotInTheShopMenu)
  seq:Do(function()
    game.World.DisablePlayerStateSoftSave()
  end)
  seq:Do(CompleteFastTravelIntro)
  seq:Do(RiverPass_950)
  seq:Do(CheckpointAndBookmark)
  seq:StartSequence()
end
function DisableHintBanterZones()
  GameObjects.Btr_FastTravelIntro_LockedIn.Child.LuaObjectScript.Disable()
  GameObjects.BanterZone_FastTravelIntro_Russian.Child.LuaObjectScript.Disable()
end
function PlayVO()
  game.Compass.SetDesignerForcedHide(true)
  game.Audio.PlayBanter("033_FastTravelIntro_Scene", function()
    finishedVO = true
  end)
end
function FinishedFastTravelVO()
  return finishedVO
end
function PlayerIsNotInTheShopMenu()
  return game.Player.FindPlayer():GetCurrentInteractObject() == nil
end
function RiverPass_950()
  game.QuestManager.ProposeQuestState("Quest_RiverPass_Objective950", "Complete")
  game.Compass.SetDesignerForcedHide(false)
end
function LuaHook_Sound_TriggerDoorForm()
  game.FindLevel("Cal120_Airlock"):CallScript("StartDoorForm_Sound")
end
function LuaHook_TriggerDoorForm()
  game.FindLevel("Cal120_Airlock"):CallScript("StartDoorForm")
end
function LuaHook_TriggerDoorCollapse()
  game.FindLevel("Cal120_Airlock"):CallScript("StartDoorCollapse")
end
function CompleteFastTravelIntro()
  if game.Wallets.GetResourceValue("HERO", "FastTravelUnlock01") == 0 then
    game.Wallets.AddResource("HERO", "FastTravelUnlock01", 1, "NO_TELEMETRY")
  else
    LD.GiveFastTravelStageOne()
  end
  GameObjects.FastTravelPoint.LuaObjectScript.FastTravelZoneEntered()
  GameObjects.LargeShop:FindSingleGOByName("vendorInteract").LuaObjectScript.DisableCinematicTrigger()
  _G.FastTravelIntroDone()
end
function CheckpointAndBookmark()
  game.World.EnablePlayerStateSoftSave()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "03_Caldera_020_FastTravelAcquired"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function BranchBrokToTableIdle()
  GameObjects.LargeShop.LuaObjectScript.StartCounterRequest(brokActor:GetCreature())
end
function IsBrokTraveling()
  local brok = ND.FindBrok()
  return brok ~= nil and brok:IsPlayingMove("MOV_CalShopIntro") and brok.AnimFrame / brok.AnimLengthFrames <= 0.9
end
function CanPlaySeq()
  return game.Level.GetVariable("CompletedCineNumber") == 183 and seq == nil and game.Wallets.GetResourceValue("HERO", "FastTravelUnlock01") <= 0
end
