local LD = require("design.LevelDesignLibrary")
local doorObj, realm, previousRealm
function OnScriptLoaded(level, obj)
  doorObj = GameObjects.SpreadDoor_Caldera_AirLock
  realm = LD.GetCurrentRealm()
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {previousRealm = previousRealm}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  previousRealm = savedInfo.previousRealm
end
local realmDoorSounds = {
  Helheim = {
    OnInteractForward_Center = "SND_WIND_Caldera_Helheim_Door_Open_01",
    OnInteractBackward_Center = "SND_WIND_Caldera_Helheim_Door_Open_01"
  },
  Alfheim = nil,
  default = {OnInteractForward_Center = "", OnInteractBackward_Center = ""}
}
function UpdateRealm(mRealm)
  print("SpreadDoor_RealmHelper received the updated realm: ", mRealm, " previous Realm: ", previousRealm)
  if previousRealm ~= mRealm then
    realm = mRealm
    SetCurrentSoundForDoor()
    previousRealm = realm
  end
end
function SetCurrentSoundForDoor()
  if realmDoorSounds[realm] ~= nil then
    doorObj.LuaObjectScript.SoundSetup(realmDoorSounds[realm])
  else
    doorObj.LuaObjectScript.SoundSetup(realmDoorSounds.default)
  end
end
