local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local banterPlayed = {}
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  GameObjects.BtrComp_030_EnteringMidgard12.LuaObjectScript.DisableConsoleError("030_EnteringMidgard12")
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {banterPlayed = banterPlayed}
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    banterPlayed = savedInfo.banterPlayed
  end
end
function UpsideDown1A_Finished()
  timers.StartLevelTimer(3, UpsideDown1B_Banter)
  banterPlayed.UpsideDown1A = true
end
function UpsideDown1B_Banter()
  if not banterPlayed.UpsideDown1B then
    game.Audio.PlayBanterNonCritical("020_UpsideDown1B", function()
      timers.StartLevelTimer(15, UpsideDown1C_Banter)
    end)
    banterPlayed.UpsideDown1B = true
  end
end
function UpsideDown1C_Banter()
  if not banterPlayed.UpsideDown1C and not banterPlayed.JotunDoor then
    game.Audio.PlayBanterNonCritical("020_UpsideDown1C")
    banterPlayed.UpsideDown1C = true
  end
end
function CanPlayTalismanClose()
  return game.Level.GetVariable("CAL_TempleFlipped") == true and game.Level.GetVariable("CompletedCineNumber") == 510
end
