local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj
local playBtr = {
  bifrostBubble = false,
  selectHel = false,
  travelToHel = false
}
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {played = playBtr}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playBtr = savedInfo.played
end
function PlayBifrostBubble()
  if not playBtr.bifrostBubble and game.Level.GetVariable("CompletedCineNumber") >= 190 and game.Level.GetVariable("CompletedCineNumber") < 210 then
    timers.StartLevelTimer(2, function()
      game.Audio.PlayBanter("FreyaBifrostBubble")
    end)
    playBtr.bifrostBubble = true
  end
end
function PlayBanter_OnInteractStart()
  timers.StartLevelTimer(0.1, function()
    if LD.GetSelectedRealm() == "Helheim" and LD.GetCurrentRealm() == "Midgard" and game.Level.GetVariable("CompletedCineNumber") == 383 then
      game.Audio.PlayBanter("020_HelheimTravelRune_02", nil, nil, false)
    end
  end)
end
function PlayBanter_OnRotate()
  timers.StartLevelTimer(0.1, function()
    if LD.GetSelectedRealm() == "Helheim" and LD.GetCurrentRealm() == "Midgard" and game.Level.GetVariable("CompletedCineNumber") == 383 then
      game.Audio.PlayBanter("020_HelheimTravelRune_02", nil, nil, false)
    end
  end)
end
function PlayBanter_OnActivated()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  local currentRealm = LD.GetCurrentRealm()
  if currentRealm == "Midgard" and cineNumber == 250 then
    game.Audio.PlayBanter("TravelWithoutMoving")
  elseif currentRealm ~= "Alfheim" and cineNumber == 250 then
    game.Audio.PlayBanter("RealmTravelRoom3_Other")
  elseif currentRealm == "Helheim" and cineNumber == 383 then
    game.Audio.PlayBanter("020_HelheimTravelRune_03")
  elseif currentRealm == "Midgard" and cineNumber == 387 then
    game.Audio.PlayBanter("030_MimirRealTalk")
  elseif cineNumber == 500 then
    game.Audio.PlayBanter("250_MimirBewitched")
  elseif cineNumber == 515 and game.Level.GetVariable("_GBL_RealmTravel_JotunheimFailed") and not game.Level.GetVariable("CAL_NAR_EyesOnThePrize") then
    game.Audio.PlayBanter("050_SindriSnakeOffCrit")
  elseif currentRealm == "Midgard" and cineNumber == 610 then
    game.Audio.PlayBanter("020_MidgardWeatherReport")
  end
  if cineNumber ~= 570 then
    GameObjects.Btr_RoadLore.LuaObjectScript.TryToPlayRoadLore()
  end
end
function PlayBanter_OnTravelComplete()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if LD.GetCurrentRealm() == "Alfheim" and cineNumber < 210 then
    game.Audio.PlayBanter("FreyaBifrostBubble_End")
    LD.DisableBoatLore()
  end
  GameObjects.Btr_RoadLore.LuaObjectScript.ResetAttemptedToPlayRecently()
end
function StartLTWPart7()
  local freObj = LD:FindFreya()
  local calFre100 = game.FindLevel("FreyaLTW")
  if calFre100 ~= nil and freObj ~= nil and game.Level.GetVariable("CompletedCineNumber") == 195 then
    timers.StartLevelTimer(0.2, function()
      calFre100:CallScript("LTW_EnterRealmTravel")
    end)
  end
end
