local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel, kraActor, sonActor, brokActor, sindriActor, cameraCineEnter, cine_lights_580
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") >= 570 and game.Level.GetVariable("CompletedCineNumber") < 580 then
    CreateActors()
    SpawnBrok()
    SpawnSindri()
    cine_lights_580 = GameObjects.Cine_Start_580
    HideCineLights()
  else
    HideZones()
    cine_lights_580 = GameObjects.Cine_Start_580
    HideCineLights()
  end
end
function CreateActors()
  kraActor = actor.Actor.New("SAYING GOODBYE: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SAYING GOODBYE: Son Actor", game.AI.FindSon)
  brokActor = actor.Actor.New("SAYING GOODBYE: Brok Actor")
  sindriActor = actor.Actor.New("SAYING GOODBYE: Sindri Actor")
end
function ShowZones()
  GameObjects.Cine_SayingGoodbye_Group:ShowEntityVolume()
  GameObjects.NoGoZone_SayingGoodbye:Show()
end
function HideZones()
  GameObjects.Cine_SayingGoodbye_Group:HideEntityVolume()
  GameObjects.NoGoZone_SayingGoodbye:Hide()
end
function SpawnBrok()
  brokActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_SayingGoodbye_Group", "Bro_SayingGoodbye_StartJoint", "CRT_Brok00", "BRA_SayingGoodbye", "brok")
  end)
end
function SpawnSindri()
  sindriActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_SayingGoodbye_Group", "Sin_SayingGoodbye_StartJoint", "CRT_Sindri00", "BRA_SayingGoodbye", "sindri")
  end)
end
function SayingGoodbyeSequence(rootsObj)
  if game.Level.GetVariable("CompletedCineNumber") >= 570 and game.Level.GetVariable("CompletedCineNumber") < 580 then
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "SayingGoodbye")
    local sayingGoodbye_ActorTable = {
      {Actor = sonActor},
      {Actor = brokActor},
      {Actor = sindriActor}
    }
    cineSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", "SND_MX_JOT_start_master")
    local LM = require("level.loadmonitor")
    local jot050Monitor = LM.CreateLoadMonitor()
    jot050Monitor:AddCallback({
      Wads = {
        "Jot050_Sound"
      },
      Functions = {
        function()
          cineSeq:MarkAbleToSkip()
        end
      }
    })
    cineSeq:SpawnActorAndWait(brokActor)
    cineSeq:SpawnActorAndWait(sindriActor)
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:Do(IncreaseKratosDeceleration)
    cineSeq:Do(PlayCineLights)
    cineSeq:ActorSync(kraActor, {
      Slaves = sayingGoodbye_ActorTable,
      Branch = "BRA_SayingGoodbye",
      ReferenceJoint = "SayingGoodbye_SynchJoint"
    })
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.06)
    cineSeq:Do(function()
      LD.UnlockWrapOnMimirBoatLore()
      rootsObj:JumpAnimToFrame(261)
      rootsObj:PauseAnim()
    end)
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.065)
    cineSeq:Do(function()
      rootsObj:JumpAnimationToFrame(0, {
        Animation = "narCalSayingGoodbyeCineScene"
      })
      rootsObj:PauseAnimation()
    end)
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.11)
    cineSeq:Do(function()
      GameObjects.realmControllerFXSequencing.LuaObjectScript.StopVortexLeaves()
    end)
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.98)
    cineSeq:DespawnActor(brokActor)
    cineSeq:DespawnActor(sindriActor)
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:WaitForLoadCheck("Cal300_JotunheimLH")
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:Do(ClearKratosDeceleration)
    cineSeq:Do(HideZones)
    cineSeq:Do(HideCineLights)
    cineSeq:Do(CompleteQuestCal880)
    cineSeq:Do(function()
      GameObjects.RealmTravelDoor_Jotunheim.LuaObjectScript.Disable()
    end)
    cineSeq:Do(EnableSonCA_JotunheimStairs)
    cineSeq:SetCompletedCineNumber(580)
    cineSeq:Do(StoreCheckpoint)
    cineSeq:StartSequence()
  end
end
function CompleteQuestCal880()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective880", "Complete")
end
function EnableSonCA_JotunheimStairs()
  local cal300 = game.FindLevel("Cal300_JotunheimLH")
  cal300:CallScript("EnableLTW_Up")
end
function PlayCineLights()
  GameObjects.worldCrystalRaise00:Show()
  cine_lights_580:Show()
  cine_lights_580:JumpAnimToFrame(0)
  cine_lights_580:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_580:Hide()
end
function IncreaseKratosDeceleration()
  game.Player.FindPlayer():SetDecelerationOverride(1.2)
  game.Player.FindPlayer():SetAccelerationOverride(1.2)
end
function ClearKratosDeceleration()
  game.Player.FindPlayer():ClearDecelerationOverride()
  game.Player.FindPlayer():ClearAccelerationOverride()
end
function StoreCheckpoint()
  game.World.StoreCheckpoint()
end
function LuaHook_OpenJotunheimDoor()
  GameObjects.RealmTravelDoor_Jotunheim.LuaObjectScript.ForceAutoOpen(0.75)
end
function LuaHook_ExtendRootBridge()
  GameObjects.realm_controller_object.LuaObjectScript.EnableTable()
  GameObjects.realm_controller_object.LuaObjectScript.ResetPressurePlatesAndRootBridgeToRealmDirection("Jotunheim")
  GameObjects.worldTreeBridge00_P.LuaObjectScript.Extend()
end
function LuaHook_StartBeamRumble()
  GameObjects.realmControllerFXSequencing.LuaObjectScript.StartBeamImpactVibration()
end
function LuaHook_StopBeamRumble()
  GameObjects.realmControllerFXSequencing.LuaObjectScript.StopBeamImpactVibration()
end
function LuaHook_ForceTravelCompleteCleanup()
  GameObjects.realmControllerFXSequencing.LuaObjectScript.Event_OnLoadComplete("Jotunheim")
end
