local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kratosActor, sonActor, newOrb, oldOrb, newMask, oldMask, centerIsland, cineEnterCamera_TalismanAcquire
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  newOrb = GameObjects.keyOrb.Child
  oldOrb = GameObjects.KeyOrb_upright.Child
  oldMask = GameObjects.Mask_upright.Child
  newMask = GameObjects.Mask_upright_cine.Child
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, orb)
  newOrb:Hide()
  newMask:Hide()
end
function OnStart(level, obj)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  GameObjects.Btr_030_EnteringMidgard12:HideEntityVolume()
  GameObjects.TalismanInteract:Hide()
  GameObjects.TalismanInteract.LuaObjectScript.Disable()
  centerIsland = GameObjects.floor_mid
end
function EnableTalismanCine()
  GameObjects.TalismanInteract:Show()
  GameObjects.TalismanInteract.LuaObjectScript.Enable()
end
function OnUpdate()
  if cineEnterCamera_TalismanAcquire ~= nil then
    cineEnterCamera_TalismanAcquire:Update()
  end
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function TalismanAcquireSeq()
  CreateActors()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "talismanAcquire")
  local actorTable = {
    {Actor = sonActor},
    {
      Obj = newOrb,
      Anim = "narCalTalismanAcquire000Cine"
    },
    {
      Obj = newMask,
      Anim = "narCalTalismanAcquire000Cine"
    }
  }
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
  seq:MarkAbleToSkip()
  seq:RequestCineModeAndWait(kratosActor, thisObj)
  seq:Do(StartCineEnter_TalismanAcquire)
  seq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_TalismanAcquire",
    ReferenceJoint = "TalismanAcquire_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = true,
    prevent_path_eval = true,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  seq:Do(SwapProps)
  seq:ActorSync(kratosActor, {
    Slaves = actorTable,
    Branch = "BRA_TalismanAcquire",
    ReferenceJoint = "TalismanAcquire_SynchJoint"
  })
  seq:WaitUntilActorAnimPastFrame(kratosActor, 280)
  seq:Do(function()
    GameObjects.DispelSphere_Upright.LuaObjectScript.Kill()
  end)
  seq:WaitUntilActorAnimPastFrame(kratosActor, 320)
  seq:Do(function()
    GameObjects.DispelSphere_Upright.LuaObjectScript.Dispel()
    _G.TurnOffUpperLensFlare()
    RestoreRealmTravelRoom()
  end)
  seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  seq:StopPuppetingActor(sonActor)
  seq:StopPuppetingActor(kratosActor)
  seq:Do(function()
    newOrb:Hide()
    newMask:Hide()
    GameObjects.realm_controller_object.LuaObjectScript.UnlockDoor(GameObjects.RealmTravelDoor_Vanaheim, true)
  end)
  seq:SetCompletedCineNumber(512)
  seq:Do(_G.TakeRuneStone)
  seq:Do(StartBetweenTheRealmsQuest)
  seq:Do(EndOfCine)
  seq:StartSequence()
end
function StartBetweenTheRealmsQuest()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective735", "Complete")
  LD.ActivateQuest("Quest_RealmBetweenRealms_Parent")
end
function SwapProps()
  oldOrb:Hide()
  newOrb:Show()
  oldMask:Hide()
  newMask:Show()
end
function RestoreRealmTravelRoom()
  GameObjects.CenterCollision:ShowCollision()
  GameObjects.realm_controller_object.LuaObjectScript.NarrativeUnlock()
  GameObjects.realmControllerFXSequencing.LuaObjectScript.SetRoomState_TalismanAcquired()
  centerIsland:PlayAnimationToEnd({Rate = -0.24})
  centerIsland:OnAnimationDone(thisObj, "FloorMidAnimationFinished")
end
function FloorMidAnimationFinished()
  centerIsland:ClearAllAnimCallbacks()
  GameObjects.realm_controller_object.LuaObjectScript.ResetPressurePlatesAndRootBridgeToRealmDirection("Midgard")
  GameObjects.worldTreeBridge00_P.LuaObjectScript.Extend()
end
function EndOfCine()
  game.World.StoreCheckpoint()
  timers.StartLevelTimer(8.5, function()
    game.Audio.PlayBanter("020_MightAsWellJump1", function()
      GameObjects.Btr_030_EnteringMidgard12:ShowEntityVolume()
    end)
  end)
end
function StartCineEnter_TalismanAcquire()
  GameObjects.TempleFlipSonSpline.LuaObjectScript.Disable()
  GameObjects.TempleFlipSon_ShieldEyes.LuaObjectScript.Disable()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_TalismanAcquire = CCEC.CineEnterCamera.New("ENV_CineEnter_TalismanAcquired", 7)
  cineEnterCamera_TalismanAcquire:SetCallback(DestroyCineEnter_TalismanAcquire)
  cineEnterCamera_TalismanAcquire:Start()
end
function DestroyCineEnter_TalismanAcquire()
  cineEnterCamera_TalismanAcquire = nil
  game.SubObject.Sleep(thisObj)
end
