local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local timers = require("level.timer")
local thisObj, thisLevel, kraActor, sonActor, freActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  SetupActors()
end
function SpawnFreya()
  local freObj = LD.FindFreya()
  local freWad = game.FindLevel("FreyaLvl100_Global")
  local jointFace = thisObj:GetWorldJointForward(thisObj:GetJointIndex("Fre_StartJoint"))
  local jointPos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex("Fre_StartJoint"))
  if freObj == nil and freWad ~= nil then
    freObj = game.AI.Spawn(freWad, jointPos, jointFace, "CRT_Freya00")
  end
  return freObj
end
function SetupActors()
  kraActor = actor.Actor.New("REALM TRAVEL ROOM II: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("REALM TRAVEL ROOM II: Son Actor", game.AI.FindSon)
  freActor = actor.Actor.New("REALM TRAVEL ROOM II: Freya Actor", LD.FindFreya)
end
function SetupPOISeq()
  local ltwStage = game.Level.GetVariable("FreyaLTWStage")
  if ltwStage == 60 then
    local doorObj = GameObjects.RealmTravelDoor_Jotunheim.Child
    local seq = LD.CreateCineSequence(thisLevel, doorObj, "RealmTravelRoom2Sequence")
    local slaveTab = {
      {Actor = sonActor},
      {Actor = freActor},
      {
        Obj = doorObj,
        Anim = "poiCalRealmTravelRoom2"
      }
    }
    doorObj.LuaObjectScript.EnableCinematicTrigger()
    local freObj = LD:FindFreya()
    local calFre100 = game.FindLevel("FreyaLTW")
    if calFre100 ~= nil and freObj ~= nil then
      timers.StartLevelTimer(0.2, function()
        calFre100:CallScript("LTW_EnterRealmTravel")
      end)
    end
    seq:RequestCineModeAndWait(kraActor, thisObj)
    seq:Do(SpawnFreya)
    seq:WaitSeconds(0.2)
    seq:WaitForFunctionTrue(function()
      return LD.FindFreya() ~= nil
    end)
    seq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_RealmTravelRoom2",
      ReferenceJoint = "synchJointBack",
      speed = ND.KraWalkSpeed,
      stop = false,
      foot = game.Creature.Foot.kLeft,
      radius = ND.ArrivalRadius,
      weapon_state = "bare"
    })
    seq:ActorSync(kraActor, {
      Slaves = slaveTab,
      Branch = "BRA_RealmTravelRoom2",
      ReferenceJoint = "synchJointBack"
    })
    seq:Do(function()
      doorObj.LuaObjectScript.RealmTravelRoom2POISoundSequence()
    end)
    seq:Do(SetupRealmTravelIntroPOI)
    seq:WaitSeconds(4.5)
    seq:Do(PlayPOIBanter)
    seq:WaitForAndCompleteCineMode(kraActor, thisObj)
    seq:StopPuppetingActor(sonActor)
    seq:StopPuppetingActor(kraActor)
    seq:StopPuppetingActor(freActor)
    seq:Do(QuestComplete)
    seq:StartSequence()
  elseif ltwStage == 70 then
    SetupRealmTravelIntroPOI()
  end
end
function QuestComplete()
  LD.CompleteQuest("Quest_Foothills_Objective502")
end
function PlayPOIBanter()
  game.Audio.PlayBanter("RealmTravelRoom2")
end
function SetupRealmTravelIntroPOI()
  GameObjects.Cine_RealmTravelIntro.LuaObjectScript.SetupRealmTravelIntro()
end
function LuaHook_StartIntroFX()
  local cal130 = game.FindLevel("Cal130_TempleInt")
  local fxObjectRef = cal130:FindSingleGameObject("realmControllerFXSequencing")
  fxObjectRef:CallScript("Callscript_StartIntroFx")
end
function LuaHook_StartRootBridgeAnim()
  GameObjects.realm_controller_object.LuaObjectScript.AnimateRootBridge_OnEnterRoom(1, 0)
  GameObjects.freyaIntroDarken:Hide()
end
function LuaHook_Sound_OpenDoorPartial()
  local doorObj = GameObjects.RealmTravelDoor_Jotunheim.Child
  doorObj.LuaObjectScript.PlaySoundDoorLeft("SND_DOOR_Realm_Room_Double_Freya_Open_Partial_L")
  doorObj.LuaObjectScript.PlaySoundDoorRight("SND_DOOR_Realm_Room_Double_Freya_Open_Partial_R")
end
function Luahook_Sound_OpenDoorShift()
  local doorObj = GameObjects.RealmTravelDoor_Jotunheim.Child
  doorObj.LuaObjectScript.PlaySoundDoorLeft("SND_DOOR_Realm_Room_Double_Freya_ShiftToOpen_L")
  doorObj.LuaObjectScript.PlaySoundDoorRight("SND_DOOR_Realm_Room_Double_Freya_ShiftToOpen_R")
end
function LuaHook_Sound_OpenDoorFull()
  local doorObj = GameObjects.RealmTravelDoor_Jotunheim.Child
  doorObj.LuaObjectScript.PlaySoundDoorLeft("SND_DOOR_Realm_Room_Double_Freya_Open_Full_L")
  doorObj.LuaObjectScript.PlaySoundDoorRight("SND_DOOR_Realm_Room_Double_Freya_Open_Full_R")
end
