local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local color = require("core.color")
local uiCalls = require("ui.uicalls")
local mpicon = require("ui.mpicon")
local CCOS = require("camera.camera_oneshot")
local CSL = require("camera.shakelibrary")
local monitors = require("level.MonitorLibrary")
local player, son, thisLevel, soundEmitter, soundOnStretch, attemptType
local bifrostLit = false
local bRoomDiscovered = false
local bFlipAttempted = false
local bSonWaitingAtDoor = false
local cameraType = 1
local climbUp
local bDoorsEnabled = false
local templeFlipPoint = {
  Stuck = nil,
  Success = nil,
  current = nil
}
local tnfChainsBroken = {left = false, right = false}
local templeFlipChains, calderaTemple
local bOutside = true
local bFirstFlipStarted = false
local cal700, camOneShot_JotunheimRune, camOneShot_JotunheimDoor
local kLookAtLength_Rune = 12
local kLookAtLength_DoorStartDelay = 4
local kLookAtLength_Door = 10
local bNearSmallDoor1 = false
local b720unloaded
function OnScriptLoaded(level)
  son = game.AI.FindSon()
  player = game.Player.FindPlayer()
  thisLevel = level
  templeFlipPoint.Stuck = GameObjects.templeFlipPoint_Stuck
  templeFlipPoint.Success = GameObjects.templeFlipPoint_Success
  climbUp = thisLevel:GetGameObject("climbUp")
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_013", false)
  templeFlipChains = GameObjects.templeFlipChain00
  if templeFlipChains.IsRefNode then
    templeFlipChains = templeFlipChains.Child
  end
  calderaTemple = GameObjects.calderaTravelRoom_Refnode.Child
end
function OnFirstStart(level)
  GameObjects.BalconyBlocker:ShowNavObstacle()
  GameObjects.FakeJotenheimDoor:Hide()
  GameObjects.navGeo:Hide()
  HideRuneFounds()
  GameObjects.RuneBowl.LuaObjectScript.Disable()
  climbUp:HideTraversePath()
  GameObjects.swap_flipHide:Show()
  GameObjects.swap_flipShow:Hide()
  GameObjects.FlatCollision:HideCollision()
  GameObjects.CloseSmallDoor2:HideEntityVolume()
  GameObjects.CloseSmallDoor3:HideEntityVolume()
  game.EvaluateLoadZones()
end
function OnStart(level)
  SoundInit()
  if cal700 == nil then
    cal700 = game.FindLevel("Cal700_TempleFlip")
  end
  local tnfInteract1 = templeFlipPoint.Stuck.LuaObjectScript.GetInteractZone()
  tnfInteract1:SetHintXZRange(20)
  local tnfInteract2 = templeFlipPoint.Success.LuaObjectScript.GetInteractZone()
  tnfInteract2:SetHintXZRange(20)
  GameObjects.SlowZone:HideEntityVolume()
  local sonInteract = GameObjects.JotuheimRune.LuaObjectScript.GetInteractZone()
  sonInteract:SetInteractFrontAngle(30)
  sonInteract:SetHintAngle(120)
  if bFlipAttempted == true then
    templeFlipPoint.Stuck.LuaObjectScript.AddSlavesToSynch({
      Slave = templeFlipChains,
      Anim = "envTempleFlipEnter"
    })
  end
  local cal720 = game.FindLevel("Cal720_LowerCenterRoom")
  if cal720 and b720unloaded == true then
    b720unloaded = false
    cal720:CallScript("EnableElevator")
    PlayRuneBowlSwitchSound()
    GameObjects.runebowlSink:PlayAnimToEnd()
    GameObjects.runebowlSink:OnAnimationDone(thisLevel, "HideRuneBowl")
  end
end
function OnUpdate(level)
  if camOneShot_JotunheimRune ~= nil then
    camOneShot_JotunheimRune:Update()
  end
  if camOneShot_JotunheimDoor ~= nil then
    camOneShot_JotunheimDoor:Update()
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_FlippedClimb_LimitedRange") then
    game.Camera.SubmitCameraByName("PLYR_CrackClimb_Limited_65_LimitDown")
  end
end
function Cal200LoadCheck()
  game.UI.LoadCheck("Cal200_Shore", "WaterGlobal", "Cal075_Lighting")
end
function OnSaveCheckpoint(level)
  return {
    bFlipAttempted = bFlipAttempted,
    bDoorsEnabled = bDoorsEnabled,
    bifrostLit = bifrostLit,
    bRoomDiscovered = bRoomDiscovered,
    bSonWaitingAtDoor = bSonWaitingAtDoor,
    bOutside = bOutside,
    bFirstFlipStarted = bFirstFlipStarted,
    b720unloaded = b720unloaded
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  bFlipAttempted = savedInfo.bFlipAttempted
  bDoorsEnabled = savedInfo.bDoorsEnabled
  bifrostLit = savedInfo.bifrostLit
  bRoomDiscovered = savedInfo.bRoomDiscovered
  bSonWaitingAtDoor = savedInfo.bSonWaitingAtDoor
  bOutside = savedInfo.bOutside
  bFirstFlipStarted = savedInfo.bFirstFlipStarted
  b720unloaded = savedInfo.b720unloaded
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Cal130_TempleInt" then
    GameObjects.FakeAsgardGate:Hide()
    GameObjects.FakeJotenheimDoor:Hide()
    OpenSmallDoor2()
    OpenSmallDoor3()
    if bNearSmallDoor1 then
      OpenSmallDoor1()
    end
  end
  if newLevel.Name == "WAD_Cal700_TempleFlip" then
    cal700 = newLevel
    if bDoorsEnabled then
      if not LD.GetEntityVariable("CAL_TempleFlipped") then
        OpenJotunheimDoor()
      end
      OpenSmallDoor2()
      OpenSmallDoor3()
    end
  end
  if newLevel.Name == "WAD_Cal720_LowerCenterRoom" and b720unloaded == true then
    newLevel:CallScript("EnableElevator")
    GameObjects.runebowlSink:PlayAnimToEnd()
    GameObjects.runebowlSink:OnAnimationDone(thisLevel, "HideRuneBowl")
    b720unloaded = false
  end
end
function OnWadUnloaded(level, newLevel)
  if newLevel ~= level then
    if newLevel.Name == "WAD_Cal130_TempleInt" then
      GameObjects.FakeAsgardGate:Show()
      GameObjects.FakeJotenheimDoor:Show()
      SlamCloseSmallDoor1()
      SlamCloseSmallDoor2()
      SlamCloseSmallDoor3()
    end
    if newLevel.Name == "WAD_Cal700_TempleFlip" then
      CloseJotunheimDoor()
      SlamCloseSmallDoor2()
      SlamCloseSmallDoor3()
    end
  end
end
function OnEvaluateLoadGroup_TempleFlipLight()
  if bOutside then
    return "TempleFlipOutside"
  else
    return "TempleFlipInside"
  end
end
function EnterRedDoorCloseBehind()
  game.SubmitActivityFeedStory("11_TempleFlip")
  bOutside = false
  game.EvaluateLoadZones()
  if not bifrostLit then
    GameObjects.IdleSonOnStairs.LuaObjectScript.Enable()
  else
    GameObjects.PullSonThroughDoor.LuaObjectScript.Enable()
  end
end
function EnterRedDoorOpen()
  EnableSpline1()
end
function ExitRedDoor()
  bOutside = true
  game.EvaluateLoadZones()
  DisableSpline1()
  GameObjects.IdleSonOnStairs.LuaObjectScript.Disable()
  CloseSmallDoor1()
  CloseSmallDoor2()
  CloseSmallDoor3()
end
function LoadCheckCal130()
  if bifrostLit == true then
    game.UI.LoadCheck("Cal130_TempleInt")
  end
end
function BifrostLit()
  if not bifrostLit then
    if player:IsInsideEntityZone("InLoadHall") then
      game.UI.LoadCheck("Cal130_TempleInt")
    end
    GameObjects.SlowZone:ShowEntityVolume()
    GameObjects.IdleSonOnStairs.LuaObjectScript.Disable()
    GameObjects.bridgeCollision:HideCollision()
    OpenSmallDoor1()
    EnableSpline1()
    bifrostLit = true
    GameObjects.Bridge_NavObstacle1:HideNavObstacle()
    GameObjects.Bridge_NavObstacle2:HideNavObstacle()
    GameObjects.Bridge_NavObstacle3:HideNavObstacle()
    GameObjects.Cal140_Banter.LuaObjectScript.Hide_FlipEntranceB_TimerZone()
    if LD.GetEntityVariable("CAL_TempleFlipped") then
      bDoorsEnabled = true
    else
      timers.StartLevelTimer(0.25, function()
        game.FindLevel("Cal130_TempleInt"):CallScript("CycleLowerLensFlare")
      end)
    end
  end
end
function BifrostUnlit()
  if bifrostLit then
    GameObjects.bridgeCollision:ShowCollision()
    CloseSmallDoor1()
    bifrostLit = false
    GameObjects.Bridge_NavObstacle1:ShowNavObstacle()
    GameObjects.Bridge_NavObstacle2:ShowNavObstacle()
    GameObjects.Bridge_NavObstacle3:ShowNavObstacle()
  end
end
function ShowPlayerDoor()
  game.UI.LoadCheck("Cal700_TempleFlip")
  OpenJotunheimDoor()
  GameObjects.lookUpAtSphere.LuaObjectScript.Disable()
  timers.StartLevelTimer(5, FirstOpen)
end
function FirstOpen()
  game.Audio.PlayBanter("045_SmallDoorOpens")
  bDoorsEnabled = true
  OpenSmallDoor2()
  OpenSmallDoor3()
  TurnOnInteriorZone()
  EnableSpline1()
  GameObjects.ShowPlayerDoor2.LuaObjectScript.Enable()
  GameObjects.ShowPlayerDoor3.LuaObjectScript.Enable()
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_013", true)
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_011x", true)
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_011x1", false)
end
function EnableSpline1()
  if not bRoomDiscovered then
    GameObjects.LeadTheWay1_1.LuaObjectScript.Enable()
    GameObjects.LeadTheWay1_2.LuaObjectScript.Enable()
    GameObjects.LeadTheWay2.LuaObjectScript.Enable()
  end
end
function DisableSpline1()
  GameObjects.LeadTheWay1_1.LuaObjectScript.Disable()
  GameObjects.LeadTheWay1_2.LuaObjectScript.Disable()
  GameObjects.LeadTheWay2.LuaObjectScript.Disable()
end
function DisableInsideCAs()
  GameObjects.ShowPlayerDoor2.LuaObjectScript.Disable()
  GameObjects.ShowPlayerDoor3.LuaObjectScript.Disable()
end
function SonLookingUpAtSphere()
  GameObjects.PromptSphereBanter.LuaObjectScript.Enable()
  DisableSpline1()
end
function TurnOnSpeedZone()
  GameObjects.SlowZone:ShowEntityVolume()
  GameObjects.SlowZone:Show()
end
function TurnOffSpeedZone()
  GameObjects.SlowZone:HideEntityVolume()
  GameObjects.SlowZone:Hide()
  LoadCheckCal130()
end
function OpenSmallDoor1()
  SlamCloseSmallDoor2()
  SlamCloseSmallDoor3()
  timers.StartLevelTimer(5, function()
    GameObjects.Door1Collision:HideCollision()
  end)
  GameObjects.SmallDoor1:PlayAnimationToEnd({Rate = 0.2})
  if GameObjects.SmallDoor1.AnimPercent < 0.9 then
    PlayDoorStart1()
  end
end
function ApproachSmallDoor1()
  bNearSmallDoor1 = true
  if player:IsInsideEntityZone("InsideTemple") then
    OpenSmallDoor1()
  elseif game.FindLevel("Cal130_TempleInt") then
    OpenSmallDoor1()
  end
end
function LeaveSmallDoor1()
  bNearSmallDoor1 = false
end
function CloseSmallDoor1()
  GameObjects.Door1Collision:ShowCollision()
  GameObjects.SmallDoor1:PlayAnimationToEnd({Rate = -0.25})
  if GameObjects.SmallDoor1.AnimPercent > 0.1 then
    PlayDoorStart1()
  end
end
function CloseSmallDoor1FromInside()
  if not son:InsideZone("InsideTemple") then
    WarpSonTo(GameObjects.Door1_in)
  end
end
function OpenSmallDoor2()
  if bDoorsEnabled then
    timers.StartLevelTimer(5, function()
      GameObjects.Door2Collision:HideCollision()
    end)
    GameObjects.SmallDoor2:PlayAnimationToEnd({Rate = 0.2})
    if GameObjects.SmallDoor2.AnimPercent < 0.9 then
      PlayDoorStart2()
    end
  end
end
function OpenSmallDoor3()
  if bDoorsEnabled then
    timers.StartLevelTimer(5, function()
      GameObjects.Door3Collision:HideCollision()
    end)
    GameObjects.SmallDoor3:PlayAnimationToEnd({Rate = 0.2})
    if GameObjects.SmallDoor3.AnimPercent < 0.9 then
      PlayDoorStart3()
    end
  end
end
function CloseSmallDoor2()
  GameObjects.Door2Collision:ShowCollision()
  GameObjects.SmallDoor2:PlayAnimationToEnd({Rate = -0.25})
  if GameObjects.SmallDoor2.AnimPercent > 0.1 then
    PlayDoorStart2()
  end
end
function CloseSmallDoor3()
  GameObjects.Door3Collision:ShowCollision()
  GameObjects.SmallDoor3:PlayAnimationToEnd({Rate = -0.25})
  if GameObjects.SmallDoor3.AnimPercent > 0.1 then
    PlayDoorStart3()
  end
end
function SlamCloseSmallDoor1()
  GameObjects.Door1Collision:ShowCollision()
  GameObjects.SmallDoor1:PlayAnimationToEnd({Rate = -10})
end
function SlamCloseSmallDoor2()
  GameObjects.Door2Collision:ShowCollision()
  GameObjects.SmallDoor2:PlayAnimationToEnd({Rate = -10})
end
function SlamCloseSmallDoor3()
  GameObjects.Door3Collision:ShowCollision()
  GameObjects.SmallDoor3:PlayAnimationToEnd({Rate = -10})
end
function TurnOnInteriorZone()
  GameObjects.CloseSmallDoor2:ShowEntityVolume()
  GameObjects.CloseSmallDoor3:ShowEntityVolume()
end
function OpenJotunheimDoor()
  local leftDoor = GameObjects.JotunDoor:FindSingleGOByName("greydoor_left")
  local leftDoorCover = GameObjects.JotunDoor:FindSingleGOByName("door_left")
  local rightDoor = GameObjects.JotunDoor:FindSingleGOByName("greydoor_right")
  local rightDoorCover = GameObjects.JotunDoor:FindSingleGOByName("door_right")
  local leftAnimBase = GameObjects.JotunDoor:FindSingleGOByName("base_left")
  local rightAnimBase = GameObjects.JotunDoor:FindSingleGOByName("base_right")
  local delay = 1
  timers.StartLevelTimer(delay, function()
    rightDoor:PlayAnimToFrame(220, 1)
    leftDoor:PlayAnimToFrame(220, 1)
    rightDoorCover:PlayAnimToFrame(220, 1)
    leftDoorCover:PlayAnimToFrame(220, 1)
    rightAnimBase:PlayAnimToFrame(220, 1)
    leftAnimBase:PlayAnimToFrame(220, 1)
    PlayTravelDoorOpen(rightDoor)
  end)
end
function CloseJotunheimDoor()
  local leftDoor = GameObjects.JotunDoor:FindSingleGOByName("greydoor_left")
  local leftDoorCover = GameObjects.JotunDoor:FindSingleGOByName("door_left")
  local rightDoor = GameObjects.JotunDoor:FindSingleGOByName("greydoor_right")
  local rightDoorCover = GameObjects.JotunDoor:FindSingleGOByName("door_right")
  local leftAnimBase = GameObjects.JotunDoor:FindSingleGOByName("base_left")
  local rightAnimBase = GameObjects.JotunDoor:FindSingleGOByName("base_right")
  rightDoor:PlayAnimToFrame(0, -1)
  leftDoor:PlayAnimToFrame(0, -1)
  rightDoorCover:PlayAnimToFrame(0, -1)
  leftDoorCover:PlayAnimToFrame(0, -1)
  rightAnimBase:PlayAnimToFrame(0, -1)
  leftAnimBase:PlayAnimToFrame(0, -1)
  PlayTravelDoorOpen(rightDoor)
end
function OpenSmallDoorsFromInside()
  if bDoorsEnabled and game.FindLevel("Cal700_TempleFlip") then
    if not LD.GetEntityVariable("CAL_TempleFlipped") then
      OpenJotunheimDoor()
    end
    OpenSmallDoor2()
    OpenSmallDoor3()
  end
end
function OpenSmallDoorsFromOutside()
  if bDoorsEnabled and game.FindLevel("Cal130_TempleInt") then
    OpenSmallDoor2()
    OpenSmallDoor3()
  end
end
function CloseSmallDoorsFromOutside()
  CloseSmallDoor3FromOutside()
  CloseSmallDoor2FromOutside()
end
function CloseSmallDoorsFromInside()
  CloseSmallDoor3FromInside()
  CloseSmallDoor2FromInside()
end
function OpenSmallDoorsFromOutside()
  if bDoorsEnabled and game.FindLevel("Cal130_TempleInt") then
    OpenSmallDoor2()
    OpenSmallDoor3()
  end
end
function CloseSmallDoor2FromOutside()
  CloseSmallDoor2()
  CloseSmallDoor3()
  if son:InsideZone("InsideTemple") then
    WarpSonTo(GameObjects.Door2_out)
  end
end
function CloseSmallDoor3FromOutside()
  CloseSmallDoor2()
  CloseSmallDoor3()
  if son:InsideZone("InsideTemple") then
    WarpSonTo(GameObjects.Door3_out)
  end
end
function CloseSmallDoor2FromInside()
  CloseSmallDoor2()
  if not son:InsideZone("InsideTemple") then
    WarpSonTo(GameObjects.Door2_in)
  end
end
function CloseSmallDoor3FromInside()
  CloseSmallDoor3()
  if not son:InsideZone("InsideTemple") then
    WarpSonTo(GameObjects.Door3_in)
  end
end
function CloseTempleFlipDoors()
  GameObjects.SmallDoor3:PlayAnimationToEnd({Rate = -1})
  GameObjects.SmallDoor2:PlayAnimationToEnd({Rate = -1})
end
function SwapTempleVisGroups()
  GameObjects.swap_flipHide:Hide()
  GameObjects.swap_flipShow:Show()
end
function EnteredRealmTravelBelow()
  uiCalls.UI_Event_DiscoverLocation("Realm Travel Room")
end
function ExitClimb()
  GameObjects.sonLookUpAtCrackClimb.LuaObjectScript.Disable()
  GameObjects.sonOnLedge.LuaObjectScript.Enable()
  CloseSmallDoor1()
  CloseSmallDoor2()
  CloseSmallDoor3()
end
function Cal720LoadCheck()
  game.UI.LoadCheck("Cal720_LowerCenterRoom")
end
function EnterRealmTravelRoom()
  GameObjects.sonOnLedge.LuaObjectScript.Disable()
end
function HideRuneFounds()
  local runeFounds = thisLevel:FindGameObjects("runeFound*")
  for _, rune in ipairs(runeFounds) do
    rune.LuaObjectScript.Disable()
  end
end
function KratosApproachesRune()
end
function DiscoverJotunheimRune()
  GameObjects.Cal140_Banter.LuaObjectScript.FlipAttempt1B_Banter()
  DisableSpline1()
  GameObjects.sonLookUpAtJotunheim.LuaObjectScript.Enable()
  bRoomDiscovered = true
  timers.StartLevelTimer(0, CamLookAt_JotunHeimRune)
  timers.StartLevelTimer(kLookAtLength_DoorStartDelay, CamLookAt_JotunHeimDoor)
end
function OnCrackClimb()
  GameObjects.sonLookUpAtCrackClimb.LuaObjectScript.Disable()
end
function TempleFlip_Start()
  game.Compass.SetDesignerForcedHide(true)
  tnfChainsBroken.left = LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
  tnfChainsBroken.right = LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
  if tnfChainsBroken.left == true and tnfChainsBroken.right == true then
    CloseJotunheimDoor()
    templeFlipPoint.current = templeFlipPoint.Success
    templeFlipChains.LuaObjectScript.AttemptLift_BothChainsBroken()
  else
    templeFlipPoint.current = templeFlipPoint.Stuck
  end
  if templeFlipPoint.current.IsRefNode then
    templeFlipPoint.current = templeFlipPoint.current.Child
  end
  if not bFlipAttempted then
    templeFlipChains.LuaObjectScript.AttemptLift_FirstTime()
  else
    GameObjects.Cal140_Banter.LuaObjectScript.FlipSuccessA_Banter()
  end
  mpicon.level.Create(calderaTemple, "WORLD_INTERACT_MASHBUTTON")
  mpicon.level.Off(templeFlipPoint.current, "WORLD_INTERACT_MASHBUTTON")
end
function TempleFlip_Idle()
  if player:IsPlayingMove("MOV_TNF_TempleFlip_Win1Stuck") or player:IsPlayingMove("MOV_TNF_TempleFlip_Win1Success") then
    mpicon.level.Create(calderaTemple, "WORLD_INTERACT_MASHBUTTON")
  end
end
function TempleFlip_WinSuccessStarted()
  PlaySoundTNF_WinSuccessStarted()
end
function TempleFlip_WinStuckStarted()
  if not bFirstFlipStarted then
    bFirstFlipStarted = true
    GameObjects.Cal140_Banter.LuaObjectScript.FlipAttempt1BB()
    game.Player.FindPlayer().Pad:DisableGameButton(tweaks.ePad.kPadSquare)
    game.Player.FindPlayer().Pad:DisableGameButton(tweaks.ePad.kPadUp)
  end
  PlaySoundTNF_WinStuckStarted()
end
function TempleFlip_StruggleComplete()
  mpicon.level.Off(calderaTemple, "WORLD_INTERACT_MASHBUTTON")
  GameObjects.cal140_Banter.LuaObjectScript.AttemptFlipLift()
  PlaySoundTNF_StruggleComplete()
end
function TempleFlip_WinStuck()
  if not bFlipAttempted then
    bFlipAttempted = "FirstAttempt"
    player:TriggerMoveEvent("LE_TNF_Win2StuckIdle_FirstAttempt")
    cal700:CallScript("Disable")
    GameObjects.RuneBowl.LuaObjectScript.Disable()
    GameObjects.sonLookDown.LuaObjectScript.Disable()
    GameObjects.sonLookUpAtTrolls.LuaObjectScript.Enable()
    timers.StartLevelTimer(8, function()
      LD.StopSound(soundEmitter, soundOnStretch)
    end)
  elseif not tnfChainsBroken.left and not tnfChainsBroken.right then
    player:TriggerMoveEvent("LE_TNF_Win2StuckIdle")
  elseif not tnfChainsBroken.left then
    player:TriggerMoveEvent("LE_TNF_Win2StuckIdle_L")
  elseif not tnfChainsBroken.right then
    player:TriggerMoveEvent("LE_TNF_Win2StuckIdle_R")
  end
end
function TempleFlip_WinStuckComplete()
  game.Compass.SetDesignerForcedHide(false)
  templeFlipChains.LuaObjectScript.DropTemple()
  if bFlipAttempted == true then
    GameObjects.Cal140_Banter.LuaObjectScript.FlipAttemptDone()
  end
end
function TempleFlip_WinSuccess()
  templeFlipChains.LuaObjectScript.SuccessLift_FlipTemple()
  LD.SetEntityVariable("CAL_TempleFlipped", true)
  bDoorsEnabled = false
  GameObjects.BalconyBlocker:HideNavObstacle()
  cal700:CallScript("HideInterior")
  timers.StartLevelTimer(4, function()
    GameObjects.RubbleCollision:HideCollision()
    GameObjects.FlatCollision:ShowCollision()
    SwapTempleVisGroups()
    GameObjects.BifrostTemporal_Intact1.LuaObjectScript.SetActive(false)
    GameObjects.BifrostTemporal_Intact1:Hide()
    BifrostUnlit()
    GameObjects.bifrostStairs:Hide()
  end)
end
function TempleFlip_WinComplete()
  game.Compass.SetDesignerForcedHide(false)
  LD.CompleteQuest("Quest_Caldera_Objective720")
  cal700:CallScript("DropChandelier")
  GameObjects.bridgeCollision:ShowCollision()
  GameObjects.sonLookUpAtCrackClimb.LuaObjectScript.Enable()
  GameObjects.FakeJotenheimDoor:Show()
  GameObjects.balconyCollision:HideCollision()
  climbUp:ShowTraversePath()
  GameObjects.Cal140_Banter.LuaObjectScript.FlipSuccessC_Banter()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "31_TempleFlip_050_TempleFlipped"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function TempleFlip_Failed()
  mpicon.level.Off(calderaTemple, "WORLD_INTERACT_MASHBUTTON")
  GameObjects.Cal140_Banter.LuaObjectScript.TempleLiftFail()
  PlaySoundTNF_Failed()
  SoundSetup_ResetStruggleOneShots()
end
function TempleFlip_FailedComplete()
  game.Player.FindPlayer().Pad:ClearAllDisabledGameButtons()
  if bFlipAttempted == true and (tnfChainsBroken.left == false or tnfChainsBroken.right == false) then
    templeFlipPoint.Stuck.LuaObjectScript.Enable()
    if tnfChainsBroken.left == false and tnfChainsBroken.right == false then
      templeFlipChains:OnAnimationDone(templeFlipChains, "JumpToNoChainsBroken", {Force = true})
    elseif tnfChainsBroken.left == false and tnfChainsBroken.right == true then
      templeFlipChains:OnAnimationDone(templeFlipChains, "JumpToRightChainBroken", {Force = true})
    elseif tnfChainsBroken.left == true and tnfChainsBroken.right == false then
      templeFlipChains:OnAnimationDone(templeFlipChains, "JumpToLeftChainBroken", {Force = true})
    else
      templeFlipChains:OnAnimationDone(templeFlipChains, "JumpToBothChainsBroken", {Force = true})
    end
    if templeFlipChains:GetAnimationName() == "default" then
      if tnfChainsBroken.left == false and tnfChainsBroken.right == false then
        templeFlipChains.LuaObjectScript.JumpToNoChainsBroken()
      elseif tnfChainsBroken.left == false and tnfChainsBroken.right == true then
        templeFlipChains.LuaObjectScript.JumpToRightChainBroken()
      elseif tnfChainsBroken.left == true and tnfChainsBroken.right == false then
        templeFlipChains.LuaObjectScript.JumpToLeftChainBroken()
      else
        templeFlipChains.LuaObjectScript.JumpToBothChainsBroken()
      end
    end
  elseif bFlipAttempted == "FirstAttempt" then
    bFlipAttempted = true
    cal700:CallScript("SwitchTrollCollision")
    DisableSpline1()
    templeFlipPoint.Stuck.LuaObjectScript.AddSlavesToSynch({
      Slave = templeFlipChains,
      Anim = "envTempleFlipEnter"
    })
    timers.StartLevelTimer(3, function()
      GameObjects.POI_CalTempleFlip010.LuaObjectScript.AttemptSeq()
      GameObjects.sonLookDown.LuaObjectScript.Disable()
      GameObjects.sonLookUpAtTrolls.LuaObjectScript.Disable()
    end)
  end
end
function HideChainDust()
  GameObjects.vfx_TEMP_bigDustFall1:Hide()
  GameObjects.vfx_TEMP_bigDustFall2:Hide()
  GameObjects.vfx_TEMP_bigDustFall3:Hide()
  GameObjects.vfx_TEMP_bigDustFall4:Hide()
  GameObjects.vfx_TEMP_bigDustFall5:Hide()
end
function ShowChainDust()
  GameObjects.vfx_TEMP_bigDustFall1:Show()
  GameObjects.vfx_TEMP_bigDustFall2:Show()
  GameObjects.vfx_TEMP_bigDustFall3:Show()
  GameObjects.vfx_TEMP_bigDustFall4:Show()
  GameObjects.vfx_TEMP_bigDustFall5:Show()
end
function WarpSonLeft()
  game.FindLevel("Cal740_LeftWing"):CallScript("OpenTraps")
  timers.StartLevelTimer(2, function()
    son:Warp(GameObjects.ObserveTemple_Left:GetWorldPosition(), GameObjects.ObserveTemple_Left:GetWorldForward())
  end)
end
function WarpSonRight()
  game.FindLevel("Cal750_RightWing"):CallScript("OpenAllTraps")
  timers.StartLevelTimer(2, function()
    son:Warp(GameObjects.ObserveTemple_Right:GetWorldPosition(), GameObjects.ObserveTemple_Right:GetWorldForward())
  end)
end
local CheckIfBothPulled = function()
  if tnfChainsBroken.right == true and tnfChainsBroken.left == true then
    templeFlipPoint.Stuck.LuaObjectScript.Disable()
    templeFlipPoint.Success.LuaObjectScript.Enable()
  end
end
function PullChainLeft()
  LD.SetEntityVariable("CAL_TempleFlip_LeftChainPulled", true)
  tnfChainsBroken.left = true
  tnfChainsBroken.right = LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
  CheckIfBothPulled()
end
function OnLeftChainBroken()
  game.FindLevel("Cal740_LeftWing"):CallScript("BreakChainLeft")
end
function PullChainRight()
  LD.SetEntityVariable("CAL_TempleFlip_RightChainPulled", true)
  tnfChainsBroken.right = true
  tnfChainsBroken.left = LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
  CheckIfBothPulled()
end
function OnRightChainBroken()
  game.FindLevel("Cal750_RightWing"):CallScript("BreakChainRight")
end
function FindRune()
  GameObjects.seaweedRuneFound1.LuaObjectScript.Disable()
  GameObjects.seaweedRuneFound2.LuaObjectScript.Disable()
  GameObjects.RuneBowl.LuaObjectScript.Enable()
  GameObjects.RuneBowl.LuaObjectScript.SetRuneDiscovered()
end
function RevealSwitch()
  EnableSpline1()
  GameObjects.sonLookDown.LuaObjectScript.Disable()
  GameObjects.sonLookUpAtJotunheim.LuaObjectScript.Disable()
  CSL.PlayShake("FFB_GENERIC_RUMBLE_MEDIUM", 0.1, 0, 1)
  local cal720 = game.FindLevel("Cal720_LowerCenterRoom")
  if cal720 then
    b720unloaded = false
    cal720:CallScript("EnableElevator")
    PlayRuneBowlSwitchSound()
    GameObjects.runebowlSink:PlayAnimToEnd()
    GameObjects.runebowlSink:OnAnimationDone(thisLevel, "HideRuneBowl")
  else
    b720unloaded = true
  end
end
function HideRuneBowl()
  GameObjects.runebowlSink:Hide()
  GameObjects.runebowl:HideCollision()
  GameObjects.runebowl.LuaObjectScript.Disable()
end
function BookmarkStart()
  if game.Level.GetVariable("CompletedCineNumber") == 510 then
    GameObjects.BOOKMARK_31_TempleFlip_010_Start:HideEntityVolume()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "31_TempleFlip_010_Start"]
    tableEntry.OverrideObject = GameObjects.TempleFlipStart_CheckpointOverride
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end
end
function SetSonUnavailableForCombat()
  if son ~= nil and son:IsAvailableInLevel() then
    local availabilityState = {
      AvailableInLevel = true,
      AvailableForBanter = son:IsAvailableForBanter(),
      AvailableForSync = son:IsAvailableForSync(),
      AvailableForCombat = false,
      Unoccupied = son:IsUnoccupied()
    }
    son:SetNewAvailabilityRequest("SonInteraction", availabilityState)
  end
end
function SetSonAvailableForCombat()
  if son ~= nil then
    son:RemoveAvailabilityRequest("SonInteraction")
  end
end
local door1Emitter, door2Emitter, door3Emitter
local openSound = "SND_DOOR_Realm_Room_Panel_Side_Sml_Slide"
local closeSound = "SND_DOOR_Realm_Room_Panel_Side_Sml_Stop"
local soundEmitterLeftDoor, soundEmitterRightDoor, soundEmitterLeftBase, soundEmitterRightBase, soundEmitterAstralSymbol
local soundDoorOpen = "SND_DOOR_Realm_Room_Open_Panel_Top"
local soundDoorClose = "SND_DOOR_Realm_Room_Close_Panel_Top"
local soundBaseOpen = "SND_DOOR_Realm_Room_Open_Panel_Bottom"
local soundBaseClose = "SND_DOOR_Realm_Room_Close_Panel_Bottom"
local soundOpenFinalImpact = "SND_DOOR_Realm_Room_Close_Stop_Impact"
local soundAstalSymbolOpen = "SND_Door_Realm_Room_Double_Door_Magic_Open"
local runebowlEmitter
function SoundInit()
  door1Emitter = GameObjects.SNDGrpSmlDoors:FindSingleSoundEmitterByName("SNDCal140SmlDoor1")
  door2Emitter = GameObjects.SNDGrpSmlDoors:FindSingleSoundEmitterByName("SNDCal140SmlDoor2")
  door3Emitter = GameObjects.SNDGrpSmlDoors:FindSingleSoundEmitterByName("SNDCal140SmlDoor3")
  soundEmitterLeftDoor = GameObjects.JotunDoor:FindSingleGOByName("door_left"):FindSingleSoundEmitterByName("SNDSpreadLeft")
  soundEmitterRightDoor = GameObjects.JotunDoor:FindSingleGOByName("door_right"):FindSingleSoundEmitterByName("SNDSpreadRight")
  soundEmitterLeftBase = GameObjects.JotunDoor:FindSingleGOByName("base_left"):FindSingleSoundEmitterByName("SNDBaseLeft")
  soundEmitterRightBase = GameObjects.JotunDoor:FindSingleGOByName("base_right"):FindSingleSoundEmitterByName("SNDBaseRight")
  soundEmitterAstralSymbol = GameObjects.JotunDoor:FindSingleGOByName("base_right"):FindSingleSoundEmitterByName("SNDAstralSymbol")
  runebowlEmitter = GameObjects.RuneBowlEmitterHouse:FindSingleSoundEmitterByName("SNDRuneBowlBaseEmitter")
  soundDoorOpen = "SND_DOOR_Realm_Room_Open_Panel_Top"
  soundDoorClose = "SND_DOOR_Realm_Room_Close_Panel_Top"
  soundBaseOpen = "SND_DOOR_Realm_Room_Open_Panel_Bottom"
  soundBaseClose = "SND_DOOR_Realm_Room_Close_Panel_Bottom"
  soundOpenFinalImpact = "SND_DOOR_Realm_Room_Close_Stop_Impact"
  SoundInit_TNF()
  local rightDoor = GameObjects.JotunDoor:FindSingleGOByName("greydoor_right")
  local jotDoorSoundMonitor = monitors.CreateAnimFrameMonitor(rightDoor)
  jotDoorSoundMonitor:OnFrameForward(62, function()
    LD.PlaySound(soundEmitterLeftDoor, soundDoorOpen)
  end)
  jotDoorSoundMonitor:OnFrameForward(62, function()
    LD.PlaySound(soundEmitterRightDoor, soundDoorOpen)
  end)
  jotDoorSoundMonitor:OnFrameForward(120, function()
    LD.PlaySound(soundEmitterLeftDoor, soundDoorClose)
  end)
  jotDoorSoundMonitor:OnFrameForward(120, function()
    LD.PlaySound(soundEmitterRightDoor, soundDoorClose)
  end)
  jotDoorSoundMonitor:OnFrameForward(120, function()
    LD.PlaySound(soundEmitterLeftBase, soundBaseOpen)
  end)
  jotDoorSoundMonitor:OnFrameForward(120, function()
    LD.PlaySound(soundEmitterRightBase, soundBaseOpen)
  end)
  jotDoorSoundMonitor:OnFrameForward(199, function()
    LD.PlaySound(soundEmitterLeftBase, soundBaseClose)
  end)
  jotDoorSoundMonitor:OnFrameForward(199, function()
    LD.PlaySound(soundEmitterRightBase, soundBaseClose)
  end)
  jotDoorSoundMonitor:OnFrameForward(160, function()
    LD.PlaySound(soundEmitterLeftBase, "SND_DOOR_Realm_Room_Double_Door_Pry_Open_L")
  end)
  jotDoorSoundMonitor:OnFrameForward(160, function()
    LD.PlaySound(soundEmitterRightBase, "SND_DOOR_Realm_Room_Double_Door_Pry_Open_R")
  end)
  jotDoorSoundMonitor:OnFrameForward(220, function()
    LD.PlaySound(soundEmitterLeftBase, soundOpenFinalImpact)
  end)
  jotDoorSoundMonitor:OnFrameForward(220, function()
    LD.PlaySound(soundEmitterRightBase, soundOpenFinalImpact)
  end)
end
function PlayRuneBowlSwitchSound()
  LD.PlaySoundAfterDelay(runebowlEmitter, "SND_MECH_Cal700_TempleFilp_RuneBowl_Lower_Lever_Raise", 0.3)
end
local door1SoundPlaying = false
local door2SoundPlaying = false
local door3SoundPlaying = false
function PlayDoorStart1()
  if door1SoundPlaying == false then
    door1SoundPlaying = true
    LD.PlaySound(door1Emitter, openSound)
    GameObjects.SmallDoor1:OnAnimationDone(thisLevel, "PlayDoorStop1", {Force = true})
  end
end
function PlayDoorStart2()
  if door2SoundPlaying == false then
    door2SoundPlaying = true
    LD.PlaySound(door2Emitter, openSound)
    GameObjects.SmallDoor2:OnAnimationDone(thisLevel, "PlayDoorStop2", {Force = true})
  end
end
function PlayDoorStart3()
  if door3SoundPlaying == false then
    door3SoundPlaying = true
    LD.PlaySound(door3Emitter, openSound)
    GameObjects.SmallDoor3:OnAnimationDone(thisLevel, "PlayDoorStop3", {Force = true})
  end
end
function PlayDoorStop1()
  door1SoundPlaying = false
  LD.PlaySound(door1Emitter, closeSound)
end
function PlayDoorStop2()
  door2SoundPlaying = false
  LD.PlaySound(door2Emitter, closeSound)
end
function PlayDoorStop3()
  door3SoundPlaying = false
  LD.PlaySound(door3Emitter, closeSound)
end
function PlayTravelDoorOpen(anim)
  LD.PlaySound(soundEmitterAstralSymbol, soundAstalSymbolOpen)
end
function WarpSonTo(point)
  son:Warp(point.WorldPosition, point:GetWorldForward())
end
function EnableChainPullLeft()
  GameObjects.chainblocker_left.LuaObjectScript.Enable()
  game.World.StoreCheckpoint(GameObjects.LW_CheckpointOverride2.Child)
end
function EnableChainPullRight()
  GameObjects.chainblocker_right.LuaObjectScript.Enable()
  game.World.StoreCheckpoint(GameObjects.RW_CheckpointOverride2.Child)
end
local templeEdgeEmitter, templeTNFEmitter, templeMultiChannelEmitter, kratosEmitter
local chainEmitters = {Left = nil, Right = nil}
local chainSoundEvents = {
  Struggle_LP_Left = "SND_TNF_TempleFlip_Chains_01_L_LP",
  Struggle_LP_Right = "SND_TNF_TempleFlip_Chains_01_R_LP",
  Chains_Start_Left = "SND_TNF_TempleFlip_ChainStart_01_L",
  Chains_Start_Right = "SND_TNF_TempleFlip_ChainStart_01_R",
  Fail_01_Stuck_Left = "SND_TNF_TempleFlip_ChainStop_01_L",
  Fail_01_Stuck_Right = "SND_TNF_TempleFlip_ChainStop_01_R",
  Fail_02_Stuck_Left = "SND_TNF_TempleFlip_ChainStop_02_L",
  Fail_02_Stuck_Right = "SND_TNF_TempleFlip_ChainStop_02_R",
  Win_02_Stuck_Left = "SND_TNF_TempleFlip_Win2StuckChains_01_L",
  Win_02_Stuck_Right = "SND_TNF_TempleFlip_Win2StuckChains_01_R",
  Exit_Left = "SND_TNF_TempleFlip_ExitChains_01_L",
  Exit_Right = "SND_TNF_TempleFlip_ExitChains_01_R"
}
local stuckSoundEvents = {
  Struggle_01_LP = "SND_TNF_TempleFlip_StruggleStuck_01_LP",
  Fail_01 = "SND_TNF_TempleFlip_FailStuck_01",
  Win_01 = "SND_TNF_TempleFlip_WinStuck_01",
  Struggle_02_LP = "SND_TNF_TempleFlip_StruggleStuck_02_LP",
  Fail_02 = "SND_TNF_TempleFlip_FailStuck_02",
  Win_02 = "SND_TNF_TempleFlip_WinStuck_02",
  Exit = "SND_TNF_TempleFlip_Exit_01"
}
local successSoundEvents = {
  Struggle_01_LP = "SND_TNF_TempleFlip_Struggle_01_LP",
  Fail_01 = "SND_TNF_TempleFlip_Fail_01",
  Win_01 = "SND_TNF_TempleFlip_Win_01",
  Struggle_02_LP = "SND_TNF_TempleFlip_Struggle_02_LP",
  Fail_02 = "SND_TNF_TempleFlip_Fail_02",
  Win_02 = "SND_TNF_TempleFlip_Win_02"
}
local struggleSoundOneShots = {
  {
    soundEvent = "SND_TNF_TempleFlip_Struggle_Start_01",
    firedThisAttempt = false
  },
  {
    soundEvent = "SND_TNF_TempleFlip_Struggle_Start_02",
    firedThisAttempt = false
  },
  {
    soundEvent = "SND_TNF_TempleFlip_Struggle_Stop_02",
    firedThisAttempt = false
  }
}
function SoundInit_TNF()
  templeEdgeEmitter = GameObjects.SNDGrpTempleFlipTNFTempleEdge.SoundEmitters[1]
  templeMultiChannelEmitter = GameObjects.SNDTempleFlipGrp:FindSingleSoundEmitterByName("SNDTempleFlipMC")
  chainEmitters.Left = GameObjects.SNDGrpTNFChains:FindSingleSoundEmitterByName("SNDTNFChain_Left")
  chainEmitters.Right = GameObjects.SNDGrpTNFChains:FindSingleSoundEmitterByName("SNDTNFChain_Right")
end
function PlaySoundTNF_WinStuckStarted()
  if player:IsPlayingMove("MOV_TNF_TempleFlip_Struggle1Stuck") then
    LD.PlaySound(templeEdgeEmitter, stuckSoundEvents.Struggle_01_LP)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Struggle2Stuck") then
    LD.PlaySound(templeEdgeEmitter, stuckSoundEvents.Struggle_02_LP)
  end
  PlaySoundTNFChainLoops()
end
function PlaySoundTNF_WinSuccessStarted()
  if player:IsPlayingMove("MOV_TNF_TempleFlip_Struggle1Success") then
    LD.PlaySound(templeEdgeEmitter, successSoundEvents.Struggle_01_LP)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Struggle2Success") then
    LD.PlaySound(templeEdgeEmitter, successSoundEvents.Struggle_02_LP)
  end
end
function PlaySoundTNF_Failed()
  if player:IsPlayingMove("MOV_TNF_TempleFlip_Fail1Stuck") then
    LD.StopSound(templeEdgeEmitter, stuckSoundEvents.Struggle_01_LP)
    LD.PlaySound(templeMultiChannelEmitter, stuckSoundEvents.Fail_01)
    StopSoundTNFChainLoops()
    PlaySoundOnTNFChain_Left(chainSoundEvents.Fail_01_Stuck_Left)
    PlaySoundOnTNFChain_Right(chainSoundEvents.Fail_01_Stuck_Right)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Fail2Stuck") then
    LD.StopSound(templeEdgeEmitter, stuckSoundEvents.Struggle_02_LP)
    LD.PlaySound(templeMultiChannelEmitter, stuckSoundEvents.Fail_02)
    StopSoundTNFChainLoops()
    PlaySoundOnTNFChain_Left(chainSoundEvents.Fail_02_Stuck_Left)
    PlaySoundOnTNFChain_Right(chainSoundEvents.Fail_02_Stuck_Right)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Exit") or player:IsPlayingMove("MOV_TNF_TempleFlip_Exit_FirstAttempt") then
    LD.PlaySound(templeMultiChannelEmitter, stuckSoundEvents.Exit)
    StopSoundTNFChainLoops()
    PlaySoundOnTNFChain_Left(chainSoundEvents.Exit_Left)
    PlaySoundOnTNFChain_Right(chainSoundEvents.Exit_Right)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Fail1Success") then
    LD.StopSound(templeEdgeEmitter, successSoundEvents.Struggle_01_LP)
    LD.PlaySound(templeMultiChannelEmitter, successSoundEvents.Fail_01)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Fail2Success") then
    LD.StopSound(templeEdgeEmitter, successSoundEvents.Struggle_02_LP)
    LD.PlaySound(templeMultiChannelEmitter, successSoundEvents.Fail_02)
  end
end
function PlaySoundTNF_StruggleComplete()
  if player:IsPlayingMove("MOV_TNF_TempleFlip_Win1Stuck") or player:IsPlayingMove("MOV_TNF_TempleFlip_Struggle1Stuck") then
    LD.StopSound(templeEdgeEmitter, stuckSoundEvents.Struggle_01_LP)
    LD.PlaySound(templeEdgeEmitter, stuckSoundEvents.Win_01)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Win2Stuck") or player:IsPlayingMove("MOV_TNF_TempleFlip_Struggle2Stuck") then
    LD.StopSound(templeEdgeEmitter, stuckSoundEvents.Struggle_02_LP)
    LD.PlaySound(templeEdgeEmitter, stuckSoundEvents.Win_02)
    StopSoundTNFChainLoops()
    PlaySoundOnTNFChain_Left(chainSoundEvents.Win_02_Stuck_Left)
    PlaySoundOnTNFChain_Right(chainSoundEvents.Win_02_Stuck_Right)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Win1Success") or player:IsPlayingMove("MOV_TNF_TempleFlip_Struggle1Success") then
    LD.StopSound(templeEdgeEmitter, successSoundEvents.Struggle_01_LP)
    LD.PlaySound(templeEdgeEmitter, successSoundEvents.Win_01)
  elseif player:IsPlayingMove("MOV_TNF_TempleFlip_Win2Success") or player:IsPlayingMove("MOV_TNF_TempleFlip_Struggle2Success") then
    LD.StopSound(templeEdgeEmitter, successSoundEvents.Struggle_02_LP)
    LD.PlaySound(GameObjects.SNDTempleFlipGrp:FindSingleSoundEmitterByName("SNDTempleFlip"), successSoundEvents.Win_02)
  end
end
function PlaySoundOnTNFChain_Left(eventToPlay)
  if not tnfChainsBroken.left then
    LD.PlaySound(chainEmitters.Left, eventToPlay)
  end
end
function PlaySoundOnTNFChain_Right(eventToPlay)
  if not tnfChainsBroken.right then
    LD.PlaySound(chainEmitters.Right, eventToPlay)
  end
end
function PlaySoundTNFChainLoops()
  if not tnfChainsBroken.left then
    PlaySoundOnTNFChain_Left(chainSoundEvents.Struggle_LP_Left)
  end
  if not tnfChainsBroken.right then
    PlaySoundOnTNFChain_Right(chainSoundEvents.Struggle_LP_Right)
  end
end
function StopSoundTNFChainLoops()
  if not tnfChainsBroken.left then
    LD.StopSound(chainEmitters.Left, chainSoundEvents.Struggle_LP_Left)
  end
  if not tnfChainsBroken.right then
    LD.StopSound(chainEmitters.Right, chainSoundEvents.Struggle_LP_Right)
  end
end
function SoundSetup_ResetStruggleOneShots()
  for i = 1, #struggleSoundOneShots do
    struggleSoundOneShots[i].firedThisAttempt = false
  end
end
function LuaHook_PlaySound_StruggleOneShot(level, oneShotIndex)
  if oneShotIndex < 1 or oneShotIndex > #struggleSoundOneShots then
    return
  end
  if struggleSoundOneShots[oneShotIndex].firedThisAttempt == false then
    struggleSoundOneShots[oneShotIndex].firedThisAttempt = true
    LD.PlaySound(templeEdgeEmitter, struggleSoundOneShots[oneShotIndex].soundEvent)
    if oneShotIndex == 2 then
      if not tnfChainsBroken.left then
        PlaySoundOnTNFChain_Left(chainSoundEvents.Chains_Start_Left)
      end
      if not tnfChainsBroken.right then
        PlaySoundOnTNFChain_Right(chainSoundEvents.Chains_Start_Right)
      end
    end
  end
end
function DestroyOneShot_LookAtJotunheimRune()
  camOneShot_JotunheimRune = nil
end
function DestroyOneShot_LookAtJotunheimDoor()
  camOneShot_JotunheimDoor = nil
end
function CamLookAt_JotunHeimRune()
  camOneShot_JotunheimRune = CCOS.OneShotCamera.New("PLYR_NAR_JotunheimRune", kLookAtLength_Rune)
  camOneShot_JotunheimRune:SetCallback(DestroyOneShot_LookAtJotunheimRune)
  local cinelockLength = kLookAtLength_DoorStartDelay + kLookAtLength_Door
  camOneShot_JotunheimRune:ActivateCineLock(cinelockLength + 1)
  camOneShot_JotunheimRune:Start()
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_013", true)
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_011x", true)
  game.Compass.SetGatewayMarkerIsOpen("CALT_130_Helper_011x1", false)
end
function CamLookAt_JotunHeimDoor()
  camOneShot_JotunheimDoor = CCOS.OneShotCamera.New("PLYR_NAR_JotunheimDoor", kLookAtLength_Door)
  camOneShot_JotunheimDoor:SetCallback(DestroyOneShot_LookAtJotunheimDoor)
  camOneShot_JotunheimDoor:Start()
  timers.StartLevelTimer(kLookAtLength_Door, function()
    CamReturn()
    if not LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled") and not LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled") then
      GameObjects.templeFlipPoint_Stuck.LuaObjectScript.Enable()
    end
    GameObjects.sonLookUpAtJotunheim.LuaObjectScript.Disable()
    GameObjects.sonLookDown.LuaObjectScript.Enable()
    GameObjects.sigilJotun:FindSingleGOByName("guide"):PlayAnimationToEnd()
    LD.HideFX(GameObjects.sigilJotun)
  end)
end
function CamReturn()
  game.Camera.Recenter({
    TimeStart = 0,
    TimeDuration = 3.2,
    LockRecenter = 0,
    PitchRange = -1,
    ReturnDown = 4.2,
    ReturnUp = 4.2,
    YawRange = 360
  })
end
function InDoorway1()
  if son:IsInsideEntityZone("InsideTemple") then
    GameObjects.ShowPlayerDoor1.LuaObjectScript.Enable()
  else
    GameObjects.ShowPlayerDoor1B.LuaObjectScript.Enable()
  end
end
function OutDoorway1()
  GameObjects.ShowPlayerDoor1.LuaObjectScript.Disable()
  GameObjects.ShowPlayerDoor1B.LuaObjectScript.Disable()
end
function InDoorway2()
  if son:IsInsideEntityZone("InsideTemple") then
    GameObjects.ShowPlayerDoor2.LuaObjectScript.Enable()
  else
    GameObjects.ShowPlayerDoor2B.LuaObjectScript.Enable()
  end
end
function OutDoorway23()
  GameObjects.ShowPlayerDoor2.LuaObjectScript.Disable()
  GameObjects.ShowPlayerDoor2B.LuaObjectScript.Disable()
  GameObjects.ShowPlayerDoor3B.LuaObjectScript.Disable()
  GameObjects.ShowPlayerDoor3.LuaObjectScript.Disable()
end
function InDoorway3()
  if son:IsInsideEntityZone("InsideTemple") then
    GameObjects.ShowPlayerDoor3.LuaObjectScript.Enable()
  else
    GameObjects.ShowPlayerDoor3B.LuaObjectScript.Enable()
  end
end
function EnableLookUpAtCrackClimb()
  if LD.GetEntityVariable("CAL_TempleFlipped") then
    GameObjects.sonLookUpAtCrackClimb.LuaObjectScript.Enable()
  end
end
function DisableLookUpAtCrackClimb()
  GameObjects.sonLookUpAtCrackClimb.LuaObjectScript.Disable()
end
function ShowDebugTable()
  local debugTable = {}
  debugTable.X = 120
  debugTable.Y = 10
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  debugTable.Title = "Cal140 Info"
  local tempTable = templeFlipChains.LuaObjectScript.GetDebugTable()
  for i = 1, #tempTable do
    table.insert(debugTable, tempTable[i])
  end
  tempTable = GameObjects.trollStatue_right.LuaObjectScript.GetDebugTable()
  for i = 1, #tempTable do
    table.insert(debugTable, tempTable[i])
  end
  tempTable = GameObjects.trollStatue_left.LuaObjectScript.GetDebugTable()
  for i = 1, #tempTable do
    table.insert(debugTable, tempTable[i])
  end
  engine.DrawDebugTable(debugTable)
end
