local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj
local banterPlayed = {}
local flipAttempt_underway = false
local flipAttempt1_done = false
local flipBanter1Table = {
  "070_FlipAttempt1G",
  "070_FlipAttempt1H",
  "070_FlipAttempt1I"
}
local flipBanter2Table = {
  "170_FlipAttempt2B",
  "170_FlipAttempt2C",
  "170_FlipAttempt2D"
}
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.flipAttempt_underway = flipAttempt_underway
  savedInfo.flipAttempt1_done = flipAttempt1_done
  savedInfo.banterPlayed = banterPlayed
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  if savedInfo ~= nil then
    flipAttempt_underway = savedInfo.flipAttempt_underway
    flipAttempt1_done = savedInfo.flipAttempt1_done
    banterPlayed = savedInfo.banterPlayed
  end
end
function JotunDoorBanter()
  if not banterPlayed.JotunDoor then
    game.Audio.PlayBanter("040_JotunDoor", function()
      _G.ShowPlayerDoor()
      GameObjects.SonUnavailableForCombatZone:HideEntityVolume()
    end)
    banterPlayed.JotunDoor = true
  end
end
function Hide_FlipEntranceB_TimerZone()
  GameObjects.BtrWaitZone_FlipEntranceB.Child.LuaObjectScript.Cancel()
  GameObjects.BtrWaitZone_FlipEntranceB:Hide()
end
function FlipAttempt1B_Banter()
  game.Audio.PlayBanter("070_FlipAttempt1B")
end
function AttemptFlipLift()
  if flipAttempt_underway then
    if not flipAttempt1_done then
      FlipAttempt1D_Banter()
      flipAttempt1_done = true
    end
  else
    local rightBroken = LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
    local leftBroken = LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
    if not flipAttempt1_done then
      game.Audio.PlayBanter("070_FlipAttempt1C1", MimirCommentsOnAxel)
    elseif rightBroken and leftBroken then
      game.Audio.PlayBanter("230_FlipSuccessB")
    else
      game.Audio.PlayBanter("170_FlipAttempt2A", FlipAttempt2B_Banter)
    end
    flipAttempt_underway = true
  end
end
function MimirCommentsOnAxel()
  if not banterPlayed.FlipAttempt1C2 then
    game.Audio.PlayBanter("070_FlipAttempt1C2")
    banterPlayed.FlipAttempt1C2 = true
  end
end
function TempleLiftFail()
  flipAttempt_underway = false
end
function FlipAttempt2B_Banter()
  local rightBroken = LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
  local leftBroken = LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
  if not rightBroken and not leftBroken then
    if 0 < #flipBanter1Table then
      game.Audio.PlayBanter(flipBanter1Table[1])
      table.remove(flipBanter1Table, 1)
    end
  elseif 0 < #flipBanter2Table then
    game.Audio.PlayBanter(flipBanter2Table[1])
    table.remove(flipBanter2Table, 1)
  end
end
function FlipSuccessA_Banter()
  local rightBroken = LD.GetEntityVariable("CAL_TempleFlip_RightChainPulled")
  local leftBroken = LD.GetEntityVariable("CAL_TempleFlip_LeftChainPulled")
  if rightBroken and leftBroken and not banterPlayed.FlipSuccessA then
    game.Audio.PlayBanter("230_FlipSuccessA")
    banterPlayed.FlipSuccessA = true
  end
end
function FlipAttempt1BB()
  if not banterPlayed.FlipAttempt1BB then
    timers.StartLevelTimer(2, function()
      game.Audio.PlayBanter("070_FlipAttempt1BB")
    end)
    banterPlayed.FlipAttempt1BB = true
  end
end
function FlipSuccessC_Banter()
  if not banterPlayed.FlipSuccessC then
    game.Audio.PlayBanter("230_FlipSuccessC")
    banterPlayed.FlipSuccessC = true
  end
end
function FlipAttempt1D_Banter()
  if not banterPlayed.FlipAttempt1D then
    timers.StartLevelTimer(6, function()
      game.Audio.PlayBanter("070_FlipAttempt1D", FlipAttempt1E_Banter)
    end)
    banterPlayed.FlipAttempt1D = true
  end
end
function FlipAttempt1E_Banter()
  GameObjects.POI_CalTempleFlip010.LuaObjectScript.SetLiftBanterComplete()
end
function FlipAttempt1F_Banter()
  if not banterPlayed.FlipAttempt1F then
    game.Audio.PlayBanterNonCritical("070_FlipAttempt1F")
    banterPlayed.FlipAttempt1F = true
  end
end
function FlipAttempt1F2_Banter()
  if not banterPlayed.FlipAttempt1F2 then
    game.Audio.PlayBanterNonCritical("070_FlipAttempt1F2")
    banterPlayed.FlipAttempt1F2 = true
  end
end
function FlipAttemptDone()
  flipAttempt_underway = false
end
function AttemptToLeave1()
  if game.Level.GetVariable("CompletedCineNumber") < 512 and LD.GetEntityVariable("CAL_TempleFlipped") and not banterPlayed.AttemptedToLeave1 then
    game.Audio.PlayBanterNonCritical("230_FlipSuccessD")
    banterPlayed.AttemptedToLeave1 = true
  end
end
function AttemptToLeave2()
  if game.Level.GetVariable("CompletedCineNumber") < 512 and LD.GetEntityVariable("CAL_TempleFlipped") and not banterPlayed.AttemptedToLeave2 then
    game.Audio.PlayBanterNonCritical("230_FlipSuccessE")
    banterPlayed.AttemptedToLeave2 = true
  end
end
