local LD = require("design.LevelDesignLibrary")
local actor = require("narrative.actor")
local timers = require("level.timer")
local thisObj, thisLevel, player, kraActor, sonActor
local bLiftBanterComplete = false
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function AttemptSeq()
  kraActor = actor.Actor.New("POI CalTempleFlip010: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("POI CalTempleFlip010: Son Actor", game.AI.FindSon)
  SetupSequence()
end
function SetupSequence()
  local poiSeq, slaveTab
  local travelRoom = GameObjects.calderaTravelRoom_Refnode.Child
  local tnfObj = GameObjects.templeFlipPoint_Stuck.Child
  if CanSeqFire() then
    poiSeq = LD.CreateCineSequence(thisLevel, travelRoom, "First Attempt TempleFlip Sequence")
    slaveTab = {
      {Actor = sonActor},
      {
        Obj = GameObjects.templeFlipChain00_root,
        Anim = "poiCalTempleFlip010Scene"
      },
      {
        Obj = GameObjects.trollStatue_right.Child,
        Anim = "poiCalTempleFlip010Scene"
      },
      {
        Obj = GameObjects.trollStatue_left.Child,
        Anim = "poiCalTempleFlip010Scene1"
      },
      {
        Obj = travelRoom,
        Anim = "poiCalTempleFlip010Scene1"
      }
    }
    poiSeq:WaitForActorMoveComplete(kraActor)
    poiSeq:Do(function()
      local kraPup = kraActor:GetActivePuppeteer()
      kraPup:WeaponEquip({weaponMode = "Bare"})
      game.UI.Idle(true, true)
    end)
    poiSeq:WaitForFunctionTrue(LiftBanterComplete)
    poiSeq:Do(function()
      game.UI.Idle(false, false)
    end)
    poiSeq:ActorSync(kraActor, {
      Slaves = slaveTab,
      Branch = "BRA_POI_CalTempleFlip010",
      ReferenceJoint = "synchJoint"
    })
    poiSeq:Do(function()
      LD.PlaySound(game.Player.FindPlayer():FindSingleSoundEmitterByName("SNDKratos"), "SND_POI_TempleFlip_TrollStatues_2D")
      LD.PlaySound(GameObjects.trollStatue_right.Child:FindSingleSoundEmitterByName("SNDTrollStatue"), "SND_POI_TempleFlip_TrollStatues_3D_01_L")
      LD.PlaySound(GameObjects.trollStatue_left.Child:FindSingleSoundEmitterByName("SNDTrollStatue"), "SND_POI_TempleFlip_TrollStatues_3D_01_R")
    end)
    poiSeq:Do(function()
      timers.StartLevelTimer(3, function()
        GameObjects.Cal140_Banter.LuaObjectScript.FlipAttempt1F_Banter()
      end)
    end)
    poiSeq:WaitForActorMoveComplete(kraActor)
    poiSeq:StopPuppetingActor(sonActor)
    poiSeq:StopPuppetingActor(kraActor)
    poiSeq:Do(StartFlipObjective)
    poiSeq:StartSequence()
  end
end
function LiftBanterComplete()
  return bLiftBanterComplete
end
function SetLiftBanterComplete()
  bLiftBanterComplete = true
end
function CanSeqFire()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return 500 <= cineNum and cineNum <= 510
end
function StartFlipObjective()
  LD.CompleteQuest("Quest_Caldera_Objective705")
  game.Player.FindPlayer().Pad:EnableGameButton(tweaks.ePad.kPadSquare)
  game.Player.FindPlayer().Pad:EnableGameButton(tweaks.ePad.kPadUp)
  GameObjects.Cal140_Banter.LuaObjectScript.FlipAttempt1F2_Banter()
  game.Compass.SetDesignerForcedHide(false)
  GameObjects.RuneBowl.LuaObjectScript.Enable()
  GameObjects.templeFlipPoint_Stuck.LuaObjectScript.Enable()
  GameObjects.trollStatue_right.LuaObjectScript.TurnComplete()
  GameObjects.trollStatue_left.LuaObjectScript.TurnComplete()
end
