local thisObj
local bFlexing = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  thisObj:JumpAnimationToFrame(0, {
    Animation = "envTempleFlipAttemptFlipFirstTime"
  })
  thisObj:PauseAnimation()
end
function OnStart(level, obj)
  if game.Level.GetVariable("CAL_TempleFlipped") == true then
    thisObj:Hide()
  end
end
local LiftTemple = function(animName)
  thisObj:JumpAnimationToFrame(0, {Animation = animName})
  thisObj:PlayAnimationToFrame(140, {Rate = 0.75})
  bFlexing = true
  thisObj:OnAnimationDone(thisObj, "FlexChain", {Force = true})
end
function FlexChain()
  if bFlexing then
    thisObj:JumpAnimationToFrame(140)
    thisObj:PlayAnimationToFrame(220, {Rate = 1.75})
    thisObj:OnAnimationDone(thisObj, "FlexChain", {Force = true})
  else
    thisObj:ClearAllAnimationCallbacks()
    thisObj:PlayAnimationToEnd({Rate = 1.75, Tween = 0.5})
  end
end
function DropTemple()
  bFlexing = false
end
function AttemptLift_FirstTime()
  LiftTemple("envTempleFlipAttemptFlipFirstTime")
  game.Compass.SetDesignerForcedHide(true)
end
function AttemptLift_BothChainsBroken()
  thisObj:PlayAnimationCycle({
    Animation = "envTempleFlipBothChainsBroken"
  })
end
function SuccessLift_FlipTemple()
  thisObj:Hide()
end
function JumpToLeftChainBroken()
  thisObj:JumpAnimationToPercent(1, {
    Animation = "envTempleFlipBreakChain_Left"
  })
end
function JumpToRightChainBroken()
  thisObj:JumpAnimationToPercent(1, {
    Animation = "envTempleFlipBreakChain_Right"
  })
end
function JumpToNoChainsBroken()
  thisObj:JumpAnimationToPercent(1, {
    Animation = "poiCalTempleFlip010Scene"
  })
end
function JumpToBothChainsBroken()
  thisObj:JumpAnimationToPercent(1, {
    Animation = "envTempleFlipBothChainsBroken"
  })
end
function ShowDebugTable()
  local debugTable = GetDebugTable()
  debugTable.X = 120
  debugTable.Y = 10
  debugTable.TitleColor = engine.Vector.New(255, 0, 128)
  engine.DrawDebugTable(GetDebugTable())
end
function GetDebugTable()
  local debugTable = {}
  debugTable.Title = "TempleFlip Chain Info"
  table.insert(debugTable, {
    "Chain> animName: ",
    thisObj:GetAnimationName()
  })
  table.insert(debugTable, {
    "animPercent : ",
    tostring(thisObj.AnimPercent)
  })
  table.insert(debugTable, {
    "animFrame : ",
    tostring(thisObj.AnimFrame)
  })
  table.insert(debugTable, {
    "Is Flexing Chain : ",
    tostring(bFlexing)
  })
  return debugTable
end
