local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local triggeredSonPoi, playedLibraryDiscovered
function OnFirstStart(level)
  GameObjects.Playtest_Questionare:Hide()
  GameObjects.TravelRoomTopElevatorSwitch.LuaObjectScript.ToggleState()
  GameObjects.HelheimReturnLanding:HideEntityVolume()
  triggeredSonPoi = false
end
function OnStart(level)
  LD.RegisterForVariableUpdate(level, "CurrentRealm", {
    immediateFn = SetCurrentRealm,
    fn = SetCurrentRealm
  })
  local interactZone = GameObjects.TravelRoomTopElevatorSwitch.LuaObjectScript.GetInteractZoneTable()
  interactZone[1]:SetInteractFrontAngleWeight(0)
  interactZone[1]:SetCameraFrontAngle(0, 120)
  interactZone[1]:SetCameraFrontAngleWeight(1)
  GameObjects.TravelRoomTopElevatorSwitch.LuaObjectScript.OverrideCameraInteractApproach("ENV_Interact_Elevator_OdinLibrary")
  SoundOnStart()
  if game.Level.GetVariable("CompletedCineNumber") ~= 500 then
    GameObjects.TravelRoomElevatorTop:FindSingleGOByName("basicelevator_top").LuaObjectScript.JumpToTopFloor()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function BreakRoof_Cal170()
  LD.BreakObject(GameObjects.hel_boat_roof_break)
end
function PlayTriptychAnim()
end
function TurnOnContextSon()
  if triggeredSonPoi == false then
    GameObjects.ContextAction_Son_ObserveForward.LuaObjectScript.Enable()
  end
end
function TurnOffContextSon()
  GameObjects.ContextAction_Son_ObserveForward.LuaObjectScript.Disable()
end
function triggeredSon()
  triggeredSonPoi = true
end
function CA_Elevator_On()
  GameObjects.CA_Observe_Forward_Elevator.LuaObjectScript.Enable()
end
function CA_Elevator_Off()
  GameObjects.CA_Observe_Forward_Elevator.LuaObjectScript.Disable()
end
function ArrivedInLibrary()
  game.Compass.SetDesignerForcedHide(true)
  LD.CallFunctionAfterDelay(function()
    uiCalls.UI_Event_DiscoverLocation("Odin's Library")
  end, 14)
  LD.CallFunctionAfterDelay(function()
    GameObjects.HelheimReturnLanding:ShowEntityVolume()
  end, 10)
end
function TravelRoomElevatorTop_Enable()
  GameObjects.TravelRoomTopElevatorSwitch.LuaObjectScript.Enable()
end
local libraryElevatorSoundOverride = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Stone_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Stone_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 0,
  AnimFrameTopFloor = -1,
  AnimFrameBottomFloor = -1
}
function SoundOnStart()
  libraryElevatorSoundOverride.SoundEmitter = GameObjects.TravelRoomElevatorTop:FindSingleSoundEmitterByName("SNDLibraryElevator")
  local elevatorManager = GameObjects.basicelevator_top
  if elevatorManager ~= nil then
    elevatorManager.LuaObjectScript.SoundSetup(libraryElevatorSoundOverride)
  end
end
function PlayLibraryDiscovered()
  if not playedLibraryDiscovered then
    game.Audio.PlayBanter("220_LibraryDiscovered01")
    playedLibraryDiscovered = true
  end
end
function TurnONPlaytestZone()
  GameObjects.Playtest_Questionare:Show()
end
function SetCurrentRealm(level)
  local currentRealm = LD.GetCurrentRealm()
  if currentRealm == "Helheim" then
    GameObjects.HelheimReturnLanding:ShowEntityVolume()
  else
    GameObjects.HelheimReturnLanding:HideEntityVolume()
  end
end
function OnSaveCheckpoint(level)
  return {
    levelState = checkpoint.Save(),
    triggeredSonPoi = triggeredSonPoi,
    playedLibraryDiscovered = playedLibraryDiscovered
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelState)
  triggeredSonPoi = savedInfo.triggeredSonPoi
  playedLibraryDiscovered = savedInfo.playedLibraryDiscovered
end
