local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, son, kraActor, sonActor, lightProp, switchProp
local almostHomeBranchStr = "BRA_AlmostHome"
local cameraCineEnter_AlmostHome
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
end
function OnStart(level, obj)
  SetupActors()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate()
  if cameraCineEnter_AlmostHome ~= nil then
    cameraCineEnter_AlmostHome:Update()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("ALMOST HOME: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("ALMOST HOME: Son Actor", game.AI.FindSon)
  lightProp = GameObjects.Cine_Start_500
  HideLights()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 500 then
    switchProp = GameObjects.TravelRoomTopElevatorSwitch.Child
    local switchObj = switchProp:FindSingleGOByName("switch_obj")
    if switchObj ~= nil then
      switchProp = switchObj
    end
    switchProp:PlayAnimationToFrame(0, {
      Animation = "narCalAlmostHome000Cine"
    })
  end
end
function HideLights()
  lightProp:Hide()
end
function PlayLights()
  lightProp:Show()
  lightProp:JumpAnimToFrame(0)
  lightProp:PlayAnimToEnd()
end
function SetupCineSequence()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 494 <= cineNum and cineNum < 500 then
    local elevatorManager = GameObjects.basicelevator_top
    local cineSeq = ND.CreateCineSequence(thisLevel, switchProp, "Almost Home Sequence")
    local slaveTab = {
      {Actor = sonActor, Branch = almostHomeBranchStr},
      {
        Obj = switchProp,
        Anim = "narCalAlmostHome000Cine"
      }
    }
    cineSeq:Do(StartCineEnter_AlmostHome)
    GameObjects.TravelRoomTopElevatorSwitch.LuaObjectScript.EnableCinematicTrigger()
    elevatorManager.LuaObjectScript.EnableCinematicTrigger()
    elevatorManager.LuaObjectScript.UpdateMoveSpeed(0.16, 0.16)
    cineSeq:RequestCineModeAndWait(kraActor, switchProp)
    cineSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:ActorForceApproachAndWait(kraActor, {
      Branch = almostHomeBranchStr,
      ReferenceJoint = "synchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.InteractStopDistance,
      weapon_state = "bare"
    })
    cineSeq:ActorSync(kraActor, {
      Slaves = slaveTab,
      Branch = almostHomeBranchStr,
      ReferenceJoint = "synchJoint"
    })
    cineSeq:Do(PlayLights)
    cineSeq:WaitSeconds(2.6667)
    cineSeq:Do(function()
      elevatorManager.LuaObjectScript.PlayerMoveElevator()
    end)
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.75)
    cineSeq:Do(function()
      cineSeq:SetMaxSkipSpeedup(2)
    end)
    cineSeq:WaitForFunctionTrue(function()
      return not son:IsPlayingMove("MOV_AlmostHome")
    end)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:WaitForAndCompleteCineMode(kraActor, switchProp)
    cineSeq:Do(HideLights)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:Do(ClearElevatorOverride)
    cineSeq:SetCompletedCineNumber(500)
    cineSeq:Do(function()
      game.World.StoreCheckpoint()
    end)
    cineSeq:Do(function()
      game.Audio.PlayBanter("240_FinishingHelheim2")
    end)
    cineSeq:StartSequence()
  end
end
function ClearElevatorOverride()
  local elevatorManager = GameObjects.basicelevator_top
  elevatorManager.LuaObjectScript.UpdateMoveSpeed(1, 1)
  GameObjects.LTW_LibraryElevator.LuaObjectScript.Enable()
end
function StartCineEnter_AlmostHome()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_AlmostHome = CCEC.CineEnterCamera.New("ENV_CineEnter_AlmostHome", 7)
  cameraCineEnter_AlmostHome:SetCallback(DestroyCineEnter_AlmostHome)
  cameraCineEnter_AlmostHome:Start()
end
function DestroyCineEnter_AlmostHome()
  cameraCineEnter_AlmostHome = nil
  game.SubObject.Sleep(thisObj)
end
