local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, doorObj, journalObj
local synchJoint = "TyrTriptych_SynchJoint"
local savedDoorPosition, savedDoorFacing, cameraCineEnter_TyrTriptych
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 499 then
    SetupActors()
  end
  SetupProps()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate(level, obj)
  if cameraCineEnter_TyrTriptych ~= nil then
    cameraCineEnter_TyrTriptych:Update()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("TYR TRIPTYCH: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("TYR TRIPTYCH: Son Actor", game.AI.FindSon)
end
function SetupProps()
  doorObj = GameObjects.SpreadDoor1.Child
  journalObj = GameObjects.sonJournalProp.Child
  HideProps()
end
function ShowProps()
  journalObj:Show()
end
function HideProps()
  journalObj:Hide()
end
function PlayTriptychAnim()
  GameObjects.center_metalB:JumpAnimToFrame(550)
  GameObjects.centerBroken:JumpAnimToFrame(550)
end
function TyrTriptychSequence()
  if game.Level.GetVariable("CompletedCineNumber") < 499 then
    print("-----------------TYR TRIPTYCH TRIGGERED")
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Tyr's Triptych")
    local slaveTab = {
      {Actor = sonActor},
      {Obj = doorObj},
      {
        Obj = journalObj,
        Anim = "narCalTyrTriptych000CineScene1"
      }
    }
    doorObj.LuaObjectScript.EnableCinematicTrigger()
    cineSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:RequestCineModeAndWait(kraActor, thisObj)
    cineSeq:Do(StartCineEnter_TyrTriptych)
    cineSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_TyrTriptych",
      ReferenceJoint = synchJoint,
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.StopTurnRadius,
      weapon_state = "bare"
    })
    cineSeq:Do(ShowProps)
    cineSeq:Do(PlayTriptychAnim)
    cineSeq:ActorSync(kraActor, {
      Slaves = slaveTab,
      Branch = "BRA_TyrTriptych",
      ReferenceJoint = synchJoint
    })
    cineSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.975)
    cineSeq:Do(PostCineBanter)
    cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    cineSeq:Do(HideProps)
    cineSeq:Do(StartKeyObjective)
    cineSeq:StopPuppetingActor(kraActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:SetCompletedCineNumber(499)
    cineSeq:Do(game.World.StoreCheckpoint)
    cineSeq:Do(TrophyCheck)
    cineSeq:StartSequence()
  end
end
function StartKeyObjective()
  game.QuestManager.ProposeQuestState("Quest_Helheim_Objective301", "Complete")
  LD.ActivateQuest("Quest_TempleFlip_Parent")
  game.Compass.SetDesignerForcedHide(false)
end
function PostCineBanter()
  game.Audio.PlayBanter("230_FlipDoorEarlyRedirect")
end
function TrophyCheck()
  game.Wallets.AddResource("HERO", "TryptichMarker", 1)
  if game.Wallets.GetResourceValue("HERO", "TryptichMarker") == 12 then
    AwardTrophy()
  end
end
function AwardTrophy()
  print("Trophy Awarded: The Truth")
  game.UnlockTrophy(33)
end
function StartCineEnter_TyrTriptych()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_TyrTriptych = CCEC.CineEnterCamera.New("ENV_CineEnter_TyrTriptych", 8)
  cameraCineEnter_TyrTriptych:SetCallback(DestroyCineEnter_TyrTriptych)
  cameraCineEnter_TyrTriptych:Start()
end
function DestroyCineEnter_TyrTriptych()
  cameraCineEnter_TyrTriptych = nil
  game.SubObject.Sleep(thisObj)
end
