local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local timers = require("level.timer")
local thisLevel, player, waterObj, snakeLoad1, snakeLoad2, snakeBellyLoad, snakeBellySwitch
local snakeBellyZonesActive = false
local camBoatZoneSnakeBellyEnterActive = false
local cal100
local cameraChainRecenter = {
  TimeStart = 0,
  TimeDuration = 2.4,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = 30,
  ReturnLeft = 19,
  ReturnRight = 15,
  TriggerRight = 8,
  PitchRange = -1,
  TriggerUp = -10,
  ReturnUp = -12.5,
  ReturnDown = -14,
  TriggerDown = -24
}
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  waterObj = GameObjects.Water_grp
  snakeLoad1 = GameObjects.WaterUpperLoad
  snakeLoad2 = GameObjects.SnakeLoad
  snakeBellyLoad = GameObjects.SnakeBellyLoad
  snakeBellySwitch = GameObjects.SnakeBellySwitch
  local refnode_Cal200Snakes = level:FindGameObject("Cal200_Snakes")
  if refnode_Cal200Snakes ~= nil then
    local goCrank_XPL940 = refnode_Cal200Snakes:FindSingleGOByName("WheelCrank_PeaksPass_Official")
    if goCrank_XPL940 ~= nil and goCrank_XPL940.LuaObjectScript ~= nil then
      goCrank_XPL940.LuaObjectScript.OverrideDefaultCameraRecenter(true, cameraChainRecenter)
      goCrank_XPL940.LuaObjectScript.OverrideDefaultCameraPitch(true, -13)
      goCrank_XPL940.LuaObjectScript.OverrideDefaultCameraYaw(true, -87)
    end
  end
  SetBridgeGatewayMarkers()
  SoundInit()
end
function OnSaveCheckpoint(level)
  return {snakeBellyZonesActive = snakeBellyZonesActive, camBoatZoneSnakeBellyEnterActive = camBoatZoneSnakeBellyEnterActive}
end
function OnRestoreCheckpoint(level, savedInfo)
  camBoatZoneSnakeBellyEnterActive = savedInfo.camBoatZoneSnakeBellyEnterActive
  snakeBellyZonesActive = savedInfo.snakeBellyZonesActive or false
end
function OnFirstStart(level)
  SnakeBellyVolumeOff()
  snakeLoad2:HideEntityVolume()
  GameObjects.chainVikingGate00:StartAnim("chainAnim")
  game.GameObject.AnimSync(GameObjects.chainVikingGate00, GameObjects.VikingFuneralDoor)
  GameObjects.chainVikingGate00:PauseAnim()
  snakeBellySwitch:HideEntityVolume()
  DisableSonSickBlockers()
  GameObjects.PreAlfheimFog:Hide()
  GameObjects.PostAlfheimFog:Hide()
  GameObjects.BaldurDragon00_end:Hide()
  CloseElevatorGateway()
  GameObjects.TV_Thor_LeftOver:Hide()
  GameObjects.TV_WorldSnakeOFF:Hide()
  GameObjects.TV_WorldSnakeON:Show()
  GameObjects.TV_MasonHammerOF:Hide()
  GameObjects.TV_MasonHammerOn:Show()
  GameObjects.SnakeBlocker_Level1_Forest:Hide()
  GameObjects.SnakeBlocker_Level1_Ruins:Hide()
end
function CalderaShoresA()
  LD.SetRegionDiscovered("CalderaShoresA")
end
function CalderaShoresB()
  LD.SetRegionDiscovered("CalderaShoresB")
end
function CalderaShoresC()
  LD.SetRegionDiscovered("CalderaShoresC")
end
function CalderaShoresD()
  LD.SetRegionDiscovered("CalderaShoresD")
end
function CalderaShoresE()
  LD.SetRegionDiscovered("CalderaShoresE")
end
function CalderaShoresF()
  LD.SetRegionDiscovered("CalderaShoresF")
end
function CalderaShoresG()
  LD.SetRegionDiscovered("CalderaShoresG")
end
function CalderaShoresH()
  LD.SetRegionDiscovered("CalderaShoresH")
end
function ShowSnakeBlocker_WaterDrop01()
  GameObjects.SnakeBlocker_Level1_Forest:Show()
  GameObjects.SnakeBlocker_Level1_Ruins:Show()
end
function OnStart(level)
  ShowWaterObjects(LD.GetCurrentWaterLevel())
  LD.RegisterForVariableUpdate(level, "BridgePosition", {
    immediateFn = SetBridgeGatewayMarkers,
    fn = SetBridgeGatewayMarkers
  })
  SetDockOpenings()
  LD.RegisterForCineUpdate(level, {
    {
      at = 180,
      immediateFn = function()
        GameObjects.BOOKMARK_03_Caldera_005_CalderaArrival:Hide()
        snakeLoad1:HideEntityVolume()
        Disable_Level1_AwarenessZones()
        GameObjects.PreAlfheimFog:Show()
        GameObjects.PostAlfheimFog:Hide()
        GameObjects.TV_WorldSnakeOFF:Hide()
        GameObjects.TV_WorldSnakeON:Show()
        GameObjects.SnakeBlocker_Level1_Forest:Show()
        GameObjects.SnakeBlocker_Level1_Ruins:Show()
      end,
      fn = function()
        snakeLoad1:HideEntityVolume()
        Disable_Level1_AwarenessZones()
        GameObjects.PreAlfheimFog:Show()
        GameObjects.PostAlfheimFog:Hide()
        GameObjects.TV_WorldSnakeOFF:Hide()
        GameObjects.TV_WorldSnakeON:Show()
      end
    },
    {
      at = 190,
      immediateFn = function()
        GameObjects.waterdropfx_manager.LuaObjectScript.ForceCompleteFX()
      end,
      fn = function()
      end
    },
    {
      at = 250,
      immediateFn = function()
        GameObjects.PreAlfheimFog:Hide()
        GameObjects.PostAlfheimFog:Show()
      end,
      fn = function()
        GameObjects.PreAlfheimFog:Hide()
        GameObjects.PostAlfheimFog:Show()
      end
    },
    {
      at = 263,
      immediateFn = function()
        GameObjects.SnakeBlocker_Level1_Forest:Hide()
      end,
      fn = function()
        GameObjects.SnakeBlocker_Level1_Forest:Hide()
      end
    },
    {
      at = 340,
      immediateFn = function()
        HideRuinsSnake()
      end,
      fn = function()
        HideRuinsSnake()
      end
    },
    {
      at = 350,
      immediateFn = function()
        GameObjects.Cbt_Cal200_Script.LuaObjectScript.EnableZone_EntZn_Arena_Spawn_2()
      end,
      fn = function()
        GameObjects.Cbt_Cal200_Script.LuaObjectScript.EnableZone_EntZn_Arena_Spawn_2()
      end
    },
    {
      at = 355,
      immediateFn = function()
        GameObjects.TV_MasonHammerOF:Show()
        GameObjects.TV_MasonHammerOn:Hide()
      end,
      fn = function()
        GameObjects.TV_MasonHammerOF:Show()
        GameObjects.TV_MasonHammerOn:Hide()
      end
    },
    {
      at = 365,
      immediateFn = function()
        EnableSonSickBlockers()
        ShowWaterObjects(LD.GetCurrentWaterLevel())
      end,
      fn = function()
        EnableSonSickBlockers()
        ShowWaterObjects(LD.GetCurrentWaterLevel())
      end
    },
    {
      at = 390,
      immediateFn = function()
        DisableSonSickBlockers()
      end,
      fn = function()
        DisableSonSickBlockers()
      end
    },
    {
      at = 425,
      immediateFn = function()
        OpenElevatorGateway()
      end,
      fn = function()
        OpenElevatorGateway()
      end
    },
    {
      at = 425,
      immediateFn = function()
        CloseElevatorGateway()
      end,
      fn = function()
        CloseElevatorGateway()
      end
    },
    {
      at = 439,
      immediateFn = function()
        GameObjects.Cbt_Cal200_Script.LuaObjectScript.DisableZone_EntZn_Arena_Spawn_2()
      end,
      fn = function()
        GameObjects.Cbt_Cal200_Script.LuaObjectScript.DisableZone_EntZn_Arena_Spawn_2()
      end
    },
    {
      at = 500,
      immediateFn = function()
        GameObjects.BaldurDragon00_end:Show()
      end,
      fn = function()
        GameObjects.BaldurDragon00_end:Show()
      end
    },
    {
      at = 520,
      immediateFn = function()
        SnakeBellyVolumeOn()
      end,
      fn = function()
        SnakeBellyVolumeOn()
      end
    },
    {
      at = 540,
      immediateFn = function()
        SnakeBellyVolumeOff()
      end,
      fn = function()
        SnakeBellyVolumeOff()
      end
    },
    {
      at = 570,
      immediateFn = function()
        GameObjects.TV_WorldSnakeOFF:Show()
        GameObjects.TV_WorldSnakeON:Hide()
      end,
      fn = function()
        GameObjects.TV_WorldSnakeOFF:Show()
        GameObjects.TV_WorldSnakeON:Hide()
      end
    }
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = function()
      LowerWater_Level01(true)
    end,
    fn = function()
      LowerWater_Level01(false)
      thisLevel:Broadcast("BoatLoot_CheckForWaterLevel")
    end
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = function()
      RemoveAll_Water01_Docks()
      LowerWater_Level02(true)
      GameObjects.TVcal980RTWFWL01:Hide()
      GameObjects.TVcal980LTWFWL01:Hide()
      GameObjects.TVcal980RTWFWL02:Show()
      GameObjects.TVcal980LTWFWL02:Show()
    end,
    fn = function()
      LowerWater_Level02(false)
      RemoveAll_Water01_Docks()
      GameObjects.TVcal980RTWFWL01:Hide()
      GameObjects.TVcal980LTWFWL01:Hide()
      GameObjects.TVcal980RTWFWL02:Show()
      GameObjects.TVcal980LTWFWL02:Show()
      thisLevel:Broadcast("BoatLoot_CheckForWaterLevel")
    end
  })
  GameObjects.BaldurDragonDead_Toggle:ShowEntityVolume()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 500 <= cineNumber and player:InsideZone(GameObjects.BaldurDragonDead_Toggle) == false then
    GameObjects.BaldurDragon00_end:Show()
  end
  SoundOnStart()
end
function RemoveAll_Water01_Docks()
  local upperDockTable = {
    "BC_940_BoatDock_Upper",
    "BM_950_DockPoint_Upper",
    "BSW_960_DockPoint_Upper",
    "BT_970_DockPoint_Upper",
    "HM01_BoatDock_Upper",
    "BW_980_DockPoint_Upper",
    "DF_875_DockPoint_Upper",
    "HM01_BoatDock_Upper",
    "ISW_910_DockPoint_Upper",
    "CAL_200_DockPoint_Upper2",
    "CAL_200_DockPoint_Upper3",
    "CAL_200_DockPoint_Upper4",
    "CAL_200_DockPoint_Upperx",
    "CAL_200_DockPoint_Upperx1",
    "CAL_200_DockPoint_Upperx2",
    "CAL_200_DockPoint_Upperx3",
    "CAL_200_DockPoint_Upperx4",
    "CAL_200_DockPoint_Upperx5"
  }
  for _, dockpoint in pairs(upperDockTable) do
    game.Compass.HideMarker(dockpoint)
    game.Map.ChangeMarkerState(dockpoint, tweaks.eTokenState.kUndiscovered)
  end
  game.Compass.SetGatewayMarkerIsOpen("BC_940_BoatDock_Upper", false)
  game.Compass.SetGatewayMarkerIsOpen("BSW_960_DockPoint_Upper", false)
  game.Compass.SetGatewayMarkerIsOpen("BT_970_DockPoint_Upper", false)
  game.Compass.SetGatewayMarkerIsOpen("ISW_910_DockPoint_Upper", false)
  game.Compass.SetGatewayMarkerIsOpen("BW_980_DockPoint_Upper", false)
  game.Compass.SetGatewayMarkerIsOpen("HM01_BoatDock_Upper", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper2", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper3", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper4", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx1", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx2", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx2", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx3", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx4", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx5", false)
end
function BaldurDragonDead_ToggleOff()
  GameObjects.BaldurDragon00_end:Hide()
end
function BaldurDragonDead_ToggleOn()
  GameObjects.BaldurDragon00_end:Show()
end
function GateWheelCrankComplete()
  game.World.StoreCheckpoint()
end
function EnableSonSickBlockers()
  GameObjects.SonSickBlockers:Show()
  GameObjects.WaterLevel2_Pools:Hide()
  GameObjects.WaterLevel2_Plucks:Hide()
end
function DisableSonSickBlockers()
  GameObjects.SonSickBlockers:Hide()
  GameObjects.WaterLevel2_Pools:Show()
  GameObjects.WaterLevel2_Plucks:Show()
end
function ShowSonSickBlockers()
  GameObjects.SonSickBlockers_visuals:Show()
  uiCalls.UI_Event_SendDesignerMessage("You have to heal your son", 3)
end
function UpdateSnakeIdle()
  local cal200 = game.FindLevel("Cal200_Shore")
  if cal200 ~= nil then
    local snakeIdleObj = cal200:GetGameObject("SnakeIdle")
    if snakeIdleObj ~= nil then
      snakeIdleObj:CallScript("UpdateSnakeIdle")
    end
  end
end
function LowerWater_Level01(bImmediate)
  if game.Level.GetVariable("CAL_FirstSnakeAnim") == false then
    game.Level.SetVariable("CAL_FirstSnakeAnim", true)
  end
  ShowWaterObjects(1)
  waterObj.LuaObjectScript.LowerWater_Level01(bImmediate)
  SetWaterLevelSoundPosition()
  SetDockOpenings(1)
  if bImmediate then
    WaterLevelOneSetupDuringCine()
  end
end
function LowerWater_Level02(bImmediate)
  ShowWaterObjects(2)
  print("DOCK MARKERS LOWER WATER LEVEL 2")
  waterObj.LuaObjectScript.LowerWater_Level02(bImmediate)
  SetWaterLevelSoundPosition()
  SetDockOpenings(2)
end
function SnakeCineVolsOn()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber < 520 then
    snakeLoad1:ShowEntityVolume()
    snakeLoad2:ShowEntityVolume()
  end
end
function SnakeCineVolsOff()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber < 520 then
    snakeLoad1:HideEntityVolume()
    snakeLoad2:HideEntityVolume()
  elseif 520 <= cineNumber and cineNumber < 540 then
    SnakeBellyVolumeOn()
  end
end
function SnakeBellyVolumeOn()
  GameObjects.TV_Wtr2_JawOFF:Hide()
  GameObjects.TV_Wtr2_JawON:Show()
  snakeLoad2:HideEntityVolume()
  snakeBellyLoad:ShowEntityVolume()
  GameObjects.Load_Quad5:HideEntityVolume()
  GameObjects.Load_Quad6:HideEntityVolume()
  GameObjects.SnakeBelly_Load_Quad5:ShowEntityVolume()
  GameObjects.SnakeBelly_Load_Quad6:ShowEntityVolume()
  GameObjects.snakeBellyEntrance:Show()
  GameObjects.SnakeBelly_BoatGeneralGuide:Show()
  local camBoatZoneSnakeBellyEnter = thisLevel:GetGameObject("CamBoatZoneNear_Inside")
  camBoatZoneSnakeBellyEnter:ShowCameraVolume()
  camBoatZoneSnakeBellyEnterActive = true
  GameObjects.BoatSpeedControl_DuringSnakeMouth.Child.LuaObjectScript.Enable()
  if not snakeBellyZonesActive then
    snakeBellyZonesActive = true
    game.World.StoreCheckpoint()
  end
end
function BoatSplineOn()
  local data = {
    Boat = game.Boat.GetPlayerBoat(),
    AngleThreshold = 30
  }
  thisLevel:EnableBoatForceDirectionControlMode(data)
end
function SnakeBellyVolumeOff()
  snakeBellyZonesActive = false
  GameObjects.TV_Wtr2_JawOFF:Show()
  GameObjects.TV_Wtr2_JawON:Hide()
  snakeBellyLoad:HideEntityVolume()
  GameObjects.Load_Quad5:ShowEntityVolume()
  GameObjects.Load_Quad6:ShowEntityVolume()
  GameObjects.SnakeBelly_Load_Quad5:HideEntityVolume()
  GameObjects.SnakeBelly_Load_Quad6:HideEntityVolume()
  snakeBellySwitch:HideEntityVolume()
  GameObjects.snakeBellyEntrance:Hide()
  GameObjects.SnakeBelly_BoatGeneralGuide:Hide()
  local camBoatZoneSnakeBellyEnter = thisLevel:GetGameObject("CamBoatZoneNear_Inside")
  camBoatZoneSnakeBellyEnter:HideCameraVolume()
  camBoatZoneSnakeBellyEnterActive = false
  GameObjects.BoatSpeedControl_DuringSnakeMouth.Child.LuaObjectScript.Disable()
end
function SetSnakeVarTrue()
  SnakeCineVolsOn()
  uiCalls.UI_Event_DiscoverLocation("Lake of Nine")
  game.Audio.StartCheckpointedMusic("SND_MX_CAL_lake_reveal")
  game.SubmitActivityFeedStory("03_WorldSnakeIntro")
end
function OnBreakableBroken(level, obj)
  GameObjects.CalderaBoatLootManager.LuaObjectScript.OnBreakableBroken(level, obj)
end
function ShowBoatPickups(waterLevel)
  local ShowBoatPickups_Validate = function(waterLevel)
    if waterLevel == 0 then
      print("Not showing boat pickups due to water level being 0")
      return false
    end
    local cineNumber = game.Level.GetVariable("CompletedCineNumber")
    if 360 <= cineNumber and cineNumber <= 389 then
      print([[
Not showing boat picksup due to cine number being between 360 & 389, inclusive.
							Son should be sick during this portion. Current Cine Number: ]], cineNumber)
      return false
    end
    return true
  end
  if ShowBoatPickups_Validate(waterLevel) ~= true then
    GameObjects.CalderaBoatLootManager.LuaObjectScript.Disable()
  else
    GameObjects.CalderaBoatLootManager.LuaObjectScript.Enable(waterLevel)
  end
end
function ShowWaterObjects(waterLevel)
  if not waterLevel then
    local waterLevel = LD.GetCurrentWaterLevel()
  end
  ShowBoatPickups(waterLevel)
  if waterLevel == 0 then
    GameObjects.TV_WaterLevel1_Obj:Hide()
    GameObjects.TV_WaterLevel2_Obj:Hide()
    GameObjects.FXWaterTopObjects:Show()
    GameObjects.FXWaterMidObjects:Hide()
    GameObjects.FXWaterBottomObjects:Hide()
    GameObjects.LightsWaterTopObjects:Show()
    GameObjects.LightsWaterMidObjects:Hide()
    GameObjects.LightsWaterBottomObjects:Hide()
    GameObjects.WaterLevel2_Plucks:Hide()
    local pools = GameObjects.WaterLevel2_Pools.Children
    for _, pool in ipairs(pools) do
      pool.Child.LuaObjectScript.Disable()
    end
    GameObjects.ZipTower_01.LuaObjectScript.setLevel(0)
    GameObjects.ZipTower_02.LuaObjectScript.setLevel(0)
    GameObjects.ZipTower_03.LuaObjectScript.setLevel(0)
    GameObjects.CraneRopes_atWaterLevel1:Show()
  elseif waterLevel == 1 then
    GameObjects.WaterLevel2_Plucks:Hide()
    local cineNumber = game.Level.GetVariable("CompletedCineNumber")
    if cineNumber < 250 then
      GameObjects.PostAlfheimFog:Hide()
      GameObjects.PreAlfheimFog:Show()
    else
      GameObjects.PreAlfheimFog:Hide()
      GameObjects.PostAlfheimFog:Show()
    end
    local pools = GameObjects.WaterLevel2_Pools.Children
    for _, pool in ipairs(pools) do
      pool.Child.LuaObjectScript.Disable()
    end
    GameObjects.ZipTower_01.LuaObjectScript.setLevel(0)
    GameObjects.ZipTower_02.LuaObjectScript.setLevel(0)
    GameObjects.ZipTower_03.LuaObjectScript.setLevel(0)
    GameObjects.CraneRopes_atWaterLevel1:Show()
  elseif waterLevel == 2 then
    GameObjects.TV_WaterLevel1_Obj:Hide()
    GameObjects.TV_WaterLevel2_Obj:Show()
    GameObjects.FXWaterTopObjects:Hide()
    GameObjects.FXWaterMidObjects:Hide()
    GameObjects.FXWaterBottomObjects:Show()
    GameObjects.LightsWaterTopObjects:Hide()
    GameObjects.LightsWaterMidObjects:Hide()
    GameObjects.LightsWaterBottomObjects:Show()
    GameObjects.WaterLevel2_Plucks:Show()
    GameObjects.PreAlfheimFog:Hide()
    GameObjects.PostAlfheimFog:Hide()
    local pools = GameObjects.WaterLevel2_Pools.Children
    for _, pool in ipairs(pools) do
      pool.Child.LuaObjectScript.Enable()
    end
    GameObjects.ZipTower_01.LuaObjectScript.setLevel_toInitial()
    GameObjects.ZipTower_02.LuaObjectScript.setLevel_toInitial()
    GameObjects.ZipTower_03.LuaObjectScript.setLevel_toInitial()
    GameObjects.CraneRopes_atWaterLevel1:Hide()
  end
end
function WaterLevelOneSetupDuringCine()
  GameObjects.TV_WaterLevel1_Obj:Show()
  GameObjects.TV_WaterLevel2_Obj:Hide()
  GameObjects.FXWaterTopObjects:Hide()
  GameObjects.FXWaterMidObjects:Show()
  GameObjects.FXWaterBottomObjects:Hide()
  GameObjects.LightsWaterTopObjects:Hide()
  GameObjects.LightsWaterMidObjects:Show()
  GameObjects.LightsWaterBottomObjects:Hide()
end
function Quest_PeaksPass_Objective745_End()
  LD.CompleteQuest("Quest_PeaksPass_Objective745")
end
function Huldra1_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("CalderaHM01Load")
  LD.SetMarkerState("CAL_HM1_Entrance", 1)
end
function Huldra2_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("CalderaHM02Load")
  LD.SetMarkerState("CAL_HM2_Entrance", 1)
end
function Huldra3_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("CalderaHSHLoad")
  LD.SetMarkerState("CAL_HSH_Entrance", 1)
end
function SM_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("StoneMason Connector")
  LD.SetMarkerState("CAL_SMC_Entrance", 1)
end
function Httk_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("CalderaHTTKLoad")
  LD.SetMarkerState("CAL_HTTK_Entrance", 1)
end
function VF_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("CalderaVFLoad")
  LD.SetMarkerState("CAL_VF_Entrance", 1)
  local waterLevel = LD.GetCurrentWaterLevel()
  if waterLevel == 1 then
    game.Compass.SetGatewayMarkerIsOpen("VF_220_Helper_WaterLevelOne", true)
    game.Compass.OnWarp()
  else
    game.Compass.SetGatewayMarkerIsOpen("VF_220_Helper_WaterLevelOne", false)
  end
end
function ForestDungeon_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("CalderaFDLoad")
  LD.SetMarkerState("CAL_FD_Entrance", 1)
end
function WitchCavern_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("CalderaRPLoad")
  LD.SetMarkerState("CAL_Freya_Entrance", 1)
end
function CalderaLake_LoadHall_AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Lake of Nine")
end
function MoveBridgeToVan100()
  LD.SetBridgePosition("Midgard")
end
function TurnOn800Zone100()
  cal100:CallScript("TurnOn800Zone")
end
function TurnOff800Zone100()
  cal100:CallScript("TurnOff800Zone")
end
function HideRockAndTower(level)
  GameObjects.cliff_LG_069:Hide()
  GameObjects.cliff_LG_068:Hide()
  GameObjects.cliff_LG_044:Hide()
end
function HideWaterPlane()
  LD.Map(thisLevel:FindGameObjects("Water_grp"), function(water)
    water.LuaObjectScript.HideWater()
  end)
end
function ShowWaterPlane()
  LD.Map(thisLevel:FindGameObjects("Water_grp"), function(water)
    water.LuaObjectScript.ShowWater()
  end)
end
function OnEnterSnake()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 520 <= cineNum and cineNum < 540 then
    GameObjects.POI_SnakesBellyEnter.LuaObjectScript.EnterSnakeStart()
    GameObjects.snakeBellyEntrance:HideEntityVolume()
  end
  local data = {
    Boat = game.Boat.GetPlayerBoat()
  }
  thisLevel:DisableBoatForceDirectionControlMode(data)
end
function EnterSnakeMouth()
  CloseSnakeMouth()
end
function CloseSnakeMouth()
  GameObjects.SnakesLights:PlayAnimToEnd()
  GameObjects.SnakeSmallLight:PlayAnimToEnd()
  GameObjects.worldsnake00:StartAnim("envCalSnakeHeadSnakeBellyMouthClosing")
  GameObjects.worldsnake00:SetAnimRate(1)
  game.Audio.PlayBanter("120_IntoTheBelly_02")
  PlaySnakeMouthCloseSound()
end
function WarpToSnakeBelly()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 520 <= cineNumber and cineNumber < 540 then
    SnakeBellyVolumeOn()
  end
  HideSnakeMouthZone()
  local cal800 = game.FindLevel("Cal800_SnakeBelly")
  if cal800 then
    cal800:CallScript("WarpToBeginning")
  end
end
function WarpFromSnakeBelly()
  local boat = game.Boat.GetPlayerBoat()
  if boat then
    boat:Warp(GameObjects.snakeExitLocation.WorldPosition, GameObjects.snakeExitLocation:GetWorldForward())
  end
end
function SwitchToSnakeBelly()
  timers.StartLevelTimer(1, function()
    snakeLoad2:HideEntityVolume()
    snakeBellyLoad:HideEntityVolume()
    snakeBellySwitch:ShowEntityVolume()
    game.UI.LoadCheck("Cal800_SnakeBelly")
    timers.StartLevelTimer(0.1, WarpToSnakeBelly)
  end)
end
function HideRuinsSnake()
  GameObjects.SnakeBlocker_Level1_Ruins:Hide()
  GameObjects.TV_Thor_Complete:Hide()
end
function ShowBrokenThor()
  GameObjects.TV_Thor_LeftOver:Show()
end
function LockCrank()
  local waterwheelCrank = thisLevel:GetGameObject("WaterWheel_WheelCrank")
  waterwheelCrank.LuaObjectScript.Lock()
end
function ThorAwareness_Stop()
  GameObjects.EnvEvt_Thor.LuaObjectScript.DisableEventEmitter()
  GameObjects.EntZn_EnvThor_DisableRemotly:HideEntityVolume()
end
function Disable_Level1_AwarenessZones()
  GameObjects.AwarenessZone_Thor_Level_0.LuaObjectScript.DisableEventEmitter()
end
function Xpl900_GateUp()
  GameObjects.GateInverseLOD_Up:Show()
  GameObjects.GateInverseLOD_Down:Hide()
end
function Xpl900_GateDown()
  GameObjects.GateInverseLOD_Up:Hide()
  GameObjects.GateInverseLOD_Down:Show()
end
function CalderaMirrors_Hide()
  GameObjects.waterLakeMirror:Hide()
  GameObjects.waterLakeMirror1:Hide()
  GameObjects.waterLakeMirror2:Hide()
  GameObjects.waterLakeMirror3:Hide()
  GameObjects.waterLakeMirror4:Hide()
end
function CalderaMirrors_Show()
  GameObjects.waterLakeMirror:Show()
  GameObjects.waterLakeMirror1:Show()
  GameObjects.waterLakeMirror2:Show()
  GameObjects.waterLakeMirror3:Show()
  GameObjects.waterLakeMirror4:Show()
end
function VikingFuneral_w01_Check()
  return CineNumberInBetween(180, 340) and IsVikingDoorClosed()
end
function VikingFuneral_w02_Check()
  return CineNumberInBetween(340, 999) and IsVikingDoorClosed()
end
function IsVikingDoorClosed()
  return not GameObjects.cal200_xpl980_VFGate.LuaObjectScript.IsUnlocked()
end
function CineNumberInBetween(min, max)
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  return min <= cineNumber and max > cineNumber
end
function SetWaterLevelSoundPosition()
  local position = waterObj.Child:GetWorldPosition()
  if cal100 == nil then
    cal100 = game.FindLevel("Cal100_Hub")
  end
  if cal100 ~= nil and waterObj ~= nil then
    cal100:CallScript("SetWaterLevelSoundPositions", position)
  end
end
function OnUpdate()
  if camBoatZoneSnakeBellyEnterActive and game.World.IsInsideCameraZone(player.WorldPosition, "CamBoatZoneNear_Inside") then
    game.Camera.SubmitCameraByName("PLYR_Boat_Forward_Near_HalfClose")
  end
end
function SetBridgeGatewayMarkers()
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge2", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge4", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge6", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge8", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge10", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge12", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper33", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper33to36", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34to35", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper35", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper64", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper36", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper65", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper37", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper37to38", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper38", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper76", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway6", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper39", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper77", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper39to40", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper40", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper41", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper41to42", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper42", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper74", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway5", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper43", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper43to44", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper44", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper75", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper45", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper45to46", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper46", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper72", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway4", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper47", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper73", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper47to48", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper48", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper49", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper49to50", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper50", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper70", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway3", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper51", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper51to52", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper52", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper71", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper53", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper53to54", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper54", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper68", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway2", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper55", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper55to56", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper56", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper69", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper57", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper57to58", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper58", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper66", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper59", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper59to60", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper60", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper67", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway1", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper1", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper2", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper3", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper4", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper6", false)
  game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper7", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock1", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock3", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock4", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock5", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock6", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock7", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock8", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock9", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock10", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock11", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock12", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock13", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock14", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge7", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge1", true)
  local selBridgePosition = LD.GetBridgePosition()
  local waterLevel = LD.GetCurrentWaterLevel()
  if selBridgePosition == "Jotunheim" then
    JotunheimCompassPaths(waterLevel)
  elseif selBridgePosition == "Alfheim" then
    AlfheimCompassPaths(waterLevel)
  elseif selBridgePosition == "Vanaheim" or selBridgePosition == "Midgard" then
    VanaheimCompassPaths(waterLevel)
  elseif selBridgePosition == "Helheim" then
    HelheimCompassPaths(waterLevel)
  elseif selBridgePosition == "Asgard" then
    AsgardCompassPaths(waterLevel)
  elseif selBridgePosition == "Muspelheim" then
    MuspelheimCompassPaths(waterLevel)
  elseif selBridgePosition == "Niflheim" then
    NiflheimCompassPaths(waterLevel)
  end
  SetDockOpenings()
end
function JotunheimCompassPaths(waterLevel)
  if waterLevel ~= 0 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge2", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper37", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper37to38", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper38", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper76", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper39", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper77", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper39to40", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper40", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway5", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway4", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway3", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway2", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway1", true)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper", true)
    if waterLevel == 2 then
      CloseJotunheimGateways()
    end
  end
end
function CloseJotunheimGateways()
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_02", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_44_WL2", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_45_WL2", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_63A_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_023", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_63B_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_18_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_19_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_17_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_08", true)
end
function AlfheimCompassPaths(waterLevel)
  if waterLevel ~= 0 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge4", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper41", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper41to42", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper42", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper74", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper43", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper43to44", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper44", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper75", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway4", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway3", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway2", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway1", true)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper7", true)
  end
end
function VanaheimCompassPaths(waterLevel)
  if waterLevel ~= 0 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge1b", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper33", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper33to36", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34to35", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper35", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper64", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper36", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper65", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway5", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway4", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway3", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway2", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway1", true)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper1", true)
    if waterLevel == 2 then
      CloseVanaheimGateways()
    end
  end
end
function CloseVanaheimGateways()
  print("GATEWAY: Attempting to close Vanaheim gateway")
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_63A_WL2", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_023", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_63B_WL2", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_02", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_44_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_45_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_18_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_19_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_17_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_08", true)
end
function HelheimCompassPaths(waterLevel)
  print("GATEWAY got helheim", waterLevel)
  if waterLevel ~= 0 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway5", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper45", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper45to46", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper46", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper72", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper47", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper73", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper47to48", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper48", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway3", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway2", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway1", true)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper6", true)
    if waterLevel == 2 then
      CloseHelHeimGateways()
    end
  end
end
function CloseHelHeimGateways()
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_63A_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_023", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_63B_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_02", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_44_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_45_WL2", true)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_18_WL2", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_19_WL2", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper_17_WL2", false)
  game.Compass.SetGatewayMarkerIsOpen("CAL_200_WL2_Gateway_08", false)
end
function AsgardCompassPaths(waterLevel)
  if waterLevel ~= 0 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge8", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway5", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway4", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper49", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper49to50", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper50", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper70", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper51", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper51to52", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper52", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper71", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway2", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway1", true)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper4", true)
  end
end
function MuspelheimCompassPaths(waterLevel)
  if waterLevel ~= 0 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge12", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway5", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway4", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway3", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway2", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper57", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper57to58", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper58", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper66", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper59", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper59to60", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper60", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper67", true)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper2", true)
  end
end
function NiflheimCompassPaths(waterLevel)
  if waterLevel ~= 0 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge10", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway5", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway4", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway3", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper53", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper53to54", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper54", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper68", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper55", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper55to56", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper56", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper69", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway1", true)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper3", true)
  end
end
function SetDockOpenings(waterLevel)
  waterLevel = waterLevel or LD.GetCurrentWaterLevel()
  if waterLevel == 0 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock2", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock3", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock4", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock5", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock6", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock7", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock8", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock9", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock10", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock11", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock12", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock13", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock14", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge2", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge1B", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge4", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge6", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge8", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge10", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge12", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper33to36", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34to35", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper35", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper64", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper36", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper65", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper37", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper37to38", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper38", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper76", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway6", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper39", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper77", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper39to40", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper40", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper41", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper41to42", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper42", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper74", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway5", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper43", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper43to44", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper44", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper75", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper45", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper45to46", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper46", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper72", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway4", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper47", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper73", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper47to48", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper48", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper49", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper49to50", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper50", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper70", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway3", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper51", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper51to52", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper52", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper71", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper53", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper53to54", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper54", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper68", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway2", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper55", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper55to56", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper56", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper69", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper57", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper57to58", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper58", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper66", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper59", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper59to60", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper60", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper67", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Waterway1", false)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper", false)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper1", false)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper2", false)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper3", false)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper4", false)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper6", false)
    game.Compass.SetGatewayMarkerIsOpen("CALT_120_Helper7", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper79", true)
    game.Compass.SetGatewayMarkerIsOpen("RP_935Upper_Helper", false)
    game.Compass.SetGatewayMarkerIsOpen("RP_935Lower_Helper2", false)
  elseif waterLevel == 1 then
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock1", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock2", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock3", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock4", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock5", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock6", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock7", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock8", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock9", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock10", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock11", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock12", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock13", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock14", true)
    game.Compass.SetGatewayMarkerIsOpen("BC_940_BoatDock_Upper", true)
    game.Compass.SetGatewayMarkerIsOpen("BM_950_DockPoint_Upper", true)
    game.Compass.SetGatewayMarkerIsOpen("BSW_960_DockPoint_Upper", true)
    game.Compass.SetGatewayMarkerIsOpen("BT_970_DockPoint_Upper", true)
    game.Compass.SetGatewayMarkerIsOpen("HM01_BoatDock_Upper", true)
    game.Compass.SetGatewayMarkerIsOpen("BW_980_DockPoint_Upper", true)
    game.Compass.SetGatewayMarkerIsOpen("DF_875_DockPoint_Upper", true)
    game.Compass.SetGatewayMarkerIsOpen("HM01_BoatDock_Upper", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper2", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper3", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper4", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx1", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx2", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx3", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx1", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx4", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx5", true)
    game.Compass.SetGatewayMarkerIsOpen("VF_220_Helper_WaterLevelOne", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34to35", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper33to36", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper59to60", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper57to58", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper53to54", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper55to56", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper49to50", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper51to52", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper47to48", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper45to46", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper41to42", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper43to44", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper37to38", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper39to40", false)
    game.Compass.SetGatewayMarkerIsOpen("RP_935Upper_Helper", true)
    game.Compass.SetGatewayMarkerIsOpen("RP_935Lower_Helper2", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper79", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper35", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper36", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_FD_Entrance", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower10", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower11", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower12", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower3", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower4", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower5", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower6", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower7", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower8", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower9", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lowerv", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lowerv", false)
    game.Compass.SetGatewayMarkerIsOpen("BM_950_DockPoint_Lower", false)
    game.Compass.SetGatewayMarkerIsOpen("BT_970_DockPoint_Lower", false)
    game.Compass.SetGatewayMarkerIsOpen("BC_940_BoatDock_Lower", false)
    game.Compass.SetGatewayMarkerIsOpen("BW_980_DockPoint_Lower", false)
    game.Compass.SetGatewayMarkerIsOpen("VF_220_LowerDockPoint", false)
  elseif waterLevel == 2 then
    game.Compass.SetGatewayMarkerIsOpen("CAL_FD_Entrance", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock1", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock2", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock3", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock4", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock5", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock6", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock7", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock8", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock9", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock10", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock11", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock12", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock13", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Dock14", false)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34to35", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper33to36", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper59to60", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper57to58", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper53to54", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper55to56", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper49to50", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper51to52", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper47to48", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper45to46", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper41to42", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper43to44", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper37to38", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper39to40", true)
    game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper79", false)
    game.Compass.SetGatewayMarkerIsOpen("RP_935Upper_Helper", false)
    game.Compass.SetGatewayMarkerIsOpen("RP_935Lower_Helper2", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower10", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower11", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower12", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower3", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower4", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower5", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower6", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower7", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower8", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lower9", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lowerv", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Lowerv", true)
    game.Compass.SetGatewayMarkerIsOpen("BM_950_DockPoint_Lower", true)
    game.Compass.SetGatewayMarkerIsOpen("BT_970_DockPoint_Lower", true)
    game.Compass.SetGatewayMarkerIsOpen("BC_940_BoatDock_Lower", true)
    game.Compass.SetGatewayMarkerIsOpen("BW_980_DockPoint_Lower", true)
    game.Compass.SetGatewayMarkerIsOpen("VF_220_LowerDockPoint", true)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper2", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper3", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upper4", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx1", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx2", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx3", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx4", false)
    game.Compass.SetGatewayMarkerIsOpen("CAL_200_DockPoint_Upperx5", false)
    game.Compass.SetGatewayMarkerIsOpen("VF_220_Helper_WaterLevelOne", false)
    game.Compass.SetGatewayMarkerIsOpen("DF_875_DockPoint_Upper", false)
    game.Compass.SetGatewayMarkerIsOpen("ISW_910_DockPoint_Upper", false)
    game.Compass.SetGatewayMarkerIsOpen("BM_950_DockPoint_Upper", false)
    game.Compass.SetGatewayMarkerIsOpen("BSW_960_DockPoint_Upper", false)
  end
end
function OpenElevatorGateway()
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_ElevatorToBridge1", true)
end
function CloseElevatorGateway()
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_ElevatorToBridge1", false)
end
function SnakeTranslateCompassClose()
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Snake", false)
end
function xpl650_LoadCheck()
  game.UI.LoadCheck("xpl650_MasonTrailCave")
end
function xpl220_LoadCheck()
  game.UI.LoadCheck("Xpl220_FuneralLH")
end
function xpl425_LoadCheck()
  game.UI.LoadCheck("Xpl425_HuldraMinesLH")
end
function xpl325_LoadCheck()
  game.UI.LoadCheck("Xpl325_StrongholdLH")
end
function xpl625_LoadCheck()
  game.UI.LoadCheck("Xpl625_MasonTrailLH")
end
function cal270_LoadCheck()
  game.UI.LoadCheck("Cal270_StoneMasonLH")
end
function xpl900_LoadCheck()
  game.UI.LoadCheck("Xpl900_IslandArch")
end
function xpl910_LoadCheck()
  game.UI.LoadCheck("Xpl910_IslandShipwreck")
end
function xpl920_LoadCheck()
  game.UI.LoadCheck("Xpl920_IslandClimb")
end
function xpl930_LoadCheck()
  game.UI.LoadCheck("Xpl930_BeachRuins")
end
function xpl940_LoadCheck()
  game.UI.LoadCheck("Xpl940_BeachCave")
end
function xpl950_LoadCheck()
  game.UI.LoadCheck("Xpl950_BeachMaze")
end
function xpl960_LoadCheck()
  game.UI.LoadCheck("Xpl960_BeachShip")
end
function xpl970_LoadCheck()
  game.UI.LoadCheck("Xpl970_BeachTower")
end
function xpl980_LoadCheck()
  game.UI.LoadCheck("Xpl980_BeachWaterfall")
end
function xpl475_LoadCheck()
  game.UI.LoadCheck("Xpl475_HuldraMinesLH")
end
function xpl875_LoadCheck()
  game.UI.LoadCheck("Xpl875_DungeonForestLH")
end
function cal225_LoadCheck()
  game.UI.LoadCheck("Cal225_RiverPassLH")
end
function xpl125_LoadCheck()
  game.UI.LoadCheck("Xpl125_HTTKLH")
end
function cal100_LoadCheck()
  game.UI.LoadCheck("Cal100_Hub")
end
function UpdateLoadGroup()
  timers.StartLevelTimer(0.1, UpdateLoadGroup_Delay)
end
function UpdateLoadGroup_Delay()
  game.EvaluateLoadZones()
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel then
    if player:InsideZone(GameObjects.AIZone_IslandArch) == true then
      if 1 < waterlevel then
        return "IslandArch_02"
      end
    elseif player:InsideZone(GameObjects.AIZone_IslandShipwreck) == true then
      return tostring("IslandShipwreck_0" .. waterlevel)
    elseif player:InsideZone(GameObjects.AIZone_IslandClimb) == true then
      if 1 < waterlevel then
        return "IslandClimb_02"
      end
    elseif player:InsideZone(GameObjects.AIZone_BeachRuins) == true then
      return tostring("BeachRuins_0" .. waterlevel)
    elseif player:InsideZone(GameObjects.AIZone_BeachCave) == true then
      return tostring("BeachCave_0" .. waterlevel)
    elseif player:InsideZone(GameObjects.AIZone_BeachMaze) == true then
      return tostring("BeachMaze_0" .. waterlevel)
    elseif player:InsideZone(GameObjects.AIZone_BeachShip) == true then
      return tostring("BeachShip_0" .. waterlevel)
    elseif player:InsideZone(GameObjects.AIZone_BeachTower) == true then
      return tostring("BeachTower_0" .. waterlevel)
    elseif player:InsideZone(GameObjects.AIZone_BeachWaterfall) == true then
      return tostring("BeachWaterfall_0" .. waterlevel)
    elseif player:InsideZone(GameObjects.AIZone_BeachMasonTrail) == true then
      if 1 < waterlevel then
        return "BeachMasonTrail_02"
      end
    elseif player:InsideZone(GameObjects.AIZone_Bridge) == true then
      local completedCineNum = game.Level.GetVariable("CompletedCineNumber")
      if completedCineNum < 180 then
        return tostring("World_Snake_Intro")
      elseif completedCineNum == 180 then
        return tostring("Bridge_01_Shop")
      elseif 190 <= completedCineNum and completedCineNum < 200 then
        return tostring("Bridge_01_Freya")
      end
    end
  end
end
function OnEvaluateLoadGroup_BeachMaze_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel and player:InsideZone(GameObjects.AIZone_BeachMaze) == true then
    return tostring("BeachMaze_0" .. waterlevel)
  end
end
function OnEvaluateLoadGroup_BeachWaterfall_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel and player:InsideZone(GameObjects.AIZone_BeachWaterfall) == true then
    return tostring("BeachWaterfall_0" .. waterlevel)
  end
end
function OnEvaluateLoadGroup_BeachTower_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel and player:InsideZone(GameObjects.AIZone_BeachTower) == true then
    return tostring("BeachTower_0" .. waterlevel)
  end
end
function OnEvaluateLoadGroup_IslandShipwreck_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel then
    if player:InsideZone(GameObjects.AIZone_IslandShipwreck) == true then
      return tostring("IslandShipwreck_0" .. waterlevel)
    end
    if player:InsideZone(GameObjects.AIZone_BeachShip) == true and 1 < waterlevel then
      return "IslandShipwreck_02"
    end
  end
end
function OnEvaluateLoadGroup_BeachShip_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel and player:InsideZone(GameObjects.AIZone_BeachShip) == true then
    return tostring("BeachShip_0" .. waterlevel)
  end
end
function OnEvaluateLoadGroup_BeachCave_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if waterlevel == 1 then
    if player:InsideZone(GameObjects.AIZone_BeachCave) == true then
      return "BeachCave_01"
    end
  elseif waterlevel == 2 and player:InsideZone(GameObjects.AIZone_BeachCave) == true then
    return "BeachCave_03"
  end
end
function OnEvaluateLoadGroup_BeachCaveLow_AI_LoadGroup()
  if player:InsideZone(GameObjects.AIZone_BeachCaveLow) == true then
    return "BeachCave_02"
  end
  if player:InsideZone(GameObjects.AIZone_IslandClimb) == true then
    local waterlevel = LD.GetCurrentWaterLevel()
    if 1 < waterlevel then
      return "BeachCave_02"
    end
  end
end
function OnEvaluateLoadGroup_IslandClimb_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel then
    if player:InsideZone(GameObjects.AIZone_IslandClimb) == true and 1 < waterlevel then
      return "IslandClimb_02"
    end
    if player:InsideZone(GameObjects.AIZone_BeachRuins) == true then
      return tostring("IslandClimb_0" .. waterlevel)
    end
  end
end
function OnEvaluateLoadGroup_BeachRuins_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel then
    if player:InsideZone(GameObjects.AIZone_BeachRuins) == true and 1 < waterlevel then
      return "BeachRuins_02"
    end
    if player:InsideZone(GameObjects.AIZone_IslandClimb) == true and 1 < waterlevel then
      return "BeachRuins_02"
    end
  end
end
function OnEvaluateLoadGroup_IslandArch_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel and player:InsideZone(GameObjects.AIZone_IslandArch) == true and 1 < waterlevel then
    return "IslandArch_02"
  end
end
function OnEvaluateLoadGroup_BeachMasonTrail_AI_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 0 < waterlevel then
    if player:InsideZone(GameObjects.AIZone_BeachMasonTrail) == true and 1 < waterlevel then
      return "BeachMasonTrail_02"
    end
    if player:InsideZone(GameObjects.AIZone_IslandClimb) == true and 1 < waterlevel then
      return "BeachMasonTrail_02"
    end
  end
end
function OnEvaluateLoadGroup_XPL475_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 1 < waterlevel then
    return "XPL475_Lights"
  else
    return "Nothing"
  end
end
function OnEvaluateLoadGroup_XPL475_Hidden_LoadGroup()
  local waterlevel = LD.GetCurrentWaterLevel()
  if 1 < waterlevel then
    return "XPL475_Lights"
  else
    return "Nothing"
  end
end
function OnEvaluateLoadGroup_RuneVaultAvailable_Hidden_LoadGroup()
  if game.Level.GetVariable("CompletedCineNumber") >= 355 then
    return "RuneVaultAvailable_Hidden"
  else
    return "Nothing"
  end
end
function BaldurDragon_POI_Requirement()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  return 470 <= cineNumber and cineNumber < 520 or 540 <= cineNumber
end
local xpl940WaterGateSoundTable = {
  SoundEmitter = nil,
  UseExplicitSoundMotion = true,
  UseInvertedEndPoints = false,
  OnStart = "SND_DOOR_Metal_Lift_Gate_Xpl940_Start_Down",
  OnReturnToStart = "SND_DOOR_Metal_Lift_Gate_Xpl940_Hit_Ceiling",
  OnForward = "SND_DOOR_Metal_Lift_Gate_Xpl940_LP",
  OnBackward = "SND_DOOR_Metal_Lift_Gate_Xpl940_LP",
  OnRewind = "SND_DOOR_Metal_Lift_Gate_Xpl940_LP",
  OnEnd = "SND_DOOR_Metal_Lift_Gate_Xpl940_Hit_Ground"
}
function SoundInit()
end
function SoundOnStart()
end
function cal200VFGateEnter()
  game.Audio.StartMusic("SND_MX_XPL985_enter_gate")
end
function PlaySnakeMouthCloseSound()
  print("PlaySnakeMouthCloseSound")
  if GameObjects.worldsnake00 ~= nil then
    local snakeEmitter = GameObjects.worldsnake00:FindSingleSoundEmitterByName("SNDMouth")
    player:CallScript("PlaySoundOnKratos", "SND_CHR_World_Serpent_Mouth_Shutting_Sequence")
    LD.StopSound(snakeEmitter, "SND_CHR_World_Serpent_Breath_Exterior_LP")
    LD.StopSound(snakeEmitter, "SND_CHR_World_Serpent_Exterior_Chortle_Oneshot_LP")
  end
end
function HideSnakeMouthZone()
  print("HideSnakeMouthZone")
  local cal050 = game.FindLevel("Cal050_Sound")
  if cal050 ~= nil then
    cal050:CallScript("HideSnakeMouthZone")
  end
end
function BestiaryUpdate()
  local helwalkerBestiaryEntry = game.Wallets.GetResourceValue("HERO", "Bestiary_Unlock_Hel_Walker")
  if 0 < helwalkerBestiaryEntry then
    game.Wallets.RemoveResource("HERO", "Bestiary_Unlock_Hel_Walker", 1)
  end
  LD.UnlockBestiaryEntry("Bestiary_Unlock_Hel_Walker_Reveal")
end
