local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  GameObjects.waterdrop_first:Hide()
  GameObjects.waterdrop_first:JumpAnimToFrame(0)
  GameObjects.waterdrop_first:PauseAnim()
  GameObjects.waterdrop_second:Hide()
  GameObjects.waterdrop_second:JumpAnimToFrame(0)
  GameObjects.waterdrop_second:PauseAnim()
end
function EnableFX()
  GameObjects.waterdrop_first:Show()
  GameObjects.waterdrop_first:JumpAnimToFrame(0)
  GameObjects.waterdrop_first:PauseAnim()
  GameObjects.waterdrop_second:Show()
  GameObjects.waterdrop_second:JumpAnimToFrame(0)
  GameObjects.waterdrop_second:PauseAnim()
end
function TriggerFX()
  GameObjects.waterdrop_first:PlayAnimToEnd()
  timers.StartLevelTimer(60, function()
    GameObjects.waterdrop_second:PlayAnimToEnd()
  end)
end
function ForceCompleteFX()
  OnFirstStart()
end
