local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local timer = require("level.timer")
local thisObj
local AnimSpeed = 0
local waterwheel, waterwheelCrank, waterwheel_vfx
local SplashVFX_Playing = false
local crankRecenter = {
  TimeStart = 0,
  TimeDuration = 2.4,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = 32,
  ReturnLeft = 23,
  ReturnRight = 20,
  TriggerRight = 17,
  PitchRange = -1,
  TriggerUp = 7,
  ReturnUp = 5,
  ReturnDown = 3,
  TriggerDown = -10
}
function OnScriptLoaded(level, obj)
  thisObj = obj
  AnimSpeed = 0
  SplashVFX_Playing = false
  waterwheel = thisObj:FindSingleGOByName("WaterWheel_900")
  waterwheel_vfx = thisObj:FindSingleGOByName("WaterSplashingWheelFx_CounterRotate")
  waterwheelCrank = thisObj:FindSingleGOByName("WaterWheel_WheelCrank")
  waterwheelCrank.LuaObjectScript.OverrideCameraInteractApproach("ENV_Crank_Approach_RightJustified")
  waterwheelCrank.LuaObjectScript.OverrideDefaultCameraRecenter(true, crankRecenter)
  waterwheelCrank.LuaObjectScript.OverrideDefaultCameraYaw(true, 139)
  waterwheelCrank.LuaObjectScript.OverrideDefaultCameraPitch(true, 4.2)
  game.SubObject.SetUpdateDisableDistance(obj, 60)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  waterwheelCrank.LuaObjectScript.Disable()
end
function OnStart(level, obj)
  waterwheel_vfx:HideParticleEmitter()
  SoundOnStart()
end
function OnUpdate(level)
  if 0 < AnimSpeed then
    AnimSpeed = AnimSpeed - 0.01
  end
  if AnimSpeed < 0 then
    AnimSpeed = AnimSpeed + 0.01
  end
  if AnimSpeed < 0.01 and -0.01 < AnimSpeed then
    AnimSpeed = 0
  end
  if AnimSpeed == 0 and SplashVFX_Playing == true then
    SplashVFX_Playing = false
    waterwheel_vfx:HideParticleEmitter()
    StopSoundWaterWheelActiveLoop()
    CleanUpWaterwheelSplashSoundMonitor()
  end
  waterwheel:PlayAnimCycle(AnimSpeed)
  waterwheel_vfx:PlayAnimCycle(AnimSpeed)
end
function OnPush_WaterWheel()
  timer.StartLevelTimer(0.1, function()
    if SplashVFX_Playing == false then
      SplashVFX_Playing = true
      waterwheel_vfx:ShowParticleEmitter()
      SetupWaterwheelSplashSoundMonitor()
    end
    if -0.25 < AnimSpeed and AnimSpeed < 0.25 then
      AnimSpeed = AnimSpeed - 0.4
    else
      AnimSpeed = AnimSpeed - 0.25
    end
    if AnimSpeed < 0.1 and -0.1 < AnimSpeed then
      AnimSpeed = AnimSpeed - 0.25
    end
    if AnimSpeed < -0.85 then
      AnimSpeed = -0.85
    end
    waterwheel:PlayAnimCycle(AnimSpeed)
    waterwheel_vfx:PlayAnimCycle(AnimSpeed)
  end)
  PlaySoundWaterWheelActiveLoop()
end
function OnPull_WaterWheel()
  timer.StartLevelTimer(0.1, function()
    if SplashVFX_Playing == false then
      SplashVFX_Playing = true
      waterwheel_vfx:ShowParticleEmitter()
      SetupWaterwheelSplashSoundMonitor()
    end
    if -0.25 < AnimSpeed and AnimSpeed < 0.25 then
      AnimSpeed = AnimSpeed + 0.4
    else
      AnimSpeed = AnimSpeed + 0.25
    end
    if AnimSpeed < 0.1 and -0.1 < AnimSpeed then
      AnimSpeed = AnimSpeed + 0.25
    end
    if 0.85 < AnimSpeed then
      AnimSpeed = 0.85
    end
    waterwheel:PlayAnimCycle(AnimSpeed)
    waterwheel_vfx:PlayAnimCycle(AnimSpeed)
  end)
  PlaySoundWaterWheelActiveLoop()
end
local isWaterWheelActive = false
local waterWheelEmitter
local waterWheelActiveLoop = "SND_MECH_Waterwheel_Rotate_Xpl900_LP"
local waterWheelSplashFrameLeadIn = 2
local waterWheelSplashMonitor
local waterWheelSplashEmitters = {}
local waterWheelSplashEvent_In = "SND_MECH_Waterwheel_Water_Splash_In_Xpl900"
local waterWheelSplashEvent_Out = "SND_MECH_Waterwheel_Water_Splash_Out_Xpl900"
function SoundOnStart()
  waterWheelEmitter = waterwheel:FindSingleGOByName("SNDGrpWWAxle").SoundEmitters[1]
  local SNDGRPWWSplashEmitters = waterwheel:FindSingleGOByName("SNDGrpWWSplashes")
  waterWheelSplashEmitters.E = SNDGRPWWSplashEmitters:FindSingleSoundEmitterByName("SNDWWSplash_Cal200_Xpl900_E")
  waterWheelSplashEmitters.W = SNDGRPWWSplashEmitters:FindSingleSoundEmitterByName("SNDWWSplash_Cal200_Xpl900_W")
  waterWheelSplashEmitters.SW = SNDGRPWWSplashEmitters:FindSingleSoundEmitterByName("SNDWWSplash_Cal200_Xpl900_SW")
  waterWheelSplashEmitters.SE = SNDGRPWWSplashEmitters:FindSingleSoundEmitterByName("SNDWWSplash_Cal200_Xpl900_SE")
  waterWheelSplashEmitters.NE = SNDGRPWWSplashEmitters:FindSingleSoundEmitterByName("SNDWWSplash_Cal200_Xpl900_NE")
  waterWheelSplashEmitters.NW = SNDGRPWWSplashEmitters:FindSingleSoundEmitterByName("SNDWWSplash_Cal200_Xpl900_NW")
end
function PlaySoundWaterWheelActiveLoop()
  if not isWaterWheelActive then
    LD.PlaySound(waterWheelEmitter, waterWheelActiveLoop, true)
    isWaterWheelActive = true
  end
end
function StopSoundWaterWheelActiveLoop()
  if isWaterWheelActive then
    LD.StopSound(waterWheelEmitter, waterWheelActiveLoop)
    isWaterWheelActive = false
    CleanUpWaterwheelSplashSoundMonitor()
  end
end
function SetupWaterwheelSplashSoundMonitor()
  if waterWheelSplashMonitor == nil then
    waterWheelSplashMonitor = monitors.CreateAnimFrameMonitor(waterwheel_vfx)
    waterWheelSplashMonitor:OnFrameBackward(315 + waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame <= 315 + waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame > 315 then
        PlayWaterWheelSplashSound_Out("SW")
      end
    end)
    waterWheelSplashMonitor:OnFrameBackward(225 + waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame <= 225 + waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame > 225 then
        PlayWaterWheelSplashSound_Out("SE")
      end
    end)
    waterWheelSplashMonitor:OnFrameBackward(180 + waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame <= 180 + waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame > 180 then
        PlayWaterWheelSplashSound_Out("E")
      end
    end)
    waterWheelSplashMonitor:OnFrameBackward(132 + waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame <= 132 + waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame > 132 then
        PlayWaterWheelSplashSound_Out("NE")
      end
    end)
    waterWheelSplashMonitor:OnFrameBackward(45 + waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame <= 45 + waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame > 45 then
        PlayWaterWheelSplashSound_Out("NW")
      end
    end)
    waterWheelSplashMonitor:OnFrameBackward(1 + waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame <= 1 + waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame > 1 then
        PlayWaterWheelSplashSound_Out("W")
      end
    end)
    waterWheelSplashMonitor:OnFrameForward(45 - waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame >= 45 - waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame < 45 then
        PlayWaterWheelSplashSound_In("NW")
      end
    end)
    waterWheelSplashMonitor:OnFrameForward(132 - waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame >= 132 - waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame < 132 then
        PlayWaterWheelSplashSound_In("NE")
      end
    end)
    waterWheelSplashMonitor:OnFrameForward(180 - waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame >= 180 - waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame < 180 then
        PlayWaterWheelSplashSound_In("E")
      end
    end)
    waterWheelSplashMonitor:OnFrameForward(225 - waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame >= 225 - waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame < 225 then
        PlayWaterWheelSplashSound_In("SE")
      end
    end)
    waterWheelSplashMonitor:OnFrameForward(315 - waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame >= 315 - waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame < 315 then
        PlayWaterWheelSplashSound_In("SW")
      end
    end)
    waterWheelSplashMonitor:OnFrameForward(360 - waterWheelSplashFrameLeadIn, function()
      if waterwheel_vfx.AnimFrame >= 360 - waterWheelSplashFrameLeadIn and waterwheel_vfx.AnimFrame < 360 then
        PlayWaterWheelSplashSound_In("W")
      end
    end)
  end
end
function CleanUpWaterwheelSplashSoundMonitor()
  if waterWheelSplashMonitor ~= nil then
    waterWheelSplashMonitor:Stop()
    waterWheelSplashMonitor:Terminate()
    waterWheelSplashMonitor = nil
  end
end
function PlayWaterWheelSplashSound_In(targetEmitterKey)
  LD.PlaySound(waterWheelSplashEmitters[targetEmitterKey], waterWheelSplashEvent_In)
end
function PlayWaterWheelSplashSound_Out(targetEmitterKey)
  LD.PlaySound(waterWheelSplashEmitters[targetEmitterKey], waterWheelSplashEvent_Out)
end
