local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local VF_Gate_Unlocked = false
local crankRecenter = {
  TimeStart = 0,
  TimeDuration = 2.4,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = 30,
  ReturnLeft = 24.5,
  ReturnRight = 23.5,
  TriggerRight = 2,
  PitchRange = -1,
  TriggerUp = 8,
  ReturnUp = -5.5,
  ReturnDown = -6.5,
  TriggerDown = -14
}
function OnScriptLoaded(level, obj)
  local rightsidedcrank = level:FindGameObject("VFGate_WheelCrank")
  if rightsidedcrank ~= nil and rightsidedcrank.LuaObjectScript ~= nil then
    rightsidedcrank.LuaObjectScript.OverrideCameraInteractApproach("ENV_Crank_Approach_RightJustified")
    rightsidedcrank.LuaObjectScript.OverrideDefaultCameraRecenter(true, crankRecenter)
    rightsidedcrank.LuaObjectScript.OverrideDefaultCameraYaw(true, 124)
    rightsidedcrank.LuaObjectScript.OverrideDefaultCameraPitch(true, -6)
  end
  local VFGateOverrides = {
    UseExplicitSoundMotion = true,
    UseInvertedEndPoints = true,
    OnStart = "SND_DOOR_Viking_Funeral_Open",
    OnReturnToStart = "SND_DOOR_Viking_Funeral_Close",
    OnForward = "SND_DOOR_Viking_Funeral_LP",
    OnBackward = "SND_DOOR_Viking_Funeral_LP",
    OnRewind = "SND_DOOR_Viking_Funeral_LP",
    OnEnd = "SND_DOOR_Viking_Funeral_Close"
  }
  rightsidedcrank.LuaObjectScript.DrivenObjectSoundSetup(VFGateOverrides)
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {VF_Gate_Unlocked = VF_Gate_Unlocked}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  VF_Gate_Unlocked = savedInfo.VF_Gate_Unlocked
end
function Enable_CAs_LakeLookOut()
  if VF_Gate_Unlocked == false then
    GameObjects.ContextAction_LakeLookOut.LuaObjectScript.Enable()
  end
end
function Disable_CAs_LakeLookOut()
  GameObjects.ContextAction_LakeLookOut.LuaObjectScript.Disable()
end
function SetVFXLevel()
  if LD.GetCurrentWaterLevel() == 1 then
    GameObjects.LDoor_WL1_On:ShowParticles()
    GameObjects.RDoor_WL1_On:ShowParticles()
    GameObjects.LDoor_WL2_On:HideParticles()
    GameObjects.RDoor_WL2_On:HideParticles()
  else
    GameObjects.LDoor_WL1_On:HideParticles()
    GameObjects.RDoor_WL1_On:HideParticles()
    GameObjects.LDoor_WL2_On:ShowParticles()
    GameObjects.RDoor_WL2_On:ShowParticles()
  end
end
function VF_Gate_Openned()
  if VF_Gate_Unlocked == false then
    VF_Gate_Unlocked = true
    game.World.StoreCheckpoint()
    game.Audio.StartMusic("SND_MX_XPL980_open_gate")
    game.Audio.PlayBanterNonCritical("ca_puzzle_success")
  end
end
function IsUnlocked()
  return VF_Gate_Unlocked
end
function PlayShakes_GateMovement(d)
  local duration = d
  game.Blender.Trigger({
    Name = "FSE_SWAY_CRANK_RUMBLE_MEDIUM",
    Duration = duration,
    TweenIn = {Time = 0.3},
    TweenOut = {Time = 0.3},
    Priority = 5000,
    Weight = 0.3
  })
  game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM",
    Duration = duration,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0},
    Priority = 5
  })
end
function StopShakes_GateMovement()
  game.Blender.Stop({
    Name = "FSE_SWAY_CRANK_RUMBLE_MEDIUM"
  })
  game.Blender.Stop({
    Name = "FFB_GENERIC_RUMBLE_MEDIUM"
  })
end
function OnForward_VFGate_WheelCrank()
  PlayShakes_GateMovement(1.3)
end
function OnBackward_VFGate_WheelCrank()
  PlayShakes_GateMovement(1.3)
end
function OnRewindEvent_VFGate_WheelCrank()
  local rewindDuration = 5
  PlayShakes_GateMovement(rewindDuration)
  timers.StartLevelTimer(rewindDuration, StopShakes_GateMovement)
end
function OnBeginningEvent_VFGate_WheelCrank()
  StopShakes_GateMovement()
end
function OnAttachedEvent_VFGate_WheelCrank()
  StopShakes_GateMovement()
end
