local LD = require("design.LevelDesignLibrary")
local WaterWheel_01_Unlocked = false
local WaterWheel_02_Unlocked = false
function OnScriptLoaded(level, obj)
  local monitors = require("level.MonitorLibrary")
  local tempMonitor = monitors.CreateAnimFrameMonitor(GameObjects.WaterWheel_01)
  tempMonitor:OnFrame(1, Enable_Lower_WaterWheel_Jump)
  tempMonitor:OnFrame(38, Disable_Lower_WaterWheel_Jump)
  tempMonitor:OnFrame(160, Enable_Lower_WaterWheel_Jump)
  tempMonitor:OnFrame(218, Disable_Lower_WaterWheel_Jump)
  tempMonitor:OnFrame(340, Enable_Lower_WaterWheel_Jump)
  tempMonitor:OnFrame(1, Disable_Upper_WaterWheel_Jump)
  tempMonitor:OnFrame(10, Enable_Upper_WaterWheel_Jump)
  tempMonitor:OnFrame(30, Disable_Upper_WaterWheel_Jump)
  tempMonitor:OnFrame(150, Enable_Upper_WaterWheel_Jump)
  tempMonitor:OnFrame(165, Disable_Upper_WaterWheel_Jump)
  SoundInit()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  GameObjects.WaterWheel_01:PauseAnim()
  GameObjects.WaterWheel_02:PauseAnim()
  GameObjects.GapJump_thruWheel1_Upper:HideTraverseLink()
end
function OnStart(level, obj)
  Disable_Upper_WaterWheel_Jump()
  SoundOnStart()
end
function StartWaterWheel_01()
  if WaterWheel_01_Unlocked == false then
    WaterWheel_01_Unlocked = true
    GameObjects.WaterWheel_01:PlayAnimCycle(0.4)
    PlaySoundsOnWaterWheel(1)
    DisableWaterWheelBanterLookAts()
  end
end
function StartWaterWheel_02()
  if WaterWheel_02_Unlocked == false then
    WaterWheel_02_Unlocked = true
    GameObjects.WaterWheel_02:PlayAnimCycle(0.5)
    PlaySoundsOnWaterWheel(2)
    DisableWaterWheelBanterLookAts()
  end
end
function Enable_Lower_WaterWheel_Jump()
  GameObjects.GapJump_thruWheel1_Lower:ShowTraverseLink()
  GameObjects.CA_WaitForWheel_A.LuaObjectScript.Disable()
  GameObjects.CA_WaitForWheel_B.LuaObjectScript.Disable()
  GameObjects.EntryZone_003:ShowEntityVolume()
end
function Disable_Lower_WaterWheel_Jump()
  GameObjects.GapJump_thruWheel1_Lower:HideTraverseLink()
  GameObjects.CA_WaitForWheel_A.LuaObjectScript.Enable()
  GameObjects.CA_WaitForWheel_B.LuaObjectScript.Enable()
  GameObjects.EntryZone_003:HideEntityVolume()
end
function Enable_Upper_WaterWheel_Jump()
  GameObjects.GapJump_thruWheel1_Upper:ShowTraverseLink()
end
function Disable_Upper_WaterWheel_Jump()
  GameObjects.GapJump_thruWheel1_Upper:HideTraverseLink()
end
local waterWheelSoundEvents = {
  AxleLoop = "SND_MECH_Waterwheel_Lrg_Rotate_Axle_LP",
  RingLoop = "SND_MECH_Waterwheel_Lrg_Rotate_Ring_LP",
  WaterRunoffLoop = "SND_MECH_Waterwheel_Lrg_WTR_Runoff_LP",
  WaterSurfaceLoop = "SND_MECH_Waterwheel_Lrg_Rotate_Water_LP"
}
local waterWheelEmitters_01 = {
  AxelEmitter = nil,
  RingEmitters = {},
  WaterRunoffEmitters = {},
  WaterSurfaceEmitters = {}
}
local waterWheelEmitters_02 = {
  AxelEmitter = nil,
  RingEmitters = {},
  WaterRunoffEmitters = {},
  WaterSurfaceEmitters = {}
}
function SoundInit()
  SoundInitWaterWheelEmitters(waterWheelEmitters_01, GameObjects.WaterWheel_01)
  SoundInitWaterWheelEmitters(waterWheelEmitters_02, GameObjects.WaterWheel_02)
end
function SoundOnStart()
  local tempWaterWheelGO_01 = GameObjects.WaterWheel_01
  local tempWaterWheelGO_02 = GameObjects.WaterWheel_02
  if tempWaterWheelGO_01.AnimFrame > 1 then
    PlaySoundsOnWaterWheel(1)
  else
    LD.CallFunctionAfterDelay(function()
      if tempWaterWheelGO_01.AnimFrame > 1 then
        PlaySoundsOnWaterWheel(1)
      end
    end, 1)
  end
  if tempWaterWheelGO_02.AnimFrame > 1 then
    PlaySoundsOnWaterWheel(2)
  else
    LD.CallFunctionAfterDelay(function()
      if tempWaterWheelGO_02.AnimFrame > 1 then
        PlaySoundsOnWaterWheel(2)
      end
    end, 1)
  end
end
function SoundInitWaterWheelEmitters(waterWheelEmitterTable, waterWheelGO)
  waterWheelEmitterTable.AxelEmitter = waterWheelGO:FindSingleSoundEmitterByName("SNDWWAxel_Cal200_Xpl980")
  waterWheelEmitterTable.RingEmitters = waterWheelGO:FindSingleGOByName("SNDGrpWWCreaks").SoundEmitters
  waterWheelEmitterTable.WaterRunoffEmitters = waterWheelGO:FindSingleGOByName("SNDGrpWWRunOff").SoundEmitters
  waterWheelEmitterTable.WaterSurfaceEmitters = waterWheelGO:FindSingleGOByName("SNDGrpWWSurface").SoundEmitters
end
function PlaySoundsOnWaterWheel(waterWheelID)
  local targetWaterWheelEmitterTable
  if waterWheelID == 1 then
    targetWaterWheelEmitterTable = waterWheelEmitters_01
  elseif waterWheelID == 2 then
    targetWaterWheelEmitterTable = waterWheelEmitters_02
  end
  LD.PlayRestartableSoundLoop(targetWaterWheelEmitterTable.AxelEmitter, waterWheelSoundEvents.AxleLoop)
  for i = 1, #targetWaterWheelEmitterTable.RingEmitters do
    LD.PlayRestartableSoundLoop(targetWaterWheelEmitterTable.RingEmitters[i], waterWheelSoundEvents.RingLoop)
  end
  for i = 1, #targetWaterWheelEmitterTable.WaterRunoffEmitters do
    LD.PlayRestartableSoundLoop(targetWaterWheelEmitterTable.WaterRunoffEmitters[i], waterWheelSoundEvents.WaterRunoffLoop)
  end
  for i = 1, #targetWaterWheelEmitterTable.WaterSurfaceEmitters do
    LD.PlayRestartableSoundLoop(targetWaterWheelEmitterTable.WaterSurfaceEmitters[i], waterWheelSoundEvents.WaterSurfaceLoop)
  end
end
function DisableWaterWheelBanterLookAts()
  GameObjects.BanterLookAt_WaterWheel.LuaObjectScript.Disable()
  GameObjects.BanterLookAt_WaterWheel2.LuaObjectScript.Disable()
end
