local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local timers = require("level.timer")
local EC = require("design.Encounter")
local thisLevel, Area_0_Encounter_1, Area_0_Encounter_3
function OnScriptLoaded(level, obj)
  thisLevel = level
  if game.Level.GetVariable("CompletedCineNumber") <= 429 then
    Area_0_Fight_3()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 430 then
    Area_0_Fight_1()
  end
end
function OnStart(level)
  if game.Level.GetVariable("CompletedCineNumber") <= 429 then
    GameObjects.StoneTrollStatue_Broken:Hide()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 430 then
    GameObjects.StoneTrollStatue_Complete:Hide()
    GameObjects.StoneTrollStatue_Broken:Show()
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 430 and Area_0_Encounter_1:WasRunning() then
    Area_0_Encounter_1:Start()
  end
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function TurnOffSpawnZones()
  GameObjects.EntZn_Arena_Spawn_0:HideEntityVolume()
end
function Area_0_Fight_1()
  Area_0_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Troll Spawn Beach Boat", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneTroll",
    LoadCheck = false,
    LodLow = 160,
    LodHigh = 190
  })
  Area_0_Encounter_1:AddWave({
    {
      spawners = "STONE_PATROL",
      markerID = "StoneTroll2",
      spawnLocators = "A0_O_Loc_01",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl990_AI_02",
      spawnCooldown = 0
    }
  })
  Area_0_Encounter_1:OnEnemySpawn(audioTrollVariation, {
    markerID = "StoneTroll2"
  })
  Area_0_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Arena_Spawn_0"), {
    cineRequirement = {439, 990}
  })
  Area_0_Encounter_1:SetAlertZone(GameObjects.EntZn_Arena_Alert_Troll)
  Area_0_Encounter_1:OnComplete(TurnOffSpawnZones)
  Area_0_Encounter_1:OnStart(function()
    LD.SetMarkerState("CAL_100_StnBeachFight", 1)
  end)
  Area_0_Encounter_1:OnComplete(function()
    LD.SetMarkerState("CAL_100_StnBeachFight", 0)
  end)
  Area_0_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Troll_Death_Eater")
  end)
  Area_0_Encounter_1:OnCombatStart(function()
    LD.StartCombatMusic("SND_MX_XPL600_troll_fight_in", "SND_MX_XPL600_troll_fight_out")
  end)
  Area_0_Encounter_1:OnEnemyDeath(xpl600TrollDeathMusic, {
    markerID = "StoneTroll2"
  })
end
function Area_0_Fight_3()
  Area_0_Encounter_3 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Flyers Spawn Beach", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneTroll",
    LoadCheck = false
  })
  Area_0_Encounter_3:AddWave({
    {
      spawners = "Flyer_PATROL_1",
      spawnLocators = "A0_O_Loc_02",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl990_AI_02",
      spawnCooldown = 3
    },
    {
      spawners = "Flyer_PATROL_2",
      spawnLocators = "A0_O_Loc_03",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl990_AI_02",
      spawnCooldown = 0
    },
    {
      spawners = "Flyer_S",
      spawnLocators = "A0_O_Loc_04",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl990_AI_02",
      spawnCooldown = 0.2
    }
  })
  Area_0_Encounter_3:AddWave({
    {
      spawners = "Flyer_AWARE",
      spawnLocators = "A0_O_Loc_05",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl990_AI_02",
      spawnCooldown = 2
    }
  })
  Area_0_Encounter_3:AddWave({
    requireCompletionOfAllPriorWaves = true,
    {
      spawners = "Flyer_AWARE",
      spawnLocators = "A0_O_Loc_06",
      useSpawnLocatorsOnly = true,
      spawnWad = "Xpl990_AI_02",
      spawnCooldown = 2
    }
  })
  Area_0_Encounter_3:SetStartZone(thisLevel:GetGameObject("EntZn_Arena_Spawn_2"), {
    cineRequirement = {0, 438}
  })
  Area_0_Encounter_3:OnEnemyDeath(function()
    Area_0_Encounter_3:StartWave(2)
  end, {count = 1})
  Area_0_Encounter_3:OnEnemyDeath(function()
    Area_0_Encounter_3:StartWave(3)
  end, {count = 2})
  Area_0_Encounter_3:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Base")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Fire")
  end)
end
function DisableZone_EntZn_Arena_Spawn_2()
  GameObjects.EntZn_Arena_Spawn_2:HideEntityVolume()
end
function EnableZone_EntZn_Arena_Spawn_2()
  GameObjects.EntZn_Arena_Spawn_2:ShowEntityVolume()
end
function audioTrollVariation(Enemy)
  game.Audio.SetWwiseSwitch(Enemy, "CHR_Variation", "CHR_Variation_07")
end
local xpl600TrollDead = false
function xpl600TrollDeathMusic()
  if xpl600TrollDead == false then
    LD.StopCombatMusic()
    xpl600TrollDead = true
  end
end
