local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, elevatorObj, kraActor, sonActor
local synchJointStr = "SnakeStatue_SynchJoint"
local mSStartJointStr = "MS_StartJoint"
local snakeStatueZoneStr = "CineZone_HornLoc"
local snakeStatueBranchStr = "BRA_SnakeStatue"
local cineEnterSnakeStatue
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  cineEnterSnakeStatue = CCEC.CineEnterCamera.New("ENV_CineEnter_narCalSnakeStatue000CineScene", 6, nil)
  cineEnterSnakeStatue:SetCallback(DestroyCineEnterSnakeStatue)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 520 then
    SetupActors()
  end
end
function OnUpdate(level, obj)
  if cineEnterSnakeStatue ~= nil then
    cineEnterSnakeStatue:Update()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("SNAKE STATUE: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SNAKE STATUE: Son Actor", game.AI.FindSon)
end
function SetupCineSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Snake Statue Sequence")
  local slaveTab = {
    {Actor = sonActor}
  }
  cineSeq:Do(function()
    game.SubObject.Wake(thisObj)
  end)
  cineSeq:Do(function()
    cineEnterSnakeStatue:Start()
  end)
  print("---------Snake Statue Fired")
  cineSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
  cineSeq:MarkAbleToSkip()
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = snakeStatueBranchStr,
    ReferenceJoint = synchJointStr,
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.StopTurnRadius,
    should_strafe = true,
    weapon_state = "bare"
  })
  cineSeq:ActorSync(kraActor, {
    Slaves = slaveTab,
    Branch = snakeStatueBranchStr,
    ReferenceJoint = synchJointStr
  })
  cineSeq:Do(AnimateSnake)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:Do(HideBoatInSnakesMouth)
  cineSeq:SetCompletedCineNumber(520)
  cineSeq:Do(EndSnakeObjective)
  cineSeq:Do(function()
    local cal100 = game.FindLevel("Cal100_Hub")
    cal100:GetGameObject("Btr_Caldera_Bridge"):CallScript("Enable_Btr_SnakeOffCrit")
  end)
  cineSeq:StartSequence()
end
function CanSeqFire()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return cineNum < 520 and 515 <= cineNum and game.Level.GetVariable("CAL_NAR_EyesOnThePrize")
end
function IsElevatorFinished()
  if game.FindLevel("Cal100_Hub") ~= nil and elevatorObj == nil then
    elevatorObj = game.FindLevel("Cal100_Hub"):GetGameObject("HornElevator")
  end
  if elevatorObj ~= nil and elevatorObj.AnimFrame == elevatorObj.AnimLengthFrames then
    return true
  end
  return false
end
function AnimateSnake()
  local jointFace = thisObj:GetWorldJointForward(thisObj:GetJointIndex(mSStartJointStr))
  local jointPos = thisObj:GetWorldJointPosition(thisObj:GetJointIndex(mSStartJointStr))
  if game.FindLevel("Cal200_Shore") ~= nil then
    game.FindLevel("Cal200_Shore"):GetGameObject("SnakeIdle"):CallScript("PlaySnakeCine", jointPos, jointFace, "snakeStatue", "snakeBelly")
  end
end
function EndSnakeObjective()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective830", "Complete")
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Bridge1", false)
  game.Compass.SetGatewayMarkerIsOpen("CALS_200_Helper34", false)
end
function HideBoatInSnakesMouth()
  local cal200 = game.FindLevel("Cal200_Shore")
  if cal200 ~= nil then
    cal200:CallScript("HideArtForSnakeBelly")
  end
end
function DestroyCineEnterSnakeStatue()
  cineEnterSnakeStatue = nil
  game.SubObject.Sleep(thisObj)
end
