local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local water0, water1, water2, waterLevel, son, player
local needBoat = false
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  water0 = GameObjects.waterlevel_1
  water1 = GameObjects.waterlevel_2
  water2 = GameObjects.waterlevel_3
  waterLevel = LD.GetCurrentWaterLevel()
end
function OnFirstStart(level)
  water0:Show()
  water1:Hide()
  water2:Hide()
  GameObjects.EntZn_ClearBoatSpeed_DemiGod:HideEntityVolume()
end
function OnStart(level)
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = LowerWater_Level01,
    fn = LowerWater_Level01
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = LowerWater_Level02,
    fn = LowerWater_Level02
  })
  if game.Level.GetVariable("CompletedCineNumber") == 368 then
    print("MIKE G - Time to add custom docking markers...")
    local creatures = {
      game.Player.FindPlayer(),
      game.AI.FindSon()
    }
    for _, creature in pairs(creatures) do
      if creature then
        print("MIKE G - FOUND CREATURE: " .. creature:GetName())
        if not creature:HasMarker("pendingDockCinematic") then
          print("MIKE G - adding 'pendingDockCinematic' marker to " .. creature:GetName())
          creature:AddMarker("pendingDockCinematic")
        end
        if not creature:HasMarker("SonSick") then
          print("MIKE G - adding 'SonSick' marker to " .. creature:GetName())
          creature:AddMarker("SonSick")
        end
      end
    end
    needBoat = true
  end
end
function LowerWater_Level01()
  waterLevel = 1
  water0:Hide()
  water1:Show()
  water2:Hide()
  GameObjects.UpperLevelCalSide:HideEntityVolume()
  GameObjects.UpperLevelRivSideVols:HideEntityVolume()
  GameObjects.Riv925_AI_Visit01_LoadCheck:HideEntityVolume()
end
function LowerWater_Level02()
  waterLevel = 2
  water0:Hide()
  water1:Hide()
  water2:Show()
  GameObjects.UpperLevelCalSide:HideEntityVolume()
  GameObjects.UpperLevelRivSideVols:HideEntityVolume()
  GameObjects.Riv925_AI_Visit01_LoadCheck:HideEntityVolume()
end
function OnUpdate(level)
  if waterLevel == 0 and game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_MountainVista") then
    game.Camera.SubmitCameraByName("PLYR_Boat_Forward_MountainVista")
  end
  if needBoat == true then
    print("MIKE G - looking for boat...")
    local boat = game.Boat.GetPlayerBoat()
    if boat then
      if not boat:HasMarker("pendingDockCinematic") then
        print("MIKE G - adding 'pendingDockCinematic' marker to " .. boat:GetName())
        boat:AddMarker("pendingDockCinematic")
      end
      if not boat:HasMarker("SonSick") then
        print("MIKE G - adding 'SonSick' marker to " .. boat:GetName())
        boat:AddMarker("SonSick")
      end
      needBoat = false
    end
  end
end
function OnEvaluateLoadGroup_Cinematic()
  if game.Level.GetVariable("CompletedCineNumber") >= 360 and game.Level.GetVariable("CompletedCineNumber") < 371 then
    return "FreyaTendsSon"
  end
end
function ToRiverpassBanterFireCallback()
  if game.Level.GetVariable("CompletedCineNumber") == 400 then
    LD.EnableBoatLore()
  end
end
function SetBoatContext_Left()
  son:CallScript("EnterBehaviorContext", "BOAT_CONTEXT_CONFIG_LEFT")
end
function BoatContext_SwitchToRight()
  son:CallScript("TransitionBehaviorContext", true)
end
function MountainAware_Start()
  GameObjects.AwareZone_Mountain.LuaObjectScript.EnableAwarenessRemotely()
end
function MountainAware_Stop()
  GameObjects.AwareZone_Mountain.LuaObjectScript.DisableAwarenessRemotely()
end
function ShowBoatTutorialMsg()
end
function Cal200LoadCheck()
  game.UI.LoadCheck("Cal200_Shore", "cal090_WaterLevelZero")
end
function Riv925AI_Visit01_LoadCheck()
  game.UI.LoadCheck("Riv925_AI_Visit01")
end
function Tutorial_TwoWayTravel()
  if game.Level.GetVariable("CompletedCineNumber") == 400 then
    TUT.RealmTravel_TwoWayTutorial()
    GameObjects.EntZN_Tut2WatQuickTravel:HideEntityVolume()
  end
end
function CanMimirSonBondingPlay()
  return game.Level.GetVariable("CompletedCineNumber") == 330 and game.Audio.CanBanterConversationPlay("IsStoryTimeNotAllowed")
end
function LoreAllowed()
  LD.SetEntityVariable("NAR_RoadLoreAllowed", true)
  LD.EnableBoatLore()
end
function EnableBoatSpeedClearZone()
  GameObjects.EntZn_ClearBoatSpeed_DemiGod:ShowEntityVolume()
end
function ClearBoatSpeed()
  game.Boat.ClearGlobalSpeedControlData()
end
