local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local checkpoint = require("level.checkpoint")
local uiCalls = require("ui.uicalls")
local son
local TutorialBanterPlayed = false
local LightCrystalRevealed = false
local LoadZones_CS185, LoadZones_CS190, LoadZones_CS250, LoadZones_CS450, BridgeCrystal
local riftFight250Complete = false
local LitCrystalCount = 0
local PoisonSolved = false
local PoisonTutorialTimer
local NifRuneRead = false
local MusRuneRead = false
function OnScriptLoaded(level, obj)
  son = game.AI.FindSon()
  BridgeCrystal = GameObjects.LightCrystal_forBridge
  LoadZones_CS185 = GameObjects.______Load_CS185
  LoadZones_CS190 = GameObjects.______Load_CS190
  LoadZones_CS250 = GameObjects.______Load_CS250
  LoadZones_CS450 = GameObjects.______Load_CS450
end
function OnPreStart(level)
  GameObjects.chest_dispell_tier1_cal250_1.LuaObjectScript.DisableCheckpointRequirement()
end
function OnFirstStart(level)
  InitialSetup()
end
function OnStart(level)
  GameObjects.SonInkObserve.LuaObjectScript.Disable()
  if game.Wallets.GetResourceValue("HERO", "MuspelheimCipherPiece") == 4 and MusRuneRead == false then
    GameObjects.CA_RuneReadPrevew_Muspelheim_Zone:ShowEntityVolume()
  end
  if game.Wallets.GetResourceValue("HERO", "NiflheimCipherPiece") == 4 and NifRuneRead == false then
    GameObjects.CA_RuneReadPrevew_Niflheim_Zone:ShowEntityVolume()
  end
  LD.RegisterForCineUpdate(level, {
    {
      at = 190,
      immediateFn = FreyaLeadTheWay_Setup,
      fn = FreyaLeadTheWay_Setup
    },
    {
      at = 242,
      immediateFn = AlfhieimLightAquired_Setup,
      fn = AlfhieimLightAquired_Setup
    },
    {
      at = 430,
      immediateFn = ReturnWithStone_Setup,
      fn = ReturnWithStone_Setup
    }
  })
  GameObjects.CA_Climb_01_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_01_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_Climb_02_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_02_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_LowerSafeSpot_01.LuaObjectScript.Disable()
  GameObjects.CA_LowerSafeSpot_02.LuaObjectScript.Disable()
  GameObjects.CA_LowerSafeSpot_RunOut.LuaObjectScript.Disable()
  if game.Level.GetVariable("CompletedCineNumber") > 189 then
    GameObjects.CA_TotemSaveSpot_01.LuaObjectScript.Disable()
    GameObjects.CA_TotemSaveSpot_02.LuaObjectScript.Disable()
    GameObjects.PoisonTotem_01.LuaObjectScript.CustomDisable_Cal250()
    GameObjects.PoisonTotem_02.LuaObjectScript.CustomDisable_Cal250()
    GameObjects.PoisonTotem_03.LuaObjectScript.CustomDisable_Cal250()
  end
  if game.Level.GetVariable("CompletedCineNumber") > 241 then
    if LightCrystalRevealed == false then
      GameObjects.LightCrystal_Carry.Child.LuaObjectScript.SafeShow()
      LightCrystalRevealed = true
    end
  else
    GameObjects.LightCrystal_Carry.Child.LuaObjectScript.SafeHide()
  end
  if 242 <= game.Level.GetVariable("CompletedCineNumber") then
    Enable_Checkpoints()
  end
  if PoisonSolved == false then
    GameObjects.PoisonTotem_TutorialZone:HideEntityVolume()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PoisonTotem_TutorialZone:ShowEntityVolume()
    end, 0.05)
  end
  if GameObjects.hanging_common_tier1_cal250_1:FindSingleGOByName("s_hook_breakable").LuaObjectScript.IsEnabled() == false then
    GameObjects.hanging_common_tier1_cal250_1:Hide()
  end
  SoundOnStart()
end
function InitialSetup()
  Disable_Checkpoints()
  PoisonTotem_DeathHint_DisableZone()
  GameObjects.CA_RuneReadPrevew_Muspelheim_Zone:HideEntityVolume()
  GameObjects.CA_RuneReadPrevew_Niflheim_Zone:HideEntityVolume()
  LoadZones_CS190:HideEntityVolume()
  LoadZones_CS250:HideEntityVolume()
  LoadZones_CS450:HideEntityVolume()
  GameObjects.VineCover_01:Hide()
  GameObjects.VineCover_02:Hide()
  GameObjects.VineCover_03:Hide()
  GameObjects.CA_TotemSaveSpot_01.LuaObjectScript.Enable()
  GameObjects.CA_TotemSaveSpot_02.LuaObjectScript.Enable()
  GameObjects.EntryZone_001:ShowEntityVolume()
end
function FreyaLeadTheWay_Setup()
  LoadZones_CS185:HideEntityVolume()
  LoadZones_CS190:ShowEntityVolume()
  Disable_Checkpoints()
  PoisonTotem_DeathHint_DisableZone()
  GameObjects.Behavior_NearPoison_01:HideEntityVolume()
  GameObjects.Behavior_NearPoison_02:HideEntityVolume()
  GameObjects.Behavior_NearPoison_03:HideEntityVolume()
  GameObjects.PoisonTotem_01.LuaObjectScript.Disable()
  GameObjects.PoisonTotem_02.LuaObjectScript.Disable()
  GameObjects.PoisonTotem_03.LuaObjectScript.Disable()
  GameObjects.VineCover_01:Show()
  GameObjects.VineCover_02:Show()
  GameObjects.VineCover_03:Show()
  GameObjects.CA_LowerSafeSpot_01_EntryZone:HideEntityVolume()
  GameObjects.PoisonRunOutZone:HideEntityVolume()
  PoisonSolved = true
  GameObjects.CA_TotemSaveSpot_01.LuaObjectScript.Disable()
  GameObjects.CA_TotemSaveSpot_02.LuaObjectScript.Disable()
  GameObjects.EntryZone_001:HideEntityVolume()
  GameObjects.hanging_common_tier1_cal250_1:Hide()
end
function DisableCrackClimbSyncExitCA()
  GameObjects.CA_Climb_01_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_01_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_Climb_02_Exit.LuaObjectScript.Disable()
  GameObjects.CA_Climb_02_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_LowerSafeSpot_01.LuaObjectScript.Disable()
  GameObjects.CA_LowerSafeSpot_02.LuaObjectScript.Disable()
  GameObjects.CA_LowerSafeSpot_RunOut.LuaObjectScript.Disable()
  GameObjects.CA_LookOutPoint.LuaObjectScript.Disable()
  GameObjects.CA_LookDown_Point.LuaObjectScript.Disable()
end
function AlfhieimLightAquired_Setup()
  LoadZones_CS190:HideEntityVolume()
  LoadZones_CS250:ShowEntityVolume()
  Enable_Checkpoints()
  PoisonSolved = true
  GameObjects.EntryZone_001:ShowEntityVolume()
  BridgeCrystal.LuaObjectScript.SetCrystalObjectStates(0)
  BridgeCrystal:Hide()
  BridgeCrystal:HideCollision()
  timer.StartLevelTimer(1, function()
    BifrostBridge_Deactivate()
  end)
  if GameObjects.hanging_common_tier1_cal250_1:FindSingleGOByName("s_hook_breakable").LuaObjectScript.IsEnabled() == true then
    GameObjects.hanging_common_tier1_cal250_1:Show()
  end
end
function ReturnWithStone_Setup()
  LoadZones_CS250:HideEntityVolume()
  LoadZones_CS450:ShowEntityVolume()
end
function RiverPass_Obj955()
  LD.CompleteQuest("Quest_RiverPass_Objective955")
end
function Foot100_LoadCheck()
  if game.Level.GetVariable("CompletedCineNumber") ~= 190 then
    game.UI.LoadCheck("Foot100_Base", "Foot500_Top", "Foot200_Mid")
  end
end
function Cal100_LoadCheck()
  game.UI.LoadCheck("Cal100_Hub")
end
function Cal200_LoadCheck()
  game.UI.LoadCheck("Cal200_Shore")
end
function Enable_Checkpoints()
  GameObjects.___Checkpoint_FromCal:ShowEntityVolume()
  GameObjects.___Checkpoint_ToHall:ShowEntityVolume()
  GameObjects.___Checkpoint_FromFoot:ShowEntityVolume()
end
function Disable_Checkpoints()
  GameObjects.___Checkpoint_FromCal:HideEntityVolume()
  GameObjects.___Checkpoint_ToHall:HideEntityVolume()
  GameObjects.___Checkpoint_FromFoot:HideEntityVolume()
end
function Disable_FightCheckpoints()
  GameObjects.___Checkpoint_FromCal:HideEntityVolume()
  GameObjects.___Checkpoint_ToHall:HideEntityVolume()
end
local FreyaLTW
function GetFreyaLTW()
  if FreyaLTW == nil then
    FreyaLTW = game.FindLevel("FreyaLTW")
  end
  return FreyaLTW
end
function OnTriptychStart()
  if GetFreyaLTW() then
    FreyaLTW:CallScript("Cal250Triptych_TurnOffSonLTW")
  end
end
function OnTriptychAbort()
  if GetFreyaLTW() then
    FreyaLTW:CallScript("Cal250Triptych_TurnOnSonLTW")
  end
end
function OnTriptychComplete()
  if GetFreyaLTW() then
    FreyaLTW:CallScript("Cal250Triptych_TurnOnSonLTW")
  end
end
function Enable_PoisonTotem_TutorialText()
  if PoisonSolved == false then
    local TUT = require("game.GlobalTutorials")
    TUT.Cal250_ScornPoleTutorial()
  end
end
function PoisonTotem_Tutorial_EnterZone()
  if PoisonSolved == false then
    PoisonTutorialTimer = timer.StartLevelTimer(5, function()
      Enable_PoisonTotem_TutorialText()
    end)
  end
end
function PoisonTotem_Tutorial_ExitZone()
  if PoisonTutorialTimer ~= nil then
    PoisonTutorialTimer:Stop()
  end
  local uiCalls = require("ui.uicalls")
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function PoisonTotem_Queue_DeathHint()
  uiCalls.UI_Event_Queue_Death_Tip(20391)
end
function PoisonTotem_Unqueue_DeathHint()
  uiCalls.UI_Event_Unqueue_Death_Tip(20391)
end
function PoisonTotem_DeathHint_EnableZone()
  GameObjects.PoisonTotem_QueueDeathHint:ShowEntityVolume()
  GameObjects.PoisonTotem_UnqueueDeathHint:ShowEntityVolume()
end
function PoisonTotem_DeathHint_DisableZone()
  GameObjects.PoisonTotem_QueueDeathHint:HideEntityVolume()
  GameObjects.PoisonTotem_UnqueueDeathHint:HideEntityVolume()
end
function PoisonTotem_Tutorial_Solve()
  if PoisonSolved == false then
    PoisonSolved = true
    GameObjects.PoisonTotem_TutorialZone:HideEntityVolume()
    if PoisonTutorialTimer ~= nil then
      PoisonTutorialTimer = nil
    end
  end
end
function Play_Tutorial_Banter()
  if PoisonSolved == false and TutorialBanterPlayed == false then
    TutorialBanterPlayed = true
    game.Audio.PlayBanter("090_ScornPoleIntro")
  end
end
function PoisonTotem_01_Embed()
  PoisonTotem_Tutorial_Solve()
  GameObjects.CA_TotemSaveSpot_01.LuaObjectScript.Disable()
  GameObjects.Behavior_NearPoison_01:HideEntityVolume()
end
function PoisonTotem_01_Unembed()
  GameObjects.CA_TotemSaveSpot_01.LuaObjectScript.Enable()
  GameObjects.Behavior_NearPoison_01:ShowEntityVolume()
end
function PoisonTotem_02_Embed()
  PoisonTotem_Tutorial_Solve()
  GameObjects.CA_TotemSaveSpot_02.LuaObjectScript.Disable()
  GameObjects.Behavior_NearPoison_02:HideEntityVolume()
end
function PoisonTotem_02_Unembed()
  GameObjects.CA_TotemSaveSpot_02.LuaObjectScript.Enable()
  GameObjects.Behavior_NearPoison_02:ShowEntityVolume()
end
function PoisonTotem_03_Embed()
  PoisonTotem_Tutorial_Solve()
  GameObjects.Behavior_NearPoison_03:HideEntityVolume()
  GameObjects.CA_LowerSafeSpot_01_EntryZone:HideEntityVolume()
  GameObjects.PoisonRunOutZone:HideEntityVolume()
end
function PoisonTotem_03_Unembed()
  GameObjects.Behavior_NearPoison_03:ShowEntityVolume()
  GameObjects.CA_Climb_01_Entrance.LuaObjectScript.Disable()
  GameObjects.CA_LowerSafeSpot_02.LuaObjectScript.Disable()
  GameObjects.CA_LowerSafeSpot_01_EntryZone:ShowEntityVolume()
  GameObjects.PoisonRunOutZone:ShowEntityVolume()
end
function CA_HangingBreakable()
  if game.Level.GetVariable("CompletedCineNumber") ~= 190 then
    GameObjects.CA_LookDown_Point.LuaObjectScript.Enable()
  end
end
function CA_RunePreview_Disable()
  GameObjects.CA_RuneReadPrevew_Niflheim.LuaObjectScript.Disable()
  GameObjects.CA_RuneReadPrevew_Muspelheim.LuaObjectScript.Disable()
end
function CA_RunePreview_MusZone_Disable()
  GameObjects.RuneReadPrevew_Muspelheim_EntryZone:HideEntityVolume()
end
function CA_RunePreview_NifZone_Disable()
  GameObjects.CA_RuneReadPrevew_Niflheim_Zone:HideEntityVolume()
end
function MusRuneRead_Complete()
  MusRuneRead = true
end
function NifRuneRead_Complete()
  NifRuneRead = true
end
function Set250FightVarComplete()
  riftFight250Complete = true
end
function SpawnPocketRift()
  LitCrystalCount = LitCrystalCount + 1
  if LitCrystalCount == 2 and riftFight250Complete == false then
    GameObjects.LootPocketRiftCal250.LuaObjectScript.Enable()
    LD.SetMarkerState("CAL_100_FootTowerFight", 1)
  else
    LD.SetMarkerState("CAL_100_FootTowerFight", 0)
  end
end
function BifrostBridge_Activate()
  GameObjects.BifrostBridge.LuaObjectScript.TurnTemporalObjectOn()
  game.Compass.SetGatewayMarkerIsOpen("CALS_250_Helper_07", true)
end
function BifrostBridge_Deactivate()
  GameObjects.BifrostBridge.LuaObjectScript.Disable()
  game.Compass.SetGatewayMarkerIsOpen("CALS_250_Helper_07", false)
end
function EnterBehaviorContext_WAIT_AND_EXPLORE()
  son:CallScript("EnterBehaviorContext", "NORMAL_LOOKAROUND_BEHAVIOR_CONTEXT_CONFIG")
end
function EnterBehaviorContext_NEARPOISON()
  son:CallScript("EnterBehaviorContext", "SICK_BEHAVIOR_CONTEXT_CONFIG")
end
function ClearBehaviorContext()
  son:CallScript("ClearBehaviorContext")
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    PoisonSolved = PoisonSolved,
    MusRuneRead = MusRuneRead,
    NifRuneRead = NifRuneRead,
    riftFight250Complete = riftFight250Complete,
    TutorialBanterPlayed = TutorialBanterPlayed,
    LightCrystalRevealed = LightCrystalRevealed
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  PoisonSolved = savedInfo.PoisonSolved
  MusRuneRead = savedInfo.MusRuneRead
  NifRuneRead = savedInfo.NifRuneRead
  local riftsRegionComplete = game.QuestManager.GetQuestState("RegionSummary_CALS_PocketRift_Parent") == "Complete"
  riftFight250Complete = savedInfo.riftFight250Complete or riftsRegionComplete
  TutorialBanterPlayed = savedInfo.TutorialBanterPlayed
  LightCrystalRevealed = savedInfo.LightCrystalRevealed
end
function SoundOnStart()
  GameObjects.invisibleinktotem_01:FindSingleGOByName("pSonReadRune").LuaObjectScript.LoreMarkerRuneReadSoundSetup()
  GameObjects.LoreMarker_02_ReadPoint:FindSingleGOByName("pSonReadRune").LuaObjectScript.WallRuneReadSoundSetup()
  GameObjects.LoreMarker_01_ReadPoint:FindSingleGOByName("pSonReadRune").LuaObjectScript.WallRuneReadSoundSetup()
  if game.Level.GetVariable("CompletedCineNumber") >= 190 then
    GameObjects.PoisonTotem_01.LuaObjectScript.StopSoundPoisonDisable_Remote()
    GameObjects.PoisonTotem_02.LuaObjectScript.StopSoundPoisonDisable_Remote()
    GameObjects.PoisonTotem_03.LuaObjectScript.StopSoundPoisonDisable_Remote()
  end
end
function cal250ExitMusic()
  if game.Level.GetVariable("CompletedCineNumber") >= 182 and game.Level.GetVariable("CompletedCineNumber") < 185 then
    game.Audio.StartMusic("SND_MX_CAL250_foothills_LH_explore_out")
  end
end
