local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, sonActor, freyaActor, arrowProp
local boolFootMagicBowstringCompleted = false
local playedApproachBanter = false
local freyaAIObject, kratosActor, player, freyaObj, bFreyaStillHasArrowInHerHands, bSubmitArrowReleasedCamera
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  bSubmitArrowReleasedCamera = false
  bFreyaStillHasArrowInHerHands = false
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if not boolFootMagicBowstringCompleted and game.Level.GetVariable("CompletedCineNumber") == 190 then
    CreateActors()
  end
  SetupProps()
  GameObjects.POIZone_SlowWalkKratos:Hide()
  GameObjects.POIZone_CustomCamera:Hide()
end
function OnUpdate(level, obj)
  if bSubmitArrowReleasedCamera == true then
    game.Camera.SubmitCameraByName("PLYR_NAR_LookAtFreyasFirstArrow_020")
  end
  if bFreyaStillHasArrowInHerHands == true then
    if freyaObj == nil then
      freyaObj = ND.FindFreya()
    end
    if player:IsInsideEntityZone("POIZone_CustomCamera") and freyaObj ~= nil then
      game.Camera.SubmitCameraByName("PLYR_NAR_LookAtFreyasFirstArrow_000")
      if freyaObj:IsPlayingMove("MOV_FootMagicBowstringScene") and freyaObj:GetActiveMovePercent() > 0.14 then
        game.Camera.SubmitCameraByName("PLYR_NAR_LookAtFreyasFirstArrow_010")
      end
    end
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.boolFootMagicBowstringCompleted = boolFootMagicBowstringCompleted
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  boolFootMagicBowstringCompleted = savedInfo.boolFootMagicBowstringCompleted
end
function CreateActors()
  freyaActor = actor.Actor.New("Freya", ND.FindFreya)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
end
function SetupProps()
  arrowProp = GameObjects.arrowProp.Child
  HideProps()
end
function HideProps()
  arrowProp:Hide()
end
function ShowProps()
  arrowProp:Show()
end
function BuildFootMagicBowstringSeq()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "FootMagicBowstring")
  local actorTable = {
    {Actor = sonActor},
    {Obj = arrowProp}
  }
  seq:Do(InitializeSpecialCamera)
  seq:Do(function()
    GameObjects.POIZone_SlowWalkKratos:Show()
  end)
  seq:Do(function()
    freyaActor:GetCreature():SetAccelerationOverride(1)
  end)
  seq:ActorForceApproachAndWait(freyaActor, {
    Branch = "BRA_FootMagicBowstringEnter",
    ReferenceJoint = "FootMagicBowstring_SynchJoint",
    speed = ND.FreyaWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius
  })
  seq:ActorSync(freyaActor, {
    Branch = "BRA_FootMagicBowstringEnter",
    ReferenceJoint = "FootMagicBowstring_SynchJoint"
  })
  seq:Do(function()
    freyaActor:GetCreature():ClearAccelerationOverride()
  end)
  seq:Do(PlayEnterBanter)
  seq:WaitForActorInZone(kratosActor, "POI_StartWhenKratosArrivesHere")
  seq:Do(DisableYSNP)
  seq:Do(ShowProps)
  seq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_FootMagicBowstringScene",
    ReferenceJoint = "FootMagicBowstring_SynchJoint",
    speed = ND.SonJogSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = 0.5
  })
  seq:ActorSync(freyaActor, {
    Slaves = actorTable,
    Branch = "BRA_FootMagicBowstringScene",
    ReferenceJoint = "FootMagicBowstring_SynchJoint"
  })
  seq:Do(function()
    game.Audio.PlayBanter("FirstMagicBowstring")
  end)
  seq:WaitForSyncStart(freyaActor:GetCreature())
  seq:Do(TurnOnArrowReleasedCamera)
  seq:StartPOIMoment()
  seq:WaitSeconds(6)
  seq:Do(function()
    thisLevel:GetGameObject("LightCrystal_forBridge").LuaObjectScript.SetCrystalObjectStates(2)
    thisLevel:GetGameObject("LightCrystal_forBridge").LuaObjectScript.PlaySoundActivateCrystal()
  end)
  seq:WaitUntilActorAnimPastPercentage(freyaActor, 0.8)
  seq:Do(EnableLTW_ToCaldera)
  seq:WaitUntilActorAnimPastPercentage(freyaActor, 0.85)
  seq:Do(HideBlockerCollision)
  seq:WaitForActorPuppeteerComplete(freyaActor)
  seq:Do(HideProps)
  seq:StopPuppetingActor(freyaActor)
  seq:StopPuppetingActor(sonActor)
  seq:Do(function()
    GameObjects.POIZone_SlowWalkKratos:Hide()
  end)
  seq:Do(StopDesignerCameraAndSleep)
  seq:EndPOIMoment()
  seq:Do(function()
    boolFootMagicBowstringCompleted = true
  end)
  seq:StartSequence()
end
function PlayApproachBanter()
  game.Audio.PlayBanter("FirstMagicBowstring_Approach", function()
    playedApproachBanter = true
  end)
end
function PlayEnterBanter()
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "FootMagicBowstring_EnterBanter")
  seq:WaitForFunctionTrue(function()
    return playedApproachBanter
  end)
  seq:Do(function()
    game.Audio.PlayBanter("FirstMagicBowstring_Enter")
  end)
  seq:StartSequence()
end
function DisableYSNP()
  local freLTWWad = game.FindLevel("FreyaLTW")
  if freLTWWad ~= nil then
    freLTWWad:CallScript("TurnOffYSNP")
  end
end
function EnableLTW_ToCaldera()
  local freLTWWad = game.FindLevel("FreyaLTW")
  if freLTWWad ~= nil then
    freLTWWad:CallScript("LTW_ToCaldera_Start")
  end
end
function HideBlockerCollision()
  local freLTWWad = game.FindLevel("FreyaLTW")
  if freLTWWad ~= nil then
    freLTWWad:CallScript("LTW_ToLightbridge_HideBlockerCollision")
  end
end
function InitializeSpecialCamera()
  game.SubObject.Wake(thisObj)
  bSubmitArrowReleasedCamera = false
  bFreyaStillHasArrowInHerHands = true
  player = game.Player.FindPlayer()
  GameObjects.POIZone_CustomCamera:Show()
end
function TurnOnArrowReleasedCamera()
  timers.StartLevelTimer(5.5, function()
    bSubmitArrowReleasedCamera = true
  end)
  timers.StartLevelTimer(7, function()
    bFreyaStillHasArrowInHerHands = false
  end)
end
function StopDesignerCameraAndSleep()
  bSubmitArrowReleasedCamera = false
  game.SubObject.Sleep(thisObj)
  GameObjects.POIZone_CustomCamera:Hide()
end
