local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
local gateIsOpen = false
function OnScriptLoaded(level)
  SoundInit()
end
function OnFirstStart(level)
  SetAmbience()
  GameObjects.TraversePath_toMasonCave:HideTraversePath()
  GameObjects.EntZne_BackTrack_FromThamurLore:Hide()
  GameObjects.ZoneEvents_BackTrack_Thamur.LuaObjectScript.Disable()
end
function OnPreStart(level)
  LD.RegisterForVariableUpdate(level, "WaterDrop01Triggered", {
    immediateFn = SetAmbience,
    fn = SetAmbience
  })
  LD.RegisterForVariableUpdate(level, "WaterDrop02Triggered", {
    immediateFn = SetAmbience,
    fn = SetAmbience
  })
end
function OnStart(level)
  LD.CallFunctionAfterDelay(ToggleBoatZones, 0.1)
end
function ToggleBoatZones()
  local regionInfo = game.Map.GetRegionInfo("Stonemason")
  local regionState = regionInfo.State
  if regionState == tweaks.eTokenState.kDiscovered then
    GameObjects.SlowDownZone_Trip1_A_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip1_B_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip1_C_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip1_D_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip2_A_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip2_B_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip2_C_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip2_D_Controller.LuaObjectScript.Enable()
  else
    GameObjects.SlowDownZone_Trip1_A_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip1_B_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip1_D_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip1_C_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip2_A_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip2_B_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip2_D_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip2_C_Controller.LuaObjectScript.Disable()
  end
end
function BOOKMARK_13_Caldera_030_MasonConnector()
  gateIsOpen = true
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "13_Caldera_030_MasonConnector"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
local waterLevel = {}
waterLevel.Bottom = 2
waterLevel.Medium = 1
waterLevel.Top = 0
local bottomWaterAmbience, mediumWaterAmbience, topWaterAmbience
function SoundInit()
  bottomWaterAmbience = GameObjects.BottomWaterAmbience
  mediumWaterAmbience = GameObjects.MediumWaterAmbience
  topWaterAmbience = GameObjects.TopWaterAmbience
end
function SetAmbience()
  local newWaterLevel = LD.GetCurrentWaterLevel()
  if newWaterLevel == waterLevel.Bottom then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Show()
  elseif newWaterLevel == waterLevel.Medium then
    topWaterAmbience:Hide()
    mediumWaterAmbience:Show()
    bottomWaterAmbience:Hide()
  elseif newWaterLevel == waterLevel.Top then
    topWaterAmbience:Show()
    mediumWaterAmbience:Hide()
    bottomWaterAmbience:Hide()
  end
end
function HideAllAmbience()
  topWaterAmbience:Hide()
  mediumWaterAmbience:Hide()
  bottomWaterAmbience:Hide()
end
function Cal100_LoadCheck()
  game.UI.LoadCheck("Cal100_Hub")
end
function OnZoneEnter_StoneMasonArch()
  EvaluateQuestObjectives_ReturnFromStoneMason()
end
function BeachBlocker_01()
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_01)
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_02)
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_03)
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_04)
end
function BeachBlocker_02()
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_05)
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_06)
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_07)
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_08)
end
function BeachBlocker_03()
  GameObjects.TraversePath_toMasonCave:ShowTraversePath()
  GameObjects.RockBlocker_Collision:HideCollision()
  LD.BreakObject(GameObjects.RockBlockers_01_Rock_09)
end
function BeachBlocker_atDoor()
  LD.BreakObject(GameObjects.RockBlockers_atDoor_Rock_01)
  LD.BreakObject(GameObjects.RockBlockers_atDoor_Rock_02)
  LD.BreakObject(GameObjects.RockBlockers_atDoor_Rock_03)
  LD.BreakObject(GameObjects.RockBlockers_atDoor_Rock_04)
  LD.BreakObject(GameObjects.RockBlockers_atDoor_Rock_05)
  LD.BreakObject(GameObjects.RockBlockers_atDoor_Rock_06)
  LD.BreakObject(GameObjects.RockBlockers_atDoor_Rock_07)
  LD.BreakObject(GameObjects.RockBlockers_atDoor_Rock_08)
end
function BeachBlocker_alongPath()
  LD.BreakObject(GameObjects.RockBlockers_alongPath_Rock_01)
  LD.BreakObject(GameObjects.RockBlockers_alongPath_Rock_02)
  LD.BreakObject(GameObjects.RockBlockers_alongPath_Rock_03)
  LD.BreakObject(GameObjects.RockBlockers_alongPath_Rock_04)
  LD.BreakObject(GameObjects.RockBlockers_alongPath_Rock_05)
  LD.BreakObject(GameObjects.RockBlockers_alongPath_Rock_06)
  LD.BreakObject(GameObjects.RockBlockers_alongPath_Rock_07)
  GameObjects.RockBlockers_alongPath_Collision:Hide()
end
local ObjectiveActions = {
  {
    ActiveQuest = "Quest_StoneMason_Objective800",
    StateRequirement = "Active",
    Action = "Complete"
  }
}
function EvaluateQuestObjectives_ReturnFromStoneMason()
  for _, v in ipairs(ObjectiveActions) do
    if v ~= nil and v.ActiveQuest ~= nil then
      local questState = game.QuestManager.GetQuestState(v.ActiveQuest)
      if questState == v.StateRequirement then
        game.QuestManager.ProposeQuestState(v.ActiveQuest, v.Action)
      end
    end
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    gateIsOpen = gateIsOpen
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  gateIsOpen = savedInfo.gateIsOpen
end
function PlayStonemasonGate()
  if LD.GetEntityVariable("CompletedCineNumber") == 340 and game.Audio.CanBanterConversationPlay("075_StonemasonGate") then
    LD.DisableBoatLore()
    game.Audio.PlayBanter("075_StonemasonGate")
    GameObjects.EntZne_BackTrack_FromThamurLore:Show()
    GameObjects.ZoneEvents_BackTrack_Thamur.LuaObjectScript.Enable()
  end
end
function EnableBoatLore()
  if LD.GetEntityVariable("CompletedCineNumber") == 340 and game.Audio.CanBanterConversationPlay("IsStoryTimeNotAllowed") then
    LD.EnableBoatLore()
  end
end
function CanPlayThamurLore()
  return LD.GetEntityVariable("CompletedCineNumber") == 340 and gateIsOpen
end
function OnPlayThamurLore()
  local cal200 = game.FindLevel("Cal200_Shore")
  if cal200 ~= nil then
    cal200:GetGameObject("Cbt_Cal200_Script"):CallScript("DisableZone_EntZn_Arena_Spawn_2")
  end
  ThamurLore_01Music()
end
function ThamurLore_01Music()
  LD.CallFunctionAfterDelay(function()
    game.Audio.StartMusic("SND_MX_CAL270_mason_story")
  end, 2.5)
end
function stoneLoadMusic()
  if LD.GetEntityVariable("CompletedCineNumber") >= 340 and LD.GetEntityVariable("CompletedCineNumber") < 350 then
    game.Audio.StartMusic("SND_MX_STN_cove_approach")
  end
end
