local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local EC = require("design.Encounter")
local thisLevel, Jotunn_HealthMonitor, Enc_Beach_Fight_1, Enc_Beach_Fight_2
function OnScriptLoaded(level, obj)
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  Fnc_Beach_Fight_1()
  Fnc_Beach_Fight_2()
end
function OnFirstStart(level, obj)
  GameObjects.EntZn_Arena_RestartFight270:HideEntityVolume()
  GameObjects.EntZn_BeachFight_Spawn:HideEntityVolume()
end
function Fnc_Beach_Fight_1()
  Enc_Beach_Fight_1 = EC.NewEncounter(thisLevel, "CAL270:F1E1: Beach Encounter 1", {
    CheckpointOnComplete = true,
    LeashZone = "LeashZoneCal270",
    StartMusic = "SND_MX_CAL270_smc_gate_fight_in",
    StopMusic = "SND_MX_CAL270_smc_gate_fight_out"
  })
  Enc_Beach_Fight_1:AddWave({
    {
      spawners = "Jotunn00_CLIMB",
      markerID = "Jotunn_Boss",
      spawnWad = "Cal270_StoneMasonLH_AI_02",
      initialSpawnAmount = 1,
      maxActive = 1,
      totalSpawns = 1,
      initialSpawnCooldown = {0, 0},
      spawnCooldown = {10, 20}
    },
    {
      spawners = "DarkOne_HS_SFA",
      spawnLocators = "Loc_G_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal270_StoneMasonLH_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {12, 14}
    },
    {
      spawners = "DarkOne_QS_SFB",
      spawnWad = "Cal270_StoneMasonLH_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {12, 14}
    }
  })
  Enc_Beach_Fight_1:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "DarkOne_QS_SFA",
      spawnLocators = "Loc_G_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal270_StoneMasonLH_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0.1, 2}
    },
    {
      spawners = "DarkOne_QS_SFA",
      spawnLocators = "Loc_G_*",
      useSpawnLocatorsOnly = true,
      spawnWad = "Cal270_StoneMasonLH_AI_02",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = {0.1, 2}
    }
  })
  Enc_Beach_Fight_1:OnEnemySpawn(Jotunn_Health_Encounter, {
    markerID = "Jotunn_Boss"
  })
  Enc_Beach_Fight_1:SetStartZone(GameObjects.EntZn_BeachFight_Spawn)
  Enc_Beach_Fight_1:OnStart(DisableQuestGiver)
  Enc_Beach_Fight_1:OnComplete(EnableQuestGiver)
end
function EnableQuestGiver()
  GameObjects.GhostInteract02:FindSingleGOByName("TriggerSpawn"):ShowEntityVolume()
  LD.CallFunctionAfterDelay(function()
    GameObjects.GhostInteract02.LuaObjectScript.AttemptToTriggerGreeting()
  end, 1)
  LD.CallFunctionAfterDelay(TriggerPostCombatFoolCheck, 7)
end
function TriggerPostCombatFoolCheck()
  game.Audio.PlayBanterNonCritical("UB1DesMdn_FoolsErrand")
end
function DisableQuestGiver()
  GameObjects.GhostInteract02:FindSingleGOByName("TriggerSpawn"):HideEntityVolume()
end
function Start_Beach_Fight()
  Enc_Beach_Fight_1:Start()
  Enc_Beach_Fight_1:AlertEnemies()
  GameObjects.EntZn_BeachFight_Spawn:ShowEntityVolume()
end
function Jotunn_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local Jotunn_Health = Enemy:GetHitPoints()
    Jotunn_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = Jotunn_Health * 0.22
    Jotunn_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      Enc_Beach_Fight_1:StartWave(2)
    end)
  end
end
function Fnc_Beach_Fight_2()
  Enc_Beach_Fight_2 = EC.NewEncounter(thisLevel, "CAL270: Beach Encounter 2 Repopulation", {
    CheckpointOnComplete = false,
    LeashZone = "LeashZoneCal270",
    RepopulationEncounter = true,
    MustHaveCompletedList = {
      "CAL270:F1E1: Beach Encounter 1"
    }
  })
  Enc_Beach_Fight_2:AddWave({
    {
      spawners = "Crawler00_PL4_SPA",
      spawnLocators = "Loc_G_*",
      spawnWad = "Cal270_StoneMasonLH_AI_02",
      initialSpawnAmount = 1,
      maxActive = 3,
      totalSpawns = 3,
      initialSpawnCooldown = 0,
      spawnCooldown = 1
    }
  })
  Enc_Beach_Fight_2:SetStartZone(GameObjects.EntZn_BeachFight_Repop_Spawn)
  Enc_Beach_Fight_2:OnStart(DisableQuestGiver)
  Enc_Beach_Fight_2:OnComplete(EnableQuestGiver)
end
