LD = require("design.LevelDesignLibrary")
function OnScriptLoaded(level)
  if LD.GetEntityVariable("STN_FinalBossStarted") then
    GameObjects.LoadStoneMason_EndGame:ShowEntityVolume()
    GameObjects.ActivateStn090_EndGame:ShowEntityVolume()
    GameObjects.DeActivateStn090_EndGame:ShowEntityVolume()
    GameObjects.DeActivateStn090:HideEntityVolume()
    GameObjects.ActivateStn090:HideEntityVolume()
    GameObjects.LoadStoneMason:HideEntityVolume()
  else
    GameObjects.DeActivateStn090:ShowEntityVolume()
    GameObjects.ActivateStn090:ShowEntityVolume()
    GameObjects.LoadStoneMason:ShowEntityVolume()
    GameObjects.LoadStoneMason_EndGame:HideEntityVolume()
    GameObjects.ActivateStn090_EndGame:HideEntityVolume()
    GameObjects.DeActivateStn090_EndGame:HideEntityVolume()
  end
end
function OnStart(level)
  LD.CallFunctionAfterDelay(ToggleBoatZones, 0.1)
end
function ToggleBoatZones()
  local regionInfo = game.Map.GetRegionInfo("Stonemason")
  local regionState = regionInfo.State
  if regionState == tweaks.eTokenState.kDiscovered then
    GameObjects.SlowDownZone_Trip1_E_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip1_F_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip2_E_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip2_F_Controller.LuaObjectScript.Enable()
  else
    GameObjects.SlowDownZone_Trip1_E_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip1_F_Controller.LuaObjectScript.Enable()
    GameObjects.SlowDownZone_Trip2_E_Controller.LuaObjectScript.Disable()
    GameObjects.SlowDownZone_Trip2_F_Controller.LuaObjectScript.Disable()
  end
end
function OnUpdate(level)
end
function OnUseWorld(level)
end
function LoadCheckCal()
  game.UI.LoadCheck("Cal200_Shore")
end
function Stn100_LoadCheck()
  game.UI.LoadCheck("Stn100_Entrance", "Stn910_BossEntrance")
end
