local LD = require("design.LevelDesignLibrary")
local thisLevel, son
local player = game.Player.FindPlayer()
local pad = player.Pad
local buttonMaskingON
local playedBrothersMimir = false
local uiCalls = require("ui.uicalls")
function OnScriptLoaded(level)
  thisLevel = level
  son = game.AI.FindSon()
end
function OnStart(level)
  if buttonMaskingON == true then
    ButtonMasking()
  end
  SoundInit()
end
function OnUpdate(level)
  if player.IsFootIKLocked then
    if player and player:InsideZone("NoLowerIKZoneHero") and not player:IsFootIKLocked() then
      player:LockFootIKOff()
    end
    if son and son:InsideZone("NoLowerIKZoneSon") and not son:IsFootIKLocked() then
      son:LockFootIKOff()
    end
  end
end
function ButtonMasking()
  print("button masking")
  ShowJotZone()
  buttonMaskingON = true
  uiCalls.UI_Event_Turn_Combat_HUD_Off()
  game.Compass.SetDesignerForcedHide(true)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  pad:DisableGameButton(tweaks.ePad.kPadCross)
  pad:DisableGameButton(tweaks.ePad.kPadLeft)
  pad:DisableGameButton(tweaks.ePad.kPadDown)
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  pad:DisableGameButton(tweaks.ePad.kPadL1)
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadL3)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  local availabilityState = {AvailableForCombat = false}
  son:SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
end
function ButtonMaskingOff()
  print("stop button masking")
  buttonMaskingON = false
  uiCalls.UI_Event_Turn_Combat_HUD_On()
  game.Compass.SetDesignerForcedHide(false)
  pad:EnableGameButton(tweaks.ePad.kPadTriangle)
  pad:EnableGameButton(tweaks.ePad.kPadCross)
  pad:EnableGameButton(tweaks.ePad.kPadLeft)
  pad:EnableGameButton(tweaks.ePad.kPadDown)
  pad:EnableGameButton(tweaks.ePad.kPadRight)
  pad:EnableGameButton(tweaks.ePad.kPadL1)
  pad:EnableGameButton(tweaks.ePad.kPadL2)
  pad:EnableGameButton(tweaks.ePad.kPadL3)
  pad:EnableGameButton(tweaks.ePad.kPadR1)
  pad:EnableGameButton(tweaks.ePad.kPadR2)
  son:RemoveAvailabilityRequest("LevelDesignScript")
end
function OpenJotDoor()
  GameObjects.POI_MimirPickup.LuaObjectScript.TryInitializeSeq()
  local openDoorSeq = LD.CreateCineSequence(thisLevel, GameObjects.POI_MimirPickup, "OpenJotDoorSequence")
  openDoorSeq:WaitForLoadCheck("Cal130_TempleInt")
  openDoorSeq:Do(function()
    game.FindLevel("Cal130_TempleInt"):CallScript("OpenJotunheimDoor")
  end)
  openDoorSeq:StartSequence()
end
function CloseJotDoor()
  local cal130 = game.FindLevel("Cal130_TempleInt")
  if cal130 ~= nil then
    cal130:CallScript("CloseJotunheimDoor")
  end
  GameObjects.CA_WaitOnJotStairs.LuaObjectScript.Disable()
  if not playedBrothersMimir then
    game.Audio.PlayBanter("040_BrothersMimir")
    playedBrothersMimir = true
  end
end
function EnableLTW_Up()
  GameObjects.LTW_Up.LuaObjectScript.Enable()
  GameObjects.CA_ShieldEyes.LuaObjectScript.Enable()
end
function DisableWaitAtLightCA()
  GameObjects.CA_ShieldEyes.LuaObjectScript.Disable()
  GameObjects.LTW_Up.LuaObjectScript.Disable()
  GameObjects.EntZn_LtwUp_Far:HideEntityVolume()
end
function EnableLTW_Down()
  GameObjects.LTW_Down.LuaObjectScript.Enable()
  GameObjects.CA_Observe_Forward_Up.LuaObjectScript.Enable()
end
function DisableLTW_Down()
  GameObjects.LTW_Down.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Forward_Up.LuaObjectScript.Disable()
end
function LTW_Update_Call300_UpFar()
  local ltwUpParams = {}
  ltwUpParams = {
    Speed = 4.85,
    LeaderDistance_Wait = 26,
    LeaderDistance_Continue = 16,
    LeaderDistance_Backtrack = 32,
    LeaderDistance_BacktrackDone = 28
  }
  GameObjects.LTW_Up.Child.LuaObjectScript.UpdateLeadTheWayParams(ltwUpParams)
end
function HeroLockIK()
  if player.LockFootIKOff then
    player:LockFootIKOff()
  end
end
function HeroUnlockIK()
  if player.UnlockFootIK then
    player:UnlockFootIK()
  end
end
function SonLockIK()
  if son.LockFootIKOff then
    son:LockFootIKOff()
  end
end
function SonUnlockIK()
  if son.UnlockFootIK then
    son:UnlockFootIK()
  end
end
function Cal300LoadCheck()
  game.UI.LoadCheck("Jot100_GiantsFingers", "Cal300_JotunheimLH")
end
function Cal120LoadCheck()
  game.UI.LoadCheck("Jot100_GiantsFingers", "Cal130_TempleInt")
end
function OnSaveCheckpoint(level)
  return {buttonMaskingON = buttonMaskingON, playedBrothersMimir = playedBrothersMimir}
end
function OnRestoreCheckpoint(level, savedInfo)
  buttonMaskingON = savedInfo.buttonMaskingON
  playedBrothersMimir = savedInfo.playedBrothersMimir
end
local SNDCrossPortalStartEmitter, PortalObject
function SoundInit()
  PortalObject = GameObjects.SNDGrpCrossOver
  SNDCrossPortalStartEmitter = PortalObject:FindSingleSoundEmitterByName("SNDCrossOverSound_Cal300Jot")
end
function PlayCrossSound()
  LD.PlaySound(SNDCrossPortalStartEmitter, "SND_MAG_Jot100_Light_Gate_Teleport")
  print("play sound")
end
function ShowJotZone()
  local jot050 = game.FindLevel("Jot050_Sound")
  if jot050 ~= nil then
    jot050:CallScript("ShowJotZone")
  end
end
