local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local player, son, thisLevel, warpDoor, warpRequested, finalDestinationMarkerID, destinationFound
local spawnPoints = {
  AtBridge = {
    player = "PlayerDeathWarpLocator",
    son = "SonDeathWarpLocator"
  },
  FarAway = {
    player = "PlayerWarpLocator",
    son = "SonWarpLocator"
  }
}
function OnScriptLoaded(level)
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  thisLevel = level
  warpDoor = level:FindSingleGameObject("ft_RealmVersionController")
end
function OnStart(level)
  warpDoor.LuaObjectScript.Disable()
  GameObjects.FastTravel_WarpDetector:HideEntityVolume()
  GameObjects.LoadZone_FinalTower:ShowEntityVolume()
  GameObjects.Cal410_LoadCheck:ShowEntityVolume()
  GameObjects.ContextAction_Bridge.LuaObjectScript.Enable()
  DisableInstantDeath()
  EnableMightAsWellJump()
  _G.StartLevelTimer(3, function()
    game.World.StoreCheckpoint()
  end)
  LD.GiveTyrUnlock()
end
function WarpIntoFastTravel()
  uiCalls.UI_Journal_Log_Unpause()
  LD.CompleteQuest("Quest_Caldera_Objective736")
  local spawn = spawnPoints.AtBridge
  local playerWarp = thisLevel:FindSingleGameObject(spawn.player)
  local sonWarp = thisLevel:FindSingleGameObject(spawn.son)
  if playerWarp ~= nil then
    player:Warp(playerWarp.WorldPosition, playerWarp:GetWorldForward())
    if son ~= nil and son:IsAvailableInLevel() then
      son:Warp(sonWarp.WorldPosition, sonWarp:GetWorldForward())
    end
  end
  timers.StartLevelTimer(0.5, function()
    BOOKMARK_32_Underworld_005_TheBigJump()
    PlayBanter()
  end)
end
function PlayerEnteredWarpZone()
end
function PlayBanter()
  game.Audio.PlayBanter("200_MightAsWellJump2", Quest_Caldera_Objective736_End)
end
function BOOKMARK_32_Underworld_005_TheBigJump()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "32_Underworld_005_TheBigJump"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function EnableSonLeadTheWay()
  GameObjects.RBR_Son_LTW.LuaObjectScript.Enable()
end
function DisableSonLeadTheWay()
  GameObjects.RBR_Son_LTW.LuaObjectScript.Disable()
end
function LoadCheck_410()
  game.UI.LoadCheck("Cal410_FinaleTowerFight")
end
function PlayMightAsWellJumpBanter()
  local cal410 = game.FindLevel("Cal410_FinaleTowerFight")
  if cal410 then
    cal410:CallScript("StartPlungeCine")
  else
    EnableMightAsWellJump()
  end
end
function Quest_Caldera_Objective736_End()
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 716,
    Body = 18771,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
    Quest = "Quest_Caldera_Objective737"
  })
end
function EnableMightAsWellJump()
  GameObjects.Interact_MightAsWellJump.LuaObjectScript.Enable()
end
function DisableMightAsWellJump()
  GameObjects.Interact_MightAsWellJump.LuaObjectScript.Disable()
end
function EnableInstantDeath()
  GameObjects.Interact_InstantDeath.LuaObjectScript.Enable()
end
function DisableInstantDeath()
  GameObjects.Interact_InstantDeath.LuaObjectScript.Disable()
end
