local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local CSL = require("camera.shakelibrary")
local thisLevel, kraPuppeteer, sonPuppeteer
local bBridgeMoved = false
local bTowerUp = false
local gauntletEncounter_Wave = 1
function OnScriptLoaded(level)
  thisLevel = level
  GameObjects.keyOrb00_Jump:Hide()
end
function OnStart(level)
  GameObjects.Lights_After:Hide()
  GameObjects.show200:HideEntityVolume()
  SoundOnStart()
end
function OnWadLoaded(level, newlevel)
  if newlevel.Name == "WAD_Cal100_Hub" then
    newlevel:CallScript("ShowJotTower")
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    bBridgeMoved = bBridgeMoved,
    bTowerUp = bTowerUp
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  bBridgeMoved = savedInfo.bBridgeMoved
  bTowerUp = savedInfo.bTowerUp
end
local kratosActor, sonActor, orb
local actorTable = {}
function SetupActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  orb = GameObjects.keyOrb00_Jump
  actorTable = {
    {Actor = sonActor}
  }
end
function StartPlungeCine()
  SetupActors()
  local cineSeq = ND.CreateCineSequence(thisLevel, GameObjects.plungeElevator, "Realm Fall Success")
  cineSeq:RequestCineModeAndWait(kratosActor, GameObjects.plungeElevator)
  cineSeq:Do(function()
    if LD.GetCurrentRealm() ~= "Midgard" then
      LD.SetCurrentRealm("Midgard")
      LD.SetSelectedRealm("Midgard")
    end
  end)
  cineSeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_RealmFallSuccess",
    ReferenceJoint = "joint1",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius,
    weapon_state = "bare",
    completion_percentage = 0.7
  })
  cineSeq:Do(function()
    game.Audio.PlayBanter("202_MightAsWellJump3")
  end)
  cineSeq:ActorSync(kratosActor, {
    Slaves = actorTable,
    Branch = "BRA_RealmFallSuccess",
    ReferenceJoint = "joint1"
  })
  cineSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.011)
  cineSeq:Do(function()
    orb:Show()
  end)
  cineSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.092)
  cineSeq:Do(function()
    orb:Hide()
  end)
  cineSeq:WaitUntilActorAnimPastPercentage(kratosActor, 0.75)
  cineSeq:Do(function()
    game.Audio.PlayBanter("210_TowerFound")
  end)
  cineSeq:WaitForActorMoveComplete(sonActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:WaitForAndCompleteCineMode(kratosActor, GameObjects.plungeElevator)
  cineSeq:Do(CompleteJumpOffRBRObjective)
  cineSeq:StopPuppetingActor(kratosActor)
  cineSeq:StartSequence()
end
function StartTowerUp()
  game.Compass.SetDesignerForcedHide(true)
  local elevatorUpDuration = 23.5
  CSL.PlayDefaultShake("ElevatorMovement", elevatorUpDuration, 0.3, 0)
  timers.StartLevelTimer(elevatorUpDuration, function()
    CSL.PlayDefaultShake("ShakeRumbleMedium", 0.9, 0, 0.3)
  end)
  GameObjects.JotunTower:Hide()
  GameObjects.RealmTowerDoor.Child.LuaObjectScript.Disable()
  HideCal410_Outside()
  GameObjects.Lights_Before:PlayAnimToEnd()
  timers.StartLevelTimer(4, function()
    GameObjects.Lights_After:Show()
  end)
  timers.StartLevelTimer(4, function()
    GameObjects.Lights_Before:Hide()
  end)
  GameObjects.Lights_After:PlayAnimCycle()
  game.Audio.PlayBanter("220_TowerActivate_02", function()
    GameObjects.encounterControl.LuaObjectScript.StartGauntlet()
    local questState = game.QuestManager.GetQuestState("Quest_SonLanguage_Niflheim_Travel")
    if questState == "Active" then
      game.Audio.PlayBanter("Gauntlet_R1_Start_Nif")
    end
    timers.StartLevelTimer(1, function()
      game.Audio.PlayBanter("220_TowerActivate_03", function()
      end)
    end)
  end)
  timers.StartLevelTimer(2, function()
    GameObjects.OrbKeyStonePedestal:PlayAnimToEnd()
    GameObjects.OrbKeyStonePedestal:OnAnimDone(thisLevel, "PlaySoundOnPedestalInGround")
  end)
end
function TowerReturn()
  bTowerUp = true
  GameObjects.Lights_After:Hide()
  GameObjects.show200:ShowEntityVolume()
  GameObjects.startLoading200:HideEntityVolume()
  LD.SetEntityVariable("CompletedCineNumber", 515)
  game.Audio.PlayBanter("230_GauntletOver")
  timers.StartLevelTimer(3, function()
    GameObjects.RealmTowerDoor.Child.LuaObjectScript.Enable()
    GameObjects.RealmTowerDoor.Child.LuaObjectScript.Disable()
    GameObjects.RealmTowerDoor:Hide()
    GameObjects.geo:Hide()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "32_Underworld_019_FightComplete"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
end
function Hide410Door()
  GameObjects.RealmTowerDoor:Hide()
  GameObjects.geo:Hide()
end
function CompleteJumpOffRBRObjective()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective737", "Complete")
end
function CompleteQuest738Door()
  LD.CompleteQuest("Quest_Caldera_Objective738")
end
function Complete_Quest_Caldera_Objective738()
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 716,
    Body = 1591,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
    Quest = "Quest_Caldera_Objective740"
  })
  game.Compass.OnWarp()
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Jotunheim Tower")
end
function OnEvaluateLoadGroup_LoadGroup_AI()
  if gauntletEncounter_Wave == 1 then
    return "AI_Fight_01"
  elseif gauntletEncounter_Wave == 2 then
    return "AI_Fight_02"
  elseif gauntletEncounter_Wave == 3 then
    return "AI_Fight_03"
  elseif gauntletEncounter_Wave == 4 then
    return "AI_Fight_03"
  else
    return nil
  end
end
function GauntletEncounter_1()
  gauntletEncounter_Wave = 1
  game.EvaluateLoadZones()
end
function GauntletEncounter_2()
  gauntletEncounter_Wave = 2
  game.EvaluateLoadZones()
end
function GauntletEncounter_3()
  gauntletEncounter_Wave = 3
  game.EvaluateLoadZones()
end
function GauntletEncounter_4()
  gauntletEncounter_Wave = 4
  game.EvaluateLoadZones()
end
function HideCal410_Outside()
  GameObjects.Cal410_Outside:Hide()
  GameObjects.Cal410_Outside:HideLights()
  GameObjects.Gbl000_Fx:Hide()
  GameObjects.Gbl000_Fx:HideLights()
  GameObjects.Gbl000_Fx:HideParticles()
  GameObjects.Gbl000_Fx:HideParticleEmitter()
  GameObjects.SurroundingBreakupFog:Hide()
  GameObjects.SurroundingBreakupFog:HideParticles()
  GameObjects.VolFog:Hide()
  GameObjects.VolFog:HideParticles()
  GameObjects.RisingGlowEmbers:Hide()
  GameObjects.RisingGlowEmbers:HideParticles()
end
function TurnOnDirectionalLight()
  GameObjects.Sun_Gbl000:PlayAnimationToEnd()
end
local pedestalSoundEvents = {
  soundPedestal = "SND_MECH_Keystone_Activate",
  soundPedestalLoop = "SND_MECH_Keystone_Activate_LP",
  soundKeyPlace = "SND_MECH_RBR_Pod_Activate"
}
function SoundOnStart()
  GameObjects.OrbStonePedestal.LuaObjectScript.SoundSetup(pedestalSoundEvents)
end
function PlaySoundOnPedestalInGround()
  GameObjects.encounterControl.LuaObjectScript.PlaySoundTowerMoving()
end
function pedistalMusic()
  game.Audio.StartMusic("SND_MX_CAL_jotunheim_tower_intro")
end
