local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local CSL = require("camera.shakelibrary")
local EncounterSM = require("boss.statemachine")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, player, son
local shakeRumble = false
local camShakeLarge = {
  EffectName = "FSE_shake_temp_Generic_Large",
  Duration = 8
}
local ForceFeedbackRumble = {
  EffectName = "FFB_HEAVY_ATTACK",
  Duration = 8
}
local gauntletEncounter_Wave = 1
local gauntletEncounter_1, gauntletEncounter_2, gauntletEncounter_3, gauntletEncounter_4, gauntletEncounter_5, doorControlWad, encounter1Monitor, encounter2Monitor, encounter4Monitor
local bChainsPulled = false
bEncounter1Complete = false
bEncounter2Complete = false
bEncounter3Complete = false
bEncounter4Complete = false
local bEncounter4Started = false
local Enemy_HealthMonitor
local Alfheim_Encounter = EncounterSM:AddStage("Alfheim - ", false)
local Helheim_Encounter = EncounterSM:AddStage("Helheim - ", false)
local Muspelheim_Encounter = EncounterSM:AddStage("Muspelheim -", false)
local Nidavellir_Encounter = EncounterSM:AddStage("Nidavellir - ", false)
local Midgard_Encounter = EncounterSM:AddStage("Midgard - ", false)
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  GauntletFight_1()
  GauntletFight_2()
  GauntletFight_3()
  GauntletFight_4()
  SoundInit()
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  GameObjects.RBR_DoorReady:Hide()
  GameObjects.DoorFog_01.Child:HideParticleEmitter()
  GameObjects.DoorFog_02.Child:HideParticleEmitter()
  GameObjects.DoorFog_03.Child:HideParticleEmitter()
  GameObjects.DoorFog_04.Child:HideParticleEmitter()
  GameObjects.FXCal410_INT_combat:Hide()
  GameObjects.Realm_Lights:HideLights()
  GameObjects.Cal410_Combat:HideParticleEmitter()
  GameObjects.Cal410_Combat:Hide()
  GameObjects.RiftDoorsAlf:Hide()
  GameObjects.RiftDoorsHel:Hide()
  GameObjects.RiftDoorsMusp:Hide()
  GameObjects.RiftDoorsNid:Hide()
  GameObjects.RT_medaillion01_AlfheimLit:Hide()
  GameObjects.RT_medaillion01_NidavellirLit:Hide()
  GameObjects.RT_medaillion01_HelheimLit:Hide()
  GameObjects.RT_medaillion01_MuspelheimLit:Hide()
  GameObjects.RT_medaillion01_JotunheimLit:Hide()
  GameObjects.RT_medaillion01_Alfheim:Hide()
  GameObjects.RT_medaillion01_Helheim:Hide()
  GameObjects.RT_medaillion01_Muspelheim:Hide()
end
function OnStart(level)
end
function OnUpdate(level, obj)
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_AfterFight_010") == true then
    game.Camera.SubmitCameraByName("PLYR_RBR_Door_RTT")
  end
  if game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_AfterFight_020") == true then
    game.Camera.SubmitCameraByName("PLYR_RBR_Symbol_RTT")
  end
end
function ShakeRumbleElevatorArriving()
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_LARGE",
    Duration = 0.5,
    TweenIn = {Time = 0},
    TweenOut = {0.5}
  })
  game.Blender.Trigger({
    Name = "FFB_LARGE",
    Duration = 0.5,
    TweenIn = {Time = 0},
    TweenOut = {0.5}
  })
end
function ElevatorMoving()
  CSL.PlayDefaultShake("ElevatorMovement", 8.8, 0.9, 0.3)
  timer.StartLevelTimer(10, function()
    CSL.PlayDefaultShake("ElevatorMovement_Reached", 0.6, 0, 0.3)
  end)
end
function ShakeRumble()
  game.Blender.Trigger({
    Name = "FSE_SHAKE_GENERIC_LARGE",
    Duration = 8.8,
    TweenIn = {Time = 0},
    TweenOut = {Time = 1.2}
  })
end
function StartGauntlet()
  EncounterSM:ForwardState()
  timer.StartLevelTimer(18, function()
    gauntletEncounter_1:Start()
  end)
  GameObjects.Sun_Gbl000:HideLights()
  AlfheimFightStart()
  StopSoundTowerMoving()
  game.Compass.SetDesignerForcedHide(true)
  GameObjects.OrbStonePedestal.LuaObjectScript.FinishPedestalInteraction()
end
function GauntletFightComplete()
  CloseAllCombatDoors()
end
function AlfheimFightStart()
  timer.StartLevelTimer(5.2, function()
    GameObjects.room:PlayAnimationToFrame(0, {
      Animation = "trim03_emissive"
    })
  end)
  GameObjects.room:SetMaterialSwap("rbr_nid_lit")
  GameObjects.AlfDoors:SetMaterialSwap("rbr_nid_lit")
  GameObjects.HelDoors:SetMaterialSwap("rbr_nid_lit")
  GameObjects.MuspDoors:SetMaterialSwap("rbr_nid_lit")
  GameObjects.NidDoors:SetMaterialSwap("rbr_nid_lit")
  GameObjects.tower1:FindSingleGOByName("geo"):Hide()
  GameObjects.Lights_Before:PlayAnimToEnd()
  GameObjects.FXCal410_INT_nocombat:Hide()
  GameObjects.FXCal410_INT_combat:Show()
  GameObjects.Skydome_FastTravel:Hide()
  CompletelyOpenAllCombatDoors()
  GameObjects.RT_medaillion01_NidavellirLit:Show()
  GameObjects.RT_medaillion01_Nidavellir:Hide()
  GameObjects.DoorFog_01.Child:ShowParticleEmitter()
  GameObjects.DoorFog_02.Child:ShowParticleEmitter()
  GameObjects.DoorFog_03.Child:ShowParticleEmitter()
  GameObjects.DoorFog_04.Child:ShowParticleEmitter()
  GameObjects.Cal410_Combat:ShowParticleEmitter()
  GameObjects.Realm_Lights:ShowLights()
  GameObjects.Realm_Lights:PlayAnimToFrame(30)
  GameObjects.fill_lights_room:PlayAnimToFrame(30)
  GameObjects.Cal410_Combat:PlayAnimToFrame(30)
  GameObjects.RBR_RoomDust_Hit:JumpAnimToFrame(0)
  GameObjects.RBR_RoomDust_Hit:PlayAnimToEnd()
  timer.StartLevelTimer(0.2, function()
    GameObjects.RiftDoorsNid:Show()
  end)
end
function AlfheimFightComplete()
  ShakeRumble()
  ElevatorMoving()
  PlaySoundTowerMoving()
  timer.StartLevelTimer(2, function()
    game.Audio.PlayBanter("Gauntlet_R1_End")
  end)
  timer.StartLevelTimer(10, function()
    game.Audio.PlayBanter("Gauntlet_R2_Start")
  end)
  GameObjects.room:SetMaterialSwap("rbr_nid_unlit")
  GameObjects.AlfDoors:SetMaterialSwap("rbr_nid_unlit")
  GameObjects.HelDoors:SetMaterialSwap("rbr_nid_unlit")
  GameObjects.MuspDoors:SetMaterialSwap("rbr_nid_unlit")
  GameObjects.NidDoors:SetMaterialSwap("rbr_nid_unlit")
  GameObjects.DoorFogLeft:PlayAnimToEnd()
  GameObjects.DoorFogRight:PlayAnimToEnd()
  timer.StartLevelTimer(1, function()
    GameObjects.DoorFog_01.Child:HideParticleEmitter()
    GameObjects.DoorFog_02.Child:HideParticleEmitter()
    GameObjects.DoorFog_03.Child:HideParticleEmitter()
    GameObjects.DoorFog_04.Child:HideParticleEmitter()
  end)
  GameObjects.Realm_Lights:PlayAnimToFrame(60)
  GameObjects.fill_lights_room:PlayAnimToFrame(60)
  timer.StartLevelTimer(9, function()
    GameObjects.DoorFog_01.Child:ShowParticleEmitter()
    GameObjects.DoorFog_02.Child:ShowParticleEmitter()
    GameObjects.DoorFog_03.Child:ShowParticleEmitter()
    GameObjects.DoorFog_04.Child:ShowParticleEmitter()
  end)
  GameObjects.RT_medaillion01_NidavellirLit:Hide()
  GameObjects.RT_medaillion01_Alfheim:Show()
  timer.StartLevelTimer(1, function()
    CloseAllCombatDoors()
    AddCameraShakeAndRumbleCallback(GameObjects.AlfDoors)
  end)
  GameObjects.MistFX:HideParticles()
  timer.StartLevelTimer(9, function()
    GameObjects.room:SetMaterialSwap("rbr_alf_lit")
    GameObjects.AlfDoors:SetMaterialSwap("rbr_alf_lit")
    GameObjects.HelDoors:SetMaterialSwap("rbr_alf_lit")
    GameObjects.MuspDoors:SetMaterialSwap("rbr_alf_lit")
    GameObjects.NidDoors:SetMaterialSwap("rbr_alf_lit")
    CompletelyOpenAllCombatDoors()
    StopSoundTowerMoving()
    GameObjects.MistFX:ShowParticles()
    GameObjects.RBR_RoomDust_Hit:JumpAnimToFrame(0)
    GameObjects.RBR_RoomDust_Hit:PlayAnimToEnd()
    GameObjects.Realm_Lights:PlayAnimToFrame(90)
    GameObjects.fill_lights_room:PlayAnimToFrame(90)
    GameObjects.Cal410_Combat:PlayAnimToFrame(60)
    GameObjects.RiftDoorsNid:Hide()
    GameObjects.RiftDoorsAlf:Show()
    GameObjects.RT_medaillion01_AlfheimLit:Show()
    GameObjects.RT_medaillion01_Alfheim:Hide()
  end)
end
function HelheimFightComplete()
  ShakeRumble()
  ElevatorMoving()
  PlaySoundTowerMoving()
  timer.StartLevelTimer(2, function()
    game.Audio.PlayBanter("Gauntlet_R2_End")
  end)
  timer.StartLevelTimer(12, function()
    game.Audio.PlayBanter("Gauntlet_R3_Start")
  end)
  GameObjects.room:SetMaterialSwap("rbr_alf_unlit")
  GameObjects.AlfDoors:SetMaterialSwap("rbr_alf_unlit")
  GameObjects.HelDoors:SetMaterialSwap("rbr_alf_unlit")
  GameObjects.MuspDoors:SetMaterialSwap("rbr_alf_unlit")
  GameObjects.NidDoors:SetMaterialSwap("rbr_alf_unlit")
  GameObjects.DoorFogLeft:PlayAnimToEnd()
  GameObjects.DoorFogRight:PlayAnimToEnd()
  GameObjects.Realm_Lights:PlayAnimToFrame(120)
  GameObjects.fill_lights_room:PlayAnimToFrame(120)
  timer.StartLevelTimer(1, function()
    GameObjects.DoorFog_01.Child:HideParticleEmitter()
    GameObjects.DoorFog_02.Child:HideParticleEmitter()
    GameObjects.DoorFog_03.Child:HideParticleEmitter()
    GameObjects.DoorFog_04.Child:HideParticleEmitter()
  end)
  timer.StartLevelTimer(9, function()
    GameObjects.DoorFog_01.Child:ShowParticleEmitter()
    GameObjects.DoorFog_02.Child:ShowParticleEmitter()
    GameObjects.DoorFog_03.Child:ShowParticleEmitter()
    GameObjects.DoorFog_04.Child:ShowParticleEmitter()
  end)
  GameObjects.RT_medaillion01_AlfheimLit:Hide()
  GameObjects.RT_medaillion01_Helheim:Show()
  timer.StartLevelTimer(1, function()
    CloseAllCombatDoors()
    AddCameraShakeAndRumbleCallback(GameObjects.HelDoors)
  end)
  timer.StartLevelTimer(9, function()
    GameObjects.room:SetMaterialSwap("rbr_hel_lit")
    GameObjects.AlfDoors:SetMaterialSwap("rbr_hel_lit")
    GameObjects.HelDoors:SetMaterialSwap("rbr_hel_lit")
    GameObjects.MuspDoors:SetMaterialSwap("rbr_hel_lit")
    GameObjects.NidDoors:SetMaterialSwap("rbr_hel_lit")
    CompletelyOpenAllCombatDoors()
    StopSoundTowerMoving()
    GameObjects.RBR_RoomDust_Hit:JumpAnimToFrame(0)
    GameObjects.RBR_RoomDust_Hit:PlayAnimToEnd()
  end)
  timer.StartLevelTimer(8, function()
    GameObjects.Realm_Lights:PlayAnimToFrame(150)
    GameObjects.fill_lights_room:PlayAnimToFrame(150)
    GameObjects.Cal410_Combat:PlayAnimToFrame(90)
  end)
  timer.StartLevelTimer(9, function()
    GameObjects.RiftDoorsAlf:Hide()
    GameObjects.RiftDoorsHel:Show()
  end)
  timer.StartLevelTimer(9, function()
    GameObjects.RT_medaillion01_HelheimLit:Show()
    GameObjects.RT_medaillion01_Helheim:Hide()
  end)
end
function MuspelheimFightComplete()
  ShakeRumble()
  ElevatorMoving()
  PlaySoundTowerMoving()
  timer.StartLevelTimer(2, function()
    game.Audio.PlayBanter("Gauntlet_R3_End")
  end)
  timer.StartLevelTimer(12, function()
    game.Audio.PlayBanter("Gauntlet_R4_Start_Musp")
  end)
  timer.StartLevelTimer(23, function()
    game.Audio.PlayBanter("Gauntlet_R3_Start_2trolls")
  end)
  GameObjects.room:SetMaterialSwap("rbr_hel_unlit")
  GameObjects.AlfDoors:SetMaterialSwap("rbr_hel_unlit")
  GameObjects.HelDoors:SetMaterialSwap("rbr_hel_unlit")
  GameObjects.MuspDoors:SetMaterialSwap("rbr_hel_unlit")
  GameObjects.NidDoors:SetMaterialSwap("rbr_hel_unlit")
  GameObjects.DoorFogLeft:PlayAnimToEnd()
  GameObjects.DoorFogRight:PlayAnimToEnd()
  GameObjects.Realm_Lights:PlayAnimToFrame(180)
  GameObjects.fill_lights_room:PlayAnimToFrame(180)
  timer.StartLevelTimer(1, function()
    GameObjects.DoorFog_01.Child:HideParticleEmitter()
    GameObjects.DoorFog_02.Child:HideParticleEmitter()
    GameObjects.DoorFog_03.Child:HideParticleEmitter()
    GameObjects.DoorFog_04.Child:HideParticleEmitter()
  end)
  timer.StartLevelTimer(9, function()
    GameObjects.DoorFog_01.Child:ShowParticleEmitter()
    GameObjects.DoorFog_02.Child:ShowParticleEmitter()
    GameObjects.DoorFog_03.Child:ShowParticleEmitter()
    GameObjects.DoorFog_04.Child:ShowParticleEmitter()
  end)
  GameObjects.RT_medaillion01_HelheimLit:Hide()
  GameObjects.RT_medaillion01_Muspelheim:Show()
  timer.StartLevelTimer(1, function()
    CloseAllCombatDoors()
    AddCameraShakeAndRumbleCallback(GameObjects.MuspDoors)
  end)
  timer.StartLevelTimer(9, function()
    GameObjects.room:SetMaterialSwap("rbr_mus_lit")
    GameObjects.AlfDoors:SetMaterialSwap("rbr_mus_lit")
    GameObjects.HelDoors:SetMaterialSwap("rbr_mus_lit")
    GameObjects.MuspDoors:SetMaterialSwap("rbr_mus_lit")
    GameObjects.NidDoors:SetMaterialSwap("rbr_mus_lit")
    CompletelyOpenAllCombatDoors()
    StopSoundTowerMoving()
    GameObjects.RBR_RoomDust_Hit:JumpAnimToFrame(0)
    GameObjects.RBR_RoomDust_Hit:PlayAnimToEnd()
  end)
  timer.StartLevelTimer(8, function()
    GameObjects.Realm_Lights:PlayAnimToFrame(210)
    GameObjects.fill_lights_room:PlayAnimToFrame(210)
    GameObjects.Cal410_Combat:PlayAnimToFrame(120)
  end)
  timer.StartLevelTimer(9, function()
    GameObjects.RiftDoorsHel:Hide()
    GameObjects.RiftDoorsMusp:Show()
  end)
  timer.StartLevelTimer(9, function()
    GameObjects.RT_medaillion01_MuspelheimLit:Show()
    GameObjects.RT_medaillion01_Muspelheim:Hide()
  end)
end
function ShowCameraVolumes_Win()
  GameObjects.CamZone_AfterFight_010:ShowCameraVolume()
  GameObjects.CamZone_AfterFight_020:ShowCameraVolume()
end
function HideCameraVolumes_Win()
  GameObjects.CamZone_AfterFight_010:HideCameraVolume()
  GameObjects.CamZone_AfterFight_020:HideCameraVolume()
end
function NidavellirFightComplete()
  CSL.PlayDefaultShake("ShakeRumbleMedium")
  PlaySoundGauntletComplete()
  game.Compass.SetDesignerForcedHide(false)
  timer.StartLevelTimer(1, function()
    GameObjects.room:SetMaterialSwap("rbr_mus_unlit")
    GameObjects.AlfDoors:SetMaterialSwap("rbr_mus_unlit")
    GameObjects.HelDoors:SetMaterialSwap("rbr_mus_unlit")
    GameObjects.MuspDoors:SetMaterialSwap("rbr_mus_unlit")
    GameObjects.NidDoors:SetMaterialSwap("rbr_mus_unlit")
  end)
  GameObjects.DoorFogLeft:PlayAnimToFrame(30)
  GameObjects.DoorFogRight:PlayAnimToFrame(30)
  CloseAllCombatDoors()
  AddCameraShakeAndRumbleCallback(GameObjects.NidDoors)
  GameObjects.RT_medaillion01_MuspelheimLit:Hide()
  GameObjects.RT_medaillion01_Muspelheim:Show()
  GameObjects.RBR_RoomDust_Hit:JumpAnimToFrame(0)
  GameObjects.RBR_RoomDust_Hit:PlayAnimToEnd()
  local cameraDuration = 4.2
  local cameraDelay = 0.6
  game.Player:FindPlayer():TriggerMoveEvent("kLEEarthquakeLightTrigger")
  timer.StartLevelTimer(cameraDelay, function()
    ShowCameraVolumes_Win()
    game.SubObject.Wake(thisObj)
  end)
  timer.StartLevelTimer(cameraDelay + cameraDuration, function()
    HideCameraVolumes_Win()
    game.SubObject.Sleep(thisObj)
  end)
  timer.StartLevelTimer(2, function()
    GameObjects.RBR_DoorReady:Show()
    GameObjects.RBR_DoorReady:JumpAnimToFrame(0)
    GameObjects.RBR_DoorReady:PlayAnimToEnd()
  end)
  timer.StartLevelTimer(4, function()
    GameObjects.RT_medaillion01_JotunheimLit:Show()
    GameObjects.RT_medaillion01_Jotunheim:Hide()
  end)
  GameObjects.FXCal410_INT_nocombat:Show()
  GameObjects.FXCal410_INT_combat:Hide()
  GameObjects.DoorFog_01.Child:HideParticleEmitter()
  GameObjects.DoorFog_02.Child:HideParticleEmitter()
  GameObjects.DoorFog_03.Child:HideParticleEmitter()
  GameObjects.DoorFog_04.Child:HideParticleEmitter()
  GameObjects.Realm_Lights:PlayAnimToFrame(240)
  GameObjects.fill_lights_room:PlayAnimToFrame(240)
  GameObjects.Cal410_Combat:PlayAnimToFrame(150)
end
function Checkpoint(timerDummy, override)
end
function Alfheim_Encounter:OnEnter(level)
  thisLevel:CallScript("GauntletEncounter_1")
  gauntletEncounter_1:Reset()
  gauntletEncounter_1:Start()
end
function Alfheim_Encounter:OnExit(level)
  if gauntletEncounter_1:IsRunning() then
    gauntletEncounter_1:DespawnEnemies()
    gauntletEncounter_1:Stop()
  end
end
function Helheim_Encounter:OnEnter(level)
  thisLevel:CallScript("GauntletEncounter_2")
  gauntletEncounter_2:Reset()
  gauntletEncounter_2:Start()
end
function Helheim_Encounter:OnExit(level)
  if gauntletEncounter_2:IsRunning() then
    gauntletEncounter_2:DespawnEnemies()
    gauntletEncounter_2:Stop()
  end
end
function Muspelheim_Encounter:OnEnter(level)
  thisLevel:CallScript("GauntletEncounter_3")
  gauntletEncounter_3:Reset()
  gauntletEncounter_3:Start()
end
function Muspelheim_Encounter:OnExit(level)
  if gauntletEncounter_3:IsRunning() then
    gauntletEncounter_3:DespawnEnemies()
    gauntletEncounter_3:Stop()
  end
end
function Nidavellir_Encounter:OnEnter(level)
  thisLevel:CallScript("GauntletEncounter_4")
  gauntletEncounter_4:Reset()
  gauntletEncounter_4:Start()
end
function Nidavellir_Encounter:OnExit(level)
  if gauntletEncounter_4:IsRunning() then
    gauntletEncounter_4:DespawnEnemies()
    gauntletEncounter_4:Stop()
  end
end
function Midgard_Encounter:OnEnter(level)
end
function Midgard_Encounter:OnExit(level)
end
function GauntletFight_1()
  gauntletEncounter_1 = EC.NewEncounter(thisLevel, "Underworld, Gauntlet 1 Encounter", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_CAL_between_realms_fight_1_in",
    StopMusic = "SND_MX_CAL_between_realms_fight_1_out"
  })
  gauntletEncounter_1:AddWave({
    {
      spawners = "Clone_4_SFG",
      spawnWad = "Cal410_AI_01",
      spawnLocators = "A1_Hel_Loc_01",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 10,
      initialSpawnCooldown = 3.3,
      spawnCooldown = 1
    },
    {
      spawners = "Clone_5_SFG",
      spawnWad = "Cal410_AI_01",
      spawnLocators = "A1_Hel_Loc_03",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 10,
      initialSpawnCooldown = 3.5,
      spawnCooldown = 1.2
    },
    {
      spawners = "Clone_3_SFG",
      spawnWad = "Cal410_AI_01",
      spawnLocators = "A1_Hel_Loc_04",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 10,
      initialSpawnCooldown = 3.7,
      spawnCooldown = 1.5
    },
    {
      spawners = "Clone_4_SFG",
      spawnWad = "Cal410_AI_01",
      spawnLocators = "A1_Hel_Loc_05",
      useSpawnLocatorsOnly = true,
      maxActive = 3,
      totalSpawns = 10,
      initialSpawnCooldown = 4,
      spawnCooldown = 2
    }
  })
  gauntletEncounter_1:OnStart(PlaySoundPortalDoorsIdle)
  gauntletEncounter_1:OnStart(function()
    GameObjects.room:SetMaterialSwap("rbr_nid_lit")
    GameObjects.AlfDoors:SetMaterialSwap("rbr_nid_lit")
    GameObjects.HelDoors:SetMaterialSwap("rbr_nid_lit")
    GameObjects.MuspDoors:SetMaterialSwap("rbr_nid_lit")
    GameObjects.NidDoors:SetMaterialSwap("rbr_nid_lit")
    GameObjects.tower1:FindSingleGOByName("geo"):Hide()
    GameObjects.Lights_Before:PlayAnimToEnd()
    GameObjects.Skydome_FastTravel:Hide()
    GameObjects.DoorFog_01.Child:ShowParticleEmitter()
    GameObjects.DoorFog_02.Child:ShowParticleEmitter()
    GameObjects.DoorFog_03.Child:ShowParticleEmitter()
    GameObjects.DoorFog_04.Child:ShowParticleEmitter()
    GameObjects.Cal410_Combat:ShowParticleEmitter()
    GameObjects.Realm_Lights:ShowLights()
    GameObjects.Realm_Lights:PlayAnimToFrame(30)
    GameObjects.fill_lights_room:PlayAnimToFrame(30)
    GameObjects.Cal410_Combat:PlayAnimToFrame(30)
    GameObjects.RBR_RoomDust_Hit:JumpAnimToFrame(0)
    GameObjects.RBR_RoomDust_Hit:PlayAnimToEnd()
    LD.CompleteQuest("Quest_Caldera_Objective740")
    LD.CallFunctionAfterDelay(ShowObj740UI, 3)
  end)
  gauntletEncounter_1:OnComplete(function()
    timer.StartLevelTimer(10, function()
      EncounterSM:ForwardState()
      game.World.StoreCheckpoint()
    end)
    AlfheimFightComplete()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Projection_Brood")
  end)
  gauntletEncounter_1:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_FrontRight, {element = 1})
  gauntletEncounter_1:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {element = 2})
  gauntletEncounter_1:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_FrontLeft, {element = 3})
  gauntletEncounter_1:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackLeft, {element = 4})
end
function GauntletFight_2()
  gauntletEncounter_2 = EC.NewEncounter(thisLevel, "Underworld, Gauntlet 2 Encounter", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_CAL_between_realms_fight_2_in",
    StopMusic = "SND_MX_CAL_between_realms_fight_2_out"
  })
  gauntletEncounter_2:AddWave({
    {
      spawners = "E_DarkOne_5_SFA",
      spawnLocators = "A1_LW_Loc_02",
      spawnWad = "Cal410_AI_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 26
    },
    {
      spawners = "E_DarkOne_4_SFA",
      spawnLocators = "A1_LW_Loc_01",
      spawnWad = "Cal410_AI_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    },
    {
      spawners = "Flyer_B_SFG",
      spawnLocators = "A1_LW_Loc_05",
      spawnWad = "Cal410_AI_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 40.2
    },
    {
      spawners = "Flyer_B_SFG",
      spawnLocators = "A1_LW_Loc_09",
      spawnWad = "Cal410_AI_02",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 52.3
    }
  })
  gauntletEncounter_2:OnStart(PlaySoundPortalDoorsIdle)
  gauntletEncounter_2:OnStart(function()
    GameObjects.room:SetMaterialSwap("rbr_alf_lit")
    GameObjects.AlfDoors:SetMaterialSwap("rbr_alf_lit")
    GameObjects.HelDoors:SetMaterialSwap("rbr_alf_lit")
    GameObjects.MuspDoors:SetMaterialSwap("rbr_alf_lit")
    GameObjects.NidDoors:SetMaterialSwap("rbr_alf_lit")
  end)
  gauntletEncounter_2:OnEnemySpawn(function(enemy)
    if enemy == nil then
      return
    end
    local EnemyHealth = enemy:GetHitPoints()
    local Health_Phase_1 = EnemyHealth * 0.5
    Enemy_HealthMonitor = monitors.CreateHealthMonitor(enemy)
    Enemy_HealthMonitor:OnHealthLessThan(Health_Phase_1, function()
      gauntletEncounter_2:StartWave()
    end)
  end, {markerID = "Jotunn_01"})
  gauntletEncounter_2:OnComplete(function()
    thisLevel:CallScript("GauntletEncounter_2")
  end, 1)
  gauntletEncounter_2:OnComplete(function()
    timer.StartLevelTimer(9, function()
      EncounterSM:ForwardState()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "32_Underworld_015_FightMidway"]
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
    HelheimFightComplete()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_DarkOne_Elite")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Blind")
  end)
  gauntletEncounter_2:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_FrontLeft, {element = 1})
  gauntletEncounter_2:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackLeft, {element = 2})
  gauntletEncounter_2:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackLeft, {element = 3})
  gauntletEncounter_2:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_FrontRight, {element = 4})
end
function GauntletFight_3()
  gauntletEncounter_3 = EC.NewEncounter(thisLevel, "Underworld, Gauntlet 3 Encounter", {
    CheckpointOnComplete = false,
    StartMusic = "SND_MX_CAL_between_realms_fight_3_in",
    StopMusic = "SND_MX_CAL_between_realms_fight_3_out"
  })
  gauntletEncounter_3:AddWave({
    {
      spawners = "Helwalker_S_SPRINT",
      spawnLocators = "A1_LW_Loc_06",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    },
    {
      spawners = "Helwalker_S_SPRINT",
      spawnLocators = "A1_LW_Loc_07",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Helwalker_SH_SPRINT",
      spawnLocators = "A1_LW_Loc_08",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7
    }
  })
  gauntletEncounter_3:AddWave({
    {
      spawners = "Helwalker_SH_SPRINT",
      spawnLocators = "A1_LW_Loc_08",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Brawler_5_SRFC",
      spawnLocators = "A1_LW_Loc_06",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    },
    {
      spawners = "Brawler_4_SRFC",
      spawnLocators = "A1_LW_Loc_07",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 5
    },
    {
      spawners = "Brawler_4_SRFC",
      spawnLocators = "A1_LW_Loc_08",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 9
    },
    {
      spawners = "Helwalker_S_SPRINT",
      spawnLocators = "A1_LW_Loc_06",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 15
    }
  })
  gauntletEncounter_3:OnStart(PlaySoundPortalDoorsIdle)
  gauntletEncounter_3:OnStart(function()
    GameObjects.room:SetMaterialSwap("rbr_hel_lit")
    GameObjects.AlfDoors:SetMaterialSwap("rbr_hel_lit")
    GameObjects.HelDoors:SetMaterialSwap("rbr_hel_lit")
    GameObjects.MuspDoors:SetMaterialSwap("rbr_hel_lit")
    GameObjects.NidDoors:SetMaterialSwap("rbr_hel_lit")
  end)
  gauntletEncounter_3:OnEnemyDeath(function()
    gauntletEncounter_3:StartWave(2)
  end, {count = 2})
  gauntletEncounter_3:OnCombatStart(function()
    game.Audio.StartMusic("SND_MX_CAL_between_realms_fight_3_in")
  end)
  gauntletEncounter_3:OnComplete(function()
    timer.StartLevelTimer(9, function()
      EncounterSM:ForwardState()
      game.World.StoreCheckpoint()
    end)
    MuspelheimFightComplete()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Hel_Walker_Shield")
  end)
  gauntletEncounter_3:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_FrontLeft, {wave = 1, element = 1})
  gauntletEncounter_3:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackLeft, {wave = 1, element = 2})
  gauntletEncounter_3:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {wave = 1, element = 3})
  gauntletEncounter_3:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {wave = 2, element = 1})
  gauntletEncounter_3:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_FrontLeft, {wave = 2, element = 2})
  gauntletEncounter_3:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackLeft, {wave = 2, element = 3})
  gauntletEncounter_3:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {wave = 2, element = 4})
  gauntletEncounter_3:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_FrontLeft, {wave = 2, element = 5})
end
function GauntletFight_4()
  gauntletEncounter_4 = EC.NewEncounter(thisLevel, "Underworld, Gauntlet 4 Encounter", {CheckpointOnComplete = false})
  gauntletEncounter_4:AddWave({
    {
      spawners = "Jotunn_N_SFG",
      spawnLocators = "A1_RW_Loc_05",
      spawnWad = "Cal410_FinaleTowerFight",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 7
    },
    {
      spawners = "DW_Draugr_L_SPRINT",
      spawnLocators = "A1_RW_Loc_01",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 37
    },
    {
      spawners = "Draugr_P_SPRINT",
      spawnLocators = "A1_RW_Loc_01",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 20
    },
    {
      spawners = "Troll_F_SBO",
      spawnLocators = "A1_RW_Loc_03",
      spawnWad = "Cal410_FinaleTowerFight",
      markerID = "Troll_Gauntlet",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 13.3
    },
    {
      spawners = "S_Draugr_N_SPRINT",
      spawnLocators = "A1_RW_Loc_02",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 30
    },
    {
      spawners = "S_Draugr_N_SPRINT",
      spawnLocators = "A1_RW_Loc_02",
      spawnWad = "Cal410_AI_03",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 32
    }
  })
  gauntletEncounter_4:OnStart(PlaySoundPortalDoorsIdle)
  gauntletEncounter_4:OnStart(function()
    GameObjects.room:SetMaterialSwap("rbr_mus_lit")
    GameObjects.AlfDoors:SetMaterialSwap("rbr_mus_lit")
    GameObjects.HelDoors:SetMaterialSwap("rbr_mus_lit")
    GameObjects.MuspDoors:SetMaterialSwap("rbr_mus_lit")
    GameObjects.NidDoors:SetMaterialSwap("rbr_mus_lit")
    game.Audio.StartMusic("SND_MX_CAL_between_realms_fight_4_in")
  end)
  gauntletEncounter_4:OnEnemySpawn(audioTrollVariation, {
    markerID = "Troll_Gauntlet"
  })
  gauntletEncounter_4:OnComplete(function()
    EncounterSM:ForwardState()
    encounterEndMusic()
    timer.StartLevelTimer(8, function()
      _G.TowerReturn()
    end)
    timer.StartLevelTimer(4, function()
      NidavellirFightComplete()
    end)
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Troll_Daudi_Munr")
  end)
  gauntletEncounter_4:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_FrontRight, {element = 1})
  gauntletEncounter_4:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {element = 2})
  gauntletEncounter_4:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {element = 3})
  gauntletEncounter_4:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {element = 4})
  gauntletEncounter_4:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {element = 5})
  gauntletEncounter_4:OnEnemySpawn(PlaySoundOnEnemySpawnAtDoor_BackRight, {element = 6})
end
function WarpSonBehind()
  local OneMeterBehindKratos = player.WorldPosition - player:GetWorldForward()
  son:Warp(OneMeterBehindKratos, player:GetWorldForward())
end
function PocketRift_On()
  local level = game.FindLevel("Cal410_FinaleTowerFight")
  LD.CallFunctionAfterDelay(function()
    GameObjects.Combat_M_PocketRift_01:Show()
  end, 1.15)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Combat_M_PocketRift_02:Show()
  end, 2.25)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Combat_L_PocketRift_01:Show()
  end, 3.35)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Combat_L_PocketRift_02:Show()
  end, 5.55)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Combat_L_PocketRift_03:Show()
  end, 8.35)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Combat_R_PocketRift_01:Show()
  end, 4.15)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Combat_R_PocketRift_02:Show()
  end, 5.75)
  LD.CallFunctionAfterDelay(function()
    GameObjects.Combat_R_PocketRift_03:Show()
  end, 8.55)
  LD.CallFunctionAfterDelay(function()
    gauntletEncounter_1:Start()
  end, 9)
end
function CompletelyOpenAllCombatDoors()
  GameObjects.AlfDoors:PlayAnimToEnd()
  GameObjects.HelDoors:PlayAnimToEnd()
  GameObjects.MuspDoors:PlayAnimToEnd()
  GameObjects.NidDoors:PlayAnimToEnd()
  PlaySoundPortalDoorsOpen()
end
function OpenAllCombatDoors()
  GameObjects.AlfDoors:PlayAnimToFrame(30)
  GameObjects.HelDoors:PlayAnimToFrame(30)
  GameObjects.MuspDoors:PlayAnimToFrame(30)
  GameObjects.NidDoors:PlayAnimToFrame(30)
end
function PlayShake_DoorFullyClosed()
  local shake = {
    Name = "FSE_SHAKE_GENERIC_MEDIUM_RANGED",
    Duration = 0.5,
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.5}
  }
  game.Blender.Trigger(shake)
  local rumble = {
    Name = "FFB_LARGE",
    TweenIn = {Time = 0},
    TweenOut = {Time = 0.5}
  }
  game.Blender.Trigger(rumble)
end
function CloseAllCombatDoors()
  GameObjects.AlfDoors:PlayAnimToFrame(0, -1)
  GameObjects.HelDoors:PlayAnimToFrame(0, -1)
  GameObjects.MuspDoors:PlayAnimToFrame(0, -1)
  GameObjects.NidDoors:PlayAnimToFrame(0, -1)
  PlaySoundPortalDoorsClose()
end
function AddCameraShakeAndRumbleCallback(gob)
  gob:OnAnimationDone(thisObj, "PlayShake_DoorFullyClosed")
end
local doorEmitters = {
  Front_Left = nil,
  Front_Right = nil,
  Back_Left = nil,
  Back_Right = nil
}
local towerEmitter
local wave4MusicEnd = false
local soundEvents = {
  TowerMovingLP = "SND_MECH_RBR_Tower_Moving_LP",
  GauntletComplete = "SND_MECH_RBR_Tower_Win_cal410",
  DoorOpen = "SND_MECH_RBR_Portal_Door_Open",
  DoorClose = "SND_MECH_RBR_Portal_Door_Close",
  DoorIdleLP = "SND_MECH_RBR_Portal_Door_Idle_LP",
  EnemySpawn = "SND_MECH_RBR_Portal_Door_Enemy_Exit"
}
function SoundInit()
  towerEmitter = GameObjects.SNDGrpJotTower.SoundEmitters[1]
  doorEmitters.Front_Left = GameObjects.SNDGrpPortalDoors:FindSingleSoundEmitterByName("SNDPortalDoor_FL")
  doorEmitters.Front_Right = GameObjects.SNDGrpPortalDoors:FindSingleSoundEmitterByName("SNDPortalDoor_FR")
  doorEmitters.Back_Left = GameObjects.SNDGrpPortalDoors:FindSingleSoundEmitterByName("SNDPortalDoor_BL")
  doorEmitters.Back_Right = GameObjects.SNDGrpPortalDoors:FindSingleSoundEmitterByName("SNDPortalDoor_BR")
end
function PlaySoundGauntletComplete()
  LD.PlaySoundAfterDelay(towerEmitter, soundEvents.GauntletComplete, 2)
end
function PlaySoundTowerMoving(bPlayRumble)
  if bPlayRumble then
    ShakeRumble()
  end
  LD.PlaySound(towerEmitter, soundEvents.TowerMovingLP)
end
function StopSoundTowerMoving()
  LD.StopSound(towerEmitter, soundEvents.TowerMovingLP)
end
function PlaySoundPortalDoorsOpen()
  for _, emitter in pairs(doorEmitters) do
    LD.PlaySound(emitter, soundEvents.DoorOpen)
  end
  PlaySoundPortalDoorsIdle()
end
function PlaySoundPortalDoorsClose()
  for _, emitter in pairs(doorEmitters) do
    LD.PlaySound(emitter, soundEvents.DoorClose)
  end
  StopSoundPortalDoorsIdle()
end
function PlaySoundPortalDoorsIdle()
  for _, emitter in pairs(doorEmitters) do
    LD.PlaySound(emitter, soundEvents.DoorIdleLP)
  end
end
function StopSoundPortalDoorsIdle()
  for _, emitter in pairs(doorEmitters) do
    LD.StopSound(emitter, soundEvents.DoorIdleLP)
  end
end
function PlaySoundOnEnemySpawnAtDoor_FrontLeft()
  PlaySoundOnEnemyExitDoor(doorEmitters.Front_Left)
end
function PlaySoundOnEnemySpawnAtDoor_FrontRight()
  PlaySoundOnEnemyExitDoor(doorEmitters.Front_Right)
end
function PlaySoundOnEnemySpawnAtDoor_BackLeft()
  PlaySoundOnEnemyExitDoor(doorEmitters.Back_Left)
end
function PlaySoundOnEnemySpawnAtDoor_BackRight()
  PlaySoundOnEnemyExitDoor(doorEmitters.Back_Right)
end
function PlaySoundOnEnemyExitDoor(targetEmitter)
  LD.PlaySound(targetEmitter, soundEvents.EnemySpawn)
end
function audioTrollVariation(Enemy)
  game.Audio.SetWwiseSwitch(Enemy, "CHR_Variation", "CHR_Variation_09")
end
function rbrMusicWave4CSTrollDeath(level, obj)
  if gauntletEncounter_4:GetNumEnemiesAlive() == 1 then
    game.Audio.StartMusic("SND_MX_CAL_between_realms_fight_troll_cs_kill")
    wave4MusicEnd = true
  else
    game.Audio.StartMusic("SND_MX_CAL_between_realms_fight_troll_cs_kill")
  end
end
function rbrMusicWave4TrollDeath(level, obj)
  if gauntletEncounter_4:GetNumEnemiesAlive() == 1 then
    game.Audio.StartMusic("SND_MX_CAL_between_realms_fight_4_out")
    wave4MusicEnd = true
  end
end
function rbrMusicWave4JotDeath(level, obj)
  if gauntletEncounter_4:GetNumEnemiesAlive() == 1 then
    game.Audio.StartMusic("SND_MX_CAL_between_realms_fight_4_out")
    wave4MusicEnd = true
  end
end
function rbrMusicWave4CSJotDeath(level, obj)
  if gauntletEncounter_4:GetNumEnemiesAlive() == 1 then
    game.Audio.StartMusic("SND_MX_CAL_between_realms_fight_ogre_cs_kill")
    wave4MusicEnd = true
  end
end
function encounterEndMusic()
  if wave4MusicEnd == false then
    game.Audio.StartMusic("SND_MX_CAL_between_realms_fight_4_out")
  end
end
function ShowObj740UI()
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 716,
    Body = 21381,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
    Quest = "Quest_Caldera_Objective742"
  })
end
