local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local CSL = require("camera.shakelibrary")
local thisLevel, timer_CamZoneBanister, timer_CamZoneSpoolKick
local room1Charged = false
local room2Charged = false
local room3Charged = false
local bRuneChestOpened = false
function OnScriptLoaded(level)
  thisLevel = level
  timer_CamZoneBanister = timers.StartLevelTimer(1.5)
  timer_CamZoneBanister:Stop()
  timer_CamZoneSpoolKick = timers.StartLevelTimer(1.5)
  timer_CamZoneSpoolKick:Stop()
  SoundInit()
end
function OnFirstStart()
  ShowNonCombat()
  HideAllShrooms()
  GameObjects.MainRoom_Encounter:Hide()
  GameObjects.Door6.LuaObjectScript.ForceDoorOpen()
  GameObjects.Door6.LuaObjectScript.Disable()
  GameObjects.alcoveA:Hide()
  GameObjects.alcoveB:Hide()
  GameObjects.alcoveC:Hide()
  GameObjects.alcoveD:Hide()
  GameObjects.alcoveE:Hide()
  GameObjects.alcoveF:Hide()
  GameObjects.fire_torus_roomA:Hide()
  GameObjects.fire_torus_roomB:Hide()
  GameObjects.fire_torus_roomC:Hide()
  DisableRuneVaultSonCollision()
  GameObjects.Room1RootLights:Hide()
  GameObjects.Room2RootLights:Hide()
  GameObjects.Room3RootLights:Hide()
  GameObjects.Room1_Door_RootLights:Hide()
  GameObjects.Room2_Door_RootLights:Hide()
  GameObjects.Room3_Door_RootLights:Hide()
  GameObjects.Room1_Door_RootLights_Pulse:PlayAnimationCycle()
  GameObjects.Room2_Door_RootLights_Pulse:Hide()
  GameObjects.Room3_Door_RootLights_Pulse:Hide()
  GameObjects.RSV_FloorReveal:Hide()
  GameObjects.Balcony_Gate_Broken:Hide()
  GameObjects.GI_MainRoom1FireGlow:Hide()
  GameObjects.GI_MainRoom2FireGlow:Hide()
  GameObjects.GI_MainRoom3FireGlow:Hide()
  GameObjects.Iris_Slices:JumpAnimationToPercent(1)
  GameObjects.Magnet_anim:JumpAnimationToFrame(0)
  GameObjects.Magnet_anim:PauseAnimation()
  GameObjects.WT_ExitFloor_Broken:Hide()
  GameObjects.TVVisOffDoor2:Hide()
  TurnOnRoom1()
end
function OnStart(level, obj)
  ShowNonCombat()
  GameObjects.chest_locked_tier4_cal500_1:FindSingleGOByName("ChestScript_RN").LuaObjectScript.DisableCheckpointRequirement()
  GameObjects.trap_stomper1.LuaObjectScript.SetHorizontalKillFrameOffset(0)
  GameObjects.trap_stomper2.LuaObjectScript.SetHorizontalKillFrameOffset(0)
  GameObjects.trap_stomper1.LuaObjectScript.SetCloseFrameCheckOffset(3)
  GameObjects.trap_stomper2.LuaObjectScript.SetCloseFrameCheckOffset(3)
  GameObjects.trap_stomper1.LuaObjectScript.OverrideHorizontalUnwalkableFrame(10)
  GameObjects.trap_stomper2.LuaObjectScript.OverrideHorizontalUnwalkableFrame(10)
  if room2Charged then
    GameObjects.trap_stomper2.LuaObjectScript.ForceOpenCrusher()
    GameObjects.trap_stomper1.LuaObjectScript.ForceCloseCrusher()
    GameObjects.trap_stomper1.Child.LuaObjectScript.Enable(true)
    timers.StartLevelTimer(0.25, function()
      GameObjects.trap_stomper2.Child.LuaObjectScript.Enable(true)
    end)
  end
  if bRuneChestOpened then
    GameObjects.trap_stomper1:FindSingleGOByName("Crusher_Gnome_1"):Hide()
  else
    local Gnome = GameObjects.GnomeTarget_LargeA.Child:GetBreakable()
    Gnome:HideBehaviors()
    Gnome:HideCollision()
    Gnome:Hide()
    Gnome = GameObjects.GnomeTarget_LargeC.Child:GetBreakable()
    Gnome:HideBehaviors()
    Gnome:HideCollision()
    Gnome:Hide()
  end
  if room3Charged then
    GameObjects.WolvesDiscovered.LuaObjectScript.Disable()
  end
  LockFrontDoor()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  if cal590 then
    cal590:CallScript("CheckIfElevatorIsAtBottom", GameObjects.SpreadDoor_Rune.Child)
  end
  SetScarabPreIdle()
  SetSgianIdle()
  SoundOnStart()
end
function OnWadLoaded(level, newLevel)
  if newLevel.Name == "WAD_Cal590_RuneVaultElevator" then
    newLevel:CallScript("CheckIfElevatorIsAtBottom", GameObjects.SpreadDoor_Rune.Child)
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    room1Charged = room1Charged,
    room2Charged = room2Charged,
    room3Charged = room3Charged,
    bRuneChestOpened = bRuneChestOpened
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  room1Charged = savedInfo.room1Charged
  room2Charged = savedInfo.room2Charged
  room3Charged = savedInfo.room3Charged
  bRuneChestOpened = savedInfo.bRuneChestOpened
end
function MakeSureLoaded()
  game.UI.LoadCheck("Cal100_Hub")
end
function RuneChestOpened()
  bRuneChestOpened = true
  game.FindLevel("Cal512_RuneVaultHalls2"):CallScript("RuneChestOpened")
end
function CheckpointRuneChest()
  game.World.StoreCheckpoint(GameObjects.CheckpointOverride_Chest)
end
function TurnOnFire()
  GameObjects.EntranceFloorPlate:PlayAnimationToEnd()
  FireFloorShakeAndRumble()
  timers.StartLevelTimer(2, function()
    GameObjects.Magnet_anim:PlayAnimationToEnd()
  end)
  GameObjects.calderaCenterChain00.LuaObjectScript.StartFloorAnim()
  local delay = 0.25
  timers.StartLevelTimer(delay, function()
    GameObjects.alcoveA:Show()
    GameObjects.alcoveA:PlayAnimToEnd()
    GameObjects.alcoveF:Show()
    GameObjects.alcoveF:PlayAnimToEnd()
  end)
  timers.StartLevelTimer(2 * delay, function()
    GameObjects.alcoveB:Show()
    GameObjects.alcoveB:PlayAnimToEnd()
    GameObjects.alcoveE:Show()
    GameObjects.alcoveE:PlayAnimToEnd()
  end)
  timers.StartLevelTimer(3 * delay, function()
    GameObjects.alcoveC:Show()
    GameObjects.alcoveC:PlayAnimToEnd()
    GameObjects.alcoveD:Show()
    GameObjects.alcoveD:PlayAnimToEnd()
  end)
  local uiCalls = require("ui.uicalls")
  uiCalls.UI_Event_DiscoverLocation("TyrsVault")
  game.Audio.StartMusic("SND_MX_CAL_vault_main_room_reveal")
  PlaySoundRingsIntro()
end
function DisableRevive()
  game.Player.FindPlayer():CallScript("LuaHook_DisableRevive", true)
end
function EnableRevive()
  game.Player.FindPlayer():CallScript("LuaHook_DisableRevive", false)
end
function TurnOnTunnel2()
  GameObjects.Room1_Door_RootLights_Pulse:Hide()
  GameObjects.Room1_Door_RootLights:Show()
  GameObjects.Room1_Door_RootLights:PlayAnimationToEnd()
  GameObjects.Room2_Door_RootLights_Pulse:Show()
  GameObjects.Room2_Door_RootLights_Pulse:PlayAnimationCycle()
  GameObjects.Room2_Door_RootLights:PlayAnimationToEnd()
end
function TurnOnTunnel3()
  GameObjects.Room2_Door_RootLights_Pulse:Hide()
  GameObjects.Room2_Door_RootLights:Show()
  GameObjects.Room2_Door_RootLights:PlayAnimationToEnd()
  GameObjects.Room3_Door_RootLights_Pulse:Show()
  GameObjects.Room3_Door_RootLights_Pulse:PlayAnimationCycle()
  GameObjects.Room3_Door_RootLights:Hide()
  GameObjects.Room3_Door_RootLights:PlayAnimationToEnd()
end
function TurnOnRoom1()
  GameObjects.fire_torus_roomA:Show()
  GameObjects.fire_torus_roomA:PlayAnimToEnd()
  GameObjects.GI_MainRoom1FireGlow:Show()
  GameObjects.GI_MainRoom1FireGlow:PlayAnimationToFrame(30, {Rate = 0.25})
  GameObjects.GI_MainRoom1FireGlow:OnAnimationDone(thisLevel, "RepeatRoom1Flicker", {Force = true})
end
function RepeatRoom1Flicker()
  GameObjects.GI_MainRoom1FireGlow:JumpAnimationToFrame(30)
  GameObjects.GI_MainRoom1FireGlow:PlayAnimationToFrame(120)
  GameObjects.GI_MainRoom1FireGlow:OnAnimationDone(thisLevel, "RepeatRoom1Flicker", {Force = true})
end
function TurnOnRoom2()
  GameObjects.fire_torus_roomB:Show()
  GameObjects.fire_torus_roomB:PlayAnimToEnd()
  GameObjects.GI_MainRoom2FireGlow:Show()
  GameObjects.GI_MainRoom2FireGlow:PlayAnimationToFrame(30, {Rate = 0.25})
  GameObjects.GI_MainRoom2FireGlow:OnAnimationDone(thisLevel, "RepeatRoom2Flicker", {Force = true})
end
function RepeatRoom2Flicker()
  GameObjects.GI_MainRoom2FireGlow:JumpAnimationToFrame(30)
  GameObjects.GI_MainRoom2FireGlow:PlayAnimationToFrame(120)
  GameObjects.GI_MainRoom2FireGlow:OnAnimationDone(thisLevel, "RepeatRoom2Flicker", {Force = true})
end
function TurnOnRoom3()
  GameObjects.fire_torus_roomC:Show()
  GameObjects.fire_torus_roomC:PlayAnimToEnd()
  TurnOnTunnel3()
  GameObjects.GI_MainRoom3FireGlow:Show()
  GameObjects.GI_MainRoom3FireGlow:PlayAnimationToFrame(30, {Rate = 0.25})
  GameObjects.GI_MainRoom3FireGlow:OnAnimationDone(thisLevel, "RepeatRoom3Flicker", {Force = true})
end
function RepeatRoom3Flicker()
  GameObjects.GI_MainRoom3FireGlow:JumpAnimationToFrame(30)
  GameObjects.GI_MainRoom3FireGlow:PlayAnimationToFrame(120)
  GameObjects.GI_MainRoom3FireGlow:OnAnimationDone(thisLevel, "RepeatRoom3Flicker", {Force = true})
end
function DiscoverWolves()
  game.Audio.PlayBanter("235_WolvesDiscovered")
  GameObjects.Door3.LuaObjectScript.Disable()
  timers.StartLevelTimer(8, function()
    GameObjects.Door3.LuaObjectScript.Enable()
  end)
end
function OpenDoor3()
  GameObjects.Door3.LuaObjectScript.ForceDoorOpen(false, 0.5)
  HideDoor3Zones()
end
function AnimateRoom(number)
  for i = 0, 15 do
    local root = thisLevel:FindGameObject("Room" .. tostring(number) .. "_Root_0" .. tostring(i))
    if root then
      timers.StartLevelTimer(i * 0.4, function()
        AnimateChildren(root)
      end)
    end
  end
end
function HideAllShrooms()
  HideRoomShrooms(1)
  HideRoomShrooms(2)
  HideRoomShrooms(3)
  HideShrooms(GameObjects.Room1_DoorFrame)
  HideShrooms(GameObjects.Room2_DoorFrame)
  HideShrooms(GameObjects.Room3_DoorFrame)
end
function HideRoomShrooms(number)
  for i = 0, 15 do
    local root = thisLevel:FindGameObject("Room" .. tostring(number) .. "_Root_0" .. tostring(i))
    if root then
      HideShrooms(root)
    end
  end
end
function HideShrooms(root)
  for _, child in ipairs(root.Children) do
    for _, object in ipairs(child.Children) do
      if string.match(object:GetName(), "shroom") then
        object.Child:Hide()
        object.Child:JumpAnimationToFrame(0)
        object.Child:PauseAnimation()
      end
    end
  end
end
function AnimateChildren(root)
  for _, child in ipairs(root.Children) do
    for _, object in ipairs(child.Children) do
      if string.match(object:GetName(), "shroom") then
        object.Child:Show()
        object.Child:PlayAnimationToEnd()
      else
        object:PlayAnimationToEnd()
      end
    end
  end
end
function ChargeRoom1()
  if not room1Charged then
    AnimateChildren(GameObjects.Room1_DoorFrame)
    GameObjects.Room1_Door_RootLights:Show()
    GameObjects.Room1_Door_RootLights:PlayAnimationToEnd()
    local cal510 = game.FindLevel("Cal510_RuneVaultHalls")
    if cal510 then
      cal510:CallScript("StartSawHall")
      PlaySoundRoom1Cal500Traps()
    end
    GameObjects.FlipSwitch1.LuaObjectScript.Flip()
    GameObjects.sonContext_control.LuaObjectScript.Charge1Dumped()
    room1Charged = true
    GameObjects.room1RootCol:HideCollision()
    timers.StartLevelTimer(1, function()
      GameObjects.Room1RootLights:Show()
      GameObjects.Room1RootLights:JumpAnimationToFrame(0)
      GameObjects.Room1RootLights:PlayAnimationToEnd({Rate = 0.25})
      AnimateRoom(1)
      BookMarkRooms("23_RuneVault_030_Room1", GameObjects.CheckpointOverride_Room1)
    end)
  end
end
function FireFloorShakeAndRumble()
  CSL.PlayShake("FFB_GENERIC_RUMBLE_MEDIUM", 0.1, 0, 1)
  game.Blender.Trigger({
    Name = "FSE_SWAY_CATCH",
    Duration = 2,
    TweenIn = {Time = 0.2},
    TweenOut = {Time = 4},
    Weight = 0.1
  })
end
function ChargeRoom2()
  if not room2Charged then
    local cal512 = game.FindLevel("Cal512_RuneVaultHalls2")
    if cal512 then
      cal512:CallScript("StartStompers")
    end
    AnimateChildren(GameObjects.Room2_DoorFrame)
    room2Charged = true
    GameObjects.FlipSwitch2.LuaObjectScript.Flip()
    GameObjects.sonContext_control.LuaObjectScript.Charge2Dumped()
    GameObjects.trap_stomper2.Child.LuaObjectScript.Enable(true)
    GameObjects.Room2_Door_RootLights:Show()
    GameObjects.Room2_Door_RootLights:PlayAnimationToEnd()
    GameObjects.room2RootCol:HideCollision()
    timers.StartLevelTimer(0.25, function()
      GameObjects.trap_stomper1.Child.LuaObjectScript.Enable(true)
    end)
    timers.StartLevelTimer(1, function()
      GameObjects.Room2RootLights:Show()
      GameObjects.Room2RootLights:JumpAnimationToFrame(0)
      GameObjects.Room2RootLights:PlayAnimationToEnd({Rate = 0.25})
      AnimateRoom(2)
      BookMarkRooms("23_RuneVault_040_Room2", GameObjects.CheckpointOverride_Room2)
    end)
  end
end
function LoadCheckRight()
  game.UI.LoadCheck("Cal510_RuneVaultHalls")
end
function LoadCheckLeft()
  game.UI.LoadCheck("Cal512_RuneVaultHalls2")
end
function LoadCheckMid()
  game.UI.LoadCheck("Cal510_RuneVaultHalls")
  game.UI.LoadCheck("Cal512_RuneVaultHalls2")
end
function ChargeRoom3()
  if not room3Charged then
    GameObjects.Room3_Door_RootLights_Pulse:Hide()
    GameObjects.Room3_Door_RootLights:Show()
    GameObjects.Room3_Door_RootLights:PlayAnimationToEnd()
    room3Charged = true
    GameObjects.FlipSwitch3.LuaObjectScript.Flip()
    AnimateChildren(GameObjects.Room3_DoorFrame)
    GameObjects.sonContext_control.LuaObjectScript.Charge3Dumped()
    GameObjects.WolvesDiscovered.LuaObjectScript.Disable()
    GameObjects.Room3_Door_RootLights:Show()
    GameObjects.room3RootCol:HideCollision()
    timers.StartLevelTimer(1, function()
      AnimateRoom(3)
      GameObjects.Room3RootLights:Show()
      GameObjects.Room3RootLights:JumpAnimationToFrame(0)
      GameObjects.Room3RootLights:PlayAnimationToEnd({Rate = 0.25})
      BookMarkRooms("23_RuneVault_050_Room3", GameObjects.CheckpointOverride_Room3)
    end)
  end
end
function EnterElevator()
  GameObjects.sonContext_control.LuaObjectScript.DisableSphereLook()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  cal590:CallScript("EnterBelow")
end
function ExitElevator()
  GameObjects.sonContext_control.LuaObjectScript.EnableSphereLook()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  cal590:CallScript("ExitBelow")
end
function OnCrackClimb()
  GameObjects.RuneVault_Btr_Group.LuaObjectScript.FoundCrackClimb()
end
function ElevatorLoadCheck()
  game.UI.LoadCheck("Cal590_RuneVaultElevator")
end
function BookMarkRooms(newbookmark, overrideObject)
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. newbookmark]
  tableEntry.OverrideObject = overrideObject
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function Crack1()
  GameObjects.Root_part_01:PlayAnimToEnd()
  PlaySoundFallingStone_1()
end
function Crack2()
  GameObjects.Root_part_02:PlayAnimToEnd()
  PlaySoundFallingStone_2()
end
function Crack3()
  GameObjects.Root_part_03:PlayAnimToEnd()
  PlaySoundFallingStone_3()
end
function DisableRuneVaultSonCollision()
  GameObjects.sonFloorCollision:HideCollision()
end
function EnableRuneVaultSonCollision()
  GameObjects.sonFloorCollision:ShowCollision()
end
function PastElevatorDoor()
  GameObjects.Son_RunToBowl.LuaObjectScript.Disable()
end
function OpenIris()
  GameObjects.Iris_Slices:PlayAnimToEnd()
end
function LockFrontDoor()
  GameObjects.SpreadDoor_Rune.LuaObjectScript.Disable()
end
function UnlockFrontDoor()
  GameObjects.SpreadDoor_Rune.LuaObjectScript.Enable()
end
function CloseIris()
  LD.PlaySoundOnFrame(GameObjects.SNDGrpMainRoomFloorCenter.SoundEmitters[1], GameObjects.Iris_Slices, "SND_MECH_Cal500_RuneStone_Platform_Close_Rise", 110, "backward")
  GameObjects.Iris_Slices:PlayAnimToEnd(-0.5)
  GameObjects.Cine_FathersKnife:ShowEntityVolume()
  GameObjects.RuneVault_Btr_Group.LuaObjectScript.WolfTrapPuzzleComplete()
  GameObjects.Iris_Slices:OnAnimationDone(thisLevel, "CheckpointRoom3Done")
end
function CheckpointRoom3Done()
  local bookmarks = require("design.Bookmarks")
  local tableEntry = bookmarks["BOOKMARK_" .. "23_RuneVault_060_Room3Done"]
  game.World.StoreCheckpointAndBookmark(tableEntry)
end
function HideNonCombat()
  GameObjects.MainRoom_Encounter:Show()
  GameObjects.MainRoom_Bot:Hide()
  GameObjects.MainRoom_BotFX:Hide()
  GameObjects.Room1RootLights:Hide()
  GameObjects.Room2RootLights:Hide()
  GameObjects.Room3RootLights:Hide()
end
function ShowNonCombat()
  GameObjects.MainRoom_Encounter:Hide()
  GameObjects.MainRoom_Bot:Show()
  GameObjects.MainRoom_BotFX:Show()
  GameObjects.Room1RootLights:Show()
  GameObjects.Room2RootLights:Show()
  GameObjects.Room3RootLights:Show()
end
function PlayRuneReadBanter_Cal500()
  local PlayFollowUpBanter = function()
    local gyroScript = GameObjects.calderaCenterChain00.LuaObjectScript
    local outerLit = gyroScript.GetRingOuterLit()
    local middleLit = gyroScript.GetRingMiddleLit()
    local innerLit = gyroScript.GetRingInnerLit()
    if innerLit and not middleLit and not outerLit then
      game.Audio.PlayBanter("Cal500_RuneGraffiti_03")
    elseif not innerLit and not middleLit and outerLit then
      game.Audio.PlayBanter("Cal500_RuneGraffiti_04")
    elseif not innerLit and not middleLit and not outerLit then
      game.Audio.PlayBanter("Cal500_RuneGraffiti_04")
    elseif innerLit and middleLit and outerLit then
      game.Audio.PlayBanter("Cal500_RuneGraffiti_02")
    else
      game.Audio.PlayBanter("Cal500_RuneGraffiti_01")
    end
  end
  game.Audio.PlayBanter("Cal500_RuneGraffiti", PlayFollowUpBanter)
end
function Break_Gnome_01()
  local Gnome = GameObjects.GnomeTarget_LargeA.Child:GetBreakable()
  Gnome:Show()
  timers.StartLevelTimer(0.25, function()
    Gnome_01_FinishBreak()
  end)
end
function Gnome_01_FinishBreak()
  local Gnome = GameObjects.GnomeTarget_LargeA.Child:GetBreakable()
  if Gnome.Broken == false then
    Gnome:Break()
  end
end
function Break_Gnome_03()
  local Gnome = GameObjects.GnomeTarget_LargeC.Child:GetBreakable()
  Gnome:Show()
  timers.StartLevelTimer(0.25, function()
    Gnome_03_FinishBreak()
  end)
end
function Gnome_03_FinishBreak()
  local Gnome = GameObjects.GnomeTarget_LargeC.Child:GetBreakable()
  if Gnome.Broken == false then
    Gnome:Break()
  end
end
function ThirdRingExposed()
  local gyroScript = GameObjects.calderaCenterChain00.LuaObjectScript
  return gyroScript.GetRingInnerLit() and not gyroScript.GetRingMiddleLit() and not gyroScript.GetRingOuterLit()
end
local gateSet1Emitters = {}
local gateSet1State = "rest"
local gateSet2Emitters = {}
local gateSet2State = "rest"
local gateSoundLoop = "SND_DOOR_Rune_Vault_Lift_Door_LP"
local gateSoundStart = "SND_DOOR_Rune_Vault_Lift_Door_Start"
local gateSoundStop = "SND_DOOR_Rune_Vault_Lift_Door_Stop"
local SND_Falling_Stone_1, SND_Falling_Stone_2, SND_Falling_Stone_3, SND_Stone_Rubble_1, SND_Stone_Rubble_2, SND_Stone_Rubble_3, SND_Stone_Rubble_4, flipSwitch3CrankScript
local SpreadDoorRune_SoundOverrides = {
  isLooping = false,
  OnInteractForward_Center = "",
  OnInteractForward_Left = "SND_DOOR_Rune_Vault_SpreadDoor_PryOpen_L",
  OnInteractForward_Right = "SND_DOOR_Rune_Vault_SpreadDoor_PryOpen_R",
  OnInteractBackward_Center = "",
  OnInteractBackward_Left = "SND_DOOR_Rune_Vault_SpreadDoor_PryOpen_L",
  OnInteractBackward_Right = "SND_DOOR_Rune_Vault_SpreadDoor_PryOpen_R",
  OnInteractClose_Center = "",
  OnInteractClose_Left = "",
  OnInteractClose_Right = ""
}
local liftGateSoundOverrides = {
  OnInteract_Start = "SND_DOOR_Rune_Vault_Lift_Up",
  OnInteract_Scrape_LP = "",
  OnForceOpen_Start = "SND_DOOR_Rune_Vault_Lift_Door_Start",
  OnForceOpen_StartFrame = 38,
  OnForceOpen_Stop = "SND_DOOR_Rune_Vault_Lift_Door_Stop",
  OnForceOpen_StopFrame = 112,
  OnForceOpen_LP = "SND_DOOR_Rune_Vault_Lift_Door_LP",
  OnForceClose_Start = "SND_DOOR_Rune_Vault_Lift_Door_Start",
  OnForceClose_StartFrame = 112,
  OnForceClose_Stop = "SND_DOOR_Rune_Vault_Lift_Door_Stop",
  OnForceClose_StopFrame = 38,
  OnForceClose_LP = "SND_DOOR_Rune_Vault_Lift_Door_LP"
}
function SoundInit()
  local doors = thisLevel:FindGameObjects("Door_Gate_1*")
  if doors ~= nil then
    for i = 1, #doors do
      gateSet1Emitters[i] = doors[i]:FindSingleGOByName("door_gate_a_root"):FindSingleSoundEmitterByName("SNDVaultGate")
    end
  end
  doors = thisLevel:FindGameObjects("Door_Gate_2*")
  if doors ~= nil then
    for i = 1, #doors do
      gateSet2Emitters[i] = doors[i]:FindSingleGOByName("door_gate_a_root"):FindSingleSoundEmitterByName("SNDVaultGate")
    end
  end
  SND_Falling_Stone_1 = GameObjects.Root_part_01:FindSingleSoundEmitterByName("SNDFallingStone1")
  SND_Falling_Stone_2 = GameObjects.Root_part_02:FindSingleSoundEmitterByName("SNDFallingStone2")
  SND_Falling_Stone_3 = GameObjects.Root_part_03:FindSingleSoundEmitterByName("SNDFallingStone3")
  SND_Stone_Rubble_1 = GameObjects.Root_part_01:FindSingleSoundEmitterByName("SNDStoneRubblePile01")
  SND_Stone_Rubble_2 = GameObjects.Root_part_02:FindSingleSoundEmitterByName("SNDStoneRubblePile02")
  SND_Stone_Rubble_3 = GameObjects.Root_part_03:FindSingleSoundEmitterByName("SNDStoneRubblePile03")
  SND_Stone_Rubble_4 = GameObjects.Root_part_03:FindSingleSoundEmitterByName("SNDStoneRubblePile04")
  flipSwitch3CrankScript = GameObjects.FlipSwitch3:FindSingleGOByName("WheelCrank").LuaObjectScript
end
function SoundOnStart()
  GameObjects.SpreadDoor_Rune.LuaObjectScript.SoundSetup(SpreadDoorRune_SoundOverrides)
  GameObjects.Door1.LuaObjectScript.SoundSetup(liftGateSoundOverrides)
  GameObjects.Door2.LuaObjectScript.SoundSetup(liftGateSoundOverrides)
  GameObjects.Door3.LuaObjectScript.SoundSetup(liftGateSoundOverrides)
  GameObjects.Door6.LuaObjectScript.SoundSetup(liftGateSoundOverrides)
  GameObjects.Door2.LuaObjectScript.RegisterOnStartOpenCallback(HideDoor2Zones)
  GameObjects.Door3.LuaObjectScript.RegisterOnStartOpenCallback(HideDoor3Zones)
  if room1Charged then
    PlaySoundRoom1Cal500Traps()
  end
end
function PlaySoundRingsIntro()
  LD.PlaySound(GameObjects.calderaCenterChain00.Child.SoundEmitters[1], "SND_MAG_RuneVault_Rings_Intro")
end
function PlaySoundRoom1Cal500Traps()
  local room1Cal500Traps = thisLevel:FindGameObjects("trap_flip*")
  for _, trap in ipairs(room1Cal500Traps) do
    trap.LuaObjectScript.Start()
  end
end
function PlaySoundFallingStone_1()
  LD.PlaySound(SND_Falling_Stone_1, "SND_BRK_Stone_Pile_01")
  LD.PlaySoundOnFrame(SND_Stone_Rubble_1, GameObjects.Root_part_01, "SND_BRK_Stone_Rubble_Pile_01", 65)
end
function PlaySoundFallingStone_2()
  LD.PlaySound(SND_Falling_Stone_2, "SND_BRK_Stone_Pile_01")
  LD.PlaySoundOnFrame(SND_Stone_Rubble_2, GameObjects.Root_part_02, "SND_BRK_Stone_Rubble_Pile_02", 72)
end
function PlaySoundFallingStone_3()
  LD.PlaySound(SND_Falling_Stone_3, "SND_BRK_Stone_Pile_01")
  LD.PlaySoundOnFrame(SND_Stone_Rubble_3, GameObjects.Root_part_03, "SND_BRK_Stone_Rubble_Pile_03", 80)
  LD.PlaySoundOnFrame(SND_Stone_Rubble_4, GameObjects.Root_part_03, "SND_BRK_Stone_Rubble_Pile_01", 108)
end
function PlaySoundOnGateForward_Set1()
  if gateSet1State ~= "forward" then
    PlaySoundGateLoop(1)
    gateSet1State = "forward"
  end
end
function PlaySoundOnGateBackward_Set1()
  if gateSet1State ~= "backward" then
    PlaySoundGateLoop(1)
    gateSet1State = "backward"
  end
end
function PlaySoundOnGateRewind_Set1()
  if gateSet1State ~= "rewind" then
    PlaySoundGateLoop(1)
    gateSet1State = "rewind"
  end
end
function StopSoundOnGatePaused_Set1()
  if gateSet1State ~= "rest" then
    StopSoundGateLoop(1)
    gateSet1State = "rest"
  end
end
function StopSoundOnAttach_Set1()
  if gateSet1State == "rewind" then
    StopSoundGateLoop(1)
    gateSet1State = "rest"
  end
end
function PlaySoundOnGateForward_Set2()
  if gateSet2State ~= "forward" then
    PlaySoundGateLoop(2)
    gateSet2State = "forward"
  end
end
function PlaySoundOnGateBackward_Set2()
  if gateSet2State ~= "backward" then
    PlaySoundGateLoop(2)
    gateSet2State = "backward"
  end
end
function PlaySoundOnGateRewind_Set2()
  if gateSet2State ~= "rewind" then
    PlaySoundGateLoop(2)
    gateSet2State = "rewind"
  end
end
function StopSoundOnGatePaused_Set2()
  if gateSet2State ~= "rest" then
    StopSoundGateLoop(2)
    gateSet2State = "rest"
  end
end
function StopSoundOnAttach_Set2()
  if gateSet2State == "rewind" then
    StopSoundGateLoop(2)
    gateSet2State = "rest"
  end
end
function PlaySoundGateLoop(targetGateSetNumber)
  if targetGateSetNumber ~= nil then
    local targetGateEmitters
    if targetGateSetNumber == 1 then
      targetGateEmitters = gateSet1Emitters
    elseif targetGateSetNumber == 2 then
      targetGateEmitters = gateSet2Emitters
    end
    if targetGateEmitters ~= nil then
      for i = 1, #targetGateEmitters do
        LD.PlaySound(targetGateEmitters[i], gateSoundStart, true)
        LD.PlaySound(targetGateEmitters[i], gateSoundLoop, true)
      end
    end
  end
end
function StopSoundGateLoop(targetGateSetNumber)
  if targetGateSetNumber ~= nil then
    local targetGateEmitters
    if targetGateSetNumber == 1 then
      targetGateEmitters = gateSet1Emitters
    elseif targetGateSetNumber == 2 then
      targetGateEmitters = gateSet2Emitters
    end
    if targetGateEmitters ~= nil then
      for i = 1, #targetGateEmitters do
        LD.PlaySound(targetGateEmitters[i], gateSoundStop, true)
        LD.StopSound(targetGateEmitters[i], gateSoundLoop, true)
      end
    end
  end
end
function PlaySoundOnSwitch3FinalCrank()
  if flipSwitch3CrankScript.GetCurrentCycle() == 6 then
    GameObjects.FlipSwitch3.LuaObjectScript.PlayTrapSound()
  end
end
local traphall1Music = false
local traphall2Music = false
local exitRoom1 = false
local exitRoom2 = false
local hall1Music = false
local hall2Music = false
function Door_Gate_1bMusic()
  game.Audio.StartMusic("SND_MX_CAL_vault_trap_hall_1_in")
  traphall1Music = true
end
function afterSawsMusic()
  game.Audio.StartMusic("SND_MX_CAL_vault_trap_hall_1_out")
  hall1Music = true
end
function room1ExitMusic()
  if traphall1Music == true and hall1Music == false then
    game.Audio.StartMusic("SND_MX_TRANS_TO_IDLE")
    exitRoom1 = true
    traphall1Music = false
  end
end
function room1hallreenterMusic()
  if exitRoom1 == true and traphall1Music == false and hall1Music == false then
    game.Audio.StartMusic("SND_MX_CAL_vault_trap_hall_1_in")
    traphall1Music = true
    exitRoom1 = false
  end
end
function Door_Gate_2bMusic()
  game.Audio.StartMusic("SND_MX_CAL_vault_trap_hall_2_in")
  traphall2Music = true
end
function afterCrushersMusic()
  game.Audio.StartMusic("SND_MX_CAL_vault_trap_hall_2_out")
  hall2Music = true
end
function room2ExitMusic()
  if traphall2Music == true and hall2Music == false then
    game.Audio.StartMusic("SND_MX_TRANS_TO_IDLE")
    exitRoom2 = true
    traphall2Music = false
  end
end
function room2hallreenterMusic()
  if exitRoom2 == true and traphall2Music == false and hall2Music == false then
    game.Audio.StartMusic("SND_MX_CAL_vault_trap_hall_2_in")
    traphall2Music = true
    exitRoom2 = false
  end
end
function HideDoor2Zones()
  local cal050 = game.FindLevel("Cal050_Sound")
  if cal050 ~= nil then
    cal050:CallScript("HideDoor2Zones")
  end
end
function HideDoor3Zones()
  local cal050 = game.FindLevel("Cal050_Sound")
  if cal050 ~= nil then
    cal050:CallScript("HideDoor3Zones")
  end
end
function SetSgianIdle()
  local sgian = GameObjects.scotlandPOI.Child
  sgian:JumpAnimationToFrame(0, {
    Animation = "poiRuneScotland020Scene"
  })
  sgian:PauseAnimation()
end
function CheckReenableScotland()
  if game.Audio.CanBanterConversationPlay("140_Scotland") then
    GameObjects.ScotlandInteract.LuaObjectScript.Enable()
  end
end
function AbandonScotland()
  GameObjects.ScotlandInteract.LuaObjectScript.Disable()
  SetSgianIdle()
end
function ScotlandDone()
  SetSgianIdle()
end
function MakePOIsUnavailable()
  GameObjects.ScotlandInteract.LuaObjectScript.Disable()
  GameObjects.EgyptInteract.LuaObjectScript.Disable()
end
function CheckReenablePOIs()
  CheckReenableEgypt()
  CheckReenableScotland()
end
function SetScarabPreIdle()
  local scarab = GameObjects.EgyptianScarab00_Top.Child
  scarab:JumpAnimationToFrame(0, {
    Animation = "poiRuneEgypt020Scene"
  })
  scarab:PauseAnimation()
end
function SetScarabPostIdle()
  local scarab = GameObjects.EgyptianScarab00_Top.Child
  scarab:JumpAnimationToFrame(0, {
    Animation = "poiRuneEgypt020_postIdle"
  })
  scarab:PauseAnimation()
end
function CheckReenableEgypt()
  if game.Audio.CanBanterConversationPlay("130_Egypt") then
    GameObjects.EgyptInteract.LuaObjectScript.Enable()
  end
end
function AbandonEgypt()
  GameObjects.EgyptInteract.LuaObjectScript.Disable()
  if game.Audio.CanBanterConversationPlay("130_Egypt") then
    SetScarabPreIdle()
  else
    SetScarabPostIdle()
  end
end
function EgyptDone()
  SetScarabPostIdle()
end
