local thisObj
local stage = 0
local nextLoop = ""
function OnScriptLoaded(level, obj)
  thisObj = obj
  game.SubObject.Sleep(obj)
end
function OnStart()
  NextLoop()
end
function OnSaveCheckpoint(level, obj)
  return {stage = stage}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  stage = savedInfo.stage
end
function NextLoop()
  if stage == 0 then
    IdleAnimation()
  elseif stage == 1 then
    RaiseUp()
  elseif stage == 2 then
    UpAnimation()
  elseif stage == 3 then
    Drop()
  end
end
function StartRise()
  stage = 1
end
function StartDrop()
  stage = 3
end
function IdleAnimation()
  stage = 0
  thisObj:JumpAnimationToFrame(0)
  thisObj:PlayAnimationToFrame(200)
  thisObj:OnAnimationDone(thisObj, "NextLoop", {Force = true})
end
function RaiseUp()
  thisObj:ClearAllAnimCallbacks()
  stage = 2
  thisObj:JumpAnimationToFrame(200)
  thisObj:PlayAnimationToFrame(400)
  thisObj:OnAnimationDone(thisObj, "NextLoop", {Force = true})
end
function UpAnimation()
  thisObj:ClearAllAnimCallbacks()
  stage = 2
  thisObj:JumpAnimationToFrame(400)
  thisObj:PlayAnimationToFrame(700)
  thisObj:OnAnimationDone(thisObj, "NextLoop", {Force = true})
end
function Drop()
  thisObj:ClearAllAnimCallbacks()
  stage = 0
  thisObj:JumpAnimationToFrame(700)
  thisObj:PlayAnimationToFrame(900)
  thisObj:OnAnimationDone(thisObj, "NextLoop")
end
