local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local playedEnjoyThisPart01 = false
local playedEnjoyThisPart02 = false
local bMoveLikeHelPlayed = false
local bEnjoyThis1Played = false
local bSecondEagle = false
local bTwoDownPlayed = false
local bOuterRingRestored = false
local bKratosEnteredVault = false
local bWolfTrapComplete = false
local bKratosDrainedCenter = false
local twoDownTimer
local bPrettyDumbPlayed = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    playedEnjoyThisPart01 = playedEnjoyThisPart01,
    playedEnjoyThisPart02 = playedEnjoyThisPart02,
    bMoveLikeHelPlayed = bMoveLikeHelPlayed,
    bEnjoyThis1Played = bEnjoyThis1Played,
    bSecondEagle = bSecondEagle,
    bTwoDownPlayed = bTwoDownPlayed,
    bOuterRingRestored = bOuterRingRestored,
    bKratosEnteredVault = bKratosEnteredVault,
    bWolfTrapComplete = bWolfTrapComplete,
    bKratosDrainedCenter = bKratosDrainedCenter,
    bPrettyDumbPlayed = bPrettyDumbPlayed
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  playedEnjoyThisPart01 = savedInfo.playedEnjoyThisPart01
  playedEnjoyThisPart02 = savedInfo.playedEnjoyThisPart02
  bMoveLikeHelPlayed = savedInfo.bMoveLikeHelPlayed
  bEnjoyThis1Played = savedInfo.bEnjoyThis1Played
  bSecondEagle = savedInfo.bSecondEagle
  bTwoDownPlayed = savedInfo.bTwoDownPlayed
  bOuterRingRestored = savedInfo.bOuterRingRestored
  bKratosEnteredVault = savedInfo.bKratosEnteredVault
  bWolfTrapComplete = savedInfo.bWolfTrapComplete
  bKratosDrainedCenter = savedInfo.bKratosDrainedCenter
  bPrettyDumbPlayed = savedInfo.bPrettyDumbPlayed
end
function PlayEnjoyThis02()
  if playedEnjoyThisPart02 == false then
    game.Audio.PlayBanter("160_EnjoyThis2")
    playedEnjoyThisPart02 = true
  end
end
function HallOfSawsPart1Banter()
  game.Audio.PlayBanterNonCritical("080_HallOfSawsPart1")
end
function PlayDownHere()
  game.Audio.PlayBanter("220_DownHere")
end
function PlayMoveLikeHel()
  if not bMoveLikeHelPlayed then
    timers.StartLevelTimer(2, function()
      game.Audio.PlayBanterNonCritical("075_MoveLikeHel")
    end)
    bMoveLikeHelPlayed = true
  end
end
function PlayEnjoyThis1()
  if not bEnjoyThis1Played then
    LD.CallFunctionAfterDelay(function()
      _G.MakePOIsUnavailable()
      game.Audio.PlayBanter("150_EnjoyThis1", ReenablePOIs)
    end, 4)
    LD.CallFunctionAfterDelay(PlaySecondEagle, 40)
  end
  bEnjoyThis1Played = true
end
function ReenablePOIs()
  _G.CheckReenablePOIs()
end
function PlaySecondEagle()
  if not bSecondEagle then
    game.Audio.PlayBanter("155_SecondEagle")
  end
  bSecondEagle = true
end
function PlayerAcquiredMiddleRing()
  bSecondEagle = true
end
function PlayPrettyDumb()
  if not bPrettyDumbPlayed then
    _G.MakePOIsUnavailable()
    game.Audio.PlayBanter("200_PrettyDumb", PlayTwoDown)
    bPrettyDumbPlayed = true
  end
end
function FoundCrackClimb()
  bTwoDownPlayed = true
  if twoDownTimer then
    twoDownTimer:Stop()
    twoDownTimer = nil
  end
end
function PlayTwoDown()
  ReenablePOIs()
  if not bTwoDownPlayed and GameObjects.calderaCenterChain00.LuaObjectScript.GetRingInnerLit() then
    twoDownTimer = timers.StartLevelTimer(10, function()
      game.Audio.PlayBanter("190_TwoDown")
    end)
    bTwoDownPlayed = true
  end
end
function WolfTrapPuzzleComplete()
  bWolfTrapComplete = true
end
function WolfTrapDone()
  return bWolfTrapComplete
end
function KratosEnteredVault()
  bKratosEnteredVault = true
end
function KratosEnteredButNotCompleted()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  return bKratosEnteredVault and 400 <= cineNum and cineNum < 430
end
function PlayerDrainedCenterRing()
  bKratosDrainedCenter = true
end
function CleverHelPlayed()
  if bMoveLikeHelPlayed == true and bKratosDrainedCenter == true and not bOuterRingRestored then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("225_CleverAsHel")
    end, 2)
    bOuterRingRestored = true
  end
end
