local timers = require("level.timer")
local bPlayed240_WolfTrap1_Btr = false
local bPlayed240_WolfTrap1_Start_Btr = false
local bPlayed240_PlayWolfTrap1_Stage4 = false
local bPlayed240_DirectToChains = false
local bPlayed240_SonReadyToStrike = false
local bPlayed240_SonStruck = false
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    bPlayed240_WolfTrap1_Btr = bPlayed240_WolfTrap1_Btr,
    bPlayed240_PlayWolfTrap1_Stage4 = bPlayed240_PlayWolfTrap1_Stage4,
    bPlayed240_DirectToChains = bPlayed240_DirectToChains,
    bPlayed240_SonReadyToStrike = bPlayed240_SonReadyToStrike,
    bPlayed240_SonStruck = bPlayed240_SonStruck
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bPlayed240_WolfTrap1_Btr = savedInfo.bPlayed240_WolfTrap1_Btr
  bPlayed240_PlayWolfTrap1_Stage4 = savedInfo.bPlayed240_PlayWolfTrap1_Stage4
  bPlayed240_DirectToChains = savedInfo.bPlayed240_DirectToChains
  bPlayed240_SonReadyToStrike = savedInfo.bPlayed240_SonReadyToStrike
  bPlayed240_SonStruck = savedInfo.bPlayed240_SonStruck
end
function PlayWolfTrap1()
  if not bPlayed240_WolfTrap1_Btr then
    game.Audio.PlayBanter("240_WolfTrap1")
    bPlayed240_WolfTrap1_Btr = true
  end
end
function PlayWolfTrap1_Start()
  game.Audio.PlayBanter("240_WolfTrap1_Start", WolfTrap1_Done)
end
function WolfTrap1_Done()
  timers.StartLevelTimer(1, function()
    GameObjects.waterTrap_control.LuaObjectScript.KidRunsToDropSpot()
  end)
end
function PlayWolfTrap1_Start_01a()
  game.Audio.PlayBanter("240_WolfTrap1_Start_01a", WolfTrap1_Done01)
end
function WolfTrap1_Done01()
  timers.StartLevelTimer(0.5, function()
    GameObjects.waterTrap_control.LuaObjectScript.ChangeCameraToRune()
  end)
end
function PlayWolfTrap1_Start_01b()
  game.Audio.PlayBanter("240_WolfTrap1_Start_01b", PlayWolfTrap1_Start_02)
end
function PlayWolfTrap1_Start_02()
  game.Audio.PlayBanter("240_WolfTrap1_Start_02a", PlayWolfTrap1_Start_03)
  timers.StartLevelTimer(5, function()
    GameObjects.waterTrap_control.LuaObjectScript.SonExplainHint()
  end)
end
function PlayWolfTrap1_Start_03()
  timers.StartLevelTimer(0.5, function()
    game.Audio.PlayBanter("240_WolfTrap1_Start_02b")
  end)
  timers.StartLevelTimer(3, function()
    GameObjects.waterTrap_control.LuaObjectScript.StartPuzzle()
  end)
end
function PlayLeft()
  game.Audio.PlayBanter("240_WolfTrap1_Left")
end
function PlayRight()
  game.Audio.PlayBanter("240_WolfTrap1_Right")
end
function PlayMiddle()
  game.Audio.PlayBanter("240_WolfTrap1_Middle")
end
function PlayWolfTrap1_Fail()
  game.Audio.PlayBanter("240_WolfTrap1_Fail")
end
function PlayWolfTrap1_Succeed()
  game.Audio.PlayBanter("240_WolfTrap1_Succeed")
end
function PlayWolfTrap2_Start()
  game.Audio.PlayBanter("250_WolfTrap2_Start")
end
function PlayWolfTrap2_DirectToChains()
  if not bPlayed240_DirectToChains then
    game.Audio.PlayBanter("250_WolfTrap2_DirectToChains")
    bPlayed240_DirectToChains = true
  end
end
function PlayWolfTrap2_SonReadyToStrike()
  if not bPlayed240_SonReadyToStrike then
    game.Audio.PlayBanter("250_WolfTrap2_SonReadyToStrike")
    bPlayed240_SonReadyToStrike = true
  end
end
function PlayWolfTrap2_SonStruck()
  if not bPlayed240_SonStruck then
    game.Audio.PlayBanter("250_WolfTrap2_SonStruck")
    bPlayed240_SonStruck = true
  end
end
function PlayWolfTrap2_KnifeSacrifice()
  game.Audio.PlayBanter("260_KnifeSacrifice")
end
function PlayWolfTrap2_WashedOff()
  game.Audio.PlayBanter("270_WashedOff")
end
