local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local thisObj, thisLevel, player, kraActor, sonActor, trollActor, cine_lights_430, blackRunestone
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  blackRunestone = GameObjects.blackRuneStone00_Top.Child
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  HideZone()
end
function OnStart(level, obj)
  cine_lights_430 = GameObjects.Cine_Start_430
  HideCineLights()
  if game.Level.GetVariable("CompletedCineNumber") < 430 then
    CreateActorsAndProps()
  end
  blackRunestone:FindSingleGOByName("Runestone_Effects"):PlayAnimationToFrame(0)
end
function OnUpdate(level, obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
local FindTroll = function()
  local objArray = game.World.FindGameObjectsByMarker("troll20")
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil and obj:GetCreature():GetAI() ~= nil and obj:GetCreature():GetAI():PickupIsAcquired("TrollFirstBrother") == true then
      return obj:GetCreature():GetAI()
    end
  end
  return nil
end
function CreateActorsAndProps()
  kraActor = actor.Actor.New("FATHERS KNIFE: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("FATHERS KNIFE: Son Actor", game.AI.FindSon)
  trollActor = actor.Actor.New("FATHERS KNIFE: Troll Actor", FindTroll)
  HideBlackRunestoneProp()
end
function FathersKnifeSequence()
  if game.Level.GetVariable("CompletedCineNumber") >= 430 then
    return
  end
  SwapProps()
  local fathersKnifeSeq = ND.CreateCineSequence(thisLevel, thisObj, "Father's Knife Cine")
  local fathersKnife_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_FathersKnifeEnter"
    },
    {
      Actor = trollActor,
      Branch = "BRA_FathersKnife"
    },
    {
      Obj = blackRunestone,
      Anim = "narCalFathersKnife010CineScene"
    },
    {
      Obj = GameObjects.DispelMask_cine.Child,
      Anim = "narCalFathersKnife010CineScene"
    }
  }
  fathersKnifeSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", nil, nil, "SND_MX_CAL_vault_stone_troll_in")
  fathersKnifeSeq:Do(AddApproachMarker)
  fathersKnifeSeq:WaitForActorPlayingMove(kraActor, "MOV_Rope_Vertical_Down_Exit")
  fathersKnifeSeq:RequestCineModeAndWait(kraActor, thisObj)
  fathersKnifeSeq:Do(function()
    fathersKnifeSeq:MarkAbleToSkip()
  end)
  fathersKnifeSeq:Do(function()
    game.Wallets.AddResource("HERO", "SonKnifeUnlock2", 1, "NO_TELEMETRY")
    GameObjects.trollCameraCollision:HideCollision()
  end)
  fathersKnifeSeq:Do(ShowForcedCombatCamera)
  fathersKnifeSeq:ActorSync(kraActor, {
    Slaves = fathersKnife_ActorTable,
    Branch = "BRA_FathersKnifeEnter",
    ReferenceJoint = "FathersKnife_SynchJoint"
  })
  fathersKnifeSeq:WaitForActorFinishMove(kraActor, "MOV_FathersKnifeEnter")
  fathersKnifeSeq:Do(RemoveApproachMarker)
  fathersKnifeSeq:Do(PlayCineLights)
  fathersKnifeSeq:WaitUntilActorAnimPastFrame(kraActor, 3076)
  fathersKnifeSeq:Do(function()
    GameObjects.DispelCore_cine.LuaObjectScript.Kill()
  end)
  fathersKnifeSeq:WaitUntilActorAnimPastFrame(kraActor, 3148)
  fathersKnifeSeq:Do(function()
    GameObjects.DispelCore_cine.LuaObjectScript.Dispel()
  end)
  fathersKnifeSeq:WaitUntilActorAnimPastFrame(kraActor, 3481)
  fathersKnifeSeq:Do(function()
    blackRunestone:FindSingleGOByName("Runestone_Effects"):PlayAnimationToEnd()
  end)
  fathersKnifeSeq:WaitUntilActorAnimPastFrame(kraActor, 3700)
  fathersKnifeSeq:Do(WakeTroll)
  fathersKnifeSeq:Do(function()
    player:MeterSetValue("Health", player:MeterGetMax("Health"))
  end)
  fathersKnifeSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.95)
  fathersKnifeSeq:Do(function()
    fathersKnifeSeq:SetMaxSkipSpeedup(5)
  end)
  fathersKnifeSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.985)
  fathersKnifeSeq:Do(function()
    fathersKnifeSeq:EndSkipIfActive()
  end)
  fathersKnifeSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  fathersKnifeSeq:StopPuppetingActor(kraActor)
  fathersKnifeSeq:StopPuppetingActor(sonActor)
  fathersKnifeSeq:StopPuppetingActor(trollActor)
  fathersKnifeSeq:Do(function()
    trollActor:GetCreature():CallScript("LuaHook_SetInCombatState")
  end)
  fathersKnifeSeq:Do(SceneOver)
  fathersKnifeSeq:SetCompletedCineNumber(430)
  fathersKnifeSeq:Do(HideForcedCombatCamera)
  fathersKnifeSeq:Do(HideCineLights)
  fathersKnifeSeq:Do(HideBlackRunestoneProp)
  fathersKnifeSeq:Do(Checkpoint)
  fathersKnifeSeq:StartSequence()
end
function SwapProps()
  GameObjects.BlackRunestone_01:Hide()
  blackRunestone:Show()
  GameObjects.DispelMask:Hide()
  GameObjects.DispelCore.LuaObjectScript.Disable()
  GameObjects.DispelCore_cine.LuaObjectScript.Enable()
  GameObjects.DispelMask_cine:Show()
end
function Checkpoint()
  game.World.StoreCheckpoint({
    OverrideObject = GameObjects.ECT_CheckpointOverride
  })
end
function DestroyShield()
  GameObjects.DispelCore_cine.LuaObjectScript.Dispel()
end
function AddApproachMarker()
  if not player:HasMarker("ApproachingCine") then
    player:AddMarker("ApproachingCine")
  end
end
function RemoveApproachMarker()
  if player:HasMarker("ApproachingCine") then
    player:RemoveMarker("ApproachingCine")
  end
end
function HideBlackRunestoneProp()
  blackRunestone:Hide()
end
function WakeTroll()
  GameObjects.encounters.LuaObjectScript.StartTrollEncounter()
  GameObjects.trollPedestal.Child:PlayAnimationToEnd()
  game.Compass.SetDesignerForcedHide(true)
end
function HideZone()
  GameObjects.Cine_FathersKnife:HideEntityVolume()
  GameObjects.DispelCore_cine.LuaObjectScript.Disable()
  GameObjects.DispelMask_cine:Hide()
end
function PlayCineLights()
  cine_lights_430:Show()
  cine_lights_430:JumpAnimToFrame(0)
  cine_lights_430:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_430:Hide()
  GameObjects.Cinestart_430A:Hide()
end
function SceneOver()
  LD.PlayMove(game.AI.FindSon(), thisObj, "MOV_DispelDoorSon")
  GameObjects.pitCollision:HideCollision()
end
function IncreaseKratosDeceleration()
  game.Player.FindPlayer():SetDecelerationOverride(1.2)
  game.Player.FindPlayer():SetAccelerationOverride(1.2)
end
function ClearKratosDeceleration()
  game.Player.FindPlayer():ClearDecelerationOverride()
  game.Player.FindPlayer():ClearAccelerationOverride()
end
function ShowForcedCombatCamera()
  local forcedcamera = thisLevel:GetGameObject("CamZone_FathersKnife_ForcedCombat")
  assert(forcedcamera)
  forcedcamera:ShowCameraVolume()
end
function HideForcedCombatCamera()
  local forcedcamera = thisLevel:GetGameObject("CamZone_FathersKnife_ForcedCombat")
  assert(forcedcamera)
  timers.StartLevelTimer(4.56, function()
    forcedcamera:HideCameraVolume()
  end)
end
