local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, wineAcquireSeq, kratosActor, sonActor, greekVase, greekVaseWebs, greekWineBottle, brokenGreekVase, greekHelmet, cine_lights_425, cameraCineEnter_WineAcquired
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  cine_lights_425 = GameObjects.Cine_Start_425
  HideCineLights()
  if game.Level.GetVariable("CompletedCineNumber") < 425 then
    CreateActorsAndPositions()
  elseif game.Level.GetVariable("CompletedCineNumber") >= 425 then
    SetPropsAfter()
  end
end
function OnUpdate(level, obj)
  if cameraCineEnter_WineAcquired ~= nil then
    cameraCineEnter_WineAcquired:Update()
  end
end
function CreateActorsAndPositions()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  greekVase = GameObjects.greekVase00.Child
  greekVase:StartAnim("narCalWineAquire000CineScene")
  greekVase:JumpAnimToFrame(0)
  greekVase:PauseAnim()
  greekWineBottle = GameObjects.greekWineBottle00.Child
  greekWineBottle:StartAnim("narCalWineAquire000CineScene")
  greekWineBottle:JumpAnimToFrame(0)
  greekWineBottle:PauseAnim()
  brokenGreekVase = GameObjects.brokenGreekVase00.Child
  brokenGreekVase:StartAnim("narCalWineAquire000CineScene")
  brokenGreekVase:JumpAnimToFrame(0)
  brokenGreekVase:PauseAnim()
  greekHelmet = GameObjects.greekHelmet00.Child
  greekHelmet:StartAnim("narCalWineAquire000CineScene")
  greekHelmet:JumpAnimToFrame(0)
  greekHelmet:PauseAnim()
  greekVaseWebs = GameObjects.greekVaseWebs00.Child
  ShowProps()
  HidePropsStart()
end
function BuildWineAcquireSequence()
  if wineAcquireSeq == nil then
    wineAcquireSeq = ND.CreateCineSequence(thisLevel, thisObj, "wineAcquire")
    local wineAcquire_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_WineAcquire"
      },
      {
        Obj = greekVase,
        Anim = "narCalWineAquire000CineScene"
      },
      {
        Obj = greekWineBottle,
        Anim = "narCalWineAquire000CineScene"
      },
      {
        Obj = brokenGreekVase,
        Anim = "narCalWineAquire000CineScene"
      },
      {
        Obj = greekHelmet,
        Anim = "narCalWineAquire000CineScene"
      }
    }
    wineAcquireSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
    wineAcquireSeq:WaitForActorPlayingMove(kratosActor, "MOV_Vault_1m")
    wineAcquireSeq:Do(HideEntityVolume)
    local requestSeq = LD.CreateCineSequence(thisLevel, thisObj, "wineAcquire InteractRequest")
    requestSeq:WaitForFunctionTrue(function()
      return not player:IsInteracting()
    end)
    requestSeq:RequestCineModeAndWait(kratosActor, thisObj)
    wineAcquireSeq:Do(function()
      wineAcquireSeq:MarkAbleToSkip()
    end)
    wineAcquireSeq:BranchSequence(requestSeq)
    wineAcquireSeq:Do(StartCineEnter_WineAcquired)
    wineAcquireSeq:Do(function()
      _G.TurnOnTunnel2()
    end)
    wineAcquireSeq:Do(ShowProps)
    wineAcquireSeq:Do(function()
      greekVaseWebs:JumpAnimationToFrame(332)
      greekVaseWebs:PlayAnimationToEnd()
    end)
    wineAcquireSeq:Do(function()
      game.Audio.StartMusic("SND_MX_CAL_wine_acquire")
    end)
    wineAcquireSeq:ActorSync(kratosActor, {
      Slaves = wineAcquire_ActorTable,
      Branch = "BRA_WineAcquire",
      ReferenceJoint = "WineAcquire_SynchJoint"
    })
    wineAcquireSeq:Do(PlayCineLights)
    wineAcquireSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    wineAcquireSeq:StopPuppetingActor(kratosActor)
    wineAcquireSeq:StopPuppetingActor(sonActor)
    wineAcquireSeq:SetCompletedCineNumber(425)
    wineAcquireSeq:Do(HideCineLights)
    wineAcquireSeq:Do(function()
      game.World.StoreCheckpoint()
    end)
    wineAcquireSeq:StartSequence()
  end
end
function PlayCineLights()
  cine_lights_425:Show()
  cine_lights_425:JumpAnimToFrame(0)
  cine_lights_425:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_425:Hide()
end
function HidePropsStart()
  brokenGreekVase:Hide()
end
function ShowProps()
  greekVase:Show()
  greekWineBottle:Show()
  brokenGreekVase:Show()
  greekHelmet:Show()
  greekVaseWebs:Show()
end
function SetPropsAfter()
  greekVase = GameObjects.greekVase00.Child
  greekVase:StartAnim("narCalWineAquire000CineScene")
  greekVase:JumpAnimToFrame(greekVase.AnimLengthFrames)
  greekVase:PauseAnim()
  brokenGreekVase = GameObjects.brokenGreekVase00.Child
  brokenGreekVase:StartAnim("narCalWineAquire000CineScene")
  brokenGreekVase:JumpAnimToFrame(brokenGreekVase.AnimLengthFrames)
  brokenGreekVase:PauseAnim()
  greekHelmet = GameObjects.greekHelmet00.Child
  greekHelmet:StartAnim("narCalWineAquire000CineScene")
  greekHelmet:JumpAnimToFrame(greekHelmet.AnimLengthFrames)
  greekHelmet:PauseAnim()
end
function HideEntityVolume()
  GameObjects.EntityZoneEvents_WineAcquire.LuaObjectScript.Disable()
end
function StartCineEnter_WineAcquired()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_WineAcquired = CCEC.CineEnterCamera.New("ENV_CineEnter_WineAcquire", 8)
  cameraCineEnter_WineAcquired:SetCallback(DestroyCineEnter_WineAcquire)
  cameraCineEnter_WineAcquired:Start()
end
function DestroyCineEnter_WineAcquire()
  cameraCineEnter_WineAcquired = nil
  game.SubObject.Sleep(thisObj)
end
