local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, sphere, idleFX, deathFX
local enabled = true
function OnScriptLoaded(level, obj)
  thisObj = obj
  idleFX = thisObj:FindSingleGOByName("idleFX")
  deathFX = thisObj:FindSingleGOByName("deathFX")
  sphere = thisObj:FindSingleGOByName("sphere")
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  LD.HideFX(deathFX)
  if enabled then
    Enable()
  else
    Disable()
  end
end
function Idle()
  if enabled then
    sphere:ClearAllAnimationCallbacks()
    sphere:JumpAnimationToFrame(50)
    sphere:PlayAnimationToFrame(650, {Rate = 1})
    sphere:OnAnimationDone(thisObj, "Idle")
  end
end
function Kill()
  LD.ShowFX(deathFX)
  deathFX:JumpAnimationToPercent(0)
  deathFX:PlayAnimationToEnd()
end
function Dispel()
  local dispelTime = 3
  local currentFrame = sphere.AnimFrame
  local speed = (700 - currentFrame) / (dispelTime * 30)
  LD.HideFX(idleFX)
  sphere:ClearAllAnimationCallbacks()
  sphere:PlayAnimationToFrame(650, {Rate = speed})
  sphere:OnAnimationDone(thisObj, "Fade")
  enabled = false
end
function Fade()
  sphere:ClearAllAnimationCallbacks()
  sphere:PlayAnimationToEnd({Rate = 1})
  sphere:OnAnimationDone(thisObj, "HideSphere")
end
function Disable()
  enabled = false
  HideSphere()
  sphere:ClearAllAnimationCallbacks()
  if idleFX then
    LD.HideFX(idleFX)
  end
  if deathFX then
    LD.HideFX(deathFX)
  end
end
function Enable()
  ShowSphere()
  enabled = true
  LD.ShowFX(idleFX)
  Idle()
end
function HideSphere()
  thisObj:Hide()
end
function ShowSphere()
  thisObj:Show()
end
function OnSaveCheckpoint(level, obj)
  return {enabled = enabled}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  enabled = savedInfo.enabled
end
