local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, crankLift, crank, crystal, floorPlate, crystalSweep, drain, holeCollision
local crystalAngle = 0
local blockCollision, vines
function OnScriptLoaded(level, obj)
  thisObj = obj
  crankLift = obj:FindSingleGOByName("crankLift")
  crank = obj:FindSingleGOByName("WheelCrank")
  crystal = obj:FindSingleGOByName("crystal")
  crystalSweep = obj:FindSingleGOByName("crystalSweep")
  drain = obj:FindSingleGOByName("flip_drainCrystal")
  floorPlate = obj:FindSingleGOByName("floorPlate")
  blockCollision = obj:FindSingleGOByName("blockCollision")
  crystalAngle = obj:GetLuaTableAttribute("crystalAngle")
  holeCollision = obj:FindSingleGOByName("holeCollision")
  vines = obj:FindSingleGOByName("vines")
  SoundInit()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  if crystalAngle then
    crystalSweep:JumpAnimToFrame(crystalAngle)
    crystalSweep:PauseAnim()
  end
  holeCollision:HideCollision()
  blockCollision:HideCollision()
  blockCollision:Hide()
end
function OnStart(level, obj)
  SoundOnStart()
end
function SetDrivenObject(newObject)
  crank.LuaObjectScript.SetDrivenObject(newObject)
end
function Flip()
  holeCollision:ShowCollision()
  blockCollision:ShowCollision()
  crystal:PlayAnimationToEnd({Rate = 1})
  crankLift:PlayAnimationToEnd({Rate = 1})
  floorPlate:PlayAnimationToEnd({Rate = 1})
  vines.LuaObjectScript.Drop()
  crank.LuaObjectScript.Enable()
  PlayFlipSound()
  crankLift:OnAnimationDone(thisObj, "HideHoleCollision", {Force = true})
end
function HideHoleCollision()
  holeCollision:HideCollision()
  StopSoundOrbIdle()
end
function Disable()
  drain.LuaObjectScript.SetActive(false)
  StopSoundOrbIdle()
end
function Lock()
  crank.LuaObjectScript.Lock()
  crank.LuaObjectScript.Disable()
  drain.LuaObjectScript.SetActive(false)
  StopSoundOrbIdle()
end
function Unlock()
  crank.LuaObjectScript.Unlock()
end
local SNDFlipSwitch
local soundEvents = {
  FlipSound = "SND_MECH_Cal500_HelWind_Pedestal",
  TrapSound = "SND_MECH_Cal500_SunMoon_Roots_Trap",
  UnTrapSound = "SND_MECH_Cal500_SunMoon_Roots_Release",
  BGGearsLoop = "SND_MECH_Cal500_SunMoon_Gears_BG_01_LP"
}
function SoundInit()
  SNDFlipSwitch = thisObj:FindSingleSoundEmitterByName("SNDFlipSwitch")
end
function SoundOnStart()
  if crystal.AnimFrame > 0 then
    StopSoundOrbIdle()
  end
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SNDFlipSwitch ~= nil then
      SNDFlipSwitch = thisObj:FindSingleSoundEmitterByName(sounds.SNDFlipSwitch)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
  end
end
function PlayFlipSound()
  LD.PlaySound(SNDFlipSwitch, soundEvents.FlipSound)
  local drainEmitter = drain.Child.SoundEmitters[1]
  LD.PlaySoundOnFrame(drainEmitter, crankLift, "SND_MECH_Crank_Wheel_Metal_Lower_LP", 60, "forward")
  LD.StopSoundOnFrame(drainEmitter, crankLift, "SND_MECH_Crank_Wheel_Metal_Lower_LP", 120, "forward")
  local crankEmitter = crank.Child.SoundEmitters[1]
  LD.PlaySoundOnFrame(crankEmitter, crankLift, "SND_MECH_Crank_Wheel_Metal_Lower_LP", 60, "forward")
  LD.PlaySoundOnFrame(crankEmitter, crankLift, "SND_MECH_Crank_Wheel_Metal_Lower_Stop", 120, "forward")
  LD.StopSoundOnFrame(crankEmitter, crankLift, "SND_MECH_Crank_Wheel_Metal_Lower_LP", 120, "forward")
end
function StopSoundOrbIdle()
  LD.CallFunctionAfterDelay(function()
    drain.Child.LuaObjectScript.StopSoundOrbActiveIdleLoop()
    drain.Child.LuaObjectScript.StopSoundOrbInactiveIdleLoop()
  end, 0.5)
end
function PlayTrapSound()
  LD.PlaySound(SNDFlipSwitch, soundEvents.TrapSound)
end
function PlayUnTrapSound()
  LD.PlaySound(SNDFlipSwitch, soundEvents.UnTrapSound)
end
function PlayBGGearsSound()
  LD.PlaySound(SNDFlipSwitch, soundEvents.BGGearsLoop)
end
function StopBGGearsSound()
  LD.StopSound(SNDFlipSwitch, soundEvents.BGGearsLoop)
end
