local LD = require("design.LevelDesignLibrary")
local thisObj, drain, rotate, ringVFX, fireFX, collisionShield, SNDRing
local powerOnAnim = "PowerOn"
local isDisabled = true
function IsLit()
  return drain.LuaObjectScript.GetActive()
end
function OnScriptLoaded(level, obj)
  thisObj = obj
  drain = thisObj:FindSingleGOByName("Drain").Child
  ringVFX = thisObj:FindSingleGOByName("RingVFX"):FindSingleGOByName("DrainCrystalInfluence_a").Child
  fireFX = thisObj:FindSingleGOByName("RingVFX"):FindSingleGOByName("FireEffects")
  collisionShield = thisObj:FindSingleGOByName("collisionShield")
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  SoundInit()
end
function OnFirstStart(level, obj)
  DeactivateShield()
end
function InitializeDrain()
  drain.LuaObjectScript.SetActive(true)
end
function InitializeDrainCallbacks(funcLit, funcUnlit)
  if funcLit ~= nil then
    drain.LuaObjectScript.OnFullyLit(funcLit)
  end
  if funcUnlit ~= nil then
    drain.LuaObjectScript.OnFullyUnlit(funcUnlit)
  end
end
function Intro()
  thisObj:StartAnimation({Animation = "Intro"})
  drain:HideCollision()
end
function StartSpin()
  drain:ShowCollision()
  thisObj:ClearAllAnimationCallbacks()
  thisObj:PlayAnimationCycle({Animation = powerOnAnim, Tween = 2})
  RingSpinSound()
  isDisabled = false
end
function StopSpin()
  thisObj:ClearAllAnimationCallbacks()
  thisObj:PauseAnimationAllowTween(powerOnAnim)
  thisObj:StartAnimation({Animation = "OffPose", Tween = 3})
  RingSpinStopSound()
  isDisabled = true
end
function SetPoweredOnAnim(newAnim)
  powerOnAnim = newAnim or "PoweredOn"
end
function ActivateShield()
  print(tostring(thisObj) .. " is activating")
  ringVFX:JumpAnimationToFrame(0)
  ringVFX:PlayAnimationToFrame(24)
  if fireFX then
    fireFX:ClearAllAnimationCallbacks()
    fireFX:JumpAnimationToFrame(0)
    fireFX:PlayAnimationToFrame(100)
    fireFX:OnAnimationDone(thisObj, "LoopFireFX")
  end
  collisionShield:ShowCollision()
  isDisabled = false
end
function LoopFireFX()
  fireFX:JumpAnimationToFrame(50)
  fireFX:PlayAnimationToFrame(100)
  fireFX:OnAnimationDone(thisObj, "LoopFireFX")
end
function DeactivateShield()
  ringVFX:JumpAnimationToFrame(24)
  ringVFX:PlayAnimationToEnd()
  if fireFX then
    fireFX:ClearAllAnimationCallbacks()
    fireFX:PlayAnimationToFrame(100, {Rate = 10})
    fireFX:OnAnimationDone(thisObj, "KillFireFX")
  end
  collisionShield:HideCollision()
  isDisabled = true
end
function KillFireFX()
  fireFX:PlayAnimationToFrame(150)
end
local soundEvents = {OnSpin = "", OnIntro = ""}
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      SNDRing = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
  end
end
function SoundInit()
  SNDRing = thisObj:FindSingleSoundEmitterByName("SNDRing")
end
function RingSpinSound()
  LD.PlaySound(SNDRing, soundEvents.OnSpin)
end
function RingSpinStopSound()
  LD.StopSound(SNDRing, soundEvents.OnSpin)
end
function Disabled()
  if thisObj:GetAnimationName() == powerOnAnim then
    isDisabled = false
  end
  return isDisabled
end
