local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local mpicon = require("ui.mpicon")
local timers = require("level.timer")
local CSL = require("camera.shakelibrary")
local thisObj, son, sonPuppeteer, spikeRoof
local threshold_1 = 400
local threshold_3 = 550
local threshold_4 = 1400
local spikeRoofMonitor
local bInteractActive = false
local bfirstButtonPressed = false
local bsecondButtonPressed = false
local icon
local enabled = false
local inputMonitor
local currentPen = 0
function OnScriptLoaded(level, obj)
  thisObj = obj
  son = game.AI.FindSon()
  spikeRoof = GameObjects.spikedRoof
  icon = thisObj:FindSingleGOByName("SacrificeIcon")
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  return {bInteractActive = bInteractActive}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bInteractActive = savedInfo.bInteractActive
end
function OnUpdate()
  UpdateIcon()
end
function Disable()
  enabled = false
  inputMonitor = nil
  mpicon.level.Off(icon, "WORLD_INTERACT_SON")
  game.SubObject.Sleep(thisObj)
end
function UpdateIcon()
  currentPen = game.Camera.GetViewPenetration(icon:GetWorldPosition(), 0, 0)
  if 0 < currentPen then
    mpicon.level.Create(icon, "WORLD_INTERACT_SON")
  else
    mpicon.level.Off(icon, "WORLD_INTERACT_SON")
  end
end
function RePositionSon()
  local jnt = thisObj:GetJointIndex("knifeSacrificeJointA")
  son:Warp(thisObj:GetWorldJointPosition(jnt), thisObj:GetWorldJointForward(jnt))
  PositionSon()
end
function PositionSon()
  GameObjects.gearPuzzle_control.LuaObjectScript.ClearPuppet()
  son:RequestInteract(thisObj)
end
function OnInteractReject(level, obj, creature)
  engine.Error("Knife Sacrifice Son Interaction failed.")
end
function OnInteractStart()
  if spikeRoofMonitor == nil then
    spikeRoofMonitor = monitors.CreateAnimFrameMonitor(spikeRoof)
  end
  spikeRoofMonitor:OnFrame(threshold_3, FirstDeathThreshold)
  spikeRoofMonitor:OnFrame(threshold_4, SecondDeathThreshold)
  sonPuppeteer = game.Puppeteer.NewForce(thisObj, "Knife Sacrifice Panic", son)
  if not bInteractActive then
    bInteractActive = true
    game.World.StoreCheckpoint()
  end
  sonPuppeteer:Sync("BRA_KnifeSacrifice", true, {}, "knifeSacrificeJointA")
end
function TriggerRunOver()
  if sonPuppeteer ~= nil then
    GameObjects.Btr_WaterTrap.LuaObjectScript.PlayWolfTrap2_DirectToChains()
    son:TriggerMoveEvent("LE_KNIFE_SEQ_2")
    Disable()
    bfirstButtonPressed = true
  end
end
function TriggerSacrifice()
  if not bsecondButtonPressed then
    game.Audio.StartMusic("SND_MX_CAL_vault_puzzle_trap_2_out")
  end
  Disable()
  bsecondButtonPressed = true
  GameObjects.spikeTrap_control.LuaObjectScript.ZoomInOnSacrifice()
  son:TriggerMoveEvent("LE_KNIFE_SACRIFICE")
end
function LuaHook_KnifeInvestigate()
  spikeRoofMonitor:OnFrame((threshold_3 + spikeRoof.AnimFrame) / 2, function()
    son:TriggerMoveEvent("LE_KNIFE_DITHER")
  end)
end
function LuaHook_ReactionDone()
  if not enabled then
    enabled = true
    timers.StartLevelTimer(7, function()
      TriggerRunOver()
    end)
  end
end
function LuaHook_KnifeDrawn()
  GameObjects.Btr_WaterTrap.LuaObjectScript.PlayWolfTrap2_SonReadyToStrike()
  timers.StartLevelTimer(4, function()
    game.SubObject.Wake(thisObj)
    inputMonitor = monitors.CreateSquareButtonMonitor()
    inputMonitor:OnButtonDown(TriggerSacrifice)
  end)
end
function LuaHook_KnifeEmbedded()
  GameObjects.spikeTrap_control.LuaObjectScript.StopPanicShakeAndRumble()
  GameObjects.ChainJitterR:PlayAnimationCycle()
  GameObjects.SpikeJitter:PlayAnimationCycle()
  GameObjects.waterTrapChainL.LuaObjectScript.PauseChain()
  GameObjects.waterTrapChainR.LuaObjectScript.PauseChain()
  timers.StartLevelTimer(1, function()
    GameObjects.Btr_WaterTrap.LuaObjectScript.PlayWolfTrap2_SonStruck()
  end)
  timers.StartLevelTimer(4, function()
    GameObjects.ChainJitterL:PlayAnimationCycle()
  end)
  GameObjects.spikeTrap_control.LuaObjectScript.PlayGearJamSound()
  timers.StartLevelTimer(0.95, function()
    CSL.PlayEffect("FSE_SHAKE_GENERIC_VERYSMALL", 8.5, 0, 0.3)
    CSL.PlayEffect("FFB_GENERIC_RUMBLE_LOW", 8.5, 0, 0.3)
  end)
end
function LuaHook_MechanismBreak()
  GameObjects.spikeTrap_control.LuaObjectScript.KnifeSacrificeSuccess()
  GameObjects.ChainJitterR:PauseAnim()
  GameObjects.ChainJitterL:PauseAnim()
  GameObjects.SpikeJitter:PauseAnim()
end
function ReleaseSon()
  if sonPuppeteer ~= nil then
    sonPuppeteer:Clear()
    sonPuppeteer = nil
  end
  bInteractActive = false
  Disable()
  son:AbortInteract()
end
function FirstDeathThreshold()
end
function SecondDeathThreshold()
  if bfirstButtonPressed and not bsecondButtonPressed then
    Disable()
    GameObjects.spikeTrap_control.LuaObjectScript.StopPanicShakeAndRumble()
    game.FX.SubmitEffect({
      EffectName = "FSE_shake_temp_Generic_Large",
      Duration = 1
    })
    spikeRoof:PlayAnimationToEnd({Rate = 100})
    GameObjects.spikeTrap_control.LuaObjectScript.PlayCeilingDropSoundToFrame(spikeRoof.AnimLengthFrames)
    GameObjects.waterTrap_control.LuaObjectScript.SkewerKratos()
  end
end
