local timers = require("level.timer")
local player, son
local bCharge1Dumped = false
local bCharge2Dumped = false
local bCharge3Dumped = false
local bFoundBalcony = false
local bDoor2Opened = false
local bDoor3Opened = false
local bOneCrystalDrained = false
local hint1Timer
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    bCharge1Dumped = bCharge1Dumped,
    bCharge2Dumped = bCharge2Dumped,
    bCharge3Dumped = bCharge3Dumped,
    bFoundBalcony = bFoundBalcony,
    bOneCrystalDrained = bOneCrystalDrained,
    bDoor2Opened = bDoor2Opened,
    bDoor3Opened = bDoor3Opened
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bCharge1Dumped = savedInfo.bCharge1Dumped
  bCharge2Dumped = savedInfo.bCharge2Dumped
  bCharge3Dumped = savedInfo.bCharge3Dumped
  bFoundBalcony = savedInfo.bFoundBalcony
  bOneCrystalDrained = savedInfo.bOneCrystalDrained
  bDoor2Opened = savedInfo.bDoor2Opened
  bDoor3Opened = savedInfo.bDoor3Opened
end
function Charge1Dumped()
  if hint1Timer then
    hint1Timer = nil
  end
  bCharge1Dumped = true
  DisableHint1()
end
function Charge2Dumped()
  bCharge2Dumped = true
  DisableHint2()
end
function Charge3Dumped()
  bCharge3Dumped = true
  DisableHint3()
end
function EnableSphereLook()
  GameObjects.Son_LookAtSphere_Up.LuaObjectScript.Enable()
end
function DisableSphereLook()
  GameObjects.Son_LookAtSphere_Up.LuaObjectScript.Disable()
end
function SonHintDoor1()
  if not bCharge1Dumped then
    GameObjects.Son_WaitAtDoor1.LuaObjectScript.Enable()
    DisableSphereLook()
  end
end
function StartHint1Timer()
  hint1Timer = timers.StartLevelTimer(5, EnableHint1)
end
function EnableHint1()
  DisableSphereLook()
  if not bOneCrystalDrained then
    GameObjects.sonLookAtCrystal.LuaObjectScript.Enable()
  elseif not bCharge1Dumped then
    GameObjects.BanterLookAt_EagleRinger.LuaObjectScript.Disable()
    GameObjects.sonLookAtCrystal.LuaObjectScript.Interrupt()
    GameObjects.sonLookAtCrystal.LuaObjectScript.Disable()
    GameObjects.Son_WaitAtDoor1.LuaObjectScript.Enable()
  end
end
function DisableHint1()
  GameObjects.sonLookAtCrystal.LuaObjectScript.Interrupt()
  GameObjects.Son_WaitAtDoor1.LuaObjectScript.Interrupt()
  GameObjects.Son_WaitAtDoor1.LuaObjectScript.Disable()
  GameObjects.sonLookAtCrystal.LuaObjectScript.Disable()
end
function EnableHint2()
  if bDoor2Opened and bCharge1Dumped and not bCharge2Dumped then
    GameObjects.Son_WaitAtDoor2.LuaObjectScript.Enable()
  end
end
function DisableHint2()
  GameObjects.Son_WaitAtDoor2.LuaObjectScript.Disable()
end
function EnableHint3()
  if bDoor3Opened and bCharge2Dumped and not bCharge3Dumped then
    if bFoundBalcony then
      GameObjects.Son_WaitAtDoor3.LuaObjectScript.Enable()
    else
      GameObjects.sonLookAtClimb.LuaObjectScript.Enable()
    end
  end
end
function DisableHint3()
  GameObjects.Son_WaitAtDoor3.LuaObjectScript.Disable()
  GameObjects.sonLookAtClimb.LuaObjectScript.Disable()
end
function SonHintDoor2()
  if not bCharge2Dumped then
    GameObjects.Son_WaitAtDoor2.LuaObjectScript.Enable()
  end
end
function SonHintDoor3()
  if not bCharge3Dumped then
    GameObjects.Son_WaitAtDoor3.LuaObjectScript.Enable()
  end
end
function crystalDrained()
  bOneCrystalDrained = true
  DisableHint1()
  EnableHint1()
  GameObjects.Btr_EagleRinger:HideEntityVolume()
  GameObjects.EagleRinger_EmptyTrap:HideEntityVolume()
end
function FirstCrystalDrained()
  return bOneCrystalDrained
end
function SonWaitingAtDoor1()
end
function EnableGearPuzzleDiscovery()
  GameObjects.Son_DiscoverGearPuzzle.LuaObjectScript.Enable()
end
function SonDiscoverGearPuzzle()
end
function EnableBalconyHint()
  bFoundBalcony = true
  if GameObjects.calderaCenterChain00.LuaObjectScript.GetRingInnerLit() and not GameObjects.calderaCenterChain00.LuaObjectScript.GetRingMiddleLit() and not GameObjects.calderaCenterChain00.LuaObjectScript.GetRingOuterLit() then
    GameObjects.Son_WaitAtBalcony.LuaObjectScript.Enable()
  end
end
function DisableBalconyHint()
  GameObjects.Son_WaitAtBalcony.LuaObjectScript.Disable()
end
function DisableCrackClimbHint()
  GameObjects.SonLookAtClimb.LuaObjectScript.Disable()
end
function OpenDoor2()
  bDoor2Opened = true
end
function OpenDoor3()
  bDoor3Opened = true
end
