local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local collisionCheck = require("camera.collisioncheck")
local TUT = require("game.GlobalTutorials")
local uiCalls = require("ui.uicalls")
thisObj = nil
thisLevel = nil
player = nil
son = nil
local door1, door2, door3, door6, encounter1, encounter2, encounterSurprise, encounterBalconyL, encounterBalconyR, encounterPopcorn, encounter3, fanaticEncounter, trollEncounter, HideSideRoomsTimer, wineMonitor, encounter3Monitor1, encounter3Monitor2, fanaticMonitor, WaveL2Start, WaveR2Start
local bWineCollected = false
local bTrollEncounterStarted = false
local bTrollEncounterFinished = false
local bDoor2Opened = false
local bEncounter1Complete = false
local bEncounter2Complete = false
local bEncounter3Complete = false
local bFanaticsComplete = false
local bDoorOpen = false
local HudToggle = false
local penDepth = 0.2
local verticalP = 0.5
local horizontalP = 0
local Witch_HealthMonitor, Troll_HealthMonitor, Jotunn_HealthMonitor
local bRoom3FirstTime = false
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  door1 = thisLevel:GetGameObject("Door1")
  door2 = thisLevel:GetGameObject("Door2")
  door3 = thisLevel:GetGameObject("Door3")
  door6 = thisLevel:GetGameObject("Door6")
  Area_1_Fight_1()
  Area_1_Fight_2()
  SurpriseRoom2()
  BalconyFightLeft()
  BalconyFightRight()
  Area_1_Fight_5()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  door6.LuaObjectScript.ForceDoorOpen()
  door1.LuaObjectScript.Disable()
  door6.LuaObjectScript.Disable()
  GameObjects.EntZnBalconyFightLeft:Hide()
  GameObjects.EntZnBalconyFightRight:Hide()
  GameObjects.EntZnBalconyFightL2:Hide()
  GameObjects.EntZnBalconyFightR2:Hide()
  GameObjects.EntZnSurprise:Hide()
end
function OnStart()
  GameObjects.NoGo_Zones:Hide()
  trollEncounter:Start()
  if bDoorOpen then
    door3.Child:Hide()
  else
    door3.Child:Show()
  end
  if encounter2:WasRunning() then
    encounter2:Start()
    DisableDoors()
  elseif bTrollEncounterStarted and not bTrollEncounterFinished then
    GameObjects.trollPedestal.Child:JumpAnimationToFrame(1)
    GameObjects.trollPedestal.Child:PauseAnim()
    GameObjects.CrackClimb:HideTraversePath()
    DisableDoors()
    game.Compass.SetDesignerForcedHide(true)
  end
end
function OnSaveCheckpoint(level, obj)
  return {
    levelstate = checkpoint.Save(),
    bTrollEncounterFinished = bTrollEncounterFinished,
    bTrollEncounterStarted = bTrollEncounterStarted,
    e1done = bEncounter1Complete,
    e2done = bEncounter2Complete,
    e3done = bEncounter3Complete,
    bDoorOpen = bDoorOpen,
    bRoom3FirstTime = bRoom3FirstTime,
    bDoor2Opened = bDoor2Opened
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bTrollEncounterFinished = savedInfo.bTrollEncounterFinished
  bTrollEncounterStarted = savedInfo.bTrollEncounterStarted
  bEncounter1Complete = savedInfo.e1done
  bEncounter2Complete = savedInfo.e2done
  bEncounter3Complete = savedInfo.e3done
  bDoorOpen = savedInfo.bDoorOpen
  bRoom3FirstTime = savedInfo.bRoom3FirstTime
  bDoor2Opened = savedInfo.bDoor2Opened
  checkpoint.Restore(savedInfo.levelstate)
end
function StartEncounter1()
  if not bEncounter1Complete then
    encounter1:Start()
    door1.LuaObjectScript.ForceDoorClose(false, 5)
    door6.LuaObjectScript.ForceDoorClose(false, 5)
  end
end
function Encounter1Complete()
  door1.LuaObjectScript.ForceDoorOpen()
  door1.LuaObjectScript.Disable()
  door6.LuaObjectScript.ForceDoorOpen()
  door6.LuaObjectScript.Disable()
  bEncounter1Complete = true
end
function StartFanaticEncounter()
  if not bFanaticsComplete then
    fanaticEncounter:Start()
  end
end
function FanaticEncounterComplete()
  bFanaticsComplete = true
end
function Door2Opened()
  bDoor2Opened = true
  GameObjects.TVVisOffDoor2:Show()
end
function StartEncounter2()
  if game.Level.GetVariable("CompletedCineNumber") == 425 and bDoor2Opened and not bEncounter2Complete then
    door1.LuaObjectScript.ForceDoorClose(false, 5)
    door2.LuaObjectScript.ForceDoorClose(false, 5)
    door6.LuaObjectScript.ForceDoorClose(false, 5)
    door1.LuaObjectScript.Disable()
    door2.LuaObjectScript.Disable()
    door6.LuaObjectScript.Disable()
    HideSideRooms()
    encounter2:Start()
    GameObjects.CubbyHoleManager1.LuaObjectScript.Disable()
    GameObjects.CubbyHoleManager2.LuaObjectScript.Disable()
    if son:IsInsideEntityZone("mainRoomZone") == false then
      son:Warp(GameObjects.warpSon:GetWorldPosition(), GameObjects.warpSon:GetWorldForward())
    end
  end
end
function StartWave_Encounter2()
  encounter2:StartWave(3)
end
function Encounter2Complete()
  game.Compass.SetDesignerForcedHide(false)
  door1.LuaObjectScript.ForceDoorOpen()
  door2.LuaObjectScript.ForceDoorOpen()
  door6.LuaObjectScript.ForceDoorOpen()
  door1.LuaObjectScript.Disable()
  door2.LuaObjectScript.Disable()
  door6.LuaObjectScript.Disable()
  ShowSideRooms()
  bEncounter2Complete = true
  timers.StartLevelTimer(2, Checkpoint, GameObjects.EC2_CheckpointOverride)
  timers.StartLevelTimer(20, function()
    GameObjects.sonContext_control.LuaObjectScript.EnableHint2()
  end)
  GameObjects.RuneVault_Btr_Group.LuaObjectScript.PlayEnjoyThis1()
  GameObjects.EntZnSurprise:Show()
  door3.LuaObjectScript.Enable()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Fire")
  GameObjects.CubbyHoleManager1.LuaObjectScript.Enable()
  GameObjects.CubbyHoleManager2.LuaObjectScript.Enable()
end
function Room2Surprise()
  encounterSurprise:Start()
end
function BalconyFightOn()
  GameObjects.EntZnBalconyFightLeft:Show()
  GameObjects.EntZnBalconyFightRight:Show()
  GameObjects.EntZnBalconyFightL2:Show()
  GameObjects.EntZnBalconyFightR2:Show()
end
function EnteredRoom3()
  bRoom3FirstTime = true
end
function LeftRoom3()
  if bRoom3FirstTime then
    GameObjects.RuneVault_Btr_Group.LuaObjectScript.PlayPrettyDumb()
  end
end
function Quest_Caldera_Objective600()
  uiCalls.UI_Event_SendMsgToQuestLog({
    Category = 10250,
    Header = 37404,
    Body = 43063,
    MessageType = tweaks.tQuestUiMessage.eMessageType.kQMS_Default,
    Quest = "Quest_Caldera_Objective601"
  })
end
function WarpTroll()
  local trolls = thisLevel:FindGameObjectsByMarker("Troll")
  for _, troll in ipairs(trolls) do
    troll:Warp(GameObjects.trollWarpPoint:GetWorldPosition(), GameObjects.trollWarpPoint:GetWorldForward())
  end
  StartTrollEncounter()
end
function Start_NextWave_TrollEncounter()
  trollEncounter:StartWave()
end
function TrollDown()
  if not bTrollEncounterFinished then
    LD.CompleteQuest("Quest_Caldera_Objective600")
    GameObjects.CrackClimb:ShowTraversePath()
    bTrollEncounterFinished = true
    GameObjects.EntryFlicker:Show()
    GameObjects.EntryFlicker:PlayAnimationCycle()
    runeTrollsDead()
    OpenAllDoors()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Troll_Grendel_the_Frost")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Troll_Grendel_of_the_Ashes")
    SetTrollComplete()
    timers.StartLevelTimer(8, function()
      TUT.SkillPointBladesReminder_Tutorial()
    end)
    timers.StartLevelTimer(2, function()
      game.Compass.SetDesignerForcedHide(false)
      game.Audio.PlayBanter("275_VaultStoneTrollDead", Quest_Caldera_Objective600)
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "23_RuneVault_070_TrollKilled"]
      tableEntry.OverrideObject = GameObjects.ECT_CheckpointOverride
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
  end
end
function OpenAllDoors()
  door1.LuaObjectScript.ForceDoorOpen()
  door2.LuaObjectScript.ForceDoorOpen()
  door3.LuaObjectScript.ForceDoorOpen()
  door6.LuaObjectScript.ForceDoorOpen()
  HideDoor3()
  timers.StartLevelTimer(2, Checkpoint)
  bDoorOpen = true
  ShowSideRooms()
end
function CloseAllDoors()
  door1.LuaObjectScript.ForceDoorClose(false, 5)
  door2.LuaObjectScript.ForceDoorClose(false, 5)
  door3:Show()
  door3.Child:Show()
  door3.LuaObjectScript.ForceDoorClose(false, 5)
  door6.LuaObjectScript.ForceDoorClose(false, 5)
  bDoorOpen = false
  HideSideRooms()
end
function HideSideRooms()
  if HideSideRoomsTimer ~= nil and HideSideRoomsTimer.running == true then
    HideSideRoomsTimer:Stop()
  end
  HideSideRoomsTimer = timers.StartLevelTimer(3, _G:HideNonCombat())
end
function ShowSideRooms()
  if HideSideRoomsTimer ~= nil and HideSideRoomsTimer.running == true then
    HideSideRoomsTimer:Stop()
  end
  _G:ShowNonCombat()
end
function HideDoor3()
  timers.StartLevelTimer(6, function()
    if bDoorOpen then
      thisLevel:GetGameObject("Door3").Child:Hide()
      thisLevel:GetGameObject("Door3").LuaObjectScript.Disable()
    end
  end)
  bDoorOpen = true
  game.Audio.StartMusic("SND_MX_CAL_vault_main_room_return_2")
end
function Checkpoint(override)
  if override then
    game.World.StoreCheckpoint({
      OverrideObject = override.Child
    })
  else
    game.World.StoreCheckpoint()
  end
end
function GetEncounter1Complete()
  return bEncounter1Complete
end
function GetEncounter2Complete()
  return bEncounter2Complete
end
function GetEncounter3Complete()
  return bEncounter3Complete
end
function SetEncounter1Complete()
  bEncounter1Complete = true
end
function SetEncounter2Complete()
  bEncounter2Complete = true
end
function SetEncounter3Complete()
  bEncounter3Complete = true
end
function SetTrollComplete()
  bTrollEncounterFinished = true
end
function Start_Witch_HealthMonitor(Enemy)
  if Enemy ~= nil then
    local WitchHealth = Enemy:GetHitPoints()
    local WitchPhase1 = WitchHealth * 0.45
    Witch_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    Witch_HealthMonitor:OnHealthLessThan(WitchPhase1, StartWave_Encounter2)
  end
end
function Start_Troll_HealthMonitor(Enemy)
  if Enemy ~= nil then
    local TrollHealth = Enemy:GetHitPoints()
    Troll_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local TrollPhase1 = TrollHealth * 0.75
    Troll_HealthMonitor:OnHealthLessThan(TrollPhase1, Start_NextWave_TrollEncounter)
  end
end
function CountEnemyDown(enemy)
  print("Enemy " .. tostring(enemy) .. " DEAD")
end
function Area_1_Fight_1()
  encounter1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 RuneVault ", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.EC1_CheckpointOverride
  })
  encounter1:AddWave({
    {
      spawners = "DW_Draugr_N_SFG",
      spawnLocators = "N_Loc_*",
      useSpawnLocatorsOnly = true,
      initialSpawnCooldown = {2, 5},
      initialSpawnAmount = 1,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = {10, 20}
    }
  })
  encounter1:OnEnemyDeath(CountEnemyDown)
  encounter1:OnComplete(Encounter1Complete)
end
function Area_1_Fight_2()
  encounter2 = EC.NewEncounter(thisLevel, "[Area 1]EC:2 RuneVault", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.EC2_CheckpointOverride,
    StartMusic = "SND_MX_CAL_vault_fight_1_in",
    StopMusic = "SND_MX_CAL_vault_fight_1_out"
  })
  encounter2:AddWave({
    {
      spawners = "T3_DW_Draugr_M_SFA_PAE",
      spawnLocators = "V_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.7
    },
    {
      spawners = "T4_DW_Draugr_M_SFA_PAE",
      spawnLocators = "V_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "T4_DW_Draugr_M_SFA_PAE",
      spawnLocators = "V_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.7
    },
    {
      spawners = "T4_DW_Draugr_M_SFA_PAE",
      spawnLocators = "V_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.4
    },
    {
      spawners = "T3_DW_Draugr_M_SFA_PAE",
      spawnLocators = "V_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.5
    }
  })
  encounter2:AddWave({
    requireSpawnersInRange = {10, 50},
    {
      spawners = "T4_Flyer_SP_AIR_For",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.8
    },
    {
      spawners = "T3_Flyer_SP_AIR_For",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.1
    },
    {
      spawners = "T4_Flyer_SP_AIR_For",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3.4
    },
    {
      spawners = "T4_Flyer_SP_AIR_For",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4.6
    }
  })
  encounter2:AddWave({
    requireSpawnersInRange = {10, 50},
    {
      spawners = "T4_DW_Draugr_M_SFA_PLS",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T3_DW_Draugr_M_SFA_PLS",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.4
    },
    {
      spawners = "T4_DW_Draugr_M_SFA_PLS",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.7
    }
  })
  encounter2:AddWave({
    requireSpawnersInRange = {10, 50},
    {
      spawners = "T4_DW_Draugr_M_SFA_PLS",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_DW_Draugr_M_SFA_PLS",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.4
    },
    {
      spawners = "T3_DW_Draugr_M_SFA_PLS",
      spawnLocators = "V_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2.7
    }
  })
  encounter2:OnStart(function()
    GameObjects.PocketRiftSpawn2.LuaObjectScript.StartCombatState()
    GameObjects.PocketRiftSpawn3.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PocketRiftSpawn2.LuaObjectScript.SpawningDone()
    end, 6)
    LD.CallFunctionAfterDelay(function()
      GameObjects.PocketRiftSpawn3.LuaObjectScript.SpawningDone()
    end, 7)
  end)
  encounter2:OnStart(function()
    Checkpoint(GameObjects.EC2_CheckpointOverride)
    game.Compass.SetDesignerForcedHide(true)
  end)
  encounter2:OnEnemyDeath(function()
    encounter2:StartWave(2)
    GameObjects.PocketRiftSpawn2.LuaObjectScript.StartCombatState()
    GameObjects.PocketRiftSpawn3.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PocketRiftSpawn2.LuaObjectScript.SpawningDone()
    end, 7)
    LD.CallFunctionAfterDelay(function()
      GameObjects.PocketRiftSpawn3.LuaObjectScript.SpawningDone()
    end, 6)
  end, {count = 2})
  encounter2:OnEnemyDeath(function()
    encounter2:StartWave(3)
    GameObjects.PocketRiftSpawn2.LuaObjectScript.StartCombatState()
    GameObjects.PocketRiftSpawn3.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PocketRiftSpawn2.LuaObjectScript.SpawningDone()
    end, 5)
    LD.CallFunctionAfterDelay(function()
      GameObjects.PocketRiftSpawn3.LuaObjectScript.SpawningDone()
    end, 4)
  end, {count = 5})
  encounter2:OnEnemyDeath(function()
    encounter2:StartWave(4)
    GameObjects.PocketRiftSpawn2.LuaObjectScript.StartCombatState()
    GameObjects.PocketRiftSpawn3.LuaObjectScript.StartCombatState()
    LD.CallFunctionAfterDelay(function()
      GameObjects.PocketRiftSpawn2.LuaObjectScript.SpawningDone()
    end, 4)
    LD.CallFunctionAfterDelay(function()
      GameObjects.PocketRiftSpawn3.LuaObjectScript.SpawningDone()
    end, 5)
  end, {count = 8})
  encounter2:OnEnemySpawn(function()
    GameObjects.PocketRiftSpawn1.LuaObjectScript.PlaySoundCombatPortalEnemySpawn()
  end)
  encounter2:OnComplete(CompleteQuestFailsafe)
  encounter2:OnComplete(Encounter2Complete)
end
function CompleteQuestFailsafe()
  LD.CompleteQuest("Quest_Caldera_Objective450")
end
function SurpriseRoom2()
  encounterSurprise = EC.NewEncounter(thisLevel, "[Area 1]EC:Surprise", {CheckpointOnComplete = false})
  encounterSurprise:AddWave({
    {
      spawners = "T2_Flyer_SUIC",
      spawnLocators = "Loc_Surp_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T2_Flyer_SUIC",
      spawnLocators = "Loc_Surp_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8
    }
  })
  encounterSurprise:AddWave({
    {
      spawners = "T2_Flyer_SUIC",
      spawnLocators = "Loc_Surp_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  encounterSurprise:SetStartZone(GameObjects.EntZnSurprise)
  encounterSurprise:OnEnemyDeath(function()
    encounterSurprise:StartWave(2)
  end, {count = 1})
end
function DisableDoors()
  door1.LuaObjectScript.Disable()
  door2.LuaObjectScript.Disable()
  door3.LuaObjectScript.Disable()
  door6.LuaObjectScript.Disable()
end
function Area_1_Fight_4()
  fanaticEncounter = EC.NewEncounter(thisLevel, "EC:4 Draugrs ", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.ECF_CheckpointOverride
  })
  fanaticEncounter:AddWave({
    {
      spawners = "DW_Draugr_N_SFG*",
      spawnLocators = "A2_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = {3, 5}
    }
  })
  fanaticEncounter:OnComplete(FanaticEncounterComplete)
  fanaticMonitor = monitors.CreateEntityZoneMonitor(player, GameObjects.fanaticTrigger)
  fanaticMonitor:OnEnter(StartFanaticEncounter)
  fanaticMonitor:SetTriggerCountLimit(1)
end
function BalconyFightLeft()
  encounterBalconyL = EC.NewEncounter(thisLevel, "[Area 1]EC:BalconyL", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_CAL_vault_fight_2_in",
    StopMusic = "SND_MX_CAL_vault_fight_2_out"
  })
  encounterBalconyL:AddWave({
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "A2_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "A2_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8
    },
    {
      spawners = "T2_Flyer_Blind",
      spawnLocators = "A2_Loc_9",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  encounterBalconyL:AddWave({
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "A2_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "A2_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 6
    },
    {
      spawners = "T2_Flyer_Blind",
      spawnLocators = "A2_Loc_8",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 10
    }
  })
  encounterBalconyL:AddWave({
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "B2_Loc_7",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T2_Flyer_Blind",
      spawnLocators = "B2_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  encounterBalconyL:SetStartZone(GameObjects.EntZnBalconyFightLeft)
  encounterBalconyL:OnStart(function()
    GameObjects.EntZnBalconyFightRight:Hide()
    game.World.StoreCheckpoint()
  end)
  encounterBalconyL:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Weapon")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Blind")
  end)
  WaveL2Start = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZnBalconyFightL2)
  WaveL2Start:OnEnter(function()
    encounterBalconyL:StartWave(2)
  end)
end
function BalconyFightRight()
  encounterBalconyR = EC.NewEncounter(thisLevel, "[Area 1]EC:BalconyR", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_CAL_vault_fight_2_in",
    StopMusic = "SND_MX_CAL_vault_fight_2_out"
  })
  encounterBalconyR:AddWave({
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "B2_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "B2_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 8
    },
    {
      spawners = "T2_Flyer_Blind",
      spawnLocators = "B2_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  encounterBalconyR:AddWave({
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "B2_Loc_4",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T4_DW_Draugr_M_SFG_PAE",
      spawnLocators = "B2_Loc_5",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 6
    },
    {
      spawners = "T2_Flyer_Blind",
      spawnLocators = "B2_Loc_6",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 4
    }
  })
  encounterBalconyR:SetStartZone(GameObjects.EntZnBalconyFightRight)
  encounterBalconyR:OnStart(function()
    GameObjects.EntZnBalconyFightLeft:Hide()
    game.World.StoreCheckpoint()
  end)
  encounterBalconyR:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Weapon")
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Nightmare_Blind")
  end)
  WaveR2Start = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZnBalconyFightR2)
  WaveR2Start:OnEnter(function()
    encounterBalconyR:StartWave(2)
  end)
end
function PopcornBalconyFight()
  encounterPopcorn = EC.NewEncounter(thisLevel, "[Area 1]EC:Balcony Popcorn", {CheckpointOnComplete = true})
  encounterPopcorn:AddWave({
    {
      spawners = "T2_Flyer_SP_AIR",
      spawnLocators = "A3_Loc_1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "T2_Flyer_SP_AIR",
      spawnLocators = "A3_Loc_2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.4
    },
    {
      spawners = "T2_Flyer_SP_AIR",
      spawnLocators = "A3_Loc_3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.5
    }
  })
  encounterPopcorn:SetStartZone(GameObjects.EntZnPopcorn)
end
local trollRef, trollBroRef
function TrollSpawned(creature)
  if trollRef == nil then
    trollRef = creature
  else
    trollBroRef = creature
  end
  if bTrollEncounterStarted == true then
    CheckTrollSpawnsForMoveEvent()
  end
end
function StartTrollEncounter()
  bTrollEncounterStarted = true
  CloseAllDoors()
  CheckTrollSpawnsForMoveEvent()
end
function CheckTrollSpawnsForMoveEvent()
  if trollRef ~= nil and trollBroRef ~= nil then
    game.Combat.TurnOnAndLockCombatStatus()
    LD.PlayMove(trollRef, thisObj, "MOV_SpawnStatueExit")
    LD.CallFunctionAfterDelay(function()
      LD.PlayMove(trollBroRef, thisObj, "MOV_SpawnStatueExit")
    end, 10)
  end
end
function Area_1_Fight_5()
  trollEncounter = EC.NewEncounter(thisLevel, "trollFight", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.ECF_CheckpointOverride
  })
  trollEncounter:AddWave({
    {
      spawners = "trollSpawner",
      markerID = "Troll",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "trollBrotherSpawner",
      markerID = "TrollBrother",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  trollEncounter:OnEnemySpawn(TrollSpawned, {wave = 1})
  trollEncounter:OnComplete(TrollDown)
  trollEncounter:OnEnemySpawn(audioTrollVariation, {markerID = "Troll"})
  trollEncounter:OnEnemySpawn(audioTrollBrotherVariation, {
    markerID = "TrollBrother"
  })
end
local trollsMusic = false
function runeTrollDeath()
  if trollEncounter:GetNumEnemiesAlive() == 1 then
    game.Audio.StartMusic("SND_MX_CAL_vault_stone_troll_out")
    trollsMusic = true
  end
end
function runeTrollsDead()
  if trollsMusic == false then
    game.Audio.StartMusic("SND_MX_CAL_vault_stone_troll_out")
  end
end
function audioTrollVariation(Enemy)
  game.Audio.SetWwiseSwitch(Enemy, "CHR_Variation", "CHR_Variation_06")
end
function audioTrollBrotherVariation(Enemy)
  game.Audio.SetWwiseSwitch(Enemy, "CHR_Variation", "CHR_Variation_10")
end
