local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local actor = require("narrative.actor")
local CSL = require("camera.shakelibrary")
local thisLevel, son, thisObj, innerFloor, outerFloor
local bTrapSprung = false
local bTrapFinished = false
local handleToSacrificeKnifeCameraShake, handleToSacrificeKnifeCameraRumble
function OnScriptLoaded(level, obj)
  thisLevel = level
  son = game.AI.FindSon()
  thisObj = obj
  innerFloor = GameObjects.innerTrapFloor
  outerFloor = GameObjects.outerTrapFloor
  SoundInit()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  GameObjects.dustFall_roof:Hide()
  GameObjects.Cinestart_430A:Hide()
end
function OnStart(level, obj)
  if bTrapSprung and not bTrapFinished then
    GameObjects.knifeSacrifice_control.LuaObjectScript.RePositionSon()
    timers.StartLevelTimer(2, StartFloorGears)
  end
  GameObjects.dustFallStopFX:Hide()
end
function OnSaveCheckpoint(level, obj)
  return {bTrapSprung = bTrapSprung, bTrapFinished = bTrapFinished}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bTrapSprung = savedInfo.bTrapSprung
  bTrapFinished = savedInfo.bTrapFinished
end
function StartSpikeTrap()
  GameObjects.waterTrap_control.LuaObjectScript.StopWaterCamera()
  GameObjects.dunkAnim:PlayAnimationToFrame(125, {Rate = 0.5})
  GameObjects.dunkAnim:OnAnimationDone(thisObj, "BackAtLevel")
  GameObjects.innerTrapFloor:PlayAnimationToFrame(220, {Rate = -1})
  PlayFloorLiftSound(GameObjects.dunkAnim, 120)
  bTrapSprung = true
  timers.StartLevelTimer(9.8, function()
    CSL.PlayEffect("FFB_GENERIC_RUMBLE_LOW", 3.8, 0, 1.6)
  end)
end
function BackAtLevel()
  innerFloor:ClearAllAnimCallbacks()
  game.World.StoreCheckpoint()
  timers.StartLevelTimer(2, StartFloorGears)
end
function StartFloorGears()
  game.GameObject.AnimSync(GameObjects.mainspool)
  GameObjects.mainSpool:PlayAnimCycle()
  GameObjects.waterTrapChainL.LuaObjectScript.Lift()
  GameObjects.waterTrapChainR.LuaObjectScript.Lift()
  PlayGearRiseSoundToFrame(2000, GameObjects.spikedRoof)
  GameObjects.knifeSacrifice_control.LuaObjectScript.PositionSon()
  GameObjects.Btr_WaterTrap.LuaObjectScript.PlayWolfTrap2_Start()
  timers.StartLevelTimer(3, ShortLift)
  game.Audio.StartCheckpointedMusic("SND_MX_CAL_vault_puzzle_trap_2_in")
end
function ShortLift()
  innerFloor:JumpAnimToFrame(320)
  local dropEndFrame = 325
  innerFloor:PlayAnimToFrame(dropEndFrame, 0.1)
  PlayRoomLiftSound(innerFloor, 324)
  local trapFloorEndFrame = 5
  outerFloor:PlayAnimToFrame(trapFloorEndFrame, 0.1)
  GameObjects.waterTrap_control.LuaObjectScript.PrepareToLookUpAtSpikes()
  timers.StartLevelTimer(3, LookUp)
end
function LookUp()
  GameObjects.dustFall_roof:Show()
  GameObjects.waterTrap_control.LuaObjectScript.LookUpAtSpikes()
  timers.StartLevelTimer(1, function()
    GameObjects.ceilingDoor:PlayAnimationToEnd(2)
    PlaySoundOnSpikeCeilingOpen()
    timers.StartLevelTimer(0.89, function()
      CSL.PlayEffect("FSE_SHAKE_ROAR", 1, 0, 0.3)
      CSL.PlayEffect("FFB_GENERIC_RUMBLE_STRONG", 1, 0, 0.6)
    end)
    timers.StartLevelTimer(7, function()
      CSL.PlayEffect("FSE_SHAKE_ELEVATOR_RISING", 9, 0.57, 0.3)
      CSL.PlayEffect("FFB_TINY", 9, 0.29, 0.3)
    end)
  end)
  timers.StartLevelTimer(2, function()
    GameObjects.spikedRoof:PlayAnimationToEnd(0.96)
    PlayCeilingDropSoundToFrame(GameObjects.spikedRoof.AnimLengthFrames)
  end)
  timers.StartLevelTimer(2, MainLift)
end
function MainLift()
  innerFloor:ClearAllAnimationCallbacks()
  outerFloor:PlayAnimationToEnd({Rate = 0.2})
  innerFloor:PlayAnimationToEnd({Rate = 0.2})
  innerFloor:OnAnimationDone(thisObj, "AtTop")
  GameObjects.trapFloorShake:PlayAnimationCycle()
  PlayRoomLiftSound(innerFloor, innerFloor.AnimLengthFrames - 1)
end
function StartPanicShakeAndRumble()
  handleToSacrificeKnifeCameraShake = game.Blender.Trigger({
    Name = "FSE_SWAY_PANIC_VERYLIGHT",
    Duration = 23,
    TweenIn = {Time = 2.8},
    TweenOut = {Time = 1},
    Weight = 0.25
  })
  handleToSacrificeKnifeCameraRumble = game.Blender.Trigger({
    Name = "FFB_GENERIC_RUMBLE_STRONG",
    Duration = 23,
    TweenIn = {Time = 2.8},
    TweenOut = {Time = 1},
    Weight = 0.25
  })
  timers.StartLevelTimer(7, function()
    if handleToSacrificeKnifeCameraShake ~= nil then
      handleToSacrificeKnifeCameraShake:Submit(0.49)
    end
    if handleToSacrificeKnifeCameraRumble ~= nil then
      handleToSacrificeKnifeCameraRumble:Submit(0.49)
    end
  end)
  timers.StartLevelTimer(13.5, function()
    if handleToSacrificeKnifeCameraShake ~= nil then
      handleToSacrificeKnifeCameraShake:Submit(0.83)
    end
    if handleToSacrificeKnifeCameraRumble ~= nil then
      handleToSacrificeKnifeCameraRumble:Submit(0.83)
    end
  end)
end
function StopPanicShakeAndRumble()
  if handleToSacrificeKnifeCameraShake ~= nil then
    handleToSacrificeKnifeCameraShake:Stop()
  end
  if handleToSacrificeKnifeCameraRumble ~= nil then
    handleToSacrificeKnifeCameraRumble:Stop()
  end
end
function AtTop()
  CSL.PlayDefaultShake("ElevatorMovement_Reached", 0.6, 0.2, 0.3)
  GameObjects.waterTrap_control.LuaObjectScript.SetSpikeKratosCamera()
  timers.StartLevelTimer(6, function()
    GameObjects.waterTrap_control.LuaObjectScript.SetSpikeSonCamera()
    StartPanicShakeAndRumble()
  end)
  timers.StartLevelTimer(8, function()
    GameObjects.waterTrap_control.LuaObjectScript.SetSpikeIdleCamera()
  end)
end
function OpenRoof()
end
function ZoomInOnSacrifice()
  if GameObjects.spikedRoof.AnimFrame < 1700 then
    GameObjects.spikedRoof:PlayAnimationToFrame(1700, {Rate = 5})
    GameObjects.spikedRoof:OnAnimationDone(thisObj, "SlowGrindDown")
  elseif GameObjects.spikedRoof.AnimFrame < 2000 then
    SlowGrindDown()
  end
end
function SlowGrindDown()
  GameObjects.spikedRoof:ClearAllAnimationCallbacks()
  local newSpeed = (2000 - GameObjects.spikedRoof.AnimFrame) / 350
  GameObjects.spikedRoof:PlayAnimationToFrame(2000, {Rate = newSpeed})
end
function KnifeSacrificeSuccess()
  StopPanicShakeAndRumble()
  StopCeilingDropSound()
  GameObjects.waterTrapChainR.LuaObjectScript.Break()
  GameObjects.waterTrap_control.LuaObjectScript.ReturnToNormalCamera()
  GameObjects.mainSpool:PauseAnim()
  timers.StartLevelTimer(6, DentGrate)
  PlayBreakEffects()
  GameObjects.waterTrap_control.LuaObjectScript.PlayGearsExplodingCamera()
  GameObjects.spikedRoof:PauseAnim()
  GameObjects.GroundPlate:Hide()
  GameObjects.SpikeJitter:PauseAnim()
  timers.StartLevelTimer(6, WindBackSpikes)
  GameObjects.dustFall_roof:Hide()
  GameObjects.dustFallStopFX:Show()
  game.FX.Spawn("dustFallStop", thisLevel, {
    GameObject = GameObjects.dustFallStopFX,
    AutoDelete = true
  })
end
function DentGrate()
  GameObjects.Btr_ThirdEagle:HideEntityVolume()
  GameObjects.BlackRunestone_Aura:Hide()
  CSL.PlayDefaultShake("ShakeRumbleLarge", 0.3)
  timers.StartLevelTimer(1.96, function()
    BigShake()
    CSL.PlayShake("FFB_SLAM", 0.35, 0, 0.3)
  end)
  GameObjects.gate_floor_rubble:PlayAnimationToEnd()
  game.FX.Spawn("waterTrapExplosion", thisLevel, {
    GameObject = GameObjects.breakGrateEffect1,
    AutoDelete = true
  })
  timers.StartLevelTimer(0.3, function()
    game.FX.Spawn("waterTrapExplosion", thisLevel, {
      GameObject = GameObjects.breakGrateEffect2,
      AutoDelete = true
    })
  end)
  timers.StartLevelTimer(1, function()
    game.FX.Spawn("waterTrapExplosion", thisLevel, {
      GameObject = GameObjects.breakGrateEffect3,
      AutoDelete = true
    })
  end)
  timers.StartLevelTimer(1.15, PlaySoundOnAnchorRelease)
  GameObjects.Grate_InteractiveOneWay.LuaObjectScript.Enable()
  GameObjects.calderaCenterChain00.LuaObjectScript.StartSlam()
  GameObjects.calderaDiagonalChain00.LuaObjectScript.StartSlam()
  game.Player.FindPlayer().Pad:EnableGameButton(tweaks.ePad.kPadUp)
  son:RemoveAvailabilityRequest("LevelDesignScript")
  GameObjects.WT_ExitFloor_Broken:Show()
  GameObjects.WT_ExitFloor:Hide()
  GameObjects.calderaCenterChain00.LuaObjectScript.HideLights()
  GameObjects.Cinestart_430A:Show()
end
function HitGrate()
  GameObjects.trapFloorShake:PauseAnimation()
end
function WindBackSpikes()
  GameObjects.spikedRoof:PlayAnimToFrame(1000, -1)
  PlayCeilingRiseSoundToFrame(1000)
  bTrapSprung = false
  GameObjects.gearPuzzle_control.LuaObjectScript.Cancel()
  timers.StartLevelTimer(4, ReleaseTrap)
  local stomperwad = game.FindLevel("Cal512_RuneVaultHalls2")
  stomperwad:CallScript("StartStompers")
end
function ReleaseTrap()
  game.Player.FindPlayer():CallScript("LuaHook_DisableRevive", false)
  GameObjects.waterTrapVines.LuaObjectScript.ReleaseTrap()
  GameObjects.waterTrap_control.LuaObjectScript.ReleaseTrap()
  GameObjects.knifeSacrifice_control.LuaObjectScript.ReleaseSon()
  timers.StartLevelTimer(2, function()
    GameObjects.Btr_WaterTrap.LuaObjectScript.PlayWolfTrap2_KnifeSacrifice()
    GameObjects.CA_TiredHandOnWall.LuaObjectScript.Enable()
    GameObjects.Reaction_OutOfBreath.LuaObjectScript.Trigger()
    LD.DisableContextBehaviorBanter()
  end)
end
function OnGrateKick_StartApproach()
  bTrapFinished = true
  _G.EnableRuneVaultSonCollision()
end
function OnGrateKick_StartSync()
  GameObjects.waterTrap_control.LuaObjectScript.CameraStartKickApproach010()
  game.Audio.PlayBanter("265_RuneAhoy")
  PlayGrateBreakSound()
  GameObjects.Balcony_Gate_Broken:Show()
  GameObjects.Balcony_Gate_Pristine:Hide()
  GameObjects.finalgrate:HideCollision()
  GameObjects.finalgrate.Child:PlayAnimToEnd()
  LD.CallFunctionAfterDelay(function()
    GameObjects.calderaCenterChain00.LuaObjectScript.SlamDown()
    GameObjects.calderaDiagonalChain00.LuaObjectScript.SlamDown()
  end, 0.1)
  GameObjects.CamZone_SphereFall:ShowCameraVolume()
end
local Setup_GrateKickSequence = function()
  local ND = require("design.NarrativeDesignLibrary")
  local kraActor = actor.Actor.New("RuneVault GrateKick: Kratos Actor", game.Player.FindPlayer)
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "RuneVault GrateKick Sequence")
  cineSeq:WaitForActorMoveComplete(kraActor)
  cineSeq:Do(function()
    game.Cinematics.EnableCinematicMode()
    timers.StartLevelTimer(0.8, function()
      GameObjects.waterTrap_control.LuaObjectScript.CameraStartKickApproach020()
    end)
  end)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_SetIdle",
    ReferenceJoint = "hero_waitJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:Do(function()
    _G.CloseIris()
  end)
  cineSeq:Do(function()
    game.Cinematics.DisableCinematicMode()
  end)
  cineSeq:Do(CompleteQuest_Caldera_Objective550)
  cineSeq:Do(function()
    game.Compass.SetDesignerForcedHide(true)
  end)
  cineSeq:StartSequence()
end
function OnGrateKick_InteractFinish()
  Setup_GrateKickSequence()
end
function BigShake()
  game.FX.SubmitEffect({
    EffectName = "FSE_shake_temp_Generic_Large",
    Duration = 1
  })
end
function SmallShake()
  game.FX.SubmitEffect({
    EffectName = "FSE_shake_temp_Generic_Small",
    Duration = 1
  })
end
function PlayBreakEffects()
  game.FX.Spawn("waterTrapExplosion", thisLevel, {
    GameObject = GameObjects.breakEffect1,
    AutoDelete = true
  })
  PlaySoundOnBreakEffectsStart()
  timers.StartLevelTimer(0.5, PlayEffect, GameObjects.breakEffect2)
  timers.StartLevelTimer(1, PlayEffect, GameObjects.breakEffect3)
  timers.StartLevelTimer(1.5, PlayEffect, GameObjects.breakEffect4)
  timers.StartLevelTimer(2, PlayEffect, GameObjects.breakEffect5)
  timers.StartLevelTimer(2.5, PlayEffect, GameObjects.breakEffect6)
  timers.StartLevelTimer(3, PlayEffect, GameObjects.breakEffect7)
  timers.StartLevelTimer(3.5, PlayEffect, GameObjects.breakEffect8)
  timers.StartLevelTimer(3.8, PlayEffect, GameObjects.breakEffect9)
  timers.StartLevelTimer(3.5, PlayEffect, GameObjects.breakEffect10)
  timers.StartLevelTimer(3.8, PlayEffect, GameObjects.breakEffect11)
  timers.StartLevelTimer(4.2, PlayEffect, GameObjects.breakEffect12)
  timers.StartLevelTimer(4.8, PlayEffect, GameObjects.breakEffect13)
  timers.StartLevelTimer(5.3, PlayEffect, GameObjects.breakEffect13)
  timers.StartLevelTimer(5.6, PlayEffect, GameObjects.breakEffect13)
  timers.StartLevelTimer(4.8, function()
    PlayEffect(nil, GameObjects.breakEffect14)
    GameObjects.waterTrapChainL.LuaObjectScript.Break()
  end)
end
function PlayEffect(newFunction, thePlace)
  game.FX.Spawn("waterTrapExplosion", thisLevel, {GameObject = thePlace, AutoDelete = true})
  CSL.PlayDefaultShake("ShakeRumbleMedium", 0.23)
  PlaySoundOnBreakEffect(thePlace)
end
function CompleteQuest_Caldera_Objective550()
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective550", "Complete")
end
local SNDFloorDrop, SNDSpikedRoof, SNDGrateBreak
local TrapFloorGearEmitters = {}
local soundEvents = {
  FloorLiftLoop = "SND_MECH_Cal500_SunMoon_Floor_Rise_LP",
  FloorLiftLoop_Start = "SND_MECH_Cal500_SunMoon_Floor_Rise_Start",
  RoomLiftLoop = "SND_MECH_Cal500_SunMoon_Room_Rise_LP",
  RoomLiftLoop_Start = "SND_MECH_Cal500_SunMoon_Room_Rise_Start",
  GearRiseLoop = "SND_MECH_Cal500_SunMoon_Gear_Rise_LP",
  GearJam = "SND_MECH_Cal500_SunMoon_Gear_Jam",
  GearBreakStart = "SND_MECH_Cal500_SunMoon_BRK_Gears_Start",
  GearExplosion = "SND_MECH_Cal500_SunMoon_BRK_Gear_Explo",
  SpikeCeilingCoverOpen = "SND_MECH_Cal500_SpikeTrap_Ceiling_Open",
  SpikesDropLoop = "SND_MECH_Cal500_SunMoon_Spikes_Drop_LP",
  SpikesDropLoop_Start = "SND_MECH_Cal500_SunMoon_Spikes_Drop_Start",
  SpikesRiseLoop = "SND_MECH_Cal500_SunMoon_Spikes_Rise_LP",
  SpikesRiseLoop_Start = "SND_MECH_Cal500_SunMoon_Spikes_Rise_Start",
  SkewerKratos = "SND_MECH_Cal500_SunMoon_Spikes_Fail",
  AnchorRelease = "SND_MECH_Cal500_SunMoon_BRK_Chain",
  GrateBreak = "SND_MECH_Cal500_SunMoon_Gate_Kick"
}
function SoundInit()
  SNDFloorDrop = innerFloor:FindSingleSoundEmitterByName("SNDFloorDrop")
  SNDSpikedRoof = GameObjects.spikedRoof:FindSingleSoundEmitterByName("SNDSpikedRoof")
  SNDGrateBreak = GameObjects.SNDGrateBreakGrp:FindSingleSoundEmitterByName("SNDGrateBreak")
  TrapFloorGearEmitters = GameObjects.WaterTrapChains.SoundEmitters
end
function PlayFloorLiftSound(liftObject, endFrame)
  LD.PlaySound(SNDFloorDrop, soundEvents.FloorLiftLoop_Start)
  LD.GameObjects.waterTrap_control.LuaObjectScript.StopSoundFloorWaterLapsLoop()
  LD.PlayLoopingSoundToAnimFrame(SNDFloorDrop, liftObject, soundEvents.FloorLiftLoop, 0, endFrame)
end
function PlayRoomLiftSound(liftObject, endFrame)
  LD.PlaySound(SNDFloorDrop, soundEvents.RoomLiftLoop_Start)
  LD.PlayLoopingSoundToAnimFrame(SNDFloorDrop, liftObject, soundEvents.RoomLiftLoop, 0, endFrame)
end
function PlayGearRiseSoundToFrame(endFrame, animObj)
  for i = 1, #TrapFloorGearEmitters do
    LD.PlayLoopingSoundToAnimFrame(TrapFloorGearEmitters[i], animObj, soundEvents.GearRiseLoop, 0, endFrame)
  end
end
function PlayGearJamSound()
  LD.PlaySound(GameObjects.WaterTrapChains:FindSingleSoundEmitterByName("SNDGearRight"), soundEvents.GearJam)
  for i = 1, #TrapFloorGearEmitters do
    LD.StopSound(TrapFloorGearEmitters[i], soundEvents.GearRiseLoop)
  end
end
function PlaySoundOnSpikeCeilingOpen()
  LD.PlaySound(SNDSpikedRoof, soundEvents.SpikeCeilingCoverOpen)
end
function PlayCeilingRiseSoundToFrame(endFrame)
  StopCeilingDropSound()
  LD.PlaySound(SNDSpikedRoof, soundEvents.SpikesRiseLoop_Start)
  LD.PlaySound(SNDSpikedRoof, soundEvents.SpikesRiseLoop)
  LD.StopSoundOnFrame(SNDSpikedRoof, GameObjects.spikedRoof, soundEvents.SpikesRiseLoop, endFrame, "backward")
end
function StopCeilingDropSound()
  LD.StopSound(SNDSpikedRoof, soundEvents.SpikesDropLoop)
end
function PlayCeilingDropSoundToFrame(endFrame)
  LD.PlaySound(SNDSpikedRoof, soundEvents.SpikesDropLoop_Start)
  LD.PlayLoopingSoundToAnimFrame(SNDSpikedRoof, GameObjects.spikedRoof, soundEvents.SpikesDropLoop, 0, endFrame)
end
function PlaySoundOnSkewerKratos()
  LD.PlaySound(SNDSpikedRoof, soundEvents.SkewerKratos)
end
function PlayGrateBreakSound()
  LD.PlaySound(SNDGrateBreak, soundEvents.GrateBreak)
end
function PlaySoundOnBreakEffectsStart()
  LD.PlaySound(GameObjects.WaterTrapChains:FindSingleSoundEmitterByName("SNDGearRight"), soundEvents.GearBreakStart)
end
function PlaySoundOnBreakEffect(breakEffectGO)
  LD.PlaySound(breakEffectGO.Child.SoundEmitters[1], soundEvents.GearExplosion)
end
function PlaySoundOnAnchorRelease()
  LD.PlaySound(SNDGrateBreak, soundEvents.AnchorRelease)
end
