timers = require("level.timer")
LD = require("design.LevelDesignLibrary")
thisObj = nil
thisLevel = nil
player = nil
son = nil
traps = {}
currentTrap = 1
trapDelay = 0.25
numberOftraps = 0
trapTimer = nil
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  traps = obj:FindGOsByName("trap*")
  trapDelay = obj:FindLuaTableAttribute("Delay") or 0.25
  if game.SubObject then
    game.SubObject.Sleep(obj)
    game.SubObject.SetForgetOnCheckpoint(obj)
  end
end
function OnUpdate(level, obj)
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function Glow()
  Start()
end
function Start()
  for _, trap in ipairs(traps) do
    local name = trap:GetName()
    if string.match(name, "trap_stomper") then
      trap.Child.LuaObjectScript.Enable(true)
    elseif string.match(name, "trap_saw") then
      trap.Child.LuaObjectScript.Start(true)
    end
  end
end
function NameNumber(index)
  local number
  if traps[number] ~= nil then
    number = string.match(traps[index]:GetName(), "%d+")
  end
  return number
end
