local thisObj, player, kraPuppeteer
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  thisObj:Hide()
end
function OnStart(level, obj)
  thisObj:PlayAnimationToFrame(1, {
    Animation = "envWaterTrapEntrance"
  })
end
function StartTrap()
  thisObj:Show()
  local slaveTable = {}
  slaveTable[1] = {
    Slave = thisObj,
    Anim = "envWaterTrapEntrance"
  }
  kraPuppeteer = game.Puppeteer.NewForce(thisObj, "WaterVineTrap", player)
  kraPuppeteer:WeaponEquip({weaponMode = "Bare"})
  kraPuppeteer:Sync("BRA_Trapped", true, slaveTable, "waterTrap_synchJoint")
end
function ReloadTrap()
  local slaveTable = {}
  slaveTable[1] = {
    Slave = thisObj,
    Anim = "envWaterTrapIdle"
  }
  kraPuppeteer = game.Puppeteer.NewForce(thisObj, "WaterVineTrap", player)
  kraPuppeteer:WeaponEquip({weaponMode = "Bare"})
  kraPuppeteer:Sync("BRA_Trapped_Loop", true, slaveTable, "waterTrap_synchJoint")
end
function ReleaseTrap()
  player:TriggerMoveEvent("LE_WATERTRAP_EXIT")
  kraPuppeteer = nil
end
function KillWithSpikes()
  local slaveTable = {}
  slaveTable[1] = {
    Slave = thisObj,
    Anim = "envWaterTrapSpikeFail"
  }
  if kraPuppeteer ~= nil then
    kraPuppeteer:Sync("BRA_WaterTrapSpikeKill", true, slaveTable, "waterTrap_synchJoint")
  end
end
function KillWithWater()
  local slaveTable = {}
  slaveTable[1] = {
    Slave = thisObj,
    Anim = "envWaterTrapWaterFail"
  }
  if kraPuppeteer ~= nil then
    kraPuppeteer:Sync("BRA_WaterTrapWaterKill", true, slaveTable, "waterTrap_synchJoint")
  end
end
