local timers = require("level.timer")
local bookmarks = require("design.Bookmarks")
local bEnabled = false
local checkpoint = require("level.checkpoint")
local bRuneChestOpened = false
function OnStart(level)
  if bEnabled then
    GameObjects.trap_stomper3.LuaObjectScript.ForceCloseCrusher()
    GameObjects.trap_stomper2.LuaObjectScript.ForceOpenCrusher()
    GameObjects.trap_stomper1.LuaObjectScript.ForceCloseCrusher()
    timers.StartLevelTimer(3, StartStompers)
  end
  if bRuneChestOpened then
    GameObjects.trap_stomper3:FindSingleGOByName("Crusher_Gnome_3"):Hide()
  end
end
function StartStompers()
  bEnabled = true
  GameObjects.trap_stomper3.LuaObjectScript.Enable(true)
  timers.StartLevelTimer(0.25, function()
    GameObjects.trap_stomper2.LuaObjectScript.Enable(true)
  end)
  timers.StartLevelTimer(0.5, function()
    GameObjects.trap_stomper1.LuaObjectScript.Enable(true)
  end)
end
function StopStompers()
  bEnabled = false
  GameObjects.trap_stomper3.LuaObjectScript.ForceCloseCrusher()
  GameObjects.trap_stomper2.LuaObjectScript.ForceOpenCrusher()
  GameObjects.trap_stomper1.LuaObjectScript.ForceCloseCrusher()
end
function OnSaveCheckpoint(level)
  print("SAVING CHECKPOINT FOR ROOM2 " .. tostring(bEnabled))
  return {
    levelstate = checkpoint.Save(),
    bEnabled = bEnabled,
    bRuneChestOpened = bRuneChestOpened
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  print("RESTORING CHECKPOINT FOR ROOM2 " .. tostring(savedInfo.bEnabled))
  bEnabled = savedInfo.bEnabled
  bRuneChestOpened = savedInfo.bRuneChestOpened
end
function RuneChestOpened()
  bRuneChestOpened = true
  game.FindLevel("Cal500_RuneVault"):CallScript("CheckpointRuneChest")
end
function Break_Gnome_03()
  local Cal500_Level = game.FindLevel("Cal500_RuneVault")
  print(Cal500_Level)
  if Cal500_Level ~= nil then
    Cal500_Level:CallScript("Break_Gnome_03")
  end
end
