local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local timers = require("level.timer")
local thisObj, thisLevel, kraActor, sonActor, boatActor, boat, boatPuppeteerHelper
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function SetupScene()
  SetupActors()
  SpawnBoat()
end
function DisableScene()
  thisObj:FindSingleGOByName("Interact_SonBoatEnter").LuaObjectScript:Disable()
end
function SpawnBoat()
  thisObj:FindSingleGOByName("Interact_SonBoatEnter").LuaObjectScript:Enable()
  local boatPos = LD.GetWorldJointPosition("Cine_SonBoatEnter", "Boat_StartJoint")
  local boatDir = LD.GetWorldJointForward("Cine_SonBoatEnter", "Boat_StartJoint")
  local boatWad = game.FindLevel("BoatGlobal")
  if game.Level.GetVariable("CompletedCineNumber") < 367 then
    boatActor:SetSpawnFunction(function()
      return game.AI.Spawn(boatWad, boatPos, boatDir, "CRT_Boat00", "BRA_Spawn")
    end)
    local seq = LD.CreateCineSequence(thisLevel, thisObj, "spawn boat")
    seq:SpawnActorAndWait(boatActor)
    seq:Do(DisableBoatPrompt)
    seq:Do(function()
      boat:AddMarker("pendingDockCinematic")
      boat:AddMarker("SonSick")
    end)
    seq:StartSequence()
  end
end
function DisableBoatPrompt()
  boat = boatActor:GetCreature()
  boatPuppeteerHelper = boat:FindSingleGOByName("puppeteerHelper")
  boatPuppeteerHelper:CallScript("DisableInteractZone")
end
function SetupActors()
  kraActor = actor.Actor.New("KRATOS", game.Player.FindPlayer)
  sonActor = actor.Actor.New("SON", game.AI.FindSon)
  boatActor = actor.Actor.New("BOAT")
end
function SetupSeq()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "SonBoatEnter")
  local slaveTab = {
    {Actor = kraActor},
    {Actor = sonActor}
  }
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master", nil, nil, "SND_MX_SonSick_travel_to_freya_in")
  seq:MarkAbleToSkip()
  seq:RequestCineModeAndWait(kraActor, thisObj)
  seq:Do(DisableSpline)
  seq:Do(UpdateDockingSystemOnBoatEnter)
  seq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_SonBoatEnter",
    ReferenceJoint = "SonBoatEnter_SynchJoint",
    speed = ND.KraWalkSpeed,
    should_strafe = true,
    stop = false,
    radius = 0.3,
    weapon_state = "bare"
  })
  seq:ActorSync(boatActor, {
    Slaves = slaveTab,
    Branch = "BRA_SonBoatEnter",
    ReferenceJoint = "SonBoatEnter_SynchJoint"
  })
  seq:Do(game.AI.FindSon():CallScript("EnterBehaviorContext", "BOAT_SICK_CONTEXT_CONFIG"))
  seq:Do(AddBoatMarkers)
  seq:WaitUntilActorAnimPastPercentage(kraActor, 0.89)
  seq:Do(ShowForcedCamera_BoatSettle)
  seq:WaitForAndCompleteCineMode(kraActor, thisObj)
  seq:StopPuppetingActor(kraActor)
  seq:StopPuppetingActor(sonActor)
  seq:StopPuppetingActor(boatActor)
  seq:Do(function()
    game.Compass.SetDesignerForcedHide(false)
  end)
  seq:SetCompletedCineNumber(368)
  seq:Do(HideForcedCamera_BoatSettle)
  seq:StartSequence()
end
function UpdateDockingSystemOnBoatEnter()
  boatPuppeteerHelper:CallScript("NotifyDockSystem_PlayerEnteringBoat", boat)
end
function AddBoatMarkers()
  local player = game.Player.FindPlayer()
  local son = game.AI.FindSon()
  player:AddMarker("pendingDockCinematic")
  player:AddMarker("SonSick")
  son:AddMarker("pendingDockCinematic")
  son:AddMarker("SonSick")
end
function DisableSpline()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  if cal590 then
    cal590:CallScript("DisableSpline")
  end
  local newLevel = game.FindLevel("Cal100_Hub")
  if newLevel ~= nil then
    newLevel:CallScript("CloseModiDoor")
  end
end
function ShowForcedCamera_BoatSettle()
  GameObjects.CamZone_ModiAmbush_ForcedBoat:ShowCameraVolume()
end
function HideForcedCamera_BoatSettle()
  timers.StartLevelTimer(0, function()
    GameObjects.CamZone_ModiAmbush_ForcedBoat:HideCameraVolume()
  end)
  game.FindLevel("Cal100_Hub"):CallScript("KidInBoat")
end
