local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, wineBottle, cine_lights_440B, cameraCineEnter_DemigodToast, shadowBlocker
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  cine_lights_440B = GameObjects.Cine_Start_440b
end
function OnStart(level, obj)
  CreateActors()
  CreateProps()
  HideCineLights()
  HideCineLightsB()
  shadowBlocker = GameObjects.cal590_shadowblocker_topgrp
end
function OnUpdate()
  if cameraCineEnter_DemigodToast ~= nil then
    cameraCineEnter_DemigodToast:Update()
  end
end
function CreateActors()
  kraActor = actor.Actor.New("DEMIGOD TOAST: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("DEMIGOD TOAST: Son Actor", game.AI.FindSon)
end
function CreateProps()
  wineBottle = thisObj:FindSingleGOByName("greekWineBottle00").Child
  wineBottle:StartAnim("narCalDemigodToast000CineScene")
  wineBottle:JumpAnimToFrame(0)
  wineBottle:PauseAnim()
  HideProps()
end
function HideProps()
  wineBottle:Hide()
end
function ShowProps()
  wineBottle:Show()
end
function HideShadowBlocker()
  shadowBlocker:Hide()
end
function ShowShadowBlocker()
  shadowBlocker:Show()
end
function BuildDemigodToastSequence()
  if game.Level.GetVariable("CompletedCineNumber") >= 430 and game.Level.GetVariable("CompletedCineNumber") < 440 then
    local demigodToastSeq = ND.CreateCineSequence(thisLevel, thisObj, "demigodToast")
    local demigodToast_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_DemigodToast"
      },
      {
        Obj = wineBottle,
        Anim = "narCalDemigodToast000CineScene"
      }
    }
    demigodToastSeq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
    demigodToastSeq:MarkAbleToSkip()
    demigodToastSeq:RequestCineModeAndWait(kraActor, thisObj)
    demigodToastSeq:Do(OpenElevatorGateway)
    demigodToastSeq:Do(HideShadowBlocker)
    demigodToastSeq:Do(StartCineEnter_DemigodToast)
    demigodToastSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_DemigodToast",
      ReferenceJoint = "DemigodToast_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.InteractStopDistance,
      weapon_state = "bare",
      strafe_distance = 1
    })
    demigodToastSeq:Do(function()
      local player = game.Player.FindPlayer()
      player:AddChild(cine_lights_440B, player:GetJointIndex("zeroJoint"))
    end)
    demigodToastSeq:Do(PlayCineLights)
    demigodToastSeq:Do(PlayCineLightsB)
    demigodToastSeq:Do(TurnOffMovementWind)
    demigodToastSeq:Do(function()
      LD.UnlockTyrOdinBoatLore()
    end)
    demigodToastSeq:Do(ShowProps)
    demigodToastSeq:Do(function()
      _G.HideCal200FromInside()
    end)
    demigodToastSeq:ActorSync(kraActor, {
      Slaves = demigodToast_ActorTable,
      Branch = "BRA_DemigodToast",
      ReferenceJoint = "DemigodToast_SynchJoint"
    })
    demigodToastSeq:Do(function()
      GameObjects.PostModi_CA_BeckonToMe.LuaObjectScript.Disable()
    end)
    demigodToastSeq:WaitUntilActorAnimPastFrame(kraActor, 100)
    demigodToastSeq:Do(MoveToTopFloor)
    demigodToastSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.025)
    demigodToastSeq:Do(PlaySandbowlEffects)
    demigodToastSeq:WaitUntilActorAnimPastFrame(kraActor, 2952)
    demigodToastSeq:Do(OpenMedallion)
    demigodToastSeq:WaitUntilActorAnimPastFrame(kraActor, 4224)
    demigodToastSeq:Do(ShowCal100)
    demigodToastSeq:WaitUntilActorAnimPastFrame(kraActor, 4824)
    demigodToastSeq:Do(LowerSeats)
    demigodToastSeq:WaitUntilActorAnimPastFrame(kraActor, 5151)
    demigodToastSeq:Do(DropToAtrium)
    demigodToastSeq:WaitUntilActorAnimPastFrame(kraActor, 5199)
    demigodToastSeq:Do(CloseMedallion)
    demigodToastSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    demigodToastSeq:Do(TurnOnMovementWind)
    demigodToastSeq:SetCompletedCineNumber(440)
    demigodToastSeq:StopPuppetingActor(sonActor)
    demigodToastSeq:StopPuppetingActor(kraActor)
    demigodToastSeq:Do(StartPeaksObjective)
    demigodToastSeq:Do(CloseElevatorGateway)
    demigodToastSeq:Do(HideProps)
    demigodToastSeq:Do(ShowShadowBlocker)
    demigodToastSeq:StartSequence()
  end
end
function ShowCal100()
  local cal100 = game.FindLevel("Cal100_Hub")
  if cal100 ~= nil then
    cal100:CallScript("ArrivedAtTop")
  end
end
function TurnOnMovementWind()
  game.FX.SetEnableCounterWind(true)
end
function TurnOffMovementWind()
  game.FX.SetEnableCounterWind(false)
end
function OpenElevatorGateway()
  local cal200 = game.FindLevel("Cal200_Shore")
  if cal200 ~= nil then
    cal200:CallScript("OpenElevatorGateway")
  end
end
function CloseElevatorGateway()
  local cal200 = game.FindLevel("Cal200_Shore")
  if cal200 ~= nil then
    cal200:CallScript("CloseElevatorGateway")
  end
end
function PlaySandbowlEffects()
  GameObjects.ElevatorRuneBowl_PostModi.LuaObjectScript.SetSandBowlVisualState(4)
end
function MoveToTopFloor()
  GameObjects.BasicElevatorManager.LuaObjectScript.SetIgnoreNextCheckpointOnFloor()
  GameObjects.Load_Cal500:HideEntityVolume()
  GameObjects.Unload_Cal500:HideEntityVolume()
  GameObjects.LoadCineUp:ShowEntityVolume()
  timers.StartLevelTimer(3, function()
    thisObj:PlayAnimationToEnd({Rate = 0.5})
    GameObjects.BasicElevatorManager.LuaObjectScript.UpdateMoveSpeed(0.5, 0.5)
    GameObjects.BasicElevatorManager.LuaObjectScript.MoveUp()
    GameObjects.Seat:PlayAnimationToEnd()
  end)
end
function LowerSeats()
  GameObjects.Seat:PlayAnimToEnd(-1)
end
function PlayCineLights()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  if cal590 then
    cal590:CallScript("PlayCineLights")
  end
end
function HideCineLights()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  if cal590 then
    cal590:CallScript("HideCineLights")
  end
end
function PlayCineLightsB()
  cine_lights_440B:Show()
  cine_lights_440B:JumpAnimToFrame(0)
  cine_lights_440B:PlayAnimToEnd()
end
function HideCineLightsB()
  cine_lights_440B:Hide()
end
function TriggerCineFogHacks()
  if game.Cinematics.FadeInDensityMap ~= nil then
    game.Cinematics.FadeInDensityMap(3)
  end
  if game.Cinematics.CorrectDensityAtFogLights ~= nil then
    game.Cinematics.CorrectDensityAtFogLights(8)
  end
end
function OpenMedallion()
  _G.ShowCal200FromInside()
  local cal200 = game.FindLevel("Cal200_Shore")
  if cal200 ~= nil then
    cal200:CallScript("HideQuads")
  end
  local cal100 = game.FindLevel("Cal100_Hub")
  if cal100 ~= nil then
    cal100:CallScript("OpenMedallion")
  end
  TriggerCineFogHacks()
end
function CloseMedallion()
  local cal100 = game.FindLevel("Cal100_Hub")
  if cal100 ~= nil then
    cal100:CallScript("CloseMedallion")
  end
end
function DropToAtrium()
  local cal590 = game.FindLevel("Cal590_RuneVaultElevator")
  cal590:CallScript("DropElevatorToAtrium")
end
function StartPeaksObjective()
  game.Compass.SetDesignerForcedHide(false)
  game.QuestManager.ProposeQuestState("Quest_Caldera_Objective601", "Complete")
  LD.ActivateQuest("Quest_Summit_Parent")
  local cal100 = game.FindLevel("Cal100_Hub")
  if cal100 ~= nil then
    cal100:GetGameObject("Btr_Caldera_Bridge"):CallScript("EnableJotunheimOrBust")
  end
  GameObjects.Load_Cal500:ShowEntityVolume()
  GameObjects.Unload_Cal500:ShowEntityVolume()
  GameObjects.LoadCineUp:HideEntityVolume()
end
function StartCineEnter_DemigodToast()
  cameraCineEnter_DemigodToast = CCEC.CineEnterCamera.New("ENV_CineEnter_DemigodToast", 7)
  cameraCineEnter_DemigodToast:SetCallback(DestroyCineEnter_DemigodToast)
  cameraCineEnter_DemigodToast:Start()
end
function DestroyCineEnter_DemigodToast()
  cameraCineEnter_DemigodToast = nil
  game.SubObject.Sleep(thisObj)
end
