local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timers = require("level.timer")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local monitors = require("level.MonitorLibrary")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, sonActor, modiActor, kratosActor, seq
local cineStarted = false
local cameraCineEnter_Modi2, cine_lights_365
local playedPrimaryHint = false
local secondHintTimer
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  cine_lights_365 = GameObjects.Cine_Start_365
  HideCineLights()
end
function OnUpdate(level, obj)
  if cameraCineEnter_Modi2 ~= nil then
    cameraCineEnter_Modi2:Update()
  end
end
function CreateActorsAndProps()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
  modiActor = actor.Actor.New("Modi")
  SetSpawnFunctions()
end
function SetSpawnFunctions()
  modiActor:SetSpawnFunction(function()
    local cineWad = game.FindLevel("Cal590_c365_ModiAmbush")
    return ND.SpawnAIAtJoint(cineWad, "Cine_Modi2", "Modi_Start", "CRT_Modi00", "BRA_Spawn_Modi2", "Modi")
  end)
end
function EnteredContextAction()
  if game.Level.GetVariable("CompletedCineNumber") < 360 then
    game.Level.SetVariable("CompletedCineNumber", 360)
  end
  if game.Level.GetVariable("CompletedCineNumber") <= 360 and not cineStarted then
    if not playedPrimaryHint then
      game.Audio.PlayBanter("090_SandBowlInterrupts_01")
      secondHintTimer = timers.StartLevelTimer(15, PlaySecondHintBanter)
      playedPrimaryHint = true
    else
      PlaySecondHintBanter()
    end
    GameObjects.ModiBowl_Interact.LuaObjectScript.GetInteractZone():SetRequiresCriticalBanterComplete(true)
    GameObjects.ModiBowl_Interact.LuaObjectScript.Enable()
    game.World.StoreCheckpoint()
  elseif not cineStarted then
    engine.Error("Entering Modi2 Context Action at an incorrect cine number ", game.Level.GetVariable("CompletedCineNumber"))
  end
end
function ExitContextAction()
  if game.Level.GetVariable("CompletedCineNumber") == 360 and not cineStarted then
    GameObjects.ModiBowl_Interact.LuaObjectScript.Disable()
    if secondHintTimer ~= nil then
      secondHintTimer:Reset()
      secondHintTimer = nil
    end
  end
end
function PlaySecondHintBanter()
  if not cineStarted then
    game.Audio.PlayBanter("090_SandBowlInterrupts_02")
  end
end
function EnableLookAtTryptic()
  if game.Level.GetVariable("CompletedCineNumber") == 360 then
    GameObjects.EntityZone_Triptych_ConAct:HideEntityVolume()
  end
end
function PlayModi2Seq()
  game.UI.LoadCheck("Cal590_c365_ModiAmbush")
  seq = ND.CreateCineSequence(thisLevel, thisObj, "modi2")
  cineStarted = true
  CreateActorsAndProps()
  local actorTable = {
    {Actor = sonActor},
    {Actor = modiActor},
    {
      Obj = GameObjects.pillarBreak.Child
    }
  }
  game.Compass.SetDesignerForcedHide(true)
  _G.SonSickDisableDocks()
  seq:SetPostSkipMusic("SND_MX_CAL_start_master", "SND_MX_SonSick_master", "SND_MX_CAL_snake_belly_master")
  seq:MarkAbleToSkip({
    callbackOnSkip = AcquireMinigamePickup
  })
  seq:RequestCineModeAndWait(kratosActor, thisObj)
  seq:Do(StartCineEnter_Modi2)
  seq:SpawnActorAndWait(modiActor)
  seq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_Modi2",
    ReferenceJoint = "Modi2_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = ND.StopTurnRadius,
    strafe_distance = 3,
    weapon_state = "bare_on_back",
    completion_percentage = 1
  })
  seq:Do(function()
    GameObjects.PreModi_CA_BeckonToMe.LuaObjectScript.Interrupt()
    GameObjects.PreModi_CA_BeckonToMe.LuaObjectScript.Disable()
  end)
  seq:ActorSync(kratosActor, {
    Slaves = actorTable,
    Branch = "BRA_Modi2",
    ReferenceJoint = "Modi2_SynchJoint"
  })
  seq:Do(PlayCineLights)
  seq:WaitUntilActorAnimPastFrame(sonActor, 3145)
  seq:WaitUntilActorAnimPastFrame(modiActor, 4342)
  seq:Do(OpenModiDoor)
  seq:SetCompletedCineNumber(364)
  seq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  seq:StopPuppetingActor(modiActor)
  seq:StopPuppetingActor(sonActor)
  seq:StopPuppetingActor(kratosActor)
  seq:DespawnActor(modiActor)
  seq:Do(HideCineLights)
  seq:Do(Pickup)
  seq:Do(function()
    seq:EndSkipIfActive()
  end)
  seq:Do(StartHealSonObjective)
  seq:SetCompletedCineNumber(365)
  seq:Do(function()
    LD.DisableBoatLore()
    LD.SetEntityVariable("NAR_RoadLoreAllowed", false)
    game.World.StoreCheckpoint()
  end)
  seq:StartSequence()
end
function PlayCineLights()
  cine_lights_365:Show()
  cine_lights_365:JumpAnimToFrame(0)
  cine_lights_365:PlayAnimToEnd()
end
function PauseCineLights()
  cine_lights_365:PauseAnim()
end
function HideCineLights()
  cine_lights_365:Hide()
end
function LuaHook_StartRageListen()
  if not player:PickupIsAcquired("MiniGameAimValid") then
    uiCalls.EnableMechanicRage()
    if seq ~= nil and not seq.skipping then
      seq:EndSkipIfActive()
    end
  end
end
function LuaHook_WinMinigame()
  if seq ~= nil and not seq.skipping then
    seq:MarkAbleToSkip()
  end
end
function LuaHook_FailedMinigame()
  PauseCineLights()
  uiCalls.DisableMechanicRage()
  game.Audio.InterruptBanterOnCharacter("Modi")
  game.Audio.InterruptBanterOnCharacter("Son")
  game.Audio.InterruptBanterOnCharacter("Mimir's Head")
end
function OpenModiDoor()
  local newLevel = game.FindLevel("Cal100_Hub")
  if newLevel ~= nil then
    newLevel:CallScript("OpenModiDoor")
  end
  _G.ShowCal200FromInside()
  local cal050 = game.FindLevel("Cal050_Sound")
  if cal050 ~= nil then
    cal050:CallScript("SonSickActive")
  end
end
function AcquireMinigamePickup()
  if not player:PickupIsAcquired("MiniGameAimValid") then
    player:PickupAcquire("MiniGameAimValid")
  end
end
function Pickup()
  _G.PickUpSon()
  player:PickupRelinquish("MiniGameAimValid")
end
function StartHealSonObjective()
  game.QuestManager.ProposeQuestState("Quest_TyrsVault_Objective550", "Complete")
  LD.ActivateQuest("Quest_Caldera_to_SonSick")
  game.Audio.StartCheckpointedMusic("SND_MX_SonSick_travel_to_freya_in")
end
function StartCineEnter_Modi2()
  game.SubObject.Wake(thisObj)
  cameraCineEnter_Modi2 = CCEC.CineEnterCamera.New("ENV_CineEnter_Modi2", 8)
  cameraCineEnter_Modi2:SetCallback(DestroyCineEnter_Modi2)
  cameraCineEnter_Modi2:Start()
end
function DestroyCineEnter_Modi2()
  cameraCineEnter_Modi2 = nil
  game.SubObject.Sleep(thisObj)
end
